/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.helper.MutexServiceHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.util.StringUtils;

public abstract class CasAccountTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(CasAccountTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext arg0, Map<String, Object> paramMap) throws KDException {
        QFilter filter = new QFilter("acctstatus", "=", (Object)"normal");
        String downloadDay = "";
        if (paramMap != null && !paramMap.isEmpty()) {
            String dDay;
            String str = paramMap.get("bankaccountnumber").toString();
            if (StringUtils.isNotEmpty((String)str)) {
                String[] number = paramMap.get("bankaccountnumber").toString().split(",");
                filter.and(new QFilter("bankaccountnumber", "in", (Object)number));
            }
            String string = dDay = paramMap.get("download_day") == null ? "" : paramMap.get("download_day").toString();
            if (StringUtils.isNotEmpty((String)dDay)) {
                downloadDay = dDay;
            }
        }
        if (this.isTaskByAccount()) {
            DynamicObject[] accountBanks = BusinessDataServiceHelper.load((String)"am_acctbank_schedule", (String)"id", (QFilter[])new QFilter[]{filter.and(this.getQfilter())});
            if (accountBanks.length == 0) {
                return;
            }
            OperateOption option = OperateOption.create();
            if (StringUtils.isNotEmpty((String)downloadDay)) {
                option.setVariableValue("download_day", downloadDay);
            }
            OperationResult result = OperateServiceHelper.execOperateWithoutThrow((String)this.getOperationKey(), (String)"am_acctbank_schedule", (Object[])StringUtils.getPks((DynamicObject[])accountBanks), (OperateOption)option);
            this.buildLog(result);
        } else {
            DynamicObject[] accountbanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"id", (QFilter[])new QFilter[]{filter});
            if (accountbanks.length == 0) {
                return;
            }
            ArrayList<Object> accountPks = new ArrayList<Object>(accountbanks.length);
            for (int i = 0; i < accountbanks.length; ++i) {
                accountPks.add(accountbanks[i].getPkValue());
            }
            DynamicObject[] data = BusinessDataServiceHelper.load((String)this.getEntityNumber(), (String)"id", (QFilter[])new QFilter[]{new QFilter(this.getAccountKey(), "in", accountPks).and(this.getQfilter())});
            if (data.length == 0) {
                return;
            }
            ArrayList errors = new ArrayList();
            List idList = Arrays.stream(data).map(DataEntityBase::getPkValue).map(String::valueOf).collect(Collectors.toList());
            Map request = MutexServiceHelper.batchRequest(idList, (String)this.getEntityNumber(), (String)(this.getOperationKey() + "_mutex"));
            List requestIds = MutexServiceHelper.getRequestResultList((DynamicObject[])data, errors, (Map)request);
            try {
                OperationResult result = requestIds.size() > 0 ? OperateServiceHelper.execOperateWithoutThrow((String)this.getOperationKey(), (String)this.getEntityNumber(), (Object[])requestIds.toArray(), (OperateOption)OperateOption.create()) : new OperationResult();
                for (OperateErrorInfo error : errors) {
                    result.addErrorInfo(error);
                }
                this.buildLog(result);
            }
            finally {
                if (requestIds.size() > 0) {
                    MutexServiceHelper.batchRelease((List)requestIds, (String)this.getEntityNumber(), (String)(this.getOperationKey() + "_mutex"));
                }
            }
        }
    }

    public String getAccountKey() {
        return "accountbank";
    }

    protected abstract boolean isTaskByAccount();

    private void buildLog(OperationResult result) {
        logger.info("\u64cd\u4f5c\u540d\u79f0" + this.getOperationKey());
        logger.info("\u6210\u529f\u6761\u6570" + result.getSuccessPkIds().size());
        logger.info("\u6821\u9a8c\u4fe1\u606f" + result.getValidateResult().getMessage());
        logger.info("\u603b\u4fe1\u606f" + result.getMessage());
        logger.info("\u603b\u4fe1\u606f" + result.getSponsor());
    }

    protected abstract QFilter getQfilter();

    protected abstract String getOperationKey();

    protected abstract String getEntityNumber();
}

