/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.task;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.helper.CasBankJournalHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.util.EmptyUtil;

public class UpdateAccountBalanceTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(UpdateAccountBalanceTask.class);

    /*
     * WARNING - void declaration
     */
    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        Object[] balancetasks;
        int top = 200;
        if (arg1 != null && !arg1.isEmpty()) {
            try {
                String topObject = (String)arg1.get("top");
                if (topObject != null) {
                    top = Integer.parseInt(topObject);
                }
            }
            catch (NumberFormatException e) {
                logger.error("\u66f4\u65b0\u4f59\u989d\u4efb\u52a1\u6761\u6570\u8f6c\u6362\u5f02\u5e38" + e);
            }
        }
        if (EmptyUtil.isNoEmpty((Object[])(balancetasks = BusinessDataServiceHelper.load((String)"cas_balancetask", (String)(String.join((CharSequence)",", EntityPropertyHelper.getPropertys((String)"cas_balancetask")) + ",errormessage_TAG"), (QFilter[])new QFilter[]{new QFilter("taskstatus", "in", (Object)new String[]{"0", "3"})}, (String)" modifydate asc ", (int)top)))) {
            void var7_10;
            Object[] objectArray = balancetasks;
            int n = objectArray.length;
            boolean bl = false;
            while (var7_10 < n) {
                Object object = objectArray[var7_10];
                object.set("taskstatus", (Object)"1");
                ++var7_10;
            }
            TXHandle tx = TX.requiresNew();
            Object object = null;
            try {
                try {
                    SaveServiceHelper.save((DynamicObject[])balancetasks);
                }
                catch (Exception exception) {
                    tx.markRollback();
                    String string = ExceptionUtils.getExceptionStackTraceMessage((Exception)exception);
                    logger.error("\u66f4\u65b0\u4f59\u989d\u4efb\u52a1\u4e3a\u5904\u7406\u4e2d\u5931\u8d25\uff1a" + string);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (object != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            Map<String, List<DynamicObject>> addBalancetaskMap = Arrays.stream(balancetasks).filter(dy -> StringUtils.equals((CharSequence)"add", (CharSequence)dy.getString("businesstype"))).collect(Collectors.groupingBy(journal -> String.format("%s_%s_%s", DynamicObjectHelper.getPk((DynamicObject)journal, (String)"org"), DynamicObjectHelper.getPk((DynamicObject)journal, (String)"bankaccount"), DynamicObjectHelper.getPk((DynamicObject)journal, (String)"currency"))));
            for (Map.Entry entry : addBalancetaskMap.entrySet()) {
                List list = (List)entry.getValue();
                TXHandle tx2 = TX.requiresNew();
                Throwable throwable = null;
                try {
                    try {
                        CasBankJournalHelper.updateBalanceTask((DynamicObject[])list.toArray(new DynamicObject[0]));
                        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"cas_balancetask"), (Object[])list.stream().map(dy -> dy.getPkValue()).toArray());
                    }
                    catch (Exception e) {
                        tx2.markRollback();
                        String exception = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                        String subException = exception.length() > 255 ? exception.substring(0, 255) : exception;
                        list.forEach(dy -> {
                            dy.set("taskstatus", (Object)"3");
                            dy.set("errormessage", (Object)subException);
                            dy.set("errormessage_TAG", (Object)exception);
                            dy.set("modifydate", (Object)new Date());
                        });
                        TXHandle tx1 = TX.requiresNew();
                        Throwable throwable2 = null;
                        try {
                            try {
                                SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
                            }
                            catch (Exception e1) {
                                tx1.markRollback();
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (tx1 == null) continue;
                            if (throwable2 != null) {
                                try {
                                    tx1.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            tx1.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (tx2 == null) continue;
                    if (throwable != null) {
                        try {
                            tx2.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    tx2.close();
                }
            }
            Map<String, List<DynamicObject>> deleteBalancetaskMap = Arrays.stream(balancetasks).filter(dy -> StringUtils.equals((CharSequence)"delete", (CharSequence)dy.getString("businesstype"))).collect(Collectors.groupingBy(journal -> String.format("%s_%s_%s", DynamicObjectHelper.getPk((DynamicObject)journal, (String)"org"), DynamicObjectHelper.getPk((DynamicObject)journal, (String)"bankaccount"), DynamicObjectHelper.getPk((DynamicObject)journal, (String)"currency"))));
            for (Map.Entry<String, List<DynamicObject>> entry : deleteBalancetaskMap.entrySet()) {
                List<DynamicObject> journals = entry.getValue();
                TXHandle tx3 = TX.requiresNew();
                Throwable throwable = null;
                try {
                    try {
                        CasBankJournalHelper.deleteBalanceTask((DynamicObject[])journals.toArray(new DynamicObject[0]));
                        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"cas_balancetask"), (Object[])journals.stream().map(dy -> dy.getPkValue()).toArray());
                    }
                    catch (Exception e) {
                        tx3.markRollback();
                        String exception = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                        String subException = exception.length() > 255 ? exception.substring(0, 255) : exception;
                        journals.forEach(dy -> {
                            dy.set("taskstatus", (Object)"3");
                            dy.set("errormessage", (Object)subException);
                            dy.set("errormessage_TAG", (Object)exception);
                            dy.set("modifydate", (Object)new Date());
                        });
                        TXHandle tx1 = TX.requiresNew();
                        Throwable throwable7 = null;
                        try {
                            try {
                                SaveServiceHelper.save((DynamicObject[])journals.toArray(new DynamicObject[0]));
                            }
                            catch (Exception e1) {
                                tx1.markRollback();
                            }
                        }
                        catch (Throwable throwable8) {
                            throwable7 = throwable8;
                            throw throwable8;
                        }
                        finally {
                            if (tx1 == null) continue;
                            if (throwable7 != null) {
                                try {
                                    tx1.close();
                                }
                                catch (Throwable throwable9) {
                                    throwable7.addSuppressed(throwable9);
                                }
                                continue;
                            }
                            tx1.close();
                        }
                    }
                }
                catch (Throwable throwable10) {
                    throwable = throwable10;
                    throw throwable10;
                }
                finally {
                    if (tx3 == null) continue;
                    if (throwable != null) {
                        try {
                            tx3.close();
                        }
                        catch (Throwable throwable11) {
                            throwable.addSuppressed(throwable11);
                        }
                        continue;
                    }
                    tx3.close();
                }
            }
        }
    }
}

