/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.upgrade.payapply;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.Pair;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.util.EmptyUtil;

public class PayApplyRefundUpgradeService
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(PayApplyRefundUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        try {
            result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u4ed8\u6b3e\u7533\u8bf7\u5355\u5206\u5f55\u9000\u6b3e\u9000\u7968\u5386\u53f2\u6570\u636e\u5347\u7ea7\u3002", (String)"PayApplyRefundUpgradeService_1", (String)"fi-cas-business", (Object[])new Object[0]));
            PayApplyRefundUpgradeService.updatePayApplyPayInfo();
            result.setLog(ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u5206\u5f55\u9000\u6b3e\u9000\u7968\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5b8c\u6bd5\u3002", (String)"PayApplyRefundUpgradeService_2", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        catch (Exception e) {
            LOGGER.error("[PayApplyRefundUpgradeService]\u4ed8\u6b3e\u7533\u8bf7\u5355\u5206\u5f55\u9000\u6b3e\u9000\u7968\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5f02\u5e38\u3002", (Throwable)e);
            result.setErrorInfo(e.getMessage());
            result.setSuccess(false);
        }
        return result;
    }

    private static void updatePayApplyPayInfo() {
        String sql = "SELECT COUNT(1) as cnt FROM t_cas_payapplybill";
        DataSet countDataSet = DB.queryDataSet((String)(PayApplyRefundUpgradeService.class.getName() + "_queryPayApplyCount"), (DBRoute)DBRouteConst.cas, (String)sql);
        if (countDataSet != null && countDataSet.hasNext()) {
            Row row = countDataSet.next();
            Long count = row.getLong("cnt");
            LOGGER.info("[PayApplyRefundUpgradeService]\u4ed8\u6b3e\u7533\u8bf7\u5355\u6570\u636e\u5347\u7ea7\u6570\u91cf\uff1a{}\u3002", (Object)count);
            if (EmptyUtil.isEmpty((Long)count)) {
                return;
            }
            int patchSize = 5000;
            int patchCount = (int)(count / (long)patchSize);
            patchCount = count % (long)patchSize == 0L ? patchCount : patchCount + 1;
            LOGGER.info("[PayApplyRefundUpgradeService]\u4ed8\u6b3e\u7533\u8bf7\u5355\u6570\u636e\u5347\u7ea7\uff0c\u6279\u6b21\u6570\uff1a{}\u3002", (Object)patchCount);
            for (int i = 0; i < patchCount; ++i) {
                Object[] payApplyBills;
                HashMap payApplyEntryIdAndPayPairMap;
                Throwable throwable;
                TXHandle tx;
                block24: {
                    block25: {
                        LOGGER.info("[PayApplyRefundUpgradeService]\u4ed8\u6b3e\u7533\u8bf7\u5355\u6570\u636e\u5347\u7ea7\uff0c\u5f53\u524d\u9875\u6570\uff1a{}\u3002", (Object)(i + 1));
                        tx = TX.requiresNew();
                        throwable = null;
                        payApplyEntryIdAndPayPairMap = new HashMap(16);
                        payApplyBills = BusinessDataServiceHelper.load((String)"cas_payapplybill", (String)"id,cas_payinfo,cas_payinfo.entry_refundamount,cas_payinfo.entry_remainrfamount,cas_payinfo.entry_backbill,cas_payinfo.entry_paidamount,cas_payinfo.entry_refund", (QFilter[])new QFilter[0], (String)"id asc", (int)i, (int)patchSize);
                        if (!EmptyUtil.isEmpty((Object[])payApplyBills)) break block24;
                        if (tx == null) break;
                        if (throwable == null) break block25;
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break;
                    }
                    tx.close();
                    break;
                }
                try {
                    try {
                        LOGGER.info("[PayApplyRefundUpgradeService]\u4ed8\u6b3e\u7533\u8bf7\u5355\u6570\u636e\u5347\u7ea7\uff0c \uff1a{}\u3002", (Object)payApplyBills.length);
                        Set payApplyIdSet = Arrays.stream(payApplyBills).map(payApplyBill -> payApplyBill.getLong("id")).collect(Collectors.toSet());
                        QFilter payFilter = new QFilter("sourcebillid", "in", payApplyIdSet);
                        Object[] payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,billstatus,entry,entry.e_sourcebillid,entry.e_sourcebillentryid,entry.e_refundamt,entry.e_remainrefundamt", (QFilter[])payFilter.toArray());
                        if (EmptyUtil.isNoEmpty((Object[])payBills)) {
                            Arrays.stream(payBills).forEach(payBill -> {
                                DynamicObjectCollection entries = payBill.getDynamicObjectCollection("entry");
                                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entries)) {
                                    String payBillStatus = payBill.getString("billstatus");
                                    entries.stream().filter(e -> EmptyUtil.isNoEmpty((Long)e.getLong("e_sourcebillentryid"))).forEach(e -> payApplyEntryIdAndPayPairMap.put(e.getLong("e_sourcebillentryid"), new Pair(e, (Object)payBillStatus)));
                                }
                            });
                        }
                        LOGGER.info("[PayApplyRefundUpgradeService]\u4ed8\u6b3e\u7533\u8bf7\u5355\u6570\u636e\u5347\u7ea7\uff0cmap\u5927\u5c0f\uff1a{}\u3002", (Object)payApplyEntryIdAndPayPairMap.size());
                        for (Object payApplyBill2 : payApplyBills) {
                            DynamicObjectCollection entries = payApplyBill2.getDynamicObjectCollection("cas_payinfo");
                            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)entries)) continue;
                            for (DynamicObject entry : entries) {
                                boolean isRefundOrReNote;
                                Pair pair = (Pair)payApplyEntryIdAndPayPairMap.get(entry.getLong("id"));
                                if (pair == null) continue;
                                String billStatus = (String)pair.getValue();
                                DynamicObject payEntry = (DynamicObject)pair.getKey();
                                boolean bl = isRefundOrReNote = StringUtils.equals((CharSequence)billStatus, (CharSequence)BillStatusEnum.RENOTE.getValue()) || StringUtils.equals((CharSequence)billStatus, (CharSequence)BillStatusEnum.REFUND.getValue());
                                if (isRefundOrReNote) {
                                    entry.set("entry_backbill", (Object)StringUtils.equals((CharSequence)billStatus, (CharSequence)BillStatusEnum.RENOTE.getValue()));
                                    entry.set("entry_refund", (Object)StringUtils.equals((CharSequence)billStatus, (CharSequence)BillStatusEnum.REFUND.getValue()));
                                }
                                entry.set("entry_refundamount", (Object)(isRefundOrReNote ? payEntry.getBigDecimal("e_refundamt") : BigDecimal.ZERO));
                                entry.set("entry_remainrfamount", (Object)payEntry.getBigDecimal("e_remainrefundamt"));
                            }
                        }
                        SaveServiceHelper.save((DynamicObject[])payApplyBills);
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        LOGGER.error("\u6279\u91cf\u66f4\u65b0\u4ed8\u6b3e\u7533\u8bf7\u5355\u5206\u5f55\u4fe1\u606f\u5931\u8d25\u3002", (Throwable)e);
                    }
                    continue;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
                finally {
                    if (tx != null) {
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
        }
    }
}

