/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.upgrade.paybill;

import java.util.ArrayList;
import java.util.Collection;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.payment.PaymentPayHelper;
import org.apache.commons.lang.ArrayUtils;

public class PayBillEntryDpAmtUpgrade
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(PayBillEntryDpAmtUpgrade.class);
    private static final String[] NEED_UPDATE_STATUS = new String[]{BillStatusEnum.PAY.getValue(), BillStatusEnum.RENOTE.getValue(), BillStatusEnum.REFUND.getValue(), BillStatusEnum.CHARGEBANK.getValue(), BillStatusEnum.DEAD.getValue()};

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        result.setLog("kd.fi.cas.business.upgrade.paybill.PayBillEntryDpAmtUpgrade");
        try {
            result.setLog(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u5206\u5f55\u5f02\u5e01\u79cd\u4ed8\u6b3e\u91d1\u989d\u6267\u884c\u5386\u53f2\u6570\u636e\u5347\u7ea7\u3002", (String)"PayBillEntryDpAmtUpgrade_1", (String)"fi-cas-business", (Object[])new Object[0]));
            PayBillEntryDpAmtUpgrade.updatePayBillEntryDpAmt();
            result.setLog(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u5206\u5f55\u5f02\u5e01\u79cd\u4ed8\u6b3e\u91d1\u989d\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5b8c\u6bd5\u3002", (String)"PayBillEntryDpAmtUpgrade_2", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        catch (Exception e) {
            logger.error("entrust pay update history error", (Throwable)e);
            result.setErrorInfo(e.getMessage());
            result.setSuccess(false);
        }
        return result;
    }

    private static void updatePayBillEntryDpAmt() {
        block38: {
            String sql = "SELECT COUNT(1) as cnt FROM T_CAS_PaymentBill t inner join T_CAS_PaymentBill_e e on t.fid = e.fid where t.fbillstatus in ('D','F','I','G','H') and e.fisdiffcur = '1'";
            try (DataSet countDataSet = DB.queryDataSet((String)"queryPayBillIsDiffcurCount", (DBRoute)DBRouteConst.cas, (String)sql);){
                if (!countDataSet.hasNext()) break block38;
                Row countData = countDataSet.next();
                Long count = countData.getLong("cnt");
                logger.info("\u9700\u8981\u66f4\u65b0\u5206\u5f55\u5f02\u5e01\u79cd\u4ed8\u6b3e\u91d1\u989d\u7684\u4ed8\u6b3e\u5355\u6570\u91cf: " + count);
                if (count == null || count.equals(0L)) {
                    return;
                }
                int pageSize = 1000;
                int totalPage = (int)(count / (long)pageSize);
                if (count % (long)pageSize > 0L) {
                    ++totalPage;
                }
                long lastId = 0L;
                for (int i = 0; i < totalPage; ++i) {
                    Object[] needUpdatePayBills;
                    Throwable throwable;
                    TXHandle tx;
                    block39: {
                        block40: {
                            tx = TX.requiresNew();
                            throwable = null;
                            QFilter filter = new QFilter("billstatus", "in", (Object)NEED_UPDATE_STATUS).and("isdiffcur", "=", (Object)"1").and("id", ">", (Object)lastId);
                            needUpdatePayBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,isdiffcur,dpcurrency.amtprecision,agreedrate,agreedquotation,dpamt,entry.id,entry.e_actamt,entry.e_dpamt", (QFilter[])filter.toArray(), (String)"id asc", (int)pageSize);
                            if (!ArrayUtils.isEmpty((Object[])needUpdatePayBills)) break block39;
                            if (tx == null) break block38;
                            if (throwable == null) break block40;
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break;
                        }
                        tx.close();
                        break;
                    }
                    try {
                        try {
                            lastId = needUpdatePayBills[needUpdatePayBills.length - 1].getLong("id");
                            logger.info("\u5f00\u59cb\u66f4\u65b0\u7b2c" + i + "\u6279\u4ed8\u6b3e\u5355\u7684\u5206\u5f55\u5f02\u5e01\u79cd\u4ed8\u6b3e\u91d1\u989d, \u6570\u91cf:" + needUpdatePayBills.length);
                            ArrayList<Object[]> paramList = new ArrayList<Object[]>((int)((double)needUpdatePayBills.length * 1.5));
                            for (Object needUpdatePayBill : needUpdatePayBills) {
                                PaymentPayHelper.updateEntryDpAmt((DynamicObject)needUpdatePayBill);
                                DynamicObjectCollection entryList = needUpdatePayBill.getDynamicObjectCollection("entry");
                                if (CollectionUtils.isEmpty((Collection)entryList)) continue;
                                for (DynamicObject entry : entryList) {
                                    paramList.add(new Object[]{entry.getBigDecimal("e_dpamt"), entry.getLong("id")});
                                }
                            }
                            if (!paramList.isEmpty()) {
                                String updateSql = "update T_CAS_PaymentBillEntry set fedpamt = ? where FEntryID = ?";
                                DB.executeBatch((DBRoute)DBRouteConst.cas, (String)updateSql, paramList);
                                tx.commit();
                            }
                            logger.info("\u5df2\u66f4\u65b0\u4ed8\u6b3e\u5355\u5df2\u59d4\u6258\u91d1\u989d\u6279\u6b21: " + i + ", \u66f4\u65b0\u6570\u91cf: " + paramList.size());
                        }
                        catch (Exception e) {
                            tx.markRollback();
                            logger.error("update paybill e_dpamt error batch no: " + i, (Throwable)e);
                        }
                        continue;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                    finally {
                        if (tx != null) {
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                tx.close();
                            }
                        }
                    }
                }
            }
        }
    }
}

