/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.util;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.consts.BillTypeConstants;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.util.EmptyUtil;

public class PayeeInfoHelper {
    public static boolean useCashAccount(DynamicObject settleType, long payeeId, String payeeType) {
        boolean isCash = BaseDataHelper.isSettleTypeCash((DynamicObject)settleType);
        if (!isCash) {
            return false;
        }
        if (StringUtils.equals((CharSequence)payeeType, (CharSequence)AsstActTypeEnum.COMPANY.getValue())) {
            return true;
        }
        if (EmptyUtil.isEmpty((Long)payeeId)) {
            return false;
        }
        if (StringUtils.equals((CharSequence)payeeType, (CharSequence)AsstActTypeEnum.SUPPLIER.getValue())) {
            DynamicObject supplierDO = BusinessDataServiceHelper.loadSingleFromCache((Object)payeeId, (String)AsstActTypeEnum.SUPPLIER.getValue());
            return EmptyUtil.isNoEmpty((DynamicObject)supplierDO.getDynamicObject("internal_company"));
        }
        if (StringUtils.equals((CharSequence)payeeType, (CharSequence)AsstActTypeEnum.CUSTOMER.getValue())) {
            DynamicObject customerDO = BusinessDataServiceHelper.loadSingleFromCache((Object)payeeId, (String)AsstActTypeEnum.CUSTOMER.getValue());
            return EmptyUtil.isNoEmpty((DynamicObject)customerDO.getDynamicObject("internal_company"));
        }
        return false;
    }

    public static boolean isPaymentBill(DynamicObject billType) {
        return EmptyUtil.isNoEmpty((DynamicObject)billType) && (BillTypeConstants.PAYBILL_PUR.equals(billType.getPkValue()) || BillTypeConstants.PAYBILL_OTR.equals(billType.getPkValue()));
    }
}

