/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.writeback;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;

public class AbstractWriteBackValidate {
    protected static final Log logger = LogFactory.getLog(AbstractWriteBackValidate.class);
    protected static final Set<String> NON_PART_PAYMENT_STATUS = new HashSet<String>(2);
    protected static final Set<String> PART_PAYMENT_STATUS = new HashSet<String>(4);
    protected static final String PAYMENT_STATUS_C = "C";
    protected static final String PAYMENT_STATUS_D = "D";
    protected static final String PAYMENT_STATUS_B = "B";
    protected static final String PAYMENT_STATUS_E = "E";
    protected static final String MAP_PAY_BILLS = "payBills";
    protected static final String MAP_PAY_APPLY_BILLS = "payApplyBills";
    protected static final String MAP_PAY_BILL_AMOUNT = "payBillAmount";
    protected static final Integer COLLECTION_CAPACITY_SIXTEEN = 16;
    protected static final Integer COLLECTION_CAPACITY_TWO = 2;

    protected Map<String, Object> handleBillInfo(List<Map<String, Object>> params) {
        HashMap<String, Object> result = new HashMap<String, Object>(COLLECTION_CAPACITY_TWO);
        HashSet<Long> sourceBillIds = new HashSet<Long>(params.size());
        HashSet<Long> payBillIds = new HashSet<Long>(params.size());
        HashMap<Long, Long> linkBillIds = new HashMap<Long, Long>(COLLECTION_CAPACITY_SIXTEEN);
        HashMap<Long, PayBillAmount> payBillAmountMap = new HashMap<Long, PayBillAmount>(COLLECTION_CAPACITY_SIXTEEN);
        this.handleCacheData(params, payBillIds, sourceBillIds, linkBillIds, payBillAmountMap, result);
        this.linkPayApplyPay(sourceBillIds, linkBillIds, result);
        this.dealPayBillInfo(payBillIds, payBillAmountMap, result);
        return result;
    }

    private void handleCacheData(List<Map<String, Object>> params, Set<Long> payBillIds, Set<Long> sourceBillIds, Map<Long, Long> linkBillIds, Map<Long, PayBillAmount> payBillAmountMap, Map<String, Object> result) {
        for (Map<String, Object> paramMap : params) {
            DynamicObject payBill = (DynamicObject)paramMap.get("info");
            if (payBill == null) continue;
            Long payBillId = payBill.getLong("id");
            payBillIds.add(payBillId);
            DynamicObjectCollection entries = payBill.getDynamicObjectCollection("entry");
            if (entries == null || entries.size() == 0) continue;
            for (DynamicObject entry : entries) {
                Long sourceId = entry.getLong("e_sourcebillid");
                Long sourceEntryId = entry.getLong("e_sourcebillentryid");
                BigDecimal payableAmount = entry.getBigDecimal("e_payableamt");
                BigDecimal actAmount = entry.getBigDecimal("e_actamt");
                sourceBillIds.add(sourceId);
                linkBillIds.put(sourceId, payBillId);
                PayBillAmount payBillAmount = new PayBillAmount(BigDecimal.ZERO, payableAmount, BigDecimal.ZERO, actAmount);
                payBillAmountMap.put(sourceEntryId, payBillAmount);
            }
        }
        result.put(MAP_PAY_BILL_AMOUNT, payBillAmountMap);
    }

    private void linkPayApplyPay(Set<Long> sourceBillIds, Map<Long, Long> linkBillIds, Map<String, Object> result) {
        DynamicObject[] payApplyBillObjects;
        HashMap<Long, ArrayList<DynamicObject>> payApplyBills = new HashMap<Long, ArrayList<DynamicObject>>(COLLECTION_CAPACITY_SIXTEEN);
        QFilter filter = new QFilter("id", "in", sourceBillIds);
        for (DynamicObject payApplyBillObject : payApplyBillObjects = BusinessDataServiceHelper.load((String)"cas_payapplybill", (String)"id, billstatus, ispartpayment, payeeamount, refundandrepay, cas_payinfo.entry_paystatus,cas_payinfo.entry_invalid,cas_payinfo.entry_payeeamount,cas_payinfo.entry_lockedamount,cas_payinfo.entry_paidamount, cas_payapplyentry.e_payeeamount, cas_payinfo.entry_refundamount", (QFilter[])new QFilter[]{filter})) {
            Long payApplyId = payApplyBillObject.getLong("id");
            Long sourceId = linkBillIds.get(payApplyId);
            ArrayList<DynamicObject> payApplyList = (ArrayList<DynamicObject>)payApplyBills.get(sourceId);
            if (payApplyList == null) {
                payApplyList = new ArrayList<DynamicObject>(COLLECTION_CAPACITY_SIXTEEN);
                payApplyBills.put(sourceId, payApplyList);
            }
            payApplyList.add(payApplyBillObject);
        }
        result.put(MAP_PAY_APPLY_BILLS, payApplyBills);
    }

    private void dealPayBillInfo(Set<Long> payBillIds, Map<Long, PayBillAmount> payBillAmountMap, Map<String, Object> result) {
        DynamicObject[] payBillObjects;
        HashMap<Long, DynamicObject> payBills = new HashMap<Long, DynamicObject>(COLLECTION_CAPACITY_SIXTEEN);
        for (DynamicObject payBillObject : payBillObjects = BusinessDataServiceHelper.load((Object[])payBillIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_paybill"))) {
            Long payBillId = payBillObject.getLong("id");
            payBills.put(payBillId, payBillObject);
            DynamicObjectCollection entries = payBillObject.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long sourceEntryId = entry.getLong("e_sourcebillentryid");
                BigDecimal payableAmount = entry.getBigDecimal("e_payableamt");
                BigDecimal actAmount = entry.getBigDecimal("e_actamt");
                PayBillAmount payBillAmount = payBillAmountMap.get(sourceEntryId);
                if (payBillAmount == null) continue;
                payBillAmount.setPrePayAmount(payableAmount);
                payBillAmount.setPreActAmount(actAmount);
            }
        }
        result.put(MAP_PAY_BILLS, payBills);
    }

    protected boolean isSameOrientation(BigDecimal ... digital) {
        BigDecimal firstData = digital[0];
        if (BigDecimal.ZERO.compareTo(firstData) <= 0) {
            return this.forwardDirection(digital);
        }
        return this.negativeDirection(digital);
    }

    private boolean forwardDirection(BigDecimal ... digital) {
        boolean result = true;
        for (BigDecimal data : digital) {
            if (BigDecimal.ZERO.compareTo(data) <= 0) continue;
            result = false;
            break;
        }
        return result;
    }

    protected boolean negativeDirection(BigDecimal ... digital) {
        boolean result = true;
        for (BigDecimal data : digital) {
            if (BigDecimal.ZERO.compareTo(data) >= 0) continue;
            result = false;
            break;
        }
        return result;
    }

    static {
        NON_PART_PAYMENT_STATUS.add(PAYMENT_STATUS_C);
        NON_PART_PAYMENT_STATUS.add(PAYMENT_STATUS_D);
        PART_PAYMENT_STATUS.add(PAYMENT_STATUS_C);
        PART_PAYMENT_STATUS.add(PAYMENT_STATUS_D);
        PART_PAYMENT_STATUS.add(PAYMENT_STATUS_B);
    }

    static class PayBillAmount {
        BigDecimal prePayAmount;
        BigDecimal postPayAmount;
        BigDecimal preActAmount;
        BigDecimal postActAmount;

        public PayBillAmount(BigDecimal prePayAmount, BigDecimal postPayAmount, BigDecimal preActAmount, BigDecimal postActAmount) {
            this.prePayAmount = prePayAmount;
            this.postPayAmount = postPayAmount;
            this.preActAmount = preActAmount;
            this.postActAmount = postActAmount;
        }

        public void setPrePayAmount(BigDecimal prePayAmount) {
            this.prePayAmount = prePayAmount;
        }

        public void setPostPayAmount(BigDecimal postPayAmount) {
            this.postPayAmount = postPayAmount;
        }

        public BigDecimal getPrePayAmount() {
            return this.prePayAmount;
        }

        public BigDecimal getPostPayAmount() {
            return this.postPayAmount;
        }

        public BigDecimal getPreActAmount() {
            return this.preActAmount;
        }

        public void setPreActAmount(BigDecimal preActAmount) {
            this.preActAmount = preActAmount;
        }

        public BigDecimal getPostActAmount() {
            return this.postActAmount;
        }

        public void setPostActAmount(BigDecimal postActAmount) {
            this.postActAmount = postActAmount;
        }
    }
}

