/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.writeback;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterCommitAmountEventArgs;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class CasPayBillWriteBackPlugin
extends AbstractWriteBackPlugIn {
    private static final Log logger = LogFactory.getLog(CasPayBillWriteBackPlugin.class);
    private List<Map<String, Object>> params = new ArrayList<Map<String, Object>>(32);
    private final Set<String> fieldKeys = Stream.of("lockedamt", "planlockedamt", "planlockedamt", "e_lockedamt").collect(Collectors.toSet());
    private final Set<String> rules = Stream.of("976599561793623040", "1492808286162974720", "724521772577205248", "724508803101384704", "655716377167958016", "656327324739847168").collect(Collectors.toSet());

    public void afterCommitAmount(AfterCommitAmountEventArgs e) {
        String srcEntityKey = e.getSrcSubMainType().getName();
        if (("bei_intelpay".equals(srcEntityKey) || "cas_betransdetail".equals(srcEntityKey)) && "receredtype".equals(e.getSrcFieldKey()) && !"delete".equalsIgnoreCase(this.getOpType()) && this.rules.contains(e.getRule().getId())) {
            e.getSrcActiveRow().set("receredtype", (Object)"3");
        }
        if (!this.fieldKeys.contains(e.getSrcFieldKey())) {
            return;
        }
        DynamicObject targetActiveRow = e.getTargetActiveRow();
        BigDecimal currVal = BigDecimal.ZERO;
        if ("ar_finarbill".equals(srcEntityKey) || "ap_finapbill".equals(srcEntityKey)) {
            currVal = e.getCurrVal();
        }
        if (BigDecimal.ZERO.compareTo(currVal) == 0) {
            return;
        }
        long tarRowId = e.getTargetRowId().getEntryId();
        DynamicObject srcBill = (DynamicObject)e.getSrcActiveRow().getParent();
        HashMap<String, Object> writeBackMap = new HashMap<String, Object>();
        writeBackMap.put("entityName", srcEntityKey);
        writeBackMap.put("opType", this.getOpType());
        writeBackMap.put("sourceId", srcBill.getLong("id"));
        writeBackMap.put("sourceEntryId", e.getSrcActiveRow().getLong("id"));
        writeBackMap.put("tarRowId", tarRowId);
        writeBackMap.put("disposeAmt", currVal);
        if ("save".equalsIgnoreCase(this.getOpType()) && targetActiveRow != null) {
            DynamicObject target = (DynamicObject)targetActiveRow.getParent();
            writeBackMap.put("billStatus", target.getString("billstatus"));
        }
        this.params.add(writeBackMap);
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        Object[] srcDataEntities = e.getSrcDataEntities();
        if (ObjectUtils.isEmpty((Object[])srcDataEntities)) {
            return;
        }
        String entityName = srcDataEntities[0].getDataEntityType().getName();
        if (!"ap_finapbill".equals(entityName) && !"ar_finarbill".equals(entityName)) {
            return;
        }
        logger.info("CasPayBillWriteBackPlugIn afterSaveSourceBill params.size is : " + this.params.size());
        if (this.params.isEmpty()) {
            return;
        }
        try (TXHandle tx = TX.required((String)"CasPayBillWriteBackPlugin");){
            try {
                List tempParams = this.params.stream().filter(param -> entityName.equals(param.get("entityName"))).collect(Collectors.toList());
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"PayBillWriteBackLockAmtService", (String)"disposeLockAmt", (Object[])new Object[]{tempParams});
            }
            catch (Exception e1) {
                tx.markRollback();
                throw e1;
            }
        }
    }
}

