/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.writeback;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.business.helper.PayBillHepler;
import kd.fi.cas.business.helper.StringHelper;
import kd.fi.cas.business.writeback.PaymentExtendConsumer;
import kd.fi.cas.business.writeback.WriteBackConfigInvoker;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.business.writeback.task.WriteBackTask;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.ExtendConfigHelper;
import kd.fi.cas.util.EmptyUtil;

public class PaymentDisposeConsumer
extends WriteBackConfigInvoker {
    private static final Log logger = LogFactory.getLog(PaymentDisposeConsumer.class);
    private static final String BILL_FIELDS = "billno,bizdate,paydate,sourcebillid,org,openorg,entrustorg,settletype,payeracctbank,payerbank,exchangerate,iscommitbe,billstatus,bankpaystatus,currency,sourcebilltype,agreedrate,dpcurrency,dpexchangerate,isdiffcur,dpamt,dplocalamt,lossamt,fee,feecurrency,paymentchannel,e_sourcebillid,e_sourcebillentryid,e_actamt,e_localamt,e_refundamt,e_refunddes,e_corebilltype,e_corebillno,e_corebillentryseq,e_payableamt,e_payablelocamt,reason,bankreturnmsg,settletnumber,draftbill,description,actpayamt,paymentidentify,cas_draftinfo,cas_draftinfo.draftbilllogid,payeename,payeebanknum,payeeacctbank,payeeacctcash,payeebankname,payeebank,e_corebillid,e_corebillentryid,e_paymenttype,conbillentity,conbillnumber,conbillid";

    @Override
    protected Object[] getInvokeParams(WriteBackTask task) {
        Object[] billPks = task.getBillPks();
        if (EmptyUtil.isNoEmpty((Object[])billPks)) {
            return this.batchBillProcess(task);
        }
        return this.singleBillProcess(task);
    }

    @Override
    protected Object[] getInvokeParamsList(List<WriteBackTask> task) {
        List billPks = task.stream().map(o -> o.getBillPk()).collect(Collectors.toList());
        WriteBackOperateEnum wbopEnum = task.get(0).getOperation();
        Map<String, Object> customParams = task.get(0).getCustomParams();
        DynamicObject[] paybills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)BILL_FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", billPks)});
        Map paymentBillMap = Arrays.stream(paybills).collect(Collectors.toMap(o -> o.getPkValue(), Function.identity()));
        Map<Long, Set<Long>> renotRecIdMap = this.getRenoteRecBills(paybills, wbopEnum);
        ArrayList<Map<String, Object>> listAll = new ArrayList<Map<String, Object>>();
        for (WriteBackTask writeBackTask : task) {
            DynamicObject paybill = (DynamicObject)paymentBillMap.get(writeBackTask.getBillPk());
            long pkId = paybill.getLong("id");
            Map<Long, Map<String, Object>> extendInfo = this.loadExtendInfo(pkId);
            List<Map<String, Object>> maps = this.genDisposeData(paybill, wbopEnum, customParams, renotRecIdMap, extendInfo);
            listAll.addAll(maps);
        }
        return new Object[]{listAll};
    }

    private boolean isSuccess(DynamicObject paymentBill, WriteBackTask task) {
        if (WriteBackOperateEnum.PAYVALIDATE == task.getOperation() || WriteBackOperateEnum.CANCELPAYVALIDATE == task.getOperation()) {
            return WriteBackOperateEnum.PAYVALIDATE == task.getOperation();
        }
        String billStatus = paymentBill.getString("billstatus");
        return BillStatusEnum.PAY.getValue().equals(billStatus);
    }

    @Override
    protected <T> T invoke(String cloud, String app, String service, String method, Object ... params) {
        if (!"fi".equals(cloud)) {
            Throwable throwable = null;
            try (TXHandle tx = TX.requiresNew((String)"payinvokeScmc");){
                Object object = DispatchServiceHelper.invokeBizService((String)cloud, (String)app, (String)service, (String)method, (Object[])params);
                return (T)object;
            }
            catch (Exception e) {
                try {
                    tx.markRollback();
                    logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        return super.invoke(cloud, app, service, method, params);
    }

    private Map<Long, Map<String, Object>> loadExtendInfo(Long payBillId) {
        HashMap<Long, Map<String, Object>> extendInfos = new HashMap<Long, Map<String, Object>>();
        try {
            DynamicObject payWriteConfig = ExtendConfigHelper.getExtendConfig((String)"fi.cas.writeback.payconsumer");
            if (payWriteConfig != null && StringUtils.isNotBlank((CharSequence)payWriteConfig.getString("configvalue"))) {
                PaymentExtendConsumer payExtConsumer = (PaymentExtendConsumer)Class.forName(payWriteConfig.getString("configvalue")).newInstance();
                extendInfos.putAll(payExtConsumer.loadExtendInfo(payBillId));
            }
        }
        catch (Exception e) {
            logger.info("\u52a0\u8f7d\u6269\u5c55\u670d\u52a1\u5f02\u5e38\uff0c%s", (Object)e.toString());
        }
        return extendInfos;
    }

    private Object[] singleBillProcess(WriteBackTask task) {
        Object pk = task.getBillPk();
        DynamicObject paymentBill = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"cas_paybill", (String)BILL_FIELDS);
        boolean isSuccess = this.isSuccess(paymentBill, task);
        Set renote_recbill = new HashSet();
        long payBillId = paymentBill.getLong("id");
        if (BillStatusEnum.RENOTE.getValue().equals(paymentBill.getString("billstatus"))) {
            renote_recbill = CasBotpHelper.getSrcBillByDestBill((Long)payBillId, (String)"cas_paybill", (String)"cas_recbill");
        }
        String operate = task.getOperation().getValue();
        if (WriteBackOperateEnum.REFUND.getValue().equals(operate)) {
            renote_recbill = CasBotpHelper.getSrcBillByDestBill((Long)payBillId, (String)"cas_paybill", (String)"cas_recbill");
        }
        ArrayList<HashMap<String, Object>> disposeData = new ArrayList<HashMap<String, Object>>(10);
        DynamicObjectCollection entry = paymentBill.getDynamicObjectCollection("entry");
        Long billId = pk instanceof String ? Long.valueOf(Long.parseLong(pk.toString())) : (Long)pk;
        Map<Long, Map<String, Object>> extendInfos = this.loadExtendInfo(billId);
        HashMap refundAMTMap = new HashMap();
        Map<String, Object> customParams = task.getCustomParams();
        HashMap<String, Object> payScheParams = new HashMap<String, Object>(4);
        HashSet clearDraftPayIdSet = new HashSet(16);
        if (null != customParams) {
            Set draftPayIdSet;
            Object isPayScheBack;
            Object refundrowamts = customParams.get("refundrowamts");
            if (refundrowamts instanceof Map) {
                refundAMTMap.putAll((Map)refundrowamts);
            }
            if ((isPayScheBack = customParams.get("isPayScheBack")) != null) {
                payScheParams.put("isPayScheBack", customParams.get("isPayScheBack"));
                payScheParams.put("payScheOPType", customParams.get("payScheOPType"));
                payScheParams.put("payScheRelease", customParams.get("payScheRelease"));
                payScheParams.put("delPayApplyBillIds", customParams.get("delPayApplyBillIds"));
            }
            if (EmptyUtil.isNoEmpty((Object)(draftPayIdSet = (Set)customParams.get("clearDraftPayIdSet")))) {
                clearDraftPayIdSet.addAll(draftPayIdSet);
            }
        }
        for (int j = 0; j < entry.size(); ++j) {
            DynamicObject settleType;
            Object isfullrefund;
            BigDecimal bigDecimal;
            DynamicObject row = (DynamicObject)entry.get(j);
            HashMap<String, Object> disposeRowInfo = new HashMap<String, Object>(50);
            disposeRowInfo.put("issuccess", isSuccess);
            String srcBillType = paymentBill.getString("sourcebilltype");
            disposeRowInfo.put("sourceentity", srcBillType);
            disposeRowInfo.put("sourcebillid", paymentBill.getLong("sourcebillid"));
            disposeRowInfo.put("sourcepk", row.getLong("e_sourcebillid"));
            disposeRowInfo.put("sourceentrypk", row.getLong("e_sourcebillentryid"));
            disposeRowInfo.put("sourceentryno", row.getLong("e_corebillentryseq"));
            disposeRowInfo.put("corebilltype", row.getString("e_corebilltype"));
            disposeRowInfo.put("corebillno", row.getString("e_corebillno"));
            disposeRowInfo.put("corebillid", row.getLong("e_corebillid"));
            disposeRowInfo.put("corebillentryid", row.getLong("e_corebillentryid"));
            disposeRowInfo.put("paymentbiztype", null == row.getDynamicObject("e_paymenttype") ? "" : row.getDynamicObject("e_paymenttype").getString("biztype"));
            disposeRowInfo.put("entryseq", j + 1);
            disposeRowInfo.put("currencypk", paymentBill.getLong("currency.id"));
            BigDecimal amount = row.getBigDecimal("e_actamt");
            logger.info("------\u53cd\u5199\u53c2\u6570\uff1aamount\uff1a" + amount);
            if (("cancelPay".endsWith(operate) || "refund".endsWith(operate) || "renote".endsWith(operate)) && ("pm_purorderbill".equals(srcBillType) || "ap_payapply".equals(srcBillType))) {
                amount = amount.negate();
            }
            if (StringUtils.isNotEmpty((CharSequence)operate) && (WriteBackOperateEnum.REFUND.getValue().equals(operate) || WriteBackOperateEnum.RENOTE.getValue().equals(operate)) && "ap_payapply".equals(srcBillType)) {
                disposeRowInfo.put("amount", row.getBigDecimal("e_refundamt").negate());
            } else {
                disposeRowInfo.put("amount", amount);
            }
            disposeRowInfo.put("localamt", row.getBigDecimal("e_localamt"));
            disposeRowInfo.put("payableamt", row.getBigDecimal("e_payableamt"));
            disposeRowInfo.put("payablelocamt", row.getBigDecimal("e_payablelocamt"));
            if (StringUtils.isNotEmpty((CharSequence)operate) && (WriteBackOperateEnum.CANCELREFUND.getValue().equals(operate) || WriteBackOperateEnum.CANCELRENOTE.getValue().equals(operate))) {
                bigDecimal = (BigDecimal)refundAMTMap.get(row.getLong("id"));
                disposeRowInfo.put("refundamt", bigDecimal == null ? BigDecimal.ZERO : bigDecimal.negate());
            } else if (StringUtils.isNotEmpty((CharSequence)operate) && (WriteBackOperateEnum.RENOTEVALIDATE.getValue().equals(operate) || WriteBackOperateEnum.REFUNDVALIDATE.getValue().equals(operate))) {
                bigDecimal = (BigDecimal)refundAMTMap.get(row.getLong("id"));
                disposeRowInfo.put("refundamt", bigDecimal == null ? BigDecimal.ZERO : bigDecimal);
            } else {
                disposeRowInfo.put("refundamt", row.getBigDecimal("e_refundamt"));
            }
            disposeRowInfo.put("refunddes", row.getString("e_refunddes"));
            disposeRowInfo.put("targetentity", "cas_paybill");
            disposeRowInfo.put("targetpk", paymentBill.getPkValue());
            disposeRowInfo.put("targetentrypk", row.getPkValue());
            disposeRowInfo.put("operate", operate);
            disposeRowInfo.put("reason", paymentBill.getString("reason"));
            disposeRowInfo.put("paymentidentify", CasHelper.isEmpty((Object)paymentBill.getDynamicObject("paymentidentify")) ? paymentBill.getDynamicObject("paymentidentify") : Long.valueOf(paymentBill.getDynamicObject("paymentidentify").getLong("id")));
            disposeRowInfo.put("renote_recbill", renote_recbill);
            if (null != customParams && (isfullrefund = customParams.get("isfullrefund")) != null) {
                disposeRowInfo.put("isfullrefund", isfullrefund);
            }
            disposeRowInfo.put("targetbillno", paymentBill.getString("billno"));
            disposeRowInfo.put("bizdate", paymentBill.getDate("bizdate"));
            disposeRowInfo.put("paydate", paymentBill.getDate("paydate"));
            disposeRowInfo.put("org", null == paymentBill.getDynamicObject("org") ? Long.valueOf(0L) : paymentBill.getDynamicObject("org").getPkValue());
            disposeRowInfo.put("openorg", null == paymentBill.getDynamicObject("openorg") ? Long.valueOf(0L) : paymentBill.getDynamicObject("openorg").getPkValue());
            disposeRowInfo.put("payeracctbank", null == paymentBill.getDynamicObject("payeracctbank") ? Long.valueOf(0L) : paymentBill.getDynamicObject("payeracctbank").getPkValue());
            if (null != paymentBill.getDynamicObject("payeracctbank")) {
                disposeRowInfo.put("payeracctbankno", paymentBill.getDynamicObject("payeracctbank").getString("bankaccountnumber"));
            }
            disposeRowInfo.put("payerbank", null == paymentBill.getDynamicObject("payerbank") ? Long.valueOf(0L) : paymentBill.getDynamicObject("payerbank").getPkValue());
            disposeRowInfo.put("exchangerate", paymentBill.getBigDecimal("exchangerate"));
            disposeRowInfo.put("entrustorg", null == paymentBill.getDynamicObject("entrustorg") ? Long.valueOf(0L) : paymentBill.getDynamicObject("entrustorg").getPkValue());
            disposeRowInfo.put("settletype", null == paymentBill.getDynamicObject("settletype") ? Long.valueOf(0L) : paymentBill.getDynamicObject("settletype").getPkValue());
            disposeRowInfo.put("agreedrate", paymentBill.getBigDecimal("agreedrate"));
            disposeRowInfo.put("dpcurrency", null == paymentBill.getDynamicObject("dpcurrency") ? Long.valueOf(0L) : paymentBill.getDynamicObject("dpcurrency").getPkValue());
            disposeRowInfo.put("dpexchangerate", paymentBill.getBigDecimal("dpexchangerate"));
            disposeRowInfo.put("isdiffcur", paymentBill.getBoolean("isdiffcur"));
            disposeRowInfo.put("dpamt", paymentBill.getBigDecimal("dpamt"));
            disposeRowInfo.put("dplocalamt", paymentBill.getBigDecimal("dplocalamt"));
            disposeRowInfo.put("lossamt", paymentBill.getBigDecimal("lossamt"));
            disposeRowInfo.put("fee", paymentBill.getBigDecimal("fee"));
            disposeRowInfo.put("feecurrency", null == paymentBill.getDynamicObject("feecurrency") ? Long.valueOf(0L) : paymentBill.getDynamicObject("feecurrency").getPkValue());
            disposeRowInfo.put("iscommitbe", paymentBill.getBoolean("iscommitbe"));
            disposeRowInfo.put("bankreturnmsg", paymentBill.getString("bankreturnmsg"));
            DynamicObjectCollection draftBillColl = paymentBill.getDynamicObjectCollection("draftbill");
            if (!CollectionUtils.isEmpty((Collection)draftBillColl)) {
                Set draftBills = draftBillColl.stream().filter(o -> o.getDynamicObject("fbasedataid") != null).map(o -> o.getDynamicObject("fbasedataid")).collect(Collectors.toSet());
                String settleNumber = draftBills.stream().map(draft -> draft.getString("draftbillno")).collect(Collectors.joining(","));
                logger.info("=======1.\u5355\u7b14\u4ed8\u6b3e\u5355\u7684\u53cd\u5199\u52a1\u5904\u7406\uff0c\u6dfb\u52a0\u53cd\u5199\u7ed3\u7b97\u53f7:{}", (Object)settleNumber);
                disposeRowInfo.put("settletnumber", StringHelper.subString(settleNumber, 2000));
                disposeRowInfo.put("draftBills", draftBills);
                disposeRowInfo.put("clearDraft", clearDraftPayIdSet.contains(payBillId));
                DynamicObjectCollection cas_draftinfos = paymentBill.getDynamicObjectCollection("cas_draftinfo");
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)cas_draftinfos) && cas_draftinfos.size() > 0 && WriteBackOperateEnum.DELETE.getValue().equals(operate)) {
                    List billLogList = cas_draftinfos.stream().filter(e -> EmptyUtil.isNoEmpty((Long)e.getLong("draftbilllogid"))).map(e -> e.getLong("draftbilllogid")).collect(Collectors.toList());
                    DynamicObjectCollection paySelectDraftLog = QueryServiceHelper.query((String)"cdm_draftbill_log", (String)"id,sourcebilltype,bizbillno", (QFilter[])new QFilter[]{new QFilter("id", "in", billLogList), new QFilter("sourcebilltype", "=", (Object)"cas_paybill"), new QFilter("sourcebillid", "=", (Object)paymentBill.getLong("id"))});
                    if (EmptyUtil.isNoEmpty((DynamicObjectCollection)paySelectDraftLog) && paySelectDraftLog.size() > 0) {
                        disposeRowInfo.put("paymentselectedbill", "Y");
                    } else {
                        disposeRowInfo.put("paymentselectedbill", "N");
                    }
                } else {
                    disposeRowInfo.put("paymentselectedbill", "N");
                }
            }
            if (PayBillHepler.isCreditSettlement(settleType = paymentBill.getDynamicObject("settletype"))) {
                disposeRowInfo.put("billno", paymentBill.getString("billno"));
                disposeRowInfo.put("actpayamt", paymentBill.getBigDecimal("actpayamt"));
                logger.info("=======2.\u5355\u7b14\u4ed8\u6b3e\u5355\u7684\u53cd\u5199\u52a1\u5904\u7406\uff0c\u6dfb\u52a0\u53cd\u5199\u7ed3\u7b97\u53f7:{}", (Object)paymentBill.getString("settletnumber"));
                disposeRowInfo.put("settletnumber", paymentBill.getString("settletnumber"));
                disposeRowInfo.put("description", paymentBill.getString("description"));
            }
            if (PayBillHepler.isLCSettlement(settleType, SettleMentTypeEnum.CREDITOPEN)) {
                disposeRowInfo.put("settletnumber", paymentBill.getString("settletnumber"));
            }
            if (payScheParams.size() > 0) {
                disposeRowInfo.put("isPayScheBack", payScheParams.get("isPayScheBack"));
                disposeRowInfo.put("payScheRelease", payScheParams.get("payScheRelease"));
                disposeRowInfo.put("payScheOPType", payScheParams.get("payScheOPType"));
                disposeRowInfo.put("delPayApplyBillIds", payScheParams.get("delPayApplyBillIds"));
            }
            logger.info("=======\u5355\u7b14\u4ed8\u6b3e\u5355\u7684\u53cd\u5199\u52a1\u5904\u7406\uff0c\u53cd\u5199\u53c2\u6570\u4fe1\u606f: targetbillno:{}, settletnumber:{}", disposeRowInfo.get("targetbillno"), disposeRowInfo.get("settletnumber"));
            Map<String, Object> extendInfo = extendInfos.get(row.getLong("id"));
            if (extendInfo != null && extendInfo.size() > 0) {
                disposeRowInfo.putAll(extendInfo);
            }
            this.putReceiveInfo(disposeRowInfo, paymentBill);
            disposeData.add(disposeRowInfo);
            logger.info("------\u53cd\u5199\u53c2\u6570\uff1aisSuccess\uff1a" + isSuccess + ",sourceentity:" + srcBillType + ",\u91d1\u989d\uff1a" + amount + "\u6e90\u5355ID:" + disposeRowInfo.get("sourcepk"));
            logger.info("------\u53cd\u5199\u53c2\u6570\uff1amap\uff1a" + SerializationUtils.toJsonString(disposeRowInfo));
        }
        return new Object[]{disposeData};
    }

    private Object[] batchBillProcess(WriteBackTask task) {
        Long[] billPks = task.getBillPks();
        WriteBackOperateEnum wbopEnum = task.getOperation();
        Map<String, Object> customParams = task.getCustomParams();
        DynamicObject[] paybills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)BILL_FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billPks)});
        Map<Long, Set<Long>> renotRecIdMap = this.getRenoteRecBills(paybills, wbopEnum);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < paybills.length; ++i) {
            DynamicObject paybill = paybills[i];
            long pkId = paybill.getLong("id");
            Map<Long, Map<String, Object>> extendInfo = this.loadExtendInfo(pkId);
            list.addAll(this.genDisposeData(paybill, wbopEnum, customParams, renotRecIdMap, extendInfo));
        }
        return new Object[]{list};
    }

    private List<Map<String, Object>> genDisposeData(DynamicObject paybill, WriteBackOperateEnum wbopEnm, Map<String, Object> customParams, Map<Long, Set<Long>> renotRecIdMap, Map<Long, Map<String, Object>> extendInfo) {
        ArrayList<Map<String, Object>> disposeData = new ArrayList<Map<String, Object>>();
        long pkId = paybill.getLong("id");
        String billStatus = paybill.getString("billStatus");
        String srcBillType = paybill.getString("sourcebilltype");
        Long sourceBillId = paybill.getLong("sourcebillid");
        Long currenyId = paybill.getLong("currency.id");
        String reason = paybill.getString("reason");
        DynamicObjectCollection entry = paybill.getDynamicObjectCollection("entry");
        Set<Long> recIds = renotRecIdMap.get(pkId);
        boolean isSuccess = BillStatusEnum.PAY.getValue().equals(billStatus) ? true : WriteBackOperateEnum.PAYVALIDATE == wbopEnm;
        String operation = wbopEnm.getValue();
        HashMap refundAMTMap = new HashMap();
        HashMap<String, Object> payScheParams = new HashMap<String, Object>(4);
        HashSet clearDraftPayIdSet = new HashSet(16);
        if (null != customParams) {
            Set draftPayIdSet;
            Object isPayScheBack;
            Object refundrowamts = customParams.get("refundrowamts");
            if (refundrowamts instanceof Map) {
                refundAMTMap.putAll((Map)refundrowamts);
            }
            if ((isPayScheBack = customParams.get("isPayScheBack")) != null) {
                payScheParams.put("isPayScheBack", customParams.get("isPayScheBack"));
                payScheParams.put("payScheOPType", customParams.get("payScheOPType"));
                payScheParams.put("payScheRelease", customParams.get("payScheRelease"));
                payScheParams.put("delPayApplyBillIds", customParams.get("delPayApplyBillIds"));
            }
            if (EmptyUtil.isNoEmpty((Object)(draftPayIdSet = (Set)customParams.get("clearDraftPayIdSet")))) {
                clearDraftPayIdSet.addAll(draftPayIdSet);
            }
        }
        for (DynamicObject row : entry) {
            DynamicObject settleType;
            Object isfullrefund;
            HashMap<String, Object> disposeRowInfo = new HashMap<String, Object>(64);
            disposeRowInfo.put("issuccess", isSuccess);
            disposeRowInfo.put("sourceentity", srcBillType);
            disposeRowInfo.put("sourcebillid", sourceBillId);
            disposeRowInfo.put("sourcepk", row.getLong("e_sourcebillid"));
            disposeRowInfo.put("sourceentrypk", row.getLong("e_sourcebillentryid"));
            disposeRowInfo.put("sourceentryno", row.getLong("e_corebillentryseq"));
            disposeRowInfo.put("currencypk", currenyId);
            BigDecimal amount = row.getBigDecimal("e_actamt");
            logger.info("------\u53cd\u5199\u53c2\u6570\uff1aamount\uff1a" + amount);
            if (("cancelPay".endsWith(operation) || "refund".endsWith(operation) || "renote".endsWith(operation)) && ("pm_purorderbill".equals(srcBillType) || "ap_payapply".equals(srcBillType))) {
                amount = amount.negate();
            }
            if (StringUtils.isNotEmpty((CharSequence)operation) && (WriteBackOperateEnum.REFUND.getValue().equals(operation) || WriteBackOperateEnum.RENOTE.getValue().equals(operation)) && "ap_payapply".equals(srcBillType)) {
                disposeRowInfo.put("amount", row.getBigDecimal("e_refundamt").negate());
            } else {
                disposeRowInfo.put("amount", amount);
            }
            disposeRowInfo.put("localamt", row.getBigDecimal("e_localamt"));
            disposeRowInfo.put("payableamt", row.getBigDecimal("e_payableamt"));
            disposeRowInfo.put("payablelocamt", row.getBigDecimal("e_payablelocamt"));
            BigDecimal bigDecimal = (BigDecimal)refundAMTMap.get(row.getLong("id"));
            if (StringUtils.isNotEmpty((CharSequence)operation) && (WriteBackOperateEnum.CANCELREFUND.getValue().equals(operation) || WriteBackOperateEnum.CANCELRENOTE.getValue().equals(operation))) {
                disposeRowInfo.put("refundamt", bigDecimal == null ? BigDecimal.ZERO : bigDecimal.negate());
            } else if (StringUtils.isNotEmpty((CharSequence)operation) && (WriteBackOperateEnum.RENOTEVALIDATE.getValue().equals(operation) || WriteBackOperateEnum.REFUNDVALIDATE.getValue().equals(operation))) {
                disposeRowInfo.put("refundamt", bigDecimal == null ? BigDecimal.ZERO : bigDecimal);
            } else {
                disposeRowInfo.put("refundamt", row.getBigDecimal("e_refundamt"));
            }
            disposeRowInfo.put("refunddes", row.getString("e_refunddes"));
            disposeRowInfo.put("targetentity", "cas_paybill");
            disposeRowInfo.put("targetpk", pkId);
            disposeRowInfo.put("targetentrypk", row.getPkValue());
            disposeRowInfo.put("operate", operation);
            disposeRowInfo.put("reason", reason);
            disposeRowInfo.put("paymentidentify", CasHelper.isEmpty((Object)paybill.getDynamicObject("paymentidentify")) ? paybill.getDynamicObject("paymentidentify") : Long.valueOf(paybill.getDynamicObject("paymentidentify").getLong("id")));
            disposeRowInfo.put("renote_recbill", recIds);
            if (null != customParams && (isfullrefund = customParams.get("isfullrefund")) != null) {
                disposeRowInfo.put("isfullrefund", isfullrefund);
            }
            disposeRowInfo.put("targetbillno", paybill.getString("billno"));
            disposeRowInfo.put("bizdate", paybill.getDate("bizdate"));
            disposeRowInfo.put("paydate", paybill.getDate("paydate"));
            disposeRowInfo.put("org", null == paybill.getDynamicObject("org") ? Long.valueOf(0L) : paybill.getDynamicObject("org").getPkValue());
            disposeRowInfo.put("openorg", null == paybill.getDynamicObject("openorg") ? Long.valueOf(0L) : paybill.getDynamicObject("openorg").getPkValue());
            disposeRowInfo.put("payeracctbank", null == paybill.getDynamicObject("payeracctbank") ? Long.valueOf(0L) : paybill.getDynamicObject("payeracctbank").getPkValue());
            if (null != paybill.getDynamicObject("payeracctbank")) {
                disposeRowInfo.put("payeracctbankno", paybill.getDynamicObject("payeracctbank").getString("bankaccountnumber"));
            }
            disposeRowInfo.put("payerbank", null == paybill.getDynamicObject("payerbank") ? Long.valueOf(0L) : paybill.getDynamicObject("payerbank").getPkValue());
            disposeRowInfo.put("exchangerate", paybill.getBigDecimal("exchangerate"));
            disposeRowInfo.put("entrustorg", null == paybill.getDynamicObject("entrustorg") ? Long.valueOf(0L) : paybill.getDynamicObject("entrustorg").getPkValue());
            disposeRowInfo.put("settletype", null == paybill.getDynamicObject("settletype") ? Long.valueOf(0L) : paybill.getDynamicObject("settletype").getPkValue());
            disposeRowInfo.put("agreedrate", paybill.getBigDecimal("agreedrate"));
            disposeRowInfo.put("dpcurrency", null == paybill.getDynamicObject("dpcurrency") ? Long.valueOf(0L) : paybill.getDynamicObject("dpcurrency").getPkValue());
            disposeRowInfo.put("dpexchangerate", paybill.getBigDecimal("dpexchangerate"));
            disposeRowInfo.put("isdiffcur", paybill.getBoolean("isdiffcur"));
            disposeRowInfo.put("dpamt", paybill.getBigDecimal("dpamt"));
            disposeRowInfo.put("dplocalamt", paybill.getBigDecimal("dplocalamt"));
            disposeRowInfo.put("lossamt", paybill.getBigDecimal("lossamt"));
            disposeRowInfo.put("fee", paybill.getBigDecimal("fee"));
            disposeRowInfo.put("feecurrency", null == paybill.getDynamicObject("feecurrency") ? Long.valueOf(0L) : paybill.getDynamicObject("feecurrency").getPkValue());
            disposeRowInfo.put("iscommitbe", paybill.getBoolean("iscommitbe"));
            disposeRowInfo.put("bankreturnmsg", paybill.getString("bankreturnmsg"));
            DynamicObjectCollection draftBillColl = paybill.getDynamicObjectCollection("draftbill");
            if (!CollectionUtils.isEmpty((Collection)draftBillColl)) {
                Set draftBills = draftBillColl.stream().filter(o -> o.getDynamicObject("fbasedataid") != null).map(o -> o.getDynamicObject("fbasedataid")).collect(Collectors.toSet());
                String settleNumber = draftBills.stream().map(draft -> draft.getString("draftbillno")).collect(Collectors.joining(","));
                logger.info("=======1.\u6279\u91cf\u4ed8\u6b3e\u5355\u7684\u53cd\u5199\u7684\u4e1a\u52a1\u5904\u7406\uff0c\u6dfb\u52a0\u53cd\u5199\u7ed3\u7b97\u53f7:{}", (Object)settleNumber);
                disposeRowInfo.put("settletnumber", StringHelper.subString(settleNumber, 2000));
                disposeRowInfo.put("draftBills", draftBills);
                disposeRowInfo.put("clearDraft", clearDraftPayIdSet.contains(pkId));
                DynamicObjectCollection cas_draftinfos = paybill.getDynamicObjectCollection("cas_draftinfo");
                if (EmptyUtil.isNoEmpty((DynamicObjectCollection)cas_draftinfos) && cas_draftinfos.size() > 0 && WriteBackOperateEnum.DELETE.getValue().equals(operation)) {
                    List billLogList = cas_draftinfos.stream().filter(e -> EmptyUtil.isNoEmpty((Long)e.getLong("draftbilllogid"))).map(e -> e.getLong("draftbilllogid")).collect(Collectors.toList());
                    DynamicObjectCollection paySelectDraftLog = QueryServiceHelper.query((String)"cdm_draftbill_log", (String)"id,sourcebilltype,bizbillno", (QFilter[])new QFilter[]{new QFilter("id", "in", billLogList), new QFilter("sourcebilltype", "=", (Object)"cas_paybill"), new QFilter("sourcebillid", "=", (Object)paybill.getLong("id"))});
                    if (EmptyUtil.isNoEmpty((DynamicObjectCollection)paySelectDraftLog) && paySelectDraftLog.size() > 0) {
                        disposeRowInfo.put("paymentselectedbill", "Y");
                    } else {
                        disposeRowInfo.put("paymentselectedbill", "N");
                    }
                } else {
                    disposeRowInfo.put("paymentselectedbill", "N");
                }
            }
            if (PayBillHepler.isCreditSettlement(settleType = paybill.getDynamicObject("settletype"))) {
                disposeRowInfo.put("billno", paybill.getString("billno"));
                disposeRowInfo.put("actpayamt", paybill.getBigDecimal("actpayamt"));
                logger.info("=======2.\u6279\u91cf\u4ed8\u6b3e\u5355\u7684\u53cd\u5199\u7684\u4e1a\u52a1\u5904\u7406\uff0c\u6dfb\u52a0\u53cd\u5199\u7ed3\u7b97\u53f7:{}", (Object)paybill.getString("settletnumber"));
                disposeRowInfo.put("settletnumber", paybill.getString("settletnumber"));
                disposeRowInfo.put("description", paybill.getString("description"));
            }
            if (PayBillHepler.isLCSettlement(settleType, SettleMentTypeEnum.CREDITOPEN)) {
                disposeRowInfo.put("settletnumber", paybill.getString("settletnumber"));
            }
            if (payScheParams.size() > 0) {
                disposeRowInfo.put("ispayscheback", payScheParams.get("payScheParams"));
                disposeRowInfo.put("payscheoptype", payScheParams.get("payscheoptype"));
                disposeRowInfo.put("payscherelease", payScheParams.get("payscherelease"));
            }
            Map<String, Object> infoMap = extendInfo.get(row.getLong("id"));
            if (extendInfo != null && extendInfo.size() > 0) {
                disposeRowInfo.putAll(infoMap);
            }
            this.putReceiveInfo(disposeRowInfo, paybill);
            logger.info("=======\u6279\u91cf\u4ed8\u6b3e\u5355\u7684\u53cd\u5199\u7684\u4e1a\u52a1\u5904\u7406\uff0c\u53cd\u5199\u53c2\u6570\u4fe1\u606f: targetbillno:{}, settletnumber:{}", disposeRowInfo.get("targetbillno"), disposeRowInfo.get("settletnumber"));
            logger.info("=======\u6279\u91cf\u4ed8\u6b3e\u5355\u7684\u53cd\u5199\u7684\u4e1a\u52a1\u5904\u7406\uff0c\u53cd\u5199\u53c2\u6570\u5bf9\u8c61\u4fe1\u606f\uff1a" + SerializationUtils.toJsonString(disposeRowInfo));
            disposeData.add(disposeRowInfo);
        }
        return disposeData;
    }

    private Map<Long, Set<Long>> getRenoteRecBills(DynamicObject[] paybills, WriteBackOperateEnum wbopEnum) {
        Long[] ids = (Long[])((Stream)Arrays.stream(paybills).parallel()).map(d -> d.getLong("id")).toArray(Long[]::new);
        Object[] renoteIds = (Long[])((Stream)Arrays.stream(paybills).parallel()).filter(d -> BillStatusEnum.RENOTE.getValue().equals(d.getString("billstatus"))).map(d -> d.getLong("id")).toArray(Long[]::new);
        Map result = new HashMap();
        if (EmptyUtil.isEmpty((Object[])renoteIds)) {
            if (WriteBackOperateEnum.REFUND.getValue().equals(wbopEnum.getValue())) {
                result = CasBotpHelper.batchGetSrcBillByDestBill((Long[])ids, (String)"cas_paybill", (String)"cas_recbill");
            }
        } else {
            result = CasBotpHelper.batchGetSrcBillByDestBill((Long[])renoteIds, (String)"cas_paybill", (String)"cas_recbill");
        }
        return result;
    }

    private void putReceiveInfo(Map<String, Object> disposeRowInfo, DynamicObject paymentBill) {
        String srcBillType = paymentBill.getString("sourcebilltype");
        if ("fr_glreim_paybill".equals(srcBillType)) {
            disposeRowInfo.put("payeename", paymentBill.getString("payeename"));
            disposeRowInfo.put("payeebanknum", paymentBill.getString("payeebanknum"));
            disposeRowInfo.put("payeeacctbank", paymentBill.getString("payeeacctbank"));
            disposeRowInfo.put("payeeacctcash", paymentBill.getString("payeeacctcash"));
            disposeRowInfo.put("payeebankname", paymentBill.getString("payeebankname"));
            DynamicObject payeeBank = paymentBill.getDynamicObject("payeebank");
            if (payeeBank != null) {
                disposeRowInfo.put("payeebank", payeeBank.getPkValue());
            }
        }
    }
}

