/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.writeback;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.writeback.WriteBackConfigInvoker;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.business.writeback.task.WriteBackTask;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.EmptyUtil;

public class RecWriteBackConsumer
extends WriteBackConfigInvoker {
    @Override
    protected Object[] getInvokeParams(WriteBackTask task) {
        List entryPks;
        DynamicObject recBill;
        ArrayList dispostData = new ArrayList();
        Object billPk = task.getBillPk();
        DynamicObjectCollection collection = task.getEntrys();
        boolean bizType = false;
        boolean confirmlogo = false;
        Map<String, Object> customParams = task.getCustomParams();
        if (EmptyUtil.isNoEmpty((Object)billPk)) {
            recBill = BusinessDataServiceHelper.loadSingle((Object)billPk, (String)"cas_recbill");
        } else {
            DynamicObject dynamicObject = recBill = customParams != null ? (DynamicObject)customParams.get("info") : null;
        }
        if (CasHelper.isNotEmpty((Object)billPk) && task.getOperation() != WriteBackOperateEnum.SUBMITVALIDATE) {
            collection = recBill.getDynamicObjectCollection("entry");
            if ("cfm_loanbill".equals(recBill.getString("sourcebilltype"))) {
                HashMap<String, Object> dispostParam = new HashMap<String, Object>(10);
                dispostParam.put("payeedate", recBill.get("bizdate"));
                dispostParam.put("sourcebillid", recBill.get("sourcebillid"));
                dispostParam.put("operate", task.getOperation().getValue());
                dispostParam.put("txt_description", recBill.get("txt_description"));
                dispostParam.put("fee", recBill.get("fee"));
                dispostParam.put("bizdate", recBill.get("bizdate"));
                dispostParam.put("currencypk", recBill.getDynamicObject("currency").getPkValue());
                return new Object[]{dispostParam};
            }
            DynamicObject recType = recBill.getDynamicObject("receivingtype");
            if ("101".equals(recType.getString("biztype"))) {
                bizType = true;
            }
            confirmlogo = recBill.getBoolean("confirmlogo");
        }
        if (customParams != null && (entryPks = (List)customParams.get("entryPks")) != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                DynamicObject row = (DynamicObject)iterator.next();
                if (entryPks.contains(row.getPkValue())) continue;
                iterator.remove();
            }
        }
        for (DynamicObject entry : collection) {
            HashMap<String, Object> disposeRowInfo = new HashMap<String, Object>(26);
            disposeRowInfo.put("sourcepk", entry.getLong("e_sourcebillid"));
            disposeRowInfo.put("sourceentrypk", entry.getLong("e_sourcebillentryid"));
            BigDecimal paidamt = entry.getBigDecimal("e_actamt");
            if (task.getSourceEntityKey().equals("fr_glreim_bill") || task.getSourceEntityKey().equals("ar_finarbill")) {
                paidamt = entry.getBigDecimal("e_receivableamt");
            }
            if (WriteBackOperateEnum.CANCELRECEIVE == task.getOperation() || WriteBackOperateEnum.UNSUBMIT == task.getOperation()) {
                disposeRowInfo.put("amount", paidamt.negate());
            } else {
                disposeRowInfo.put("amount", paidamt);
            }
            disposeRowInfo.put("corebilltype", entry.getString("e_corebilltype"));
            disposeRowInfo.put("corebillno", entry.getString("e_corebillno"));
            disposeRowInfo.put("corebillid", entry.getLong("e_corebillid"));
            disposeRowInfo.put("biztype", bizType);
            disposeRowInfo.put("operation", task.getOperation().getValue());
            disposeRowInfo.put("confirmlogo", confirmlogo);
            disposeRowInfo.put("targetentrypk", entry.getPkValue());
            disposeRowInfo.put("targetpk", billPk);
            disposeRowInfo.put("targetbilltype", task.getEntityKey());
            disposeRowInfo.put("targetbillno", recBill.get("billno"));
            disposeRowInfo.put("payeedate", recBill.get("payeedate"));
            disposeRowInfo.put("sourcebillid", recBill.get("sourcebillid"));
            disposeRowInfo.put("txt_description", recBill.get("txt_description"));
            disposeRowInfo.put("fee", recBill.get("fee"));
            disposeRowInfo.put("bizdate", recBill.get("bizdate"));
            disposeRowInfo.put("currencypk", recBill.getDynamicObject("currency").getPkValue());
            dispostData.add(disposeRowInfo);
        }
        return new Object[]{dispostData};
    }

    @Override
    protected Object[] getInvokeParamsList(List<WriteBackTask> task) {
        List billPks = task.stream().map(o -> o.getBillPk()).collect(Collectors.toList());
        DynamicObject[] recBills = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"id,billno,sourcebilltype,bizdate,sourcebillid,receivingtype,confirmlogo,payeedate,txt_description,fee,bizdate,currency,entry,entry.e_sourcebillid,entry.e_sourcebillentryid,entry.e_actamt,entry.e_receivableamt,entry.e_corebilltype,entry.e_corebillno,entry.e_corebillid", (QFilter[])new QFilter[]{new QFilter("id", "in", billPks)});
        Map recBillMap = Arrays.stream(recBills).collect(Collectors.toMap(o -> o.getPkValue(), Function.identity()));
        ArrayList listAll = new ArrayList();
        for (WriteBackTask writeBackTask : task) {
            List entryPks;
            Map<String, Object> customParams;
            Object billPk = writeBackTask.getBillPk();
            DynamicObjectCollection collection = writeBackTask.getEntrys();
            boolean bizType = false;
            boolean confirmlogo = false;
            DynamicObject recBill = (DynamicObject)recBillMap.get(writeBackTask.getBillPk());
            if (CasHelper.isNotEmpty((Object)billPk) && writeBackTask.getOperation() != WriteBackOperateEnum.SUBMITVALIDATE) {
                collection = recBill.getDynamicObjectCollection("entry");
                if ("cfm_loanbill".equals(recBill.getString("sourcebilltype"))) {
                    HashMap<String, Object> dispostParam = new HashMap<String, Object>();
                    dispostParam.put("payeedate", recBill.get("bizdate"));
                    dispostParam.put("sourcebillid", recBill.get("sourcebillid"));
                    dispostParam.put("operate", writeBackTask.getOperation().getValue());
                    return new Object[]{dispostParam};
                }
                DynamicObject recType = recBill.getDynamicObject("receivingtype");
                if ("101".equals(recType.getString("biztype"))) {
                    bizType = true;
                }
                confirmlogo = recBill.getBoolean("confirmlogo");
            }
            if ((customParams = writeBackTask.getCustomParams()) != null && (entryPks = (List)customParams.get("entryPks")) != null) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    DynamicObject row = (DynamicObject)iterator.next();
                    if (entryPks.contains(row.getPkValue())) continue;
                    iterator.remove();
                }
            }
            for (DynamicObject entry : collection) {
                HashMap<String, Object> disposeRowInfo = new HashMap<String, Object>(26);
                disposeRowInfo.put("sourcepk", entry.getLong("e_sourcebillid"));
                disposeRowInfo.put("sourceentrypk", entry.getLong("e_sourcebillentryid"));
                BigDecimal paidamt = entry.getBigDecimal("e_actamt");
                if (writeBackTask.getSourceEntityKey().equals("fr_glreim_bill") || writeBackTask.getSourceEntityKey().equals("ar_finarbill")) {
                    paidamt = entry.getBigDecimal("e_receivableamt");
                }
                if (WriteBackOperateEnum.CANCELRECEIVE == writeBackTask.getOperation() || WriteBackOperateEnum.UNSUBMIT == writeBackTask.getOperation()) {
                    disposeRowInfo.put("amount", paidamt.negate());
                } else {
                    disposeRowInfo.put("amount", paidamt);
                }
                disposeRowInfo.put("corebilltype", entry.getString("e_corebilltype"));
                disposeRowInfo.put("corebillno", entry.getString("e_corebillno"));
                disposeRowInfo.put("corebillid", entry.getLong("e_corebillid"));
                disposeRowInfo.put("biztype", bizType);
                disposeRowInfo.put("operation", writeBackTask.getOperation().getValue());
                disposeRowInfo.put("confirmlogo", confirmlogo);
                disposeRowInfo.put("targetentrypk", entry.getPkValue());
                disposeRowInfo.put("targetpk", billPk);
                disposeRowInfo.put("targetbilltype", writeBackTask.getEntityKey());
                disposeRowInfo.put("targetbillno", recBill.get("billno"));
                disposeRowInfo.put("payeedate", recBill.get("payeedate"));
                disposeRowInfo.put("sourcebillid", recBill.get("sourcebillid"));
                disposeRowInfo.put("txt_description", recBill.get("txt_description"));
                disposeRowInfo.put("fee", recBill.get("fee"));
                disposeRowInfo.put("bizdate", recBill.get("bizdate"));
                disposeRowInfo.put("currencypk", recBill.getDynamicObject("currency").getPkValue());
                listAll.add(disposeRowInfo);
            }
        }
        return new Object[]{listAll};
    }
}

