/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.writeback;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.business.writeback.WriteBackTaskConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;

public class WriteBackValidateHelper {
    private static final Log logger = LogFactory.getLog(WriteBackValidateHelper.class);
    private static final Set<String> ER_VALIDATE_BILLS = new HashSet<String>(){
        {
            this.add("er_dailyreimbursebill");
            this.add("er_dailyloanbill");
            this.add("er_tripreqbill");
            this.add("er_tripreimbursebill");
            this.add("er_checkingpaybill");
            this.add("er_publicreimbursebill");
            this.add("er_prepaybill");
            this.add("er_applypaybill");
        }
    };

    public static Set<String> getErValidateBills() {
        HashSet<String> bills = new HashSet<String>();
        bills.add("er_dailyreimbursebill");
        bills.add("er_dailyloanbill");
        bills.add("er_tripreqbill");
        bills.add("er_tripreimbursebill");
        bills.add("er_checkingpaybill");
        bills.add("er_publicreimbursebill");
        bills.add("er_prepaybill");
        bills.add("er_applypaybill");
        bills.add("fr_glreim_paybill");
        return bills;
    }

    public static Set<String> getOldValidateTypeBills() {
        HashSet<String> bills = new HashSet<String>();
        bills.add("fr_glreim_paybill");
        return bills;
    }

    public static boolean isErValidateBill(String sourceBillType) {
        return ER_VALIDATE_BILLS.contains(sourceBillType);
    }

    public static <T extends WriteBackTaskConsumer> void writeBackValidate(DynamicObject bill, WriteBackOperateEnum operation, Class<T> taskConsumer) {
        String billType = bill.getString("sourcebilltype");
        if (WriteBackValidateHelper.getErValidateBills().contains(billType)) {
            Object result = WriteBackTaskHelper.addRealtimeTask(bill, billType, operation, taskConsumer);
            WriteBackValidateHelper.WriteBackResultDeal(bill, result, bill.getString("sourcebilltype"), operation);
        }
    }

    public static <T extends WriteBackTaskConsumer> void writeBackValidate(DynamicObject bill, WriteBackOperateEnum operation, Class<T> taskConsumer, Map<String, Object> params) {
        String billType = bill.getString("sourcebilltype");
        if (WriteBackValidateHelper.getOldValidateTypeBills().contains(billType)) {
            Object result = WriteBackTaskHelper.addRealtimeTask(bill, billType, operation, taskConsumer, params);
            WriteBackValidateHelper.WriteBackResultDeal(bill, result, bill.getString("sourcebilltype"), operation);
        }
    }

    public static void WriteBackResultDeal(DynamicObject bill, Object result, String souceType, WriteBackOperateEnum operation) {
        if (result != null) {
            String messages = ResManager.loadKDString((String)"\u4e0a\u6e38\u5355\u636e\u53cd\u5199\u6821\u9a8c\u5f02\u5e38\u3002", (String)"WriteBackTaskHelper_0", (String)"fi-cas-business", (Object[])new Object[0]);
            OperationResult operationResult = null;
            try {
                if (result instanceof OperationResult) {
                    operationResult = (OperationResult)result;
                }
                if (operationResult == null) {
                    return;
                }
                ValidateResultCollection validateResults = operationResult.getValidateResult();
                List validateErrors = validateResults.getValidateErrors("");
                if (!operationResult.isSuccess()) {
                    logger.info("\u6821\u9a8c\u7ed3\u679c\u96c6\uff1a" + validateErrors.size());
                    if (validateErrors != null && validateErrors.size() > 0) {
                        List allErrorInfo = ((ValidateResult)validateErrors.get(0)).getAllErrorInfo();
                        messages = ((ValidateResult)validateErrors.get(0)).getMessage();
                        if (allErrorInfo != null && allErrorInfo.size() > 0) {
                            logger.info("\u7ed3\u679c\u96c6" + ((OperateErrorInfo)allErrorInfo.get(0)).getMessage());
                            messages = ((OperateErrorInfo)allErrorInfo.get(0)).getMessage();
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.info("WriteBackResultDeal" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            if (operationResult != null && !operationResult.isSuccess()) {
                throw new KDBizException(messages);
            }
        }
    }
}

