/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.writeback.refund;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.Pair;
import kd.fi.cas.business.writeback.WriteBackConfigInvoker;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.business.writeback.task.WriteBackTask;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.RefundHelper;
import kd.fi.cas.refund.RefundEntryInfo;
import kd.fi.cas.refund.RefundPayBillInfo;
import kd.fi.cas.refund.RefundRenoteOrCancelParam;
import kd.fi.cas.refund.SourceBillInfo;

public class RefundWriteBackConsumer
extends WriteBackConfigInvoker {
    private Object[] invokeParams;

    public RefundRenoteOrCancelParam initInvokeParams(Map<String, Object> params, String entityKey, String sourceEntity, WriteBackOperateEnum operation) {
        WriteBackTask task = new WriteBackTask();
        DynamicObject[] bills = (DynamicObject[])params.get("bills");
        task.setBillPks((Long[])Arrays.stream(bills).map(b -> (Long)b.getPkValue()).toArray(Long[]::new));
        task.setEntityKey(entityKey);
        task.setSourceEntityKey(sourceEntity);
        task.setOperation(operation);
        task.setConsumer(this.getClass());
        task.setCustomParams(params);
        return (RefundRenoteOrCancelParam)this.getInvokeParams(task)[0];
    }

    @Override
    protected Object[] getInvokeParams(WriteBackTask task) {
        Function<DynamicObject, BigDecimal> amtFun;
        Function<DynamicObject, List> buildFun;
        if (this.invokeParams != null) {
            return this.invokeParams;
        }
        Map<String, Object> customParams = task.getCustomParams();
        boolean releWithInfo = (Boolean)customParams.get("releWithInfo");
        String releBillType = (String)customParams.get("releBillType");
        List releBillList = (List)customParams.get("releBillList");
        Long revId = (Long)customParams.get("revId");
        DynamicObject[] bills = (DynamicObject[])customParams.get("bills");
        RefundRenoteOrCancelParam writeBackParam = new RefundRenoteOrCancelParam();
        writeBackParam.setOperate(task.getOperation().getValue());
        writeBackParam.setRecId(revId);
        ArrayList<RefundPayBillInfo> refundPayInfos = new ArrayList<RefundPayBillInfo>(releBillList.size());
        writeBackParam.setRefundPayInfos(refundPayInfos);
        Map<Long, List<DynamicObject>> releInfoByBillId = releBillList.stream().collect(Collectors.groupingBy(r -> r.getLong("id")));
        Function<DynamicObject, String> settletNumberFun = this.getSettletNumberFun(releBillType);
        if ("cas_paybill".equals(releBillType)) {
            buildFun = payBill -> this.buildPayBillRefundEntryList((DynamicObject)payBill, releInfoByBillId, releWithInfo);
            amtFun = payBillEntry -> payBillEntry.getBigDecimal("e_payableamt");
        } else {
            buildFun = agentBill -> this.buildAgentBillRefundEntryList((DynamicObject)agentBill, releInfoByBillId);
            amtFun = agentBillEntry -> AgentPayBillHelper.decodeAmount((String)agentBillEntry.getString("e_encryptamount"));
        }
        for (DynamicObject bill : bills) {
            long billId = bill.getLong("id");
            RefundPayBillInfo refundPayInfo = new RefundPayBillInfo();
            List infos = buildFun.apply(bill);
            refundPayInfo.setEntryInfos(infos);
            List<DynamicObject> reles = releInfoByBillId.get(billId);
            BigDecimal currentRefundAmtSum = reles.stream().map(r -> r.getBigDecimal("currentrefundamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            DynamicObjectCollection entryList = bill.getDynamicObjectCollection("entry");
            BigDecimal amtSum = entryList.stream().map(amtFun).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal eRefundAmtSum = entryList.stream().map(ent -> ent.getBigDecimal("e_refundamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundPayInfo.setTargetPk(Long.valueOf(billId));
            refundPayInfo.setTargetBillType(task.getEntityKey());
            BigDecimal totalHadRefundAmt = currentRefundAmtSum.add(eRefundAmtSum);
            refundPayInfo.setTotalRefundedAmt(totalHadRefundAmt);
            refundPayInfo.setTotalRemainRefundAmt(amtSum.subtract(totalHadRefundAmt));
            refundPayInfo.setSettletnumber(settletNumberFun.apply(bill));
            refundPayInfo.setDifferPay(Boolean.valueOf(bill.getBoolean("isdiffcur")));
            refundPayInfos.add(refundPayInfo);
        }
        this.invokeParams = new Object[]{writeBackParam};
        return this.invokeParams;
    }

    private List<RefundEntryInfo> buildPayBillRefundEntryList(DynamicObject paybill, Map<Long, List<DynamicObject>> releInfoByBillId, boolean releWithInfo) {
        List<DynamicObject> reles = releInfoByBillId.get((Long)paybill.getPkValue());
        Pair refundEntryAndAmt = RefundHelper.getRefundEntryAndAmt((DynamicObject)paybill, reles, (boolean)releWithInfo);
        List refundEntryList = (List)refundEntryAndAmt.getKey();
        Map entryIdWithRefundAmt = (Map)refundEntryAndAmt.getValue();
        List sourceBotpList = BFTrackerServiceHelper.loadSourceRowIds((String)"cas_paybill", (String)"entry", (Long[])new Long[]{(Long)paybill.getPkValue()}, (Long[])((Long[])refundEntryList.stream().map(r -> (Long)r.getPkValue()).toArray(Long[]::new)), null);
        return refundEntryList.stream().map(entry -> this.bulidRefundEntryInfo(paybill, (DynamicObject)entry, sourceBotpList, entryIdWithRefundAmt)).collect(Collectors.toList());
    }

    private List<RefundEntryInfo> buildAgentBillRefundEntryList(DynamicObject agentBill, Map<Long, List<DynamicObject>> releInfoByBillId) {
        DynamicObjectCollection entryList = agentBill.getDynamicObjectCollection("entry");
        List<DynamicObject> reles = releInfoByBillId.get(agentBill.getLong("id"));
        Map<Long, BigDecimal> entryIdWithRefundAmt = reles.stream().filter(r -> BigDecimal.ZERO.compareTo(r.getBigDecimal("currentrefundamt")) != 0).collect(Collectors.toMap(r -> r.getLong("entryid"), r -> r.getBigDecimal("currentrefundamt")));
        List refundEntryList = entryList.stream().filter(e -> entryIdWithRefundAmt.containsKey(e.getLong("id"))).collect(Collectors.toList());
        List sourceBotpList = BFTrackerServiceHelper.loadSourceRowIds((String)"cas_agentpaybill", (String)"entry", (Long[])new Long[]{(Long)agentBill.getPkValue()}, (Long[])((Long[])refundEntryList.stream().map(r -> (Long)r.getPkValue()).toArray(Long[]::new)), null);
        return refundEntryList.stream().map(entry -> this.bulidRefundEntryInfo(agentBill, (DynamicObject)entry, sourceBotpList, entryIdWithRefundAmt)).collect(Collectors.toList());
    }

    public RefundEntryInfo bulidRefundEntryInfo(DynamicObject bill, DynamicObject entry, List<BFRow> sourceBotpList, Map<Long, BigDecimal> entryIdWithRefundAmt) {
        return this.bulidRefundEntryInfo(bill, entry, sourceBotpList, entryIdWithRefundAmt, false);
    }

    public RefundEntryInfo bulidRefundEntryInfo(DynamicObject bill, DynamicObject entry, List<BFRow> sourceBotpList, Map<Long, BigDecimal> entryIdWithRefundAmt, boolean cancelRefund) {
        BigDecimal hadRefundAmt;
        DynamicObject paymentType;
        DynamicObject entrustOrg;
        BigDecimal entryAmt;
        RefundEntryInfo info = new RefundEntryInfo();
        info.setDpAmt(bill.getBigDecimal("dpamt"));
        DynamicObject feeCurrency = bill.getDynamicObject("feecurrency");
        info.setFeeCurrency(Long.valueOf(feeCurrency != null ? (Long)feeCurrency.getPkValue() : 0L));
        info.setDiffCur(Boolean.valueOf(bill.getBoolean("isdiffcur")));
        info.setFee(bill.getBigDecimal("fee"));
        info.setCurrencyPk(Long.valueOf(bill.getLong("currency.id")));
        info.setAgreedRate(bill.getBigDecimal("agreedrate"));
        info.setDpLocalAmt(bill.getBigDecimal("dplocalamt"));
        info.setExchangeRate(bill.getBigDecimal("exchangerate"));
        DynamicObject settleType = bill.getDynamicObject("settletype");
        info.setSettleType(Long.valueOf(settleType != null ? (Long)settleType.getPkValue() : 0L));
        DynamicObject dpCurrency = bill.getDynamicObject("dpcurrency");
        info.setDpCurrency(Long.valueOf(dpCurrency != null ? (Long)dpCurrency.getPkValue() : 0L));
        DynamicObject payerBank = bill.getDynamicObject("payerbank");
        info.setPayerBank(Long.valueOf(payerBank != null ? (Long)payerBank.getPkValue() : 0L));
        info.setLossAmt(bill.getBigDecimal("lossamt"));
        DynamicObject payeracctbank = bill.getDynamicObject("payeracctbank");
        if (payeracctbank != null) {
            info.setPayerAcctBank((Long)payeracctbank.getPkValue());
            info.setPayerAcctBankNo(payeracctbank.getString("bankaccountnumber"));
        }
        info.setDpExchangeRate(bill.getBigDecimal("dpexchangerate"));
        info.setTargetEntryPk((Long)entry.getPkValue());
        DynamicObject org = bill.getDynamicObject("org");
        info.setOrg(Long.valueOf(org != null ? (Long)org.getPkValue() : 0L));
        DynamicObject openorg = bill.getDynamicObject("openorg");
        info.setOpenOrg(Long.valueOf(openorg != null ? (Long)openorg.getPkValue() : 0L));
        info.setTargetBillNo(bill.getString("billno"));
        info.setBizdate(bill.getDate("bizdate"));
        info.setReason(entry.getString("e_refunddes"));
        List<SourceBillInfo> sourceInfoList = this.buildSourceInfos(bill, (Long)entry.getPkValue(), bill.getString("sourcebilltype"), sourceBotpList);
        info.setSourceInfos(sourceInfoList);
        if ("cas_paybill".equals(bill.getDataEntityType().getName())) {
            info.setSuccess(Boolean.valueOf(BillStatusEnum.PAY.getValue().equals(bill.getString("billstatus"))));
            entryAmt = entry.getBigDecimal("e_payableamt");
            info.setCoreBillId(Long.valueOf(entry.getLong("e_corebillid")));
            info.setCoreBillEntryId(Long.valueOf(entry.getLong("e_corebillentryid")));
            info.setCoreBillType(entry.getString("e_corebilltype"));
            info.setAmount(bill.getBigDecimal("actpayamt"));
            info.setLocalAmt(entry.getBigDecimal("e_localamt"));
            entrustOrg = bill.getDynamicObject("entrustorg");
            info.setEntrustOrg(Long.valueOf(entrustOrg != null ? (Long)entrustOrg.getPkValue() : 0L));
            info.setPaydate(bill.getDate("paydate"));
            paymentType = entry.getDynamicObject("e_paymenttype");
            info.setPaymentBizType(paymentType != null ? paymentType.getString("biztype") : "");
            info.setEntrySeq(entry.getInt("seq"));
            info.setEntryPayableLocAmt(entry.getBigDecimal("e_payablelocamt"));
        } else {
            if (cancelRefund) {
                info.setSuccess(Boolean.FALSE);
            } else {
                info.setSuccess(Boolean.valueOf(entry.getBoolean("e_issuccess")));
            }
            info.setRefund(Boolean.TRUE);
            entryAmt = AgentPayBillHelper.decodeAmount((String)entry.getString("e_encryptamount"));
            info.setAmount(entry.getBigDecimal("e_dpamt"));
            info.setLocalAmt(entry.getBigDecimal("e_dplocalamt"));
            entrustOrg = bill.getDynamicObject("delegorg");
            info.setEntrustOrg(Long.valueOf(entrustOrg != null ? (Long)entrustOrg.getPkValue() : 0L));
            info.setPaydate(bill.getDate("paytime"));
            paymentType = bill.getDynamicObject("paymenttype");
            info.setPaymentBizType(paymentType != null ? paymentType.getString("biztype") : "");
        }
        BigDecimal curRefundAmt = entryIdWithRefundAmt.get(entry.getLong("id"));
        if (cancelRefund) {
            info.setRefundAmt(curRefundAmt.negate());
            hadRefundAmt = entry.getBigDecimal("e_refundamt").subtract(curRefundAmt);
        } else {
            info.setRefundAmt(curRefundAmt);
            hadRefundAmt = entry.getBigDecimal("e_refundamt").add(curRefundAmt);
        }
        info.setEntryRemainRefundAmt(entryAmt.subtract(hadRefundAmt));
        info.setEntryRefundedAmt(hadRefundAmt);
        return info;
    }

    private List<SourceBillInfo> buildSourceInfos(DynamicObject bill, Long targetEntryId, String sourceEntityType, List<BFRow> sourceBotpList) {
        Long targetBillId = (Long)bill.getPkValue();
        List botpList = sourceBotpList.stream().filter(row -> {
            BFRowId targetRow = row.getId();
            return targetRow.getBillId().equals(targetBillId) && targetRow.getEntryId().equals(targetEntryId);
        }).collect(Collectors.toList());
        String billType = bill.getDataEntityType().getName();
        if (CollectionUtils.isEmpty(botpList)) {
            Set sourceIds = CasBotpHelper.getSrcBillByDestBill((Long)targetBillId, (String)billType, (String)sourceEntityType);
            if (sourceIds != null) {
                ArrayList<SourceBillInfo> infoList = new ArrayList<SourceBillInfo>(sourceIds.size());
                for (Long sourceId : sourceIds) {
                    SourceBillInfo sourceBillInfo = new SourceBillInfo();
                    sourceBillInfo.setSourceEntity(sourceEntityType);
                    sourceBillInfo.setSourcePk(sourceId);
                    sourceBillInfo.setSourceEntryPks(Collections.emptySet());
                    infoList.add(sourceBillInfo);
                }
                return infoList;
            }
            return Collections.emptyList();
        }
        if ("cas_agentpaybill".equals(billType) && bill.getBoolean("isrepay")) {
            BFRow bfRow = (BFRow)botpList.get(0);
            BFRowId sourceBfRow = bfRow.getSId();
            List newBotpList = BFTrackerServiceHelper.loadSourceRowIds((String)"cas_agentpaybill", (String)"entry", (Long[])new Long[]{sourceBfRow.getBillId()}, (Long[])new Long[]{sourceBfRow.getEntryId()}, null);
            DynamicObject sourceAgentBill = BusinessDataServiceHelper.loadSingle((Object)sourceBfRow.getBillId(), (String)"cas_agentpaybill", (String)"id,isrepay");
            return this.buildSourceInfos(sourceAgentBill, sourceBfRow.getEntryId(), sourceEntityType, newBotpList);
        }
        Map<Long, List<BFRow>> sourceMap = botpList.stream().collect(Collectors.groupingBy(b -> b.getSId().getBillId()));
        ArrayList<SourceBillInfo> infoList = new ArrayList<SourceBillInfo>(sourceMap.size());
        for (Map.Entry<Long, List<BFRow>> sourceEntry : sourceMap.entrySet()) {
            Long sourceBillId = sourceEntry.getKey();
            Set sourceEntryIds = sourceEntry.getValue().stream().map(r -> r.getSId().getEntryId()).collect(Collectors.toSet());
            SourceBillInfo sourceBillInfo = new SourceBillInfo();
            sourceBillInfo.setSourceEntity(sourceEntityType);
            sourceBillInfo.setSourcePk(sourceBillId);
            sourceBillInfo.setSourceEntryPks(sourceEntryIds);
            infoList.add(sourceBillInfo);
        }
        return infoList;
    }

    @Override
    public <T> T invoke(DynamicObject config, Object[] params) {
        String[] serviceInfos = config.getString("entry.service").split("[.]");
        String cloud = serviceInfos[0];
        if (!"fi".equalsIgnoreCase(cloud)) {
            Object[] mapParams = new Object[params.length];
            TypeReference<Map<String, Object>> typeReference = new TypeReference<Map<String, Object>>(){};
            for (int i = 0; i < params.length; ++i) {
                String jsonStr = JSONObject.toJSONString((Object)params[i]);
                Map mapParam = (Map)JSONObject.parseObject((String)jsonStr, (TypeReference)typeReference, (Feature[])new Feature[0]);
                mapParams[i] = mapParam;
            }
            params = mapParams;
        }
        return super.invoke(config, params);
    }

    public Function<DynamicObject, String> getSettletNumberFun(String entityType) {
        Function<DynamicObject, String> settletNumberFun = "cas_paybill".equals(entityType) ? payBill -> {
            DynamicObjectCollection draftBillColl = payBill.getDynamicObjectCollection("draftbill");
            if (CollectionUtils.isNotEmpty((Collection)draftBillColl)) {
                Set draftBills = draftBillColl.stream().filter(o -> o.getDynamicObject("fbasedataid") != null).map(o -> o.getDynamicObject("fbasedataid")).collect(Collectors.toSet());
                return draftBills.stream().map(draft -> draft.getString("draftbillno")).collect(Collectors.joining(","));
            }
            return null;
        } : payBill -> null;
        return settletNumberFun;
    }
}

