/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.writeback.task;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.property.TextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.writeback.WriteBackTaskConsumer;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;

public class WriteBackTask
implements Serializable {
    private static final long serialVersionUID = 7366339905110500838L;
    private static final Log logger = LogFactory.getLog(WriteBackTask.class);
    private String entityKey;
    private Object billPk;
    private Long[] billPks;
    private WriteBackOperateEnum operation;
    private String sourceEntityKey;
    private Map<String, Object> customParams;
    private Class<? extends WriteBackTaskConsumer> consumer;
    private String consumerString;
    private Object[] params;
    private DynamicObjectCollection entrys;

    public WriteBackTask() {
    }

    public WriteBackTask(DynamicObject taskInfo) {
        try {
            this.consumer = Class.forName(taskInfo.getString("taskexecuteclass"));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.customParams = (Map)JSON.parseObject((String)taskInfo.getString("param"), Map.class);
        this.billPk = taskInfo.getLong("billpk");
        this.sourceEntityKey = taskInfo.getString("sourceentitykey");
        this.operation = this.getOperation(taskInfo.getString("operation").trim());
        this.entityKey = taskInfo.getString("entitykey");
    }

    private WriteBackOperateEnum getOperation(String value) {
        for (WriteBackOperateEnum operate : WriteBackOperateEnum.values()) {
            if (!operate.getValue().equals(value)) continue;
            return operate;
        }
        return null;
    }

    public DynamicObject toDynamicObject() {
        DynamicObject writeBackTask = BusinessDataServiceHelper.newDynamicObject((String)"cas_writebacktask");
        String exeCuteClass = null;
        exeCuteClass = null == this.getConsumer() ? this.getConsumerString() : this.getConsumer().getName();
        writeBackTask.set("taskexecuteclass", (Object)exeCuteClass);
        String paramsStr = SerializationUtils.toJsonString((Object)this.getParams());
        TextProp property = (TextProp)writeBackTask.getDataEntityType().getProperties().get((Object)"param");
        int maxLenth = property.getMaxLenth();
        if (paramsStr != null && paramsStr.length() > maxLenth) {
            paramsStr = paramsStr.substring(0, maxLenth);
        }
        writeBackTask.set("param", (Object)paramsStr);
        writeBackTask.set("result", (Object)"-1");
        writeBackTask.set("billpk", this.getBillPk());
        writeBackTask.set("sourceentitykey", (Object)this.getSourceEntityKey());
        writeBackTask.set("operation", (Object)this.getOperation().getValue());
        writeBackTask.set("entitykey", (Object)this.getEntityKey());
        try {
            writeBackTask.set("exception_tag", (Object)SerializationUtils.toJsonString((Object)this.getParams()));
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        return writeBackTask;
    }

    @Deprecated
    public WriteBackTask(Map<String, Object> params) {
        String jsonString = JSON.toJSONString(params, (boolean)false);
        JSON.parseObject((String)jsonString, WriteBackTask.class);
    }

    public Map<String, Object> getCustomParams() {
        return this.customParams;
    }

    public void setCustomParams(Map<String, Object> customParams) {
        this.customParams = customParams;
    }

    public Class<? extends WriteBackTaskConsumer> getConsumer() {
        return this.consumer;
    }

    public void setConsumer(Class<? extends WriteBackTaskConsumer> consumer) {
        this.consumer = consumer;
    }

    public Object getBillPk() {
        return this.billPk;
    }

    public void setBillPk(Object billPk) {
        this.billPk = billPk;
    }

    public WriteBackOperateEnum getOperation() {
        return this.operation;
    }

    public void setOperation(WriteBackOperateEnum operation) {
        this.operation = operation;
    }

    public String getEntityKey() {
        return this.entityKey;
    }

    public void setEntityKey(String entityKey) {
        this.entityKey = entityKey;
    }

    public String getSourceEntityKey() {
        return this.sourceEntityKey;
    }

    public void setSourceEntityKey(String sourceEntityKey) {
        this.sourceEntityKey = sourceEntityKey;
    }

    public Object[] getParams() {
        return this.params;
    }

    public void setParams(Object[] params) {
        this.params = params;
    }

    public DynamicObjectCollection getEntrys() {
        return this.entrys;
    }

    public void setEntrys(DynamicObjectCollection entrys) {
        this.entrys = entrys;
    }

    public Long[] getBillPks() {
        return this.billPks;
    }

    public void setBillPks(Long[] billPks) {
        this.billPks = billPks;
    }

    public String getConsumerString() {
        return this.consumerString;
    }

    public void setConsumerString(String consumerString) {
        this.consumerString = consumerString;
    }
}

