/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.ai;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.ais.model.ShowBillFormData;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.bill.events.AICommandEvent;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.er.business.ai.response.ErAiResponseModel;
import kd.fi.er.business.ai.response.model.NumCardModel;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.kingdee.QueryInvoiceDetailBO;
import kd.fi.er.business.utils.AmountFormatsUtil;
import kd.fi.er.business.utils.ErAIUtils;
import kd.fi.er.common.model.invoice.InvoiceVO;

public class AITripReimImportInvoiceApiPlugin
extends AbstractBillWebApiPlugin {
    private Log logger = LogFactory.getLog(AITripReimImportInvoiceApiPlugin.class);
    private IFormView view;
    private IDataModel model;
    private String formId;
    private String formidmob;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAICommand(AICommandEvent e) {
        super.doAICommand(e);
        long startTime = System.currentTimeMillis();
        Map params = e.getCommand().getParameter();
        this.logger.info("\u5c0fKAITripReimImportInvoiceApiPlugin\u5165\u53c2" + params.toString());
        Object billIdObj = params.get("billId");
        Object invoceId = params.get("invoceId");
        ApiResult result = new ApiResult();
        if (null == invoceId) {
            result.setData((Object)ErAiResponseModel.createTextResponse(ResManager.loadKDString((String)"\u672a\u4f20\u5165\u53d1\u7968\u5e8f\u5217\u53f7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AITripReimImportInvoiceApiPlugin_5", (String)"fi-er-business", (Object[])new Object[0])));
            return;
        }
        if (null == billIdObj) {
            result.setData((Object)ErAiResponseModel.createTextResponse(ResManager.loadKDString((String)"\u5bf9\u8bdd\u5e73\u53f0\u672a\u4f20\u5165\u5dee\u65c5\u62a5\u9500\u5355\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AITripReimImportInvoiceApiPlugin_6", (String)"fi-er-business", (Object[])new Object[0])));
            return;
        }
        Long billId = Long.parseLong(billIdObj.toString());
        DynamicObject load = QueryServiceHelper.queryOne((String)"er_tripreimbursebill", (String)"billkind,id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)});
        if (load == null) {
            result.setData((Object)ErAiResponseModel.createTextResponse(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u5dee\u65c5\u62a5\u9500\u5355\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u662f\u5426\u5b58\u5728\u3002", (String)"AITripReimImportInvoiceApiPlugin_0", (String)"fi-er-business", (Object[])new Object[0])));
            e.setResult(result);
            return;
        }
        int billkind = load.getInt("billkind");
        this.formId = "er_tripreimbursebill";
        this.formidmob = "er_tripreimbursebill_mob";
        if (billkind == 1) {
            this.formId = "er_tripreimbill_grid";
            this.formidmob = "er_tripreim_grid_mb";
        }
        try {
            this.view = ErAIUtils.getView(this.formId);
            this.model = ErAIUtils.getModel(this.view, Long.parseLong(billId.toString()));
            QueryInvoiceDetailBO queryInvoiceDetailBO = ErAIUtils.buildQueryInvoiceDetailBO(this.view, invoceId.toString());
            if (queryInvoiceDetailBO == null) {
                result.setData((Object)ErAiResponseModel.createTextResponse(ResManager.loadKDString((String)"\u5f53\u524d\u8d39\u7528\u627f\u62c5\u516c\u53f8\u672a\u914d\u7f6e\u53d1\u7968\u4e91\u3002", (String)"AITripReimImportInvoiceApiPlugin_1", (String)"fi-er-business", (Object[])new Object[0])));
                e.setResult(result);
                return;
            }
            try {
                List<InvoiceVO> invoiceVOs = APIHelper.queryInvoiceDetailBySerialNo(queryInvoiceDetailBO);
                Class<?> o = Class.forName("kd.fi.er.formplugin.invoicecloud.v2.ImportInvoiceForTripReimPCPlugin");
                Method setView = o.getMethod("setView", IFormView.class);
                Object o1 = o.newInstance();
                Method processInvoiceVO = o.getMethod("processInvoiceVO", List.class);
                setView.invoke(o1, this.view);
                processInvoiceVO.invoke(o1, invoiceVOs);
            }
            catch (Exception exception) {
                String message = exception.getMessage();
                result.setData((Object)ErAiResponseModel.createTextResponse(message));
                e.setResult(result);
                if (this.view != null) {
                    this.view.close();
                }
                return;
            }
            ErAiResponseModel responseModel = this.getResponseModel(Long.parseLong(billId.toString()), params);
            this.logger.info(String.format("\u5c0fK\u53d1\u7968\u660e\u7ec6\u5206\u5f55size:%1$s,\u5c0fK\u8fd4\u56de\u5c0fK\u4e0b\u63a8\u751f\u6210\u7684\u5dee\u65c5\u62a5\u9500\u5355\u6570\u636e\u4e3a\uff1a%2$s", this.model.getEntryRowCount("invoiceitementry"), SerializationUtils.toJsonString((Object)responseModel)));
            result.setData((Object)responseModel);
            e.setResult(result);
        }
        catch (Exception e1) {
            this.logger.error((Throwable)e1);
        }
        finally {
            if (this.view != null) {
                this.view.close();
            }
        }
    }

    private ErAiResponseModel getResponseModel(Long billId, Map<String, Object> params) {
        BigDecimal[] YZJ_CHATBOT;
        OperationServiceHelper.executeOperate((String)"save", (String)"er_tripreimbursebill", (DynamicObject[])new DynamicObject[]{this.model.getDataEntity(true)}, (OperateOption)OperateOption.create());
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billId, (DynamicObjectType)this.model.getDataEntityType());
        if (bill == null) {
            this.logger.info("\u5c0fK\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664,\u5355\u636eid\u4e3a:" + billId);
            return ErAiResponseModel.createTextResponse(ResManager.loadKDString((String)"\u751f\u6210\u5dee\u65c5\u62a5\u9500\u5355\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AITripReimImportInvoiceApiPlugin_2", (String)"fi-er-business", (Object[])new Object[0]));
        }
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("id", billId);
        responseMap.put("description", bill.getString("description"));
        responseMap.put("from", bill.getString("rfrom"));
        responseMap.put("to", bill.getString("rto"));
        DynamicObjectCollection tripentrys = bill.getDynamicObjectCollection("tripentry");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        responseMap.put("startdate", "");
        responseMap.put("enddate", "");
        for (DynamicObject tripentry : tripentrys) {
            Date startdate = tripentry.getDate("startdate");
            Date enddate = tripentry.getDate("startdate");
            if (null != startdate) {
                responseMap.put("startdate", sdf.format(startdate));
            }
            if (null != enddate) {
                responseMap.put("enddate", sdf.format(enddate));
            }
            DynamicObjectCollection entryentitys = tripentry.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryentity : entryentitys) {
                if (null == startdate && null != (startdate = entryentity.getDate("trip2startdate"))) {
                    responseMap.put("startdate", sdf.format(startdate));
                }
                if (null != enddate || null == (enddate = entryentity.getDate("trip2enddate"))) continue;
                responseMap.put("enddate", sdf.format(enddate));
            }
        }
        DynamicObjectCollection entryEntity = ((DynamicObject)bill.getDynamicObjectCollection("tripentry").get(0)).getDynamicObjectCollection("entryentity");
        if (null != entryEntity) {
            String[] expenseitems = entryEntity.stream().map(v -> null == v.getDynamicObject("expenseitem") ? ResManager.loadKDString((String)"\u5dee\u65c5\u9879\u76ee\uff1a\u65e0", (String)"AITripReimImportInvoiceApiPlugin_9", (String)"fi-er-business", (Object[])new Object[0]) : v.getDynamicObject("expenseitem").getLocaleString("name").getLocaleValue()).collect(Collectors.toList()).toArray(new String[0]);
            responseMap.put("expenseitems", expenseitems);
            BigDecimal[] reimamount = entryEntity.stream().map(v -> null == v.getBigDecimal("entryamount") ? BigDecimal.ZERO : v.getBigDecimal("entryamount").setScale(2, 4)).collect(Collectors.toList()).toArray(new BigDecimal[0]);
            ArrayList<String> amounts = new ArrayList<String>();
            String currencySign = "";
            int amountPrecition = 4;
            DynamicObject currency = bill.getDynamicObject("currency");
            if (currency != null) {
                currencySign = currency.getString("sign");
                amountPrecition = currency.getInt("amtprecision");
                for (BigDecimal bigDecimal : reimamount) {
                    amounts.add(AmountFormatsUtil.getLabelAmountAfterFormat(currencySign, bigDecimal.setScale(amountPrecition, 4), amountPrecition));
                }
                responseMap.put("reimamount", amounts);
            } else {
                responseMap.put("reimamount", reimamount);
            }
        }
        switch (YZJ_CHATBOT = params.get("AI_DEVICE").toString()) {
            case "APP_CHATBOT": {
                StringBuilder url = new StringBuilder(RequestContext.get().getClientFullContextPath()).append((CharSequence)new StringBuilder("mobile.html#/form/")).append(this.formidmob).append("?");
                url.append("billStatusValue=1&").append("pkId=").append(bill.getPkValue());
                url.append("&returnDefaultHome=true&isAI=true&app=tra");
                responseMap.put("billUrl", url);
                this.logger.info("\u5c0fK\u751f\u6210\u7684url\u4e3a:" + url);
                break;
            }
            case "CQ_CHATBOT": {
                String data = SerializationUtils.toJsonString((Object)new ShowBillFormData("tra", this.formId, (Object)billId));
                responseMap.put("billUrl", String.format("bizAction://%s?%s", "ShowBillForm", data));
            }
        }
        ArrayList<Map<String, Object>> cardBody = new ArrayList<Map<String, Object>>();
        cardBody.add(responseMap);
        NumCardModel numCardModel = new NumCardModel();
        numCardModel.setTitle(ResManager.loadKDString((String)"\u672c\u6b21\u5dee\u65c5\u60a8\u53ef\u4ee5\u62a5\u9500\u7684\u8d39\u7528\u8be6\u60c5\u5982\u4e0b\uff0c\u786e\u8ba4\u540e\u5373\u53ef\u63d0\u4ea4\u3002", (String)"AITripReimImportInvoiceApiPlugin_10", (String)"fi-er-business", (Object[])new Object[0]));
        numCardModel.setCardBody(cardBody);
        return ErAiResponseModel.createCardJsonResponse(numCardModel, params.get("cardId"), null);
    }
}

