/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.ai;

import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.ais.model.ShowBillFormData;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.bill.events.AICommandEvent;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.AICommand;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.er.business.ai.response.ErAiResponseModel;
import kd.fi.er.business.ai.response.model.NumCardModel;
import kd.fi.er.business.utils.ErAIUtils;

public class AITripReimburseSubmitApiPlugin
extends AbstractBillWebApiPlugin {
    private static final Log logger = LogFactory.getLog(AITripReimburseSubmitApiPlugin.class);
    private DynamicObject bill = null;
    private IFormView view;
    private IDataModel model;
    private String formId;
    private String formidmob;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAICommand(AICommandEvent e) {
        long startTime = System.currentTimeMillis();
        AICommand cmd = e.getCommand();
        Map params = cmd.getParameter();
        logger.info(params.toString());
        ApiResult ret = new ApiResult();
        String bizAppId = "tra";
        if (null == params.get("id") || params.get("id").toString().isEmpty()) {
            ErAiResponseModel responseData = ErAiResponseModel.createTextResponse(ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u7f3a\u5931\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AITripReimburseSubmitApiPlugin_01", (String)"fi-er-business", (Object[])new Object[0]));
            ret.setData((Object)responseData);
            e.setResult(ret);
            return;
        }
        Long billId = Long.parseLong(params.get("id").toString());
        this.bill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"er_tripreimbursebill");
        if (this.bill == null) {
            ErAiResponseModel responseData = ErAiResponseModel.createTextResponse(ResManager.loadKDString((String)"\u751f\u6210\u5dee\u65c5\u62a5\u9500\u5355\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AITripReimburseSubmitApiPlugin_02", (String)"fi-er-business", (Object[])new Object[0]));
            ret.setData((Object)responseData);
            e.setResult(ret);
            return;
        }
        int billkind = this.bill.getInt("billkind");
        this.formId = "er_tripreimbursebill";
        this.formidmob = "er_tripreimbursebill_mob";
        if (billkind == 1) {
            this.formId = "er_tripreimbill_grid";
            this.formidmob = "er_tripreim_grid_mb";
        }
        try {
            this.view = ErAIUtils.getView(this.formId);
            this.model = ErAIUtils.getModel(this.view, Long.parseLong(billId.toString()));
            Long pkId = this.bill.getLong("id");
            OperationResult submit = OperationServiceHelper.executeOperate((String)"submit", (String)"er_tripreimbursebill", (DynamicObject[])new DynamicObject[]{this.model.getDataEntity(true)}, (OperateOption)OperateOption.create());
            String errorMsg = null;
            if (!submit.isSuccess()) {
                errorMsg = ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u8bf7\u70b9\u51fb\u5355\u636e\u8be6\u60c5\u8fdb\u884c\u7f16\u8f91\u3002", (String)"AITripReimburseSubmitApiPlugin_04", (String)"fi-er-business", (Object[])new Object[0]);
            }
            ret.setSuccess(Boolean.TRUE.booleanValue());
            ErAiResponseModel responseData = this.getResponseModel(pkId, params, errorMsg);
            ret.setData((Object)responseData);
            e.setResult(ret);
            long endTime = System.currentTimeMillis();
            logger.info(String.format("\u5c0fK\u7d50\u675fdoAICommand\u65b9\u6cd5\uff0c\u603b\u5171\u6267\u884c\u65f6\u95f4\uff1a%1$s,\u8fd4\u56de\u6570\u636e\uff1a%2$s", endTime - startTime, JSON.toJSONString((Object)responseData)));
        }
        catch (Exception e1) {
            logger.error((Throwable)e1);
        }
        finally {
            if (this.view != null) {
                this.view.close();
            }
        }
    }

    private ErAiResponseModel getResponseModel(Long billId, Map<String, Object> params, String subErrorMsg) {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("id", billId);
        responseMap.put("description", this.bill.getString("description"));
        responseMap.put("from", this.bill.getString("rfrom"));
        responseMap.put("to", this.bill.getString("rto"));
        DynamicObjectCollection tripentrys = this.bill.getDynamicObjectCollection("tripentry");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        responseMap.put("startdate", "");
        responseMap.put("enddate", "");
        for (DynamicObject tripentry : tripentrys) {
            Object startdate = tripentry.getDate("startdate");
            Date enddate = tripentry.getDate("startdate");
            if (null != startdate) {
                responseMap.put("startdate", sdf.format((Date)startdate));
            }
            if (null != enddate) {
                responseMap.put("enddate", sdf.format(enddate));
            }
            DynamicObjectCollection entryentitys = tripentry.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryentity : entryentitys) {
                if (null == startdate && null != (startdate = entryentity.getDate("trip2startdate"))) {
                    responseMap.put("startdate", sdf.format((Date)startdate));
                }
                if (null != enddate || null == (enddate = entryentity.getDate("trip2enddate"))) continue;
                responseMap.put("enddate", sdf.format(enddate));
            }
        }
        DynamicObject costcompany = this.bill.getDynamicObject("costcompany");
        if (costcompany == null) {
            return ErAiResponseModel.createTextResponse(ResManager.loadKDString((String)"\u5f53\u524d\u5dee\u65c5\u62a5\u9500\u5355\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AITripReimburseSubmitApiPlugin_05", (String)"fi-er-business", (Object[])new Object[0]));
        }
        String YZJ_CHATBOT = params.get("AI_DEVICE").toString();
        switch (YZJ_CHATBOT) {
            case "APP_CHATBOT": {
                StringBuilder url = new StringBuilder(RequestContext.get().getClientFullContextPath()).append((CharSequence)new StringBuilder("mobile.html#/form/")).append(this.formidmob).append("?");
                url.append("billStatusValue=1&").append("pkId=").append(this.bill.getPkValue());
                url.append("&returnDefaultHome=true&isAI=true&app=tra");
                responseMap.put("billUrl", url);
                logger.info("\u5c0fK\u751f\u6210\u7684url\u4e3a:" + url);
                break;
            }
            case "CQ_CHATBOT": {
                String billUrl = SerializationUtils.toJsonString((Object)new ShowBillFormData("tra", this.formId, (Object)billId));
                responseMap.put("billUrl", String.format("bizAction://%s?%s", "ShowBillForm", billUrl));
            }
        }
        responseMap.put("billNumber", billId);
        responseMap.put("random", UUID.randomUUID().toString().replace("-", ""));
        ArrayList<Map<String, Object>> cardBody = new ArrayList<Map<String, Object>>();
        cardBody.add(responseMap);
        NumCardModel numCardModel = new NumCardModel();
        if (null == subErrorMsg || subErrorMsg.isEmpty()) {
            subErrorMsg = ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"AITripReimburseSubmitApiPlugin_06", (String)"fi-er-business", (Object[])new Object[0]);
        }
        numCardModel.setTitle(subErrorMsg);
        numCardModel.setCardBody(cardBody);
        logger.info("\u5c0fK\u8fd4\u56de\u5c0fK\u5dee\u65c5\u62a5\u9500\u5355\u63d0\u4ea4\u6570\u636e\u4e3a" + SerializationUtils.toJsonString(cardBody));
        return ErAiResponseModel.createCardJsonResponse(numCardModel, params.get("cardId"), null);
    }
}

