/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.ai;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ErAIService {
    private static final Log logger = LogFactory.getLog(ErAIService.class);

    private ErAIService() {
    }

    public static String preHandleData(Map bizData) {
        Long companyId;
        String userId = RequestContext.get().getUserId();
        long applierId = Long.parseLong(userId);
        Map<String, Object> userMap = CoreBaseBillServiceHelper.createNewData(applierId);
        Object company = userMap.get("company");
        if (company == null || (companyId = (Long)company).compareTo(0L) == 0) {
            return ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ErAIService_0", (String)"fi-er-business", (Object[])new Object[0]);
        }
        if (bizData.get("triptype") == null || StringUtils.isEmpty((CharSequence)String.valueOf(bizData.get("triptype")))) {
            ILocaleString name;
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_triptype", (Long)companyId);
            qFilter = qFilter.and(new QFilter("default", "=", (Object)Boolean.TRUE));
            DynamicObject[] defaultTripTypes = BusinessDataServiceHelper.load((String)"er_triptype", (String)"id,name,number,createorg,default", (QFilter[])new QFilter[]{qFilter = qFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE))});
            if (defaultTripTypes.length > 0 && (name = defaultTripTypes[0].getLocaleString("name")) != null) {
                bizData.put("triptype", name.getLocaleValue());
            }
        }
        if (userMap != null) {
            DynamicObject currency;
            Map costOrg = null;
            try {
                Long costCompanyId = (Long)userMap.get("costcompany");
                Long costDept = (Long)((DynamicObject)userMap.get("costdept")).getPkValue();
                costOrg = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{costCompanyId, costDept}, (String)"bos_org");
                bizData.put("entrycostcompany", ((DynamicObject)costOrg.get(costCompanyId)).getString("name"));
                bizData.put("entrycostdept", ((DynamicObject)costOrg.get(costDept)).getString("name"));
            }
            catch (NullPointerException e) {
                logger.info("\u8d39\u7528\u627f\u62c5\u7ec4\u7ec7\u4e3a\u7a7a:costCompanyId:{}", userMap.get("costcompany"));
                return ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8d39\u7528\u627f\u62c5\u516c\u53f8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ErAIService_6", (String)"fi-er-business", (Object[])new Object[0]);
            }
            try {
                currency = BaseCurrencyServiceHelper.getBaseCurrencyObject(companyId, userMap.get("costcompany"));
            }
            catch (NullPointerException e) {
                logger.info("\u3010\u6839\u636e\u7ec4\u7ec7\u4fe1\u606f\u83b7\u53d6\u672c\u4f4d\u5e01\u8bbe\u7f6e\u4fe1\u606f\u5931\u8d25\u3011:userId:{}companyId:{}", (Object)userId, (Object)companyId);
                return ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff0c\u68c0\u67e5\u4eba\u5458\u7ec4\u7ec7\u4fe1\u606f\u662f\u5426\u6b63\u786e\u3002", (String)"ErAIService_3", (String)"fi-er-business", (Object[])new Object[0]);
            }
            if (currency != null) {
                String currenName = currency.getString("name");
                currenName = currenName == null ? ResManager.loadKDString((String)"\u4eba\u6c11\u5e01", (String)"ErAIService_4", (String)"fi-er-business", (Object[])new Object[0]) : currenName;
                bizData.put("currency", currency.getLong("id"));
                bizData.put("tripcurrency", currency.getLong("id"));
            } else {
                return ResManager.loadKDString((String)"\u672c\u4f4d\u5e01\u672a\u8bbe\u7f6e", (String)"ErAIService_5", (String)"fi-er-business", (Object[])new Object[0]);
            }
        }
        Long tripDays = 0L;
        try {
            SimpleDateFormat siDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date startDate = siDateFormat.parse((String)bizData.get("startdate"));
            Date endDate = siDateFormat.parse((String)bizData.get("enddate"));
            tripDays = CommonServiceHelper.calcDays(startDate, endDate);
        }
        catch (ParseException e) {
            return ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u51fa\u9519", (String)"ErAIService_7", (String)"fi-er-business", (Object[])new Object[0]);
        }
        bizData.put("plandays", tripDays);
        bizData.put("tripday", tripDays);
        Object amount = bizData.get("triporiamount");
        bizData.put("amount", amount);
        bizData.put("approveamount", amount);
        bizData.put("tripamount", amount);
        bizData.put("triporiaccappamount", amount);
        bizData.put("tripaccappamount", amount);
        bizData.put("origin", ResManager.loadKDString((String)"\u8bed\u97f3\u52a9\u624b", (String)"ErAIService_8", (String)"fi-er-business", (Object[])new Object[0]));
        bizData.put("tripexchangerate", 1);
        return null;
    }

    public static String preCommonHandleData(Map bizData) {
        Long companyId;
        long applierId = RequestContext.get().getCurrUserId();
        Map<String, Object> userMap = CoreBaseBillServiceHelper.createNewData(applierId);
        Object company = userMap.get("company");
        if (company == null || (companyId = (Long)company).compareTo(0L) == 0) {
            return ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ErAIService_9", (String)"fi-er-business", (Object[])new Object[0]);
        }
        userMap.remove("billstatus");
        bizData.putAll(userMap);
        bizData.put("origin", ResManager.loadKDString((String)"\u8bed\u97f3\u52a9\u624b", (String)"ErAIService_8", (String)"fi-er-business", (Object[])new Object[0]));
        return null;
    }
}

