/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.ai;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.ai.model.ResponseModel;
import kd.bos.ai.model.SelectsModel;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.bill.events.AICommandEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class TripTypeGetApiPlugin
extends AbstractBillWebApiPlugin {
    private Log logger = LogFactory.getLog(TripTypeGetApiPlugin.class);

    public void doAICommand(AICommandEvent e) {
        long startTime = System.currentTimeMillis();
        Map<String, String> tripTypes = this.getTripType();
        ApiResult ret = new ApiResult();
        ArrayList<SelectsModel.SelectItem> items = new ArrayList<SelectsModel.SelectItem>(tripTypes.size());
        for (Map.Entry<String, String> entry : tripTypes.entrySet()) {
            SelectsModel.SelectItem item = new SelectsModel.SelectItem(entry.getKey(), entry.getValue());
            items.add(item);
        }
        SelectsModel selects = new SelectsModel(ResManager.loadKDString((String)"\u51fa\u5dee\u7c7b\u578b\u5982\u4e0b\uff1a", (String)"TripTypeGetApiPlugin_0", (String)"fi-er-business", (Object[])new Object[0]), items);
        ResponseModel response = ResponseModel.createSelectsResponse((SelectsModel)selects);
        ret.setData((Object)response);
        e.setResult(ret);
        this.logger.info("\u7d50\u675fdoAICommand\u65b9\u6cd5\uff0c\u603b\u5171\u6267\u884c\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - startTime));
    }

    private Map<String, String> getTripType() {
        HashMap<String, String> tripType = new HashMap<String, String>();
        String selectFields = "id,name,number";
        DynamicObjectCollection tripTypes = QueryServiceHelper.query((String)"er_triptype", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)1)});
        for (DynamicObject dyobj : tripTypes) {
            tripType.put(dyobj.getString("name"), dyobj.getString("id"));
        }
        this.logger.info("getTripType\u65b9\u6cd5\u6267\u884c\u5b8c\u6bd5\uff0c\u7ed3\u679c:" + tripType);
        return tripType;
    }
}

