/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.ai.aireimburse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.fi.er.business.ai.response.ErAiResponseModel;
import kd.fi.er.business.ai.response.model.NumCardModel;
import kd.fi.er.business.utils.ErAIUtils;
import kd.fi.er.business.utils.ErCommonUtils;

public class AbstractAIReimburseAPIPlugin
extends AbstractBillWebApiPlugin {
    protected IFormView view;
    protected IDataModel model;
    protected String formId;
    protected String formidmob;
    protected String appId;
    protected ErAiResponseModel responseModel;

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public String getFormidmob() {
        return this.formidmob;
    }

    public void setFormidmob(String formidmob) {
        this.formidmob = formidmob;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public ErAiResponseModel getResponseModel(Map params, String titleMsg) {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        DynamicObject dataEntity = this.model.getDataEntity(true);
        Long billId = ErCommonUtils.getPk(dataEntity.getPkValue());
        responseMap.put("id", billId);
        responseMap.put("billno", dataEntity.getString("billno"));
        responseMap.put("description", dataEntity.getString("description"));
        responseMap.put("reimamount", ErAIUtils.getAmountStr(dataEntity, "currency", "reimburseamount"));
        ArrayList entryEntityList = new ArrayList();
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("expenseentryentity");
        for (DynamicObject entry : entryEntity) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("entryId", entry.getPkValue());
            map.put("expenseitem", entry.getDynamicObject("expenseitem") == null ? "" : entry.getDynamicObject("expenseitem").getString("name"));
            map.put("entryAmount", ErAIUtils.getAmountStr(entry, "entrycurrency", "expenseamount"));
            entryEntityList.add(map);
        }
        responseMap.put("entryEntityList", entryEntityList);
        String payerName = "";
        String payerAccount = "";
        String payerBank = "";
        String receiveAmountStr = "\uffe50";
        DynamicObjectCollection accountentry = dataEntity.getDynamicObjectCollection("accountentry");
        if (accountentry != null && accountentry.size() > 0) {
            DynamicObject entry = (DynamicObject)accountentry.get(0);
            payerName = entry.getString("payername");
            payerAccount = entry.getString("payeraccount01");
            payerBank = entry.getDynamicObject("payerbank") == null ? "" : entry.getDynamicObject("payerbank").getString("name");
            receiveAmountStr = ErAIUtils.getAmountStr(entry, "accountcurrency", "orireceiveamount");
        }
        responseMap.put("payerName", payerName);
        responseMap.put("payerAccount", payerAccount);
        responseMap.put("payerBank", payerBank);
        responseMap.put("receiveamount", receiveAmountStr);
        responseMap.put("billUrl", ErAIUtils.getUrl(this.formId, this.formidmob, this.appId, billId, params));
        ArrayList<Map<String, Object>> cardBody = new ArrayList<Map<String, Object>>();
        cardBody.add(responseMap);
        NumCardModel numCardModel = new NumCardModel();
        numCardModel.setTitle(titleMsg);
        numCardModel.setCardBody(cardBody);
        ErAiResponseModel responseModel = ErAiResponseModel.createCardJsonResponse(numCardModel, params.get("cardId"), null);
        return responseModel;
    }
}

