/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.billingpool.api;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.fi.er.business.billingpool.model.BillingSaveRelationArgs;
import kd.fi.er.business.billingpool.model.BillingWrtieBackArgs;
import kd.fi.er.business.billingpool.service.BillingSaveRelationService;
import kd.fi.er.business.billingpool.service.WriteOffBillingService;

public class BillingPoolAPI {
    public static void execWriteOff(List<BillingWrtieBackArgs> args) {
        Map<Long, List<BillingWrtieBackArgs>> args_groupId = args.stream().collect(Collectors.groupingBy(BillingWrtieBackArgs::getTid));
        Set<Map.Entry<Long, List<BillingWrtieBackArgs>>> entries = args_groupId.entrySet();
        for (Map.Entry<Long, List<BillingWrtieBackArgs>> entry : entries) {
            Long tId = entry.getKey();
            List<BillingWrtieBackArgs> billArgs = entry.getValue();
            if (tId == null || tId == 0L || billArgs == null || billArgs.isEmpty()) continue;
            BillingWrtieBackArgs backArgs = billArgs.get(0);
            String operateType = backArgs.getOperateType();
            if ("save".equals(operateType) || "delete".equals(operateType)) {
                List<Long> billingIds = billArgs.stream().map(BillingWrtieBackArgs::getBillingid).collect(Collectors.toList());
                BillingSaveRelationArgs saveArgs = new BillingSaveRelationArgs();
                saveArgs.settId(backArgs.getTid()).setBillNo(backArgs.getBillno()).setEntityType(backArgs.getEntityType()).setOperateType(backArgs.getOperateType()).settEntryId(backArgs.gettEntryid()).setSeq(backArgs.getSeq()).setBillingIds(billingIds);
                BillingSaveRelationService saveRelationService = new BillingSaveRelationService(saveArgs);
                saveRelationService.doWriteBack();
                continue;
            }
            WriteOffBillingService billingService = null;
            for (BillingWrtieBackArgs writeOffArg : billArgs) {
                writeOffArg.checkValid();
                billingService = new WriteOffBillingService(writeOffArg);
                billingService.doWriteBack();
            }
        }
    }

    public static void execWriteOffValidate(List<BillingWrtieBackArgs> args) {
        WriteOffBillingService billingService = null;
        for (BillingWrtieBackArgs writeOffArg : args) {
            writeOffArg.checkValid();
            billingService = new WriteOffBillingService(writeOffArg);
            billingService.validate();
        }
    }
}

