/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.billingpool.service;

import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.billingpool.model.BillingPoolConfigModel;
import kd.fi.er.business.billingpool.model.BillingWrtieBackArgs;
import kd.fi.er.business.billingpool.service.WriteOffBillingInfo;
import kd.fi.er.business.billingpool.util.BillingPoolConfigUtils;
import kd.fi.er.business.billingpool.validate.WriteOffValidate;
import kd.fi.er.business.billingpool.writeback.BillingStatusWriteBack;
import kd.fi.er.business.billingpool.writeback.WriteOffWriteBack;
import kd.fi.er.business.dao.billing.IBillingPoolDao;
import kd.fi.er.business.dao.billing.imp.BillingPoolDaoImpl;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang3.StringUtils;

public final class WriteOffBillingService {
    private static final String ENTITYNAME = "er_billingpool";
    private IBillingPoolDao billingDao;
    private BillingWrtieBackArgs writeOffArgs;
    private WriteOffBillingInfo writeOffInfo;

    public WriteOffBillingService(BillingWrtieBackArgs writeOffArgs) {
        this.writeOffArgs = writeOffArgs;
        this.initService();
    }

    private void initService() {
        this.writeOffInfo = new WriteOffBillingInfo(this.writeOffArgs);
        this.billingDao = new BillingPoolDaoImpl(ENTITYNAME);
    }

    public void validate() {
        this.fillWriteOffInfo();
        new WriteOffValidate(this.writeOffInfo).doValidate();
    }

    private void fillWriteOffInfo() {
        if (this.writeOffInfo.getTotalAmt() == null) {
            AtomicReference<String> selectProperties;
            DynamicObject billing;
            List<DynamicObject> histroyRecord = this.getHistroyRecord(this.writeOffArgs.getBillingid(), this.writeOffArgs.gettEntryid());
            this.writeOffInfo.setExecAmount(this.calcExecAmount(histroyRecord, this.writeOffArgs.getPoolreimburseamount(), "execAmount", WriteBackType.Lessen));
            this.writeOffInfo.setExecInOutAmount(this.calcExecAmount(histroyRecord, this.writeOffArgs.getInoutamount(), "execinOutAmount", WriteBackType.Add));
            this.writeOffInfo.setExecOffsetAmount(this.calcExecAmount(histroyRecord, this.writeOffArgs.getOffsetamount(), "execOffsetAmount", WriteBackType.Add));
            this.writeOffInfo.setReasonfortransferout(this.calcStr(this.writeOffArgs.getReasonfortransferout(), WriteBackType.Cover));
            this.writeOffInfo.setNodeductionreason(this.calcStr(this.writeOffArgs.getNodeductionreason(), WriteBackType.Cover));
            this.writeOffInfo.setOffsetexpense(this.writeOffArgs.isOffset_invoice());
            List<BillingPoolConfigModel> billingPoolConfigModels = BillingPoolConfigUtils.queryPoolConfigs(this.writeOffArgs.getAccountOrg());
            if (!billingPoolConfigModels.isEmpty()) {
                this.writeOffInfo.setConfigModel(billingPoolConfigModels.get(0));
            }
            if ((billing = this.billingDao.queryOne((selectProperties = new AtomicReference<String>("invoiceno,billstatus,invoicecurrency,oribalanceamount,oriusedamount,totalamount,isexpensesync,ismutilreimburse,reasonfortransferout,inoutamount,offsetamount,offsetexpense,ismutilreimburse,relbill,relbilltype,voucherentity.relentryid,voucherentity.relbillid,voucherentity.entityid,voucherentity.entityid,relbills,issmallreim,nodeductionreason")).get(), this.writeOffArgs.getBillingid())) != null) {
                this.writeOffInfo.setDataEntity(billing);
                this.writeOffInfo.setExpensesync(billing.getBoolean("isexpensesync"));
                this.writeOffInfo.setTotalAmt(billing.getBigDecimal("totalamount"));
                this.writeOffInfo.setBalanceAmt(billing.getBigDecimal("oribalanceamount"));
                this.writeOffInfo.setCurrency(ErCommonUtils.getPk(billing.get("invoicecurrency")));
            } else {
                throw new KDBizException("billingid not found");
            }
        }
    }

    private String calcStr(String reasonfortransferout, WriteBackType cover) {
        if (this.writeOffInfo.isForward()) {
            return reasonfortransferout;
        }
        return "";
    }

    private BigDecimal calcExecAmount(List<DynamicObject> histroyRecord, BigDecimal amount, String execAmountField, WriteBackType writeBackType) {
        BigDecimal execAmt = null;
        BigDecimal hasExcAmount = histroyRecord.stream().map(v -> v.getBigDecimal(execAmountField)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        if (WriteBackType.Lessen == writeBackType) {
            hasExcAmount = hasExcAmount.negate();
            execAmt = this.writeOffInfo.isForward() ? hasExcAmount.subtract(amount) : hasExcAmount;
        } else if (WriteBackType.Add == writeBackType) {
            hasExcAmount = hasExcAmount.negate();
            execAmt = this.writeOffInfo.isForward() ? hasExcAmount.add(amount) : hasExcAmount;
        }
        return execAmt;
    }

    public void doWriteBack() {
        this.validate();
        this.executeWriteBack();
        DynamicObject record = this.buildRecord();
        try (TXHandle h = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
                if (this.writeOffInfo.isNeedDelete()) {
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue("skipCheckDataPermission", String.valueOf(true));
                    operateOption.setVariableValue("er_skipCheckStatus", String.valueOf(true));
                    OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)ENTITYNAME, (Object[])new Object[]{this.writeOffInfo.getWriteOffArgs().getBillingid()}, (OperateOption)operateOption);
                    if (!operationResult.isSuccess()) {
                        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
                        String errorMsg = allErrorOrValidateInfo.stream().map(info -> info.getMessage()).collect(Collectors.joining());
                        if (StringUtils.isEmpty((CharSequence)errorMsg)) {
                            errorMsg = operationResult.getMessage();
                        }
                        throw new KDBizException(errorMsg);
                    }
                } else {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{(DynamicObject)this.writeOffInfo.getDataEntity()});
                }
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private DynamicObject buildRecord() {
        DynamicObject writeOffRecord = BusinessDataServiceHelper.newDynamicObject((String)"er_billing_writeoff_rec");
        writeOffRecord.set("billingid", (Object)this.writeOffInfo.getWriteOffArgs().getBillingid());
        writeOffRecord.set("tEntryid", (Object)this.writeOffInfo.getWriteOffArgs().gettEntryid());
        writeOffRecord.set("tid", (Object)this.writeOffInfo.getWriteOffArgs().getTid());
        writeOffRecord.set("entitytype", (Object)this.writeOffInfo.getWriteOffArgs().getEntityType());
        writeOffRecord.set("operateType", (Object)this.writeOffInfo.getWriteOffArgs().getOperateType());
        writeOffRecord.set("creator", (Object)this.writeOffInfo.getWriteOffArgs().getCreator());
        writeOffRecord.set("billno", (Object)this.writeOffInfo.getWriteOffArgs().getBillno());
        writeOffRecord.set("currency", (Object)this.writeOffInfo.getWriteOffArgs().getCurrency());
        writeOffRecord.set("poolReimburseAmount", (Object)this.writeOffInfo.getWriteOffArgs().getPoolreimburseamount());
        writeOffRecord.set("inoutAmount", (Object)this.writeOffInfo.getWriteOffArgs().getInoutamount());
        writeOffRecord.set("offsetAmount", (Object)this.writeOffInfo.getWriteOffArgs().getOffsetamount());
        writeOffRecord.set("reasonForTransferout", (Object)this.writeOffInfo.getWriteOffArgs().getReasonfortransferout());
        writeOffRecord.set("execAmount", (Object)this.writeOffInfo.getExecAmount());
        writeOffRecord.set("execinoutamount", (Object)this.writeOffInfo.getExecInOutAmount());
        writeOffRecord.set("execoffsetamount", (Object)this.writeOffInfo.getExecOffsetAmount());
        return writeOffRecord;
    }

    private List<DynamicObject> getHistroyRecord(Long billingid, Long tentryid) {
        return this.billingDao.queryHistoryWriteOffRecord(billingid, tentryid);
    }

    protected void setBillingDao(IBillingPoolDao billingDao) {
        this.billingDao = billingDao;
    }

    private void executeWriteBack() {
        new WriteOffWriteBack(this.writeOffInfo).doWriteBack();
        new BillingStatusWriteBack(this.writeOffInfo).doWriteBack();
    }

    static enum WriteBackType {
        Add(0),
        Lessen(1),
        Cover(2);

        int value;

        private WriteBackType(int value) {
            this.value = value;
        }
    }
}

