/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.billingpool.writeback;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.billingpool.service.SaveRelationInfo;
import kd.fi.er.business.billingpool.writeback.IBillingWriteBack;

public class BillingSaveStatusWriteBack
implements IBillingWriteBack {
    private static final Log log = LogFactory.getLog(BillingSaveStatusWriteBack.class);
    private SaveRelationInfo saveRelationInfo;

    public BillingSaveStatusWriteBack(SaveRelationInfo saveRelationInfo) {
        this.saveRelationInfo = saveRelationInfo;
    }

    @Override
    public void doWriteBack() {
        DynamicObject[] dataEntity = (DynamicObject[])this.saveRelationInfo.getDataEntity();
        List<Long> billingIds = this.saveRelationInfo.getSaveRelationArgs().getBillingIds();
        if ((dataEntity == null || dataEntity.length == 0) && billingIds.isEmpty()) {
            log.info("the billing database hasn't this bill data");
            return;
        }
        Long tId = this.saveRelationInfo.getSaveRelationArgs().gettId();
        if (this.saveRelationInfo.isForward()) {
            for (DynamicObject billingPool : dataEntity) {
                DynamicObjectCollection voucherEntity = billingPool.getDynamicObjectCollection("voucherentity");
                if (!billingIds.contains(billingPool.getPkValue())) {
                    for (int index = 0; index < voucherEntity.size(); ++index) {
                        DynamicObject relation = (DynamicObject)voucherEntity.get(index);
                        Long relBillId = relation.getLong("relbillid");
                        if (tId.compareTo(relBillId) != 0) continue;
                        voucherEntity.remove(index);
                        break;
                    }
                } else {
                    boolean hasRelation = voucherEntity.stream().anyMatch(voucher -> tId.longValue() == voucher.getLong("relbillid"));
                    if (!hasRelation) {
                        this.addRelation(voucherEntity);
                    }
                }
                this.calcRelBills(billingPool, voucherEntity);
            }
        } else {
            for (DynamicObject billingPool : dataEntity) {
                Map<Boolean, Set<Long>> needDeleteMap;
                Set<Long> poolIds;
                boolean isExpenseSync;
                DynamicObjectCollection voucherEntity = billingPool.getDynamicObjectCollection("voucherentity");
                for (int index = 0; index < voucherEntity.size(); ++index) {
                    DynamicObject relation = (DynamicObject)voucherEntity.get(index);
                    Long relBillId = relation.getLong("relbillid");
                    if (tId.compareTo(relBillId) != 0) continue;
                    voucherEntity.remove(index);
                    break;
                }
                long id = billingPool.getLong("id");
                boolean needDelete = false;
                if ((voucherEntity == null || voucherEntity.isEmpty()) && (isExpenseSync = billingPool.getBoolean("isexpensesync")) && id != 0L) {
                    needDelete = true;
                }
                if ((poolIds = (needDeleteMap = this.saveRelationInfo.getNeedDelete()).get(needDelete)) == null) {
                    poolIds = new HashSet<Long>();
                    needDeleteMap.put(needDelete, poolIds);
                }
                poolIds.add(id);
            }
        }
    }

    private void addRelation(DynamicObjectCollection voucherEntity) {
        DynamicObject addNew = voucherEntity.addNew();
        addNew.set("relbillid", (Object)this.saveRelationInfo.getSaveRelationArgs().gettId());
        addNew.set("relentryid", (Object)this.saveRelationInfo.getSaveRelationArgs().gettEntryId());
        addNew.set("entityid", (Object)this.saveRelationInfo.getSaveRelationArgs().getEntityType());
        addNew.set("relbills", (Object)this.saveRelationInfo.getSaveRelationArgs().getBillNo());
    }
}

