/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.billingpool.writeback;

import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.er.business.billingpool.service.WriteOffBillingInfo;
import kd.fi.er.business.billingpool.writeback.IBillingWriteBack;

public class BillingStatusWriteBack
implements IBillingWriteBack {
    private WriteOffBillingInfo writeOffInfo = null;

    public BillingStatusWriteBack(WriteOffBillingInfo writeOffInfo) {
        this.writeOffInfo = writeOffInfo;
    }

    @Override
    public void doWriteBack() {
        if (this.writeOffInfo.isForward()) {
            DynamicObject dataEntity = (DynamicObject)this.writeOffInfo.getDataEntity();
            if ("submit".equals(this.writeOffInfo.getWriteOffArgs().getOperateType()) && !Boolean.TRUE.equals(this.writeOffInfo.isExpensesync())) {
                dataEntity.set("billstatus", (Object)"J");
            } else if ("audit".equals(this.writeOffInfo.getWriteOffArgs().getOperateType())) {
                if (!this.writeOffInfo.getWriteOffArgs().isMutilreimburse() || this.writeOffInfo.getUsedAmt().compareTo(this.writeOffInfo.getTotalAmt()) == 0) {
                    dataEntity.set("billstatus", (Object)"K");
                } else {
                    dataEntity.set("billstatus", (Object)"J");
                }
            }
            this.updateRelation(dataEntity);
        } else {
            DynamicObject dataEntity = (DynamicObject)this.writeOffInfo.getDataEntity();
            DynamicObjectCollection voucherentity = dataEntity.getDynamicObjectCollection("voucherentity");
            Set relBills = voucherentity.stream().map(v -> v.getLong("relbillid")).collect(Collectors.toSet());
            if (Boolean.TRUE.equals(this.writeOffInfo.isExpensesync())) {
                if (relBills.size() == 1 && relBills.contains(this.writeOffInfo.getWriteOffArgs().getTid())) {
                    this.writeOffInfo.setNeedDelete(true);
                } else {
                    if ("invalid".equals(this.writeOffInfo.getWriteOffArgs().getOperateType())) {
                        this.removeRelation(dataEntity);
                    }
                    dataEntity.set("billstatus", (Object)"J");
                }
            } else if (relBills.size() > 1) {
                dataEntity.set("billstatus", (Object)"J");
            } else {
                dataEntity.set("billstatus", (Object)"E");
            }
        }
    }

    private void updateRelation(DynamicObject dataEntity) {
        DynamicObjectCollection voucherentity = dataEntity.getDynamicObjectCollection("voucherentity");
        Iterator iterator = voucherentity.iterator();
        boolean exist = false;
        DynamicObject voucherInfos = null;
        while (iterator.hasNext()) {
            voucherInfos = (DynamicObject)iterator.next();
            if (!this.writeOffInfo.getWriteOffArgs().getTid().equals(voucherInfos.getLong("relbillid"))) continue;
            exist = true;
            break;
        }
        if (!exist) {
            DynamicObject addNew = voucherentity.addNew();
            addNew.set("relbillid", (Object)this.writeOffInfo.getWriteOffArgs().getTid());
            addNew.set("relentryid", (Object)this.writeOffInfo.getWriteOffArgs().gettEntryid());
            addNew.set("entityid", (Object)this.writeOffInfo.getWriteOffArgs().getEntityType());
            addNew.set("relbills", (Object)this.writeOffInfo.getWriteOffArgs().getBillno());
            addNew.set("issmallreim", (Object)this.writeOffInfo.getWriteOffArgs().isSmallReimburse());
        } else {
            voucherInfos.set("issmallreim", (Object)this.writeOffInfo.getWriteOffArgs().isSmallReimburse());
        }
        this.calcRelBills(dataEntity, voucherentity);
    }

    private void removeRelation(DynamicObject dataEntity) {
        DynamicObjectCollection voucherentity = dataEntity.getDynamicObjectCollection("voucherentity");
        Iterator iterator = voucherentity.iterator();
        while (iterator.hasNext()) {
            DynamicObject voucherInfos = (DynamicObject)iterator.next();
            if (!this.writeOffInfo.getWriteOffArgs().getTid().equals(voucherInfos.getLong("relbillid"))) continue;
            iterator.remove();
        }
        this.calcRelBills(dataEntity, voucherentity);
    }
}

