/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.cache;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;

public class ErCloudFrameworkCache {
    private static final String CACHE_DISTRIBUTESESSION = "er_cloudframework_cache";
    private static final String CACHE_TYPE = "cloudframework";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("er_cloudframework_cache", new DistributeCacheHAPolicy(true, true));

    private static String buildCacheType() {
        return String.format("%s.%s.%s", CACHE_TYPE, RequestContext.get().getAccountId(), RequestContext.get().getCurrUserId());
    }

    private static String buildCacheKey(String pageId, String inputKey) {
        return String.format("%s.%s", pageId, inputKey);
    }

    public static void removeCache(String pageId, String inputKey) {
        String type = ErCloudFrameworkCache.buildCacheType();
        String[] keys = new String[]{ErCloudFrameworkCache.buildCacheKey(pageId, inputKey)};
        cache.remove(type, keys);
    }

    public static void putValueByPageId(String pageId, String inputKey, String value) {
        String type = ErCloudFrameworkCache.buildCacheType();
        String cacheKey = ErCloudFrameworkCache.buildCacheKey(pageId, inputKey);
        cache.put(type, cacheKey, (Object)value);
    }

    public static String getValueByPageId(String pageId, String inputKey) {
        String type = ErCloudFrameworkCache.buildCacheType();
        String cacheKey = ErCloudFrameworkCache.buildCacheKey(pageId, inputKey);
        String value = (String)cache.get(type, cacheKey);
        return value;
    }
}

