/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.daily.amount.service.impl.test;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.daily.amount.service.EmployeeReimAmountService;
import kd.fi.er.business.daily.service.model.ReimburseAmountDetailBean;
import kd.fi.er.business.utils.ErStdConfig;

public class EmployeeReimAmountServiceImpl
implements EmployeeReimAmountService {
    private static final Log log = LogFactory.getLog(EmployeeReimAmountServiceImpl.class);

    @Override
    public BigDecimal getEmployeeCurrentInReimbursedAmountBetween(Long companyId, Long userId, Long expenseItemId, Long currencyId, LocalDate beginDate, LocalDate endDate, Map<String, Object> otherParams) {
        BigDecimal result = BigDecimal.ZERO;
        try {
            String amount = ErStdConfig.get("Amont.Ctrl.Ext.Employee");
            result = new BigDecimal(amount);
        }
        catch (Exception e) {
            log.error("\u540e\u53f0\u6570\u636e\u6709\u95ee\u9898\uff1a", (Throwable)e);
        }
        if (result == null) {
            result = BigDecimal.ZERO;
        }
        return result;
    }

    @Override
    public BigDecimal getEmployeeReimbursedAmountBetween(Long companyId, Long userId, Long expenseItemId, Long currencyId, LocalDate beginDate, LocalDate endDate, List<Long> notInIds, Map<String, Object> otherParams) {
        BigDecimal result = BigDecimal.ZERO;
        try {
            String amount = ErStdConfig.get("Amont.Ctrl.Ext.Employee");
            result = new BigDecimal(amount);
        }
        catch (Exception e) {
            log.error("\u540e\u53f0\u6570\u636e\u6709\u95ee\u9898\uff1a", (Throwable)e);
        }
        if (result == null) {
            result = BigDecimal.ZERO;
        }
        return result;
    }

    @Override
    public List<ReimburseAmountDetailBean> getEmployeeReimbursedAmountDetailBetween(Long companyId, Long userId, Long expenseItemId, Long currencyId, LocalDate beginDate, LocalDate endDate, List<Long> notInIds, Map<String, Object> otherParams) {
        ReimburseAmountDetailBean bean = new ReimburseAmountDetailBean();
        bean.setBillId(10086L);
        bean.setBillName(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u6d4b\u8bd5\u4e2a\u4eba\u989d\u5ea6\u5355\u636e", (String)"EmployeeReimAmountServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]), (String)"EmployeeReimAmountServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]));
        bean.setBillno("test001");
        bean.setHappenedDate(LocalDate.now());
        bean.setMetaKey("er_tripreimbursebill");
        bean.setMobFormKey("er_tripreimbursebill_mob");
        bean.setReimburseAmount(new BigDecimal("10086"));
        return Lists.newArrayList((Object[])new ReimburseAmountDetailBean[]{bean});
    }
}

