/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.daily.amount.service.util;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.daily.amount.service.DeptReimAmountService;
import kd.fi.er.business.daily.amount.service.EmployeeReimAmountService;
import kd.fi.er.business.daily.amount.service.factory.ReimAmountServiceFactory;
import kd.fi.er.business.daily.service.model.ReimburseAmountDetailBean;

public class DailyAmountUtils {
    private static Log logger = LogFactory.getLog(DailyAmountUtils.class);

    public static BigDecimal getDeptCurrentInReimbursedAmountBetween(Long companyId, Long deptId, Long expenseItemId, Long currencyId, LocalDate beginDate, LocalDate endDate, Map<String, Object> otherParams) {
        BigDecimal exAmount;
        DeptReimAmountService deptReimAmountService = DailyAmountUtils.getSingletonService(DeptReimAmountService.class);
        if (deptReimAmountService != null && (exAmount = deptReimAmountService.getDeptCurrentInReimbursedAmountBetween(companyId, deptId, expenseItemId, currencyId, beginDate, endDate, otherParams)) != null) {
            return exAmount;
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal getDeptReimbursedAmountBetween(Long companyId, Long deptId, Long expenseItemId, Long currencyId, LocalDate beginDate, LocalDate endDate, List<Long> notInIds, Map<String, Object> otherParams) {
        BigDecimal exAmount;
        DeptReimAmountService deptReimAmountService = DailyAmountUtils.getSingletonService(DeptReimAmountService.class);
        if (deptReimAmountService != null && (exAmount = deptReimAmountService.getDeptReimbursedAmountBetween(companyId, deptId, expenseItemId, currencyId, beginDate, endDate, notInIds, otherParams)) != null) {
            return exAmount;
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal getEmployeeCurrentInReimbursedAmountBetween(Long companyId, Long userId, Long expenseItemId, Long currencyId, LocalDate beginDate, LocalDate endDate, Map<String, Object> otherParams) {
        BigDecimal exAmount;
        EmployeeReimAmountService employeeReimAmountService = DailyAmountUtils.getSingletonService(EmployeeReimAmountService.class);
        if (employeeReimAmountService != null && (exAmount = employeeReimAmountService.getEmployeeCurrentInReimbursedAmountBetween(companyId, userId, expenseItemId, currencyId, beginDate, endDate, otherParams)) != null) {
            return exAmount;
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal getEmployeeReimbursedAmountBetween(Long companyId, Long userId, Long expenseItemId, Long currencyId, LocalDate beginDate, LocalDate endDate, List<Long> notInIds, Map<String, Object> otherParams) {
        BigDecimal exAmount;
        EmployeeReimAmountService employeeReimAmountService = DailyAmountUtils.getSingletonService(EmployeeReimAmountService.class);
        if (employeeReimAmountService != null && (exAmount = employeeReimAmountService.getEmployeeReimbursedAmountBetween(companyId, userId, expenseItemId, currencyId, beginDate, endDate, notInIds, Maps.newHashMapWithExpectedSize((int)0))) != null) {
            return exAmount;
        }
        return BigDecimal.ZERO;
    }

    public static List<ReimburseAmountDetailBean> getEmployeeReimbursedAmountDetailBetween(Long companyId, Long userId, Long expenseItemId, Long currencyId, LocalDate beginDate, LocalDate endDate, List<Long> notInIds, Map<String, Object> otherParams) {
        List<ReimburseAmountDetailBean> employeeReimbursedAmountDetailBetween;
        EmployeeReimAmountService employeeReimAmountService = DailyAmountUtils.getSingletonService(EmployeeReimAmountService.class);
        if (employeeReimAmountService != null && (employeeReimbursedAmountDetailBetween = employeeReimAmountService.getEmployeeReimbursedAmountDetailBetween(companyId, userId, expenseItemId, currencyId, beginDate, endDate, notInIds, Maps.newHashMapWithExpectedSize((int)0))) != null) {
            return employeeReimbursedAmountDetailBetween;
        }
        return Collections.emptyList();
    }

    public static List<ReimburseAmountDetailBean> getDeptReimbursedAmountDetailBetween(Long companyId, Long deptId, Long expenseItemId, Long currencyId, LocalDate beginDate, LocalDate endDate, List<Long> notInIds, Map<String, Object> otherParams) {
        List<ReimburseAmountDetailBean> deptReimbursedAmountDetailBetween;
        DeptReimAmountService deptReimAmountService = DailyAmountUtils.getSingletonService(DeptReimAmountService.class);
        if (deptReimAmountService != null && (deptReimbursedAmountDetailBetween = deptReimAmountService.getDeptReimbursedAmountDetailBetween(companyId, deptId, expenseItemId, currencyId, beginDate, endDate, notInIds, Maps.newHashMapWithExpectedSize((int)0))) != null) {
            return deptReimbursedAmountDetailBetween;
        }
        return Collections.emptyList();
    }

    private static <T> T getSingletonService(Class<T> clazz) {
        T t = null;
        try {
            t = ReimAmountServiceFactory.getSingletonService(clazz);
        }
        catch (Exception e) {
            if (ThreadCache.exists((Object)"fromreport")) {
                HashSet<String> getedServiceSingleSet;
                HashSet<String> reimAmountServiceSingleSet;
                if (!ThreadCache.exists((Object)"reimAmountServiceSingle")) {
                    reimAmountServiceSingleSet = new HashSet<String>();
                    ThreadCache.put((Object)"reimAmountServiceSingle", reimAmountServiceSingleSet);
                }
                if ((reimAmountServiceSingleSet = ThreadCache.get((Object)"reimAmountServiceSingle")) instanceof HashSet && !(getedServiceSingleSet = reimAmountServiceSingleSet).contains(clazz.getName())) {
                    getedServiceSingleSet.add(clazz.getName());
                }
            }
            logger.error((Throwable)e);
        }
        return t;
    }
}

