/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.daily.service.helper;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.daily.service.ReimburseAmountControlService;
import kd.fi.er.business.daily.service.model.DeptExpenseItemAndCurrencyBO;
import kd.fi.er.business.daily.service.model.ExpenseItemAndCurrencyBO;
import kd.fi.er.business.daily.service.model.ReimburseAmountBO;
import kd.fi.er.business.daily.service.model.ReimburseAmountControlResultBO;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.ReimburseControlUtils;
import kd.fi.er.common.constant.ErExpenseItemConstant;
import kd.fi.er.common.reimctl.ReimburseControlCurrency;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

@Deprecated
public class ReimburseAmountHelper {
    private static final Log log = LogFactory.getLog(ReimburseAmountHelper.class);
    private static final Set<String> UNFINISHED_STATUS = new HashSet<String>();

    @Deprecated
    public static List<String> doValidate(DynamicObject dataEntity) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)0);
        DynamicObject applierUser = dataEntity.getDynamicObject("applier");
        Boolean multiReimburserFlag = dataEntity.getBoolean("ismultireimburser");
        DynamicObject company = ReimburseControlUtils.getReimburseControlCompany(dataEntity);
        if (company == null) {
            return result;
        }
        Long companyId = (Long)company.getPkValue();
        DynamicObject parameterSettingCompanyDO = ReimburseControlUtils.getParameterSettingCompany(dataEntity);
        Long baseCurrencyId = ErCommonUtils.getPk(dataEntity.getDynamicObject("currency"));
        DynamicObjectCollection expenseEntryEntity = dataEntity.getDynamicObjectCollection("expenseentryentity");
        HashMap<ExpenseItemAndCurrencyBO, List<ReimburseAmountBO>> reimburseAmountByExpenseItem = new HashMap<ExpenseItemAndCurrencyBO, List<ReimburseAmountBO>>(expenseEntryEntity.size());
        HashMap<DeptExpenseItemAndCurrencyBO, List<ReimburseAmountBO>> deptReimburseAmountByExpenseItem = new HashMap<DeptExpenseItemAndCurrencyBO, List<ReimburseAmountBO>>(expenseEntryEntity.size());
        block10: for (int i = 0; i < expenseEntryEntity.size(); ++i) {
            DynamicObject expenseEntity = (DynamicObject)expenseEntryEntity.get(i);
            DynamicObject expenseItemDO = expenseEntity.getDynamicObject("expenseitem");
            Date happenDateOld = expenseEntity.getDate("happendate");
            if (Objects.isNull(expenseItemDO)) break;
            if (Objects.isNull(happenDateOld)) {
                result.add(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u8d39\u7528\u660e\u7ec6\u201c\u8d39\u7528\u53d1\u751f\u65e5\u671f\u201d\u3002", (String)"ReimburseAmountHelper_0", (String)"fi-er-business", (Object[])new Object[0]));
                break;
            }
            Long reimburseUserId = null;
            if (multiReimburserFlag.booleanValue()) {
                if (expenseEntity.getDynamicObject("reimburser") == null) {
                    result.add(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u8d39\u7528\u660e\u7ec6\u62a5\u9500\u4eba\u201d\u3002", (String)"ReimburseAmountHelper_1", (String)"fi-er-business", (Object[])new Object[0]));
                    break;
                }
                reimburseUserId = (Long)expenseEntity.getDynamicObject("reimburser").getPkValue();
            } else {
                reimburseUserId = (Long)applierUser.getPkValue();
            }
            if (null == reimburseUserId) {
                result.add(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u7533\u8bf7\u4eba\u201d\u6216 \u201c\u8d39\u7528\u660e\u7ec6\u62a5\u9500\u4eba\u201d\u3002", (String)"ReimburseAmountHelper_2", (String)"fi-er-business", (Object[])new Object[0]));
                break;
            }
            Long expenseItemId = (Long)expenseItemDO.getPkValue();
            LocalDate happenDate = ErCommonUtils.getLocalDateFromDate(expenseEntity.getDate("happendate"));
            BigDecimal reimburseAmount = null;
            Long currencyId = null;
            Long oriCurrencyId = (Long)expenseEntity.getDynamicObject("entrycurrency").getPkValue();
            String reimCtlType = expenseItemDO.getString("reimctltype");
            String reimType = expenseItemDO.getString("isreimburseamountctl");
            boolean hasReimburseAmountData = false;
            switch (reimType) {
                case "0": {
                    continue block10;
                }
                case "1": {
                    currencyId = ReimburseControlUtils.getPersonCtlCurrency(ErCommonUtils.getPk(parameterSettingCompanyDO)) == ReimburseControlCurrency.OriCurrency ? oriCurrencyId : baseCurrencyId;
                    reimburseAmount = ReimburseControlUtils.getPersonCtlCurrency(ErCommonUtils.getPk(parameterSettingCompanyDO)).getAmount(expenseEntity);
                    hasReimburseAmountData = ReimburseAmountControlService.hasReimburseAmountData(companyId, reimburseUserId, expenseItemId, currencyId, Year.of(happenDate.getYear()));
                    if (StringUtils.equals((CharSequence)reimCtlType, (CharSequence)"2") && !hasReimburseAmountData) {
                        log.info("\u4fdd\u5b58\u524d\u7684\u6821\u9a8c\u5f53\u524d\u8d39\u7528\u9879\u76ee\u662f\u6df7\u5408\u63a7\u5236\u6a21\u5f0f, \u4e14\u989d\u5ea6\u63a7\u5236\u8868\u4e2d\u6ca1\u6709\u8fd9\u4e2a\u7528\u6237\u7684\u6570\u636e");
                        continue block10;
                    }
                    ExpenseItemAndCurrencyBO key = new ExpenseItemAndCurrencyBO(expenseItemId, currencyId, reimburseUserId);
                    if (!reimburseAmountByExpenseItem.containsKey(key)) {
                        reimburseAmountByExpenseItem.put(key, new ArrayList());
                    }
                    List reimburseAmountBOs = (List)reimburseAmountByExpenseItem.get(key);
                    reimburseAmountBOs.add(new ReimburseAmountBO(happenDate, reimburseAmount, currencyId));
                    continue block10;
                }
                case "2": {
                    currencyId = ReimburseControlUtils.getDeptCtlCurrency(ErCommonUtils.getPk(parameterSettingCompanyDO)) == ReimburseControlCurrency.OriCurrency ? oriCurrencyId : baseCurrencyId;
                    reimburseAmount = ReimburseControlUtils.getDeptCtlCurrency(ErCommonUtils.getPk(parameterSettingCompanyDO)).getAmount(expenseEntity);
                    DynamicObject deptDO = ReimburseControlUtils.getReimCtlDeptInExpenseEntry(dataEntity, i);
                    Long deptId = ErCommonUtils.getPk(deptDO);
                    hasReimburseAmountData = ReimburseAmountControlService.hasDeptReimburseAmountData(companyId, deptId, expenseItemId, currencyId, Year.of(happenDate.getYear()));
                    if (StringUtils.equals((CharSequence)reimCtlType, (CharSequence)"2") && !hasReimburseAmountData) {
                        log.info("\u4fdd\u5b58\u524d\u7684\u6821\u9a8c\u5f53\u524d\u8d39\u7528\u9879\u76ee\u662f\u6df7\u5408\u63a7\u5236\u6a21\u5f0f, \u4e14\u989d\u5ea6\u63a7\u5236\u8868\u4e2d\u6ca1\u6709\u8fd9\u4e2a\u90e8\u95e8\u7684\u6570\u636e, deptId: " + deptId);
                        continue block10;
                    }
                    DeptExpenseItemAndCurrencyBO deptKey = new DeptExpenseItemAndCurrencyBO(expenseItemId, currencyId, deptId);
                    if (!deptReimburseAmountByExpenseItem.containsKey(deptKey)) {
                        deptReimburseAmountByExpenseItem.put(deptKey, new ArrayList());
                    }
                    List deptReimburseAmountBOs = (List)deptReimburseAmountByExpenseItem.get(deptKey);
                    deptReimburseAmountBOs.add(new ReimburseAmountBO(happenDate, reimburseAmount, currencyId));
                    continue block10;
                }
            }
        }
        ReimburseAmountHelper.processPersonReimCtl(result, dataEntity, companyId, reimburseAmountByExpenseItem);
        ReimburseAmountHelper.processDeptReimCtl(result, dataEntity, companyId, deptReimburseAmountByExpenseItem);
        if (reimburseAmountByExpenseItem.isEmpty() && deptReimburseAmountByExpenseItem.isEmpty()) {
            dataEntity.set("abovequota", (Object)"0");
        } else if (!result.isEmpty()) {
            dataEntity.set("abovequota", (Object)"1");
        } else {
            dataEntity.set("abovequota", (Object)"2");
        }
        return result;
    }

    private static void processDeptReimCtl(List<String> result, DynamicObject dataEntity, Long companyId, Map<DeptExpenseItemAndCurrencyBO, List<ReimburseAmountBO>> deptReimburseAmountByExpenseItem) {
        DynamicObject parameterSettingCompanyDO = ReimburseControlUtils.getParameterSettingCompany(dataEntity);
        Long parameterSettingCompanyId = ErCommonUtils.getPk(parameterSettingCompanyDO);
        deptReimburseAmountByExpenseItem.forEach((expenseItemAndCurrency, reimburseAmountBOs) -> {
            Long expenseItemId = expenseItemAndCurrency.getExpenseItemId();
            Long currencyId = expenseItemAndCurrency.getCurrencyId();
            Long deptId = expenseItemAndCurrency.getDeptId();
            boolean isReimburseControl = ReimburseAmountControlService.isReimburseLimitControlByExpensenItem(parameterSettingCompanyId, expenseItemId);
            if (isReimburseControl) {
                log.info(String.format("\u9700\u8981\u6267\u884c\u90e8\u95e8\u989d\u5ea6\u63a7\u5236: \u516c\u53f8id:%d, \u90e8\u95e8id: %d, \u8d39\u7528\u9879\u76eeid:%d", companyId, deptId, expenseItemId));
                DynamicObject expenseItem = BusinessDataServiceHelper.loadSingleFromCache((Object)expenseItemId, (String)"er_expenseitemedit", (String)"reimburseamountctlmethod,name,reimburseamountctlcount");
                String controlMethod = expenseItem.getString("reimburseamountctlmethod");
                controlMethod = (String)StringUtils.defaultIfBlank((CharSequence)controlMethod, (CharSequence)ErExpenseItemConstant.ReimburseAmountCtlMethod.Accumulative.getValue());
                ReimburseAmountControlService controlService = ReimburseAmountControlService.controlServiceMap.get(ErExpenseItemConstant.ReimburseAmountCtlMethod.getEnumByValue((String)controlMethod));
                ArrayList excludeReimburseBillIds = Lists.newArrayList((Object[])new Long[]{(Long)dataEntity.getPkValue()});
                QFilter currencyQFilter = ReimburseControlUtils.getDeptCtlCurrency(parameterSettingCompanyId).getCurrencyQFilter(currencyId);
                QFilter deptQFilter = ReimburseControlUtils.getReimCtlDeptQFilter(parameterSettingCompanyId, deptId).and(currencyQFilter).and("expenseentryentity.expenseitem", "=", (Object)expenseItemId).and("billstatus", "not in", UNFINISHED_STATUS);
                String msg = ReimburseAmountHelper.validateExpItemCtlCount(expenseItem, reimburseAmountBOs, deptQFilter, controlService);
                if (msg != null) {
                    result.add(msg);
                }
                ReimburseAmountControlResultBO resultBO = controlService.validateDeptReim(companyId, deptId, expenseItemId, currencyId, (List<ReimburseAmountBO>)reimburseAmountBOs, excludeReimburseBillIds);
                ReimburseAmountHelper.isOverBudget(companyId, result, resultBO);
            }
        });
    }

    private static void processPersonReimCtl(List<String> result, DynamicObject dataEntity, Long companyId, Map<ExpenseItemAndCurrencyBO, List<ReimburseAmountBO>> reimburseAmountByExpenseItem) {
        DynamicObject parameterSettingCompanyDO = ReimburseControlUtils.getParameterSettingCompany(dataEntity);
        Long parameterSettingCompanyId = ErCommonUtils.getPk(parameterSettingCompanyDO);
        reimburseAmountByExpenseItem.forEach((expenseItemAndCurrency, reimburseAmountBOs) -> {
            Long expenseItemId = expenseItemAndCurrency.getExpenseItemId();
            Long currencyId = expenseItemAndCurrency.getCurrencyId();
            Long reimburseUserId = expenseItemAndCurrency.getReimburseUserId();
            boolean isReimburseControl = ReimburseAmountControlService.isReimburseLimitControlByExpensenItem(parameterSettingCompanyId, expenseItemId);
            if (isReimburseControl) {
                log.info(String.format("\u9700\u8981\u6267\u884c\u989d\u5ea6\u63a7\u5236: \u516c\u53f8id:%d, \u7528\u6237id: %d, \u8d39\u7528\u9879\u76eeid:%d", companyId, reimburseUserId, expenseItemId));
                DynamicObject expenseItem = BusinessDataServiceHelper.loadSingleFromCache((Object)expenseItemId, (String)"er_expenseitemedit", (String)"reimburseamountctlmethod,name,reimburseamountctlcount");
                String controlMethod = expenseItem.getString("reimburseamountctlmethod");
                controlMethod = (String)StringUtils.defaultIfBlank((CharSequence)controlMethod, (CharSequence)ErExpenseItemConstant.ReimburseAmountCtlMethod.Accumulative.getValue());
                ReimburseAmountControlService controlService = ReimburseAmountControlService.controlServiceMap.get(ErExpenseItemConstant.ReimburseAmountCtlMethod.getEnumByValue((String)controlMethod));
                ArrayList excludeReimburseBillIds = Lists.newArrayList((Object[])new Long[]{(Long)dataEntity.getPkValue()});
                QFilter reimCtlCompanyQFilter = ReimburseControlUtils.getPersonReimCtlCompanyQFilter(companyId);
                QFilter currencyQFilter = ReimburseControlUtils.getPersonCtlCurrency(parameterSettingCompanyId).getCurrencyQFilter(currencyId);
                QFilter userQFilter = QFilter.of((String)"expenseentryentity.reimburser=?", (Object[])new Object[]{reimburseUserId}).and(reimCtlCompanyQFilter).and(currencyQFilter).and("expenseentryentity.expenseitem", "=", (Object)expenseItemId).and("billstatus", "not in", UNFINISHED_STATUS);
                String msg = ReimburseAmountHelper.validateExpItemCtlCount(expenseItem, reimburseAmountBOs, userQFilter, controlService);
                if (msg != null) {
                    result.add(msg);
                }
                ReimburseAmountControlResultBO resultBO = controlService.validate(companyId, reimburseUserId, expenseItemId, currencyId, (List<ReimburseAmountBO>)reimburseAmountBOs, excludeReimburseBillIds);
                ReimburseAmountHelper.isOverBudget(companyId, result, resultBO);
            }
        });
    }

    @Deprecated
    protected static void isOverBudget(Long companyId, List<String> result, ReimburseAmountControlResultBO resultBO) {
        if (resultBO.isOver()) {
            result.add(resultBO.getOverDesc());
        }
    }

    private static String validateExpItemCtlCount(DynamicObject expenseItem, List<ReimburseAmountBO> reimburseAmountBOs, QFilter userQFilterOrDeptQFilter, ReimburseAmountControlService controlService) {
        int reimburseAmountCtlCount = 0;
        if (expenseItem == null || (reimburseAmountCtlCount = expenseItem.getInt("reimburseamountctlcount")) == 0) {
            return null;
        }
        Map<YearMonth, List<ReimburseAmountBO>> reimburses = reimburseAmountBOs.stream().collect(Collectors.groupingBy(reimburseAmountBO -> YearMonth.from(reimburseAmountBO.getHappenDate())));
        String quotaDateField = ErStdConfig.getQuotaDateField();
        String filterStr = "%s >= ? and %s <= ?";
        filterStr = String.format(filterStr, quotaDateField, quotaDateField);
        for (YearMonth yearMonth : reimburses.keySet()) {
            Map<String, LocalDate> reimburseBillHappenDatePeriod = controlService.getReimburseBillHappenDatePeriod(yearMonth);
            QFilter qFilter = QFilter.of((String)filterStr, (Object[])new Object[]{ErCommonUtils.getDateFromLocalDate(reimburseBillHappenDatePeriod.get("start")), ErCommonUtils.getDateFromLocalDate(reimburseBillHappenDatePeriod.get("end"))});
            Object[] dailyReimburseBills = BusinessDataServiceHelper.load((String)"er_dailyreimbursebill", (String)"id,billno", (QFilter[])new QFilter[]{qFilter, userQFilterOrDeptQFilter});
            if (!ArrayUtils.isNotEmpty((Object[])dailyReimburseBills) || dailyReimburseBills.length < reimburseAmountCtlCount) continue;
            List billNos = Arrays.stream(dailyReimburseBills).map(e -> (String)e.get("billno")).collect(Collectors.toList());
            return String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u62a5\u9500%2$s\u6b21\uff08\u5355\u53f7\uff1a%3$s\uff09\uff0c\u5f53\u524d\u62a5\u9500\u8d85\u51fa\u9650\u5236\u6b21\u6570\u3002", (String)"ReimburseAmountHelper_6", (String)"fi-er-business", (Object[])new Object[0]), ((OrmLocaleValue)expenseItem.get("name")).getDefaultItem(), String.valueOf(dailyReimburseBills.length), String.join((CharSequence)",", billNos));
        }
        return null;
    }

    @Deprecated
    public static boolean isContrl(DynamicObject dataEntity) {
        boolean quotaZeroIsCtrl = ErStdConfig.quotaZeroIsCtrl();
        DynamicObjectCollection expenseEntryEntity = dataEntity.getDynamicObjectCollection("expenseentryentity");
        DynamicObject company = ReimburseControlUtils.getReimburseControlCompany(dataEntity);
        if (company == null) {
            return false;
        }
        String reimburseLimitControlType = ReimburseAmountControlService.getReimburseLimitControlType((Long)company.getPkValue());
        DynamicObject parameterSettingCompanyDO = ReimburseControlUtils.getParameterSettingCompany(dataEntity);
        Long companyId = (Long)company.getPkValue();
        DynamicObject applierUser = dataEntity.getDynamicObject("applier");
        Boolean multiReimburserFlag = dataEntity.getBoolean("ismultireimburser");
        Long baseCurrencyId = ErCommonUtils.getPk(dataEntity.getDynamicObject("currency"));
        block10: for (int i = 0; i < expenseEntryEntity.size(); ++i) {
            DynamicObject expenseEntity = (DynamicObject)expenseEntryEntity.get(i);
            DynamicObject expenseItemDO = expenseEntity.getDynamicObject("expenseitem");
            Date happenDateOld = expenseEntity.getDate("happendate");
            if (Objects.isNull(expenseItemDO) || Objects.isNull(happenDateOld)) break;
            Long reimburseUserId = null;
            if (multiReimburserFlag.booleanValue()) {
                if (expenseEntity.getDynamicObject("reimburser") == null) break;
                reimburseUserId = (Long)expenseEntity.getDynamicObject("reimburser").getPkValue();
            } else {
                reimburseUserId = (Long)applierUser.getPkValue();
            }
            if (null == reimburseUserId) break;
            Long expenseItemId = (Long)expenseItemDO.getPkValue();
            LocalDate happenDate = ErCommonUtils.getLocalDateFromDate(expenseEntity.getDate("happendate"));
            Long currencyId = null;
            Long oriCurrencyId = (Long)expenseEntity.getDynamicObject("entrycurrency").getPkValue();
            String reimCtlType = expenseItemDO.getString("reimctltype");
            String reimType = expenseItemDO.getString("isreimburseamountctl");
            boolean hasReimburseAmountData = false;
            switch (reimType) {
                case "0": {
                    continue block10;
                }
                case "1": {
                    currencyId = ReimburseControlUtils.getPersonCtlCurrency(ErCommonUtils.getPk(parameterSettingCompanyDO)) == ReimburseControlCurrency.OriCurrency ? oriCurrencyId : baseCurrencyId;
                    hasReimburseAmountData = ReimburseAmountControlService.hasReimburseAmountData(companyId, reimburseUserId, expenseItemId, currencyId, Year.of(happenDate.getYear()));
                    if (!StringUtils.equals((CharSequence)reimCtlType, (CharSequence)"1") || hasReimburseAmountData || !quotaZeroIsCtrl || !"3".equals(reimburseLimitControlType)) continue block10;
                    return false;
                }
                case "2": {
                    currencyId = ReimburseControlUtils.getDeptCtlCurrency(ErCommonUtils.getPk(parameterSettingCompanyDO)) == ReimburseControlCurrency.OriCurrency ? oriCurrencyId : baseCurrencyId;
                    DynamicObject deptDO = ReimburseControlUtils.getReimCtlDeptInExpenseEntry(dataEntity, i);
                    Long deptId = ErCommonUtils.getPk(deptDO);
                    hasReimburseAmountData = ReimburseAmountControlService.hasDeptReimburseAmountData(companyId, deptId, expenseItemId, currencyId, Year.of(happenDate.getYear()));
                    if (!StringUtils.equals((CharSequence)reimCtlType, (CharSequence)"1") || hasReimburseAmountData || !quotaZeroIsCtrl || !"3".equals(reimburseLimitControlType)) continue block10;
                    return false;
                }
            }
        }
        return true;
    }

    static {
        UNFINISHED_STATUS.add("A");
        UNFINISHED_STATUS.add("D");
        UNFINISHED_STATUS.add("H");
    }
}

