/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.daily.service.impl;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.er.business.daily.service.ReimburseAmountControlService;
import kd.fi.er.business.daily.service.model.ReimburseAmountBO;
import kd.fi.er.business.daily.service.model.ReimburseAmountControlResultBO;
import kd.fi.er.business.utils.CollectorsUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ReimburseControlUtils;

public class QuarterlyControlServiceImpl
implements ReimburseAmountControlService {
    @Override
    public ReimburseAmountControlResultBO validate(Long companyId, Long userId, Long expenseItemId, Long currencyId, List<ReimburseAmountBO> reimburseAmountBOs, List<Long> notInIds) {
        log.info(String.format("\u6309\u5b63\u63a7\u5236: \u516c\u53f8:%d, \u7528\u6237:%d, \u8d39\u7528\u9879\u76ee:%d, \u5e01\u79cd:%d, \u8fdb\u884c\u63a7\u5236\u7684\u8d39\u7528\u9879\u76ee\u4fe1\u606f:%s", companyId, userId, expenseItemId, currencyId, JSON.toJSONString(reimburseAmountBOs)));
        ReimburseAmountControlResultBO result = new ReimburseAmountControlResultBO();
        result.setOver(false);
        Map<YearMonth, BigDecimal> quarterReimburseAmountBO = reimburseAmountBOs.stream().collect(Collectors.groupingBy(reimburseAmountBO -> YearMonth.of(reimburseAmountBO.getHappenDate().getYear(), reimburseAmountBO.getHappenDate().getMonth().firstMonthOfQuarter()), CollectorsUtil.summingBigDecimal(ReimburseAmountBO::getAmount)));
        for (Map.Entry<YearMonth, BigDecimal> quarterReimburseAmountBOEntry : quarterReimburseAmountBO.entrySet()) {
            YearMonth yearMonth = quarterReimburseAmountBOEntry.getKey();
            BigDecimal needReimburseAmount = quarterReimburseAmountBOEntry.getValue();
            BigDecimal reimbursedAmount = this.getReimbursedAmountByMonth(companyId, userId, expenseItemId, currencyId, yearMonth, notInIds);
            BigDecimal reimburseLimitAmount = this.getReimburseLimitAmountByMonth(companyId, userId, expenseItemId, currencyId, yearMonth);
            BigDecimal balanceAmount = reimburseLimitAmount.subtract(reimbursedAmount);
            if (balanceAmount.compareTo(needReimburseAmount) >= 0) continue;
            result.setOver(true);
            result.setBalanceAmount(balanceAmount);
            result.setTotalAmount(reimburseLimitAmount);
            result.setCurrencyId(currencyId);
            result.setExpenseItemId(expenseItemId);
            result.setReimbursePeriod(String.format(ResManager.loadKDString((String)"\u7b2c%s\u5b63\u5ea6", (String)"QuarterlyControlServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]), (yearMonth.getMonthValue() + 2) / 3));
            result.setReimUserOrDeptName(ReimburseControlUtils.getUserName(userId));
            result.setInTable(ReimburseAmountControlService.hasReimburseAmountData(companyId, userId, expenseItemId, currencyId, Year.of(yearMonth.getYear())));
            return result;
        }
        return result;
    }

    @Override
    public ReimburseAmountControlResultBO validateDeptReim(Long companyId, Long deptId, Long expenseItemId, Long currencyId, List<ReimburseAmountBO> reimburseAmountBOs, List<Long> notInIds) {
        log.info(String.format("\u90e8\u95e8\u989d\u5ea6\u6309\u5b63\u63a7\u5236: \u516c\u53f8:%d, \u90e8\u95e8:%d, \u8d39\u7528\u9879\u76ee:%d, \u5e01\u79cd:%d, \u8fdb\u884c\u63a7\u5236\u7684\u8d39\u7528\u9879\u76ee\u4fe1\u606f:%s", companyId, deptId, expenseItemId, currencyId, JSON.toJSONString(reimburseAmountBOs)));
        ReimburseAmountControlResultBO result = new ReimburseAmountControlResultBO();
        result.setOver(false);
        Map<YearMonth, BigDecimal> quarterReimburseAmountBO = reimburseAmountBOs.stream().collect(Collectors.groupingBy(reimburseAmountBO -> YearMonth.of(reimburseAmountBO.getHappenDate().getYear(), reimburseAmountBO.getHappenDate().getMonth().firstMonthOfQuarter()), CollectorsUtil.summingBigDecimal(ReimburseAmountBO::getAmount)));
        for (Map.Entry<YearMonth, BigDecimal> quarterReimburseAmountBOEntry : quarterReimburseAmountBO.entrySet()) {
            YearMonth yearMonth = quarterReimburseAmountBOEntry.getKey();
            BigDecimal needReimburseAmount = quarterReimburseAmountBOEntry.getValue();
            BigDecimal reimbursedAmount = this.getDeptReimbursedAmountByMonth(companyId, deptId, expenseItemId, currencyId, yearMonth, notInIds);
            BigDecimal reimburseLimitAmount = this.getDeptReimburseLimitAmountByMonth(companyId, deptId, expenseItemId, currencyId, yearMonth);
            BigDecimal balanceAmount = reimburseLimitAmount.subtract(reimbursedAmount);
            if (balanceAmount.compareTo(needReimburseAmount) >= 0) continue;
            result.setOver(true);
            result.setBalanceAmount(balanceAmount);
            result.setTotalAmount(reimburseLimitAmount);
            result.setCurrencyId(currencyId);
            result.setExpenseItemId(expenseItemId);
            result.setReimbursePeriod(String.format(ResManager.loadKDString((String)"\u7b2c%s\u5b63\u5ea6", (String)"QuarterlyControlServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]), (yearMonth.getMonthValue() + 2) / 3));
            result.setReimUserOrDeptName(ReimburseControlUtils.getOrgName(deptId));
            result.setInTable(ReimburseAmountControlService.hasDeptReimburseAmountData(companyId, deptId, expenseItemId, currencyId, Year.of(yearMonth.getYear())));
            return result;
        }
        return result;
    }

    @Override
    public BigDecimal getReimburseLimitAmountByMonth(Long companyId, Long userId, Long expenseItemId, Long currencyId, YearMonth yearMonth) {
        return this.getReimburseQuarterlyAmountLimited(companyId, userId, expenseItemId, currencyId, yearMonth);
    }

    @Override
    public BigDecimal getDeptReimburseLimitAmountByMonth(Long companyId, Long deptId, Long expenseItemId, Long currencyId, YearMonth yearMonth) {
        return this.getDeptReimburseQuarterlyAmountLimited(companyId, deptId, expenseItemId, currencyId, yearMonth);
    }

    @Override
    public BigDecimal getReimbursedAmountByMonth(Long companyId, Long userId, Long expenseItemId, Long currencyId, YearMonth yearMonth, List<Long> notInIds) {
        Map<String, LocalDate> quarterPeriod = ErCommonUtils.getQuarterPeriod(yearMonth);
        return this.getUserReimbursedAmountBetween(companyId, userId, expenseItemId, currencyId, quarterPeriod.get("start"), quarterPeriod.get("end"), notInIds);
    }

    @Override
    public BigDecimal getDeptReimbursedAmountByMonth(Long companyId, Long deptId, Long expenseItemId, Long currencyId, YearMonth yearMonth, List<Long> notInIds) {
        Map<String, LocalDate> quarterPeriod = ErCommonUtils.getQuarterPeriod(yearMonth);
        return this.getDeptReimbursedAmountBetween(companyId, deptId, expenseItemId, currencyId, quarterPeriod.get("start"), quarterPeriod.get("end"), notInIds);
    }

    @Override
    public BigDecimal getAuditReimbursedAmountByMonth(Long companyId, Long userId, Long expenseItemId, Long currencyId, YearMonth yearMonth) {
        Map<String, LocalDate> quarterPeriod = ErCommonUtils.getQuarterPeriod(yearMonth);
        return this.getAuditReimbursedAmountBetween(companyId, userId, expenseItemId, currencyId, quarterPeriod.get("start"), quarterPeriod.get("end"));
    }

    @Override
    public Map<String, LocalDate> getReimburseBillHappenDatePeriod(YearMonth yearMonth) {
        return ErCommonUtils.getQuarterPeriod(yearMonth);
    }
}

