/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.daily.service.model;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.utils.ActionLocalCache;
import org.apache.commons.lang3.StringUtils;

public class CurrencyBO
implements Serializable {
    private static final long serialVersionUID = 3528297126109950006L;
    private Long currencyId;
    private Integer precision;
    private String symbol;
    private String name;
    private String number;

    public CurrencyBO(Long currencyId) {
        this.currencyId = currencyId;
        DynamicObject currencyDO = (DynamicObject)ActionLocalCache.get().get("CURRENCY_DYN_OBJ", currencyId, () -> BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency"));
        this.precision = currencyDO.getInt("amtprecision");
        this.symbol = currencyDO.getString("sign");
        this.name = currencyDO.getLocaleString("name").getLocaleValue();
        this.number = currencyDO.getString("number");
    }

    public CurrencyBO(Long currencyId, Integer precision, String symbol) {
        this.currencyId = currencyId;
        this.precision = precision;
        this.symbol = symbol;
    }

    public Long getCurrencyId() {
        return this.currencyId;
    }

    public void setCurrencyId(Long currencyId) {
        this.currencyId = currencyId;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public DecimalFormat getDefaultDecimalFormat() {
        String formatStr = ",##0." + StringUtils.repeat((char)'0', (int)(this.precision == null ? 2 : this.precision));
        String language = ResManager.getLanguage();
        DecimalFormat decimalFormat = !"zh_CN".equals(language) && !"zh_TW".equals(language) ? new DecimalFormat(formatStr, new DecimalFormatSymbols(Locale.GERMANY)) : new DecimalFormat(formatStr);
        return decimalFormat;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }
}

