/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.datacheck.validator;

import java.math.BigDecimal;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.datacheck.validator.BizAmountCheckCondition;
import kd.fi.er.business.domain.amount.BillAmountServiceFacade;
import kd.fi.er.business.domain.amount.IBillAmountService;
import kd.fi.er.business.domain.amount.ILoanBillAmountService;
import kd.fi.er.business.domain.amount.IReimurseBillAmountSevice;
import kd.fi.er.business.isc.IscHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.FieldNameHelper;
import kd.fi.er.common.field.expenseentry.ExpenseEntryFields;
import kd.fi.er.common.field.head.BillHeadFields;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;

public class CommonAmountCheckCondition {
    private static Log logger = LogFactory.getLog(CommonAmountCheckCondition.class);
    public static final Function<DynamicObject, String> encashedAmtValidator = CommonAmountCheckCondition.encashedAmtValidator();
    public static final Function<DynamicObject, String> reCalcEncashedAmtValidator = CommonAmountCheckCondition.reCalcEncashedAmtValidator();
    public static final Function<DynamicObject, String> accountEntryAmtValidator = CommonAmountCheckCondition.accountEntryAmtValidator();
    public static final Function<DynamicObject, String> sumOfEntryAndHeadAmtValidator = CommonAmountCheckCondition.sumOfEntryAndHeadAmtValidator();
    public static final Function<DynamicObject, String> payOrNotAmtValidator = CommonAmountCheckCondition.payOrNotAmtValidator();
    public static final Function<DynamicObject, String> reCalcEntryCurApproveAmtValidator = CommonAmountCheckCondition.reCalcEntryCurApproveAmtValidator();

    private static Function<DynamicObject, String> encashedAmtValidator() {
        return dataEntity -> {
            String entityname = dataEntity.getDataEntityType().getName();
            if (PayeeServiceHelper.storageLimits(dataEntity)) {
                return null;
            }
            BillHeadFields billHeadInstance = FieldNameHelper.getBillHeadInstance(entityname);
            IBillAmountService service = BillAmountServiceFacade.getService(dataEntity.getDataEntityType().getName());
            if (billHeadInstance != null) {
                DynamicObjectCollection accEntry;
                BigDecimal accEntryTotalPayAmount;
                if (ErEntityTypeUtils.isApplyPayBill(entityname)) {
                    return null;
                }
                BigDecimal payAmount = dataEntity.getBigDecimal(billHeadInstance.encashAmtField);
                if (payAmount.compareTo(accEntryTotalPayAmount = (accEntry = dataEntity.getDynamicObjectCollection("accountentry")).stream().map(row -> row.getBigDecimal("receiveamount")).reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) {
                    String currencySign = dataEntity.getDynamicObject("currency").getString("sign");
                    logger.warn(ResManager.loadKDString((String)"\u4ed8\u73b0\u91d1\u989d\u548c\u6536\u6b3e\u4fe1\u606f\u5206\u5f55\u4e0d\u76f8\u7b49\u3002\u4ed8\u73b0\u91d1\u989d%1$s\uff0c\u6536\u6b3e\u4fe1\u606f\u6536\u6b3e\u91d1\u989d\u603b\u8ba1%2$s\u3002", (String)"CommonAmountCheckCondition_11", (String)"fi-er-business", (Object[])new Object[0]), (Object)StringUtils.joinWith(null, (Object[])new Object[]{currencySign, CommonAmountCheckCondition.stripTrailingZeros(payAmount)}), (Object)StringUtils.joinWith(null, (Object[])new Object[]{currencySign, CommonAmountCheckCondition.stripTrailingZeros(accEntryTotalPayAmount)}));
                    String encashedAmtValidatorMsg = ResManager.loadKDString((String)"\u4ed8\u73b0\u91d1\u989d\u548c\u6536\u6b3e\u91d1\u989d\u5408\u8ba1\u4e0d\u76f8\u7b49\uff0c", (String)"CommonAmountCheckCondition_0", (String)"fi-er-business", (Object[])new Object[0]);
                    if (service != null) {
                        return encashedAmtValidatorMsg + service.encashedAmtValidatorMsg((DynamicObject)dataEntity);
                    }
                    return encashedAmtValidatorMsg;
                }
            }
            return null;
        };
    }

    private static Function<DynamicObject, String> reCalcEncashedAmtValidator() {
        return dataEntity -> {
            if (ErStdConfig.get("ext.service.er.payamountCalc") != null) {
                return null;
            }
            IBillAmountService service = BillAmountServiceFacade.getService(dataEntity.getDataEntityType().getName());
            if (service != null) {
                BigDecimal calcPayAmount = service.calcPayAmount((DynamicObject)dataEntity);
                BigDecimal payAmountNow = service.getPayAmountNow((DynamicObject)dataEntity);
                if (payAmountNow.compareTo(calcPayAmount) != 0) {
                    if (calcPayAmount.compareTo(BigDecimal.ZERO) < 0 && payAmountNow.compareTo(BigDecimal.ZERO) == 0) {
                        return null;
                    }
                    return String.format(ResManager.loadKDString((String)"\u5355\u5934\u201c\u4ed8\u73b0\u91d1\u989d\u201d%1s\u548c\u91cd\u65b0\u8ba1\u7b97\u7684\u4ed8\u73b0\u91d1\u989d%2s\u4e0d\u76f8\u7b49\uff0c\u6570\u636e\u7591\u4f3c\u53d1\u751f\u9519\u8bef\u3002", (String)"CommonAmountCheckCondition_1", (String)"fi-er-business", (Object[])new Object[0]), CommonAmountCheckCondition.stripTrailingZeros(payAmountNow), CommonAmountCheckCondition.stripTrailingZeros(calcPayAmount));
                }
            }
            return null;
        };
    }

    private static String stripTrailingZeros(BigDecimal decimal) {
        if (decimal == null) {
            return "null";
        }
        return decimal.stripTrailingZeros().toPlainString();
    }

    private static Function<DynamicObject, String> accountEntryAmtValidator() {
        return dataEntity -> {
            IDataEntityProperty accountEntryProp = (IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)"accountentry");
            if (accountEntryProp != null) {
                DynamicObjectCollection accEntry = dataEntity.getDynamicObjectCollection("accountentry");
                for (int idx = 0; idx < accEntry.size(); ++idx) {
                    DynamicObject row = (DynamicObject)accEntry.get(idx);
                    BigDecimal receiveAmount = row.getBigDecimal("receiveamount");
                    BigDecimal oriReceiveAmount = row.getBigDecimal("orireceiveamount");
                    BigDecimal exchangeRate = row.getBigDecimal("accexchangerate");
                    DynamicObject currency = dataEntity.getDynamicObject("currency");
                    int precision = 2;
                    if (currency != null) {
                        precision = currency.getInt("amtprecision");
                    }
                    String quoteType = StringUtils.isBlank((CharSequence)row.getString("accquotetype")) ? "0" : row.getString("accquotetype");
                    BigDecimal realReceviceAmount = AmountUtils.getCurrencyAmount(oriReceiveAmount, exchangeRate, precision, quoteType);
                    BigDecimal diffRange = new BigDecimal("0.1");
                    String accentryDiffRange = ErStdConfig.get("accentryDiffRange");
                    if (!StringUtils.isBlank((CharSequence)accentryDiffRange) && NumberUtils.isNumber((String)accentryDiffRange)) {
                        diffRange = new BigDecimal(accentryDiffRange.toCharArray());
                    }
                    if (realReceviceAmount.subtract(receiveAmount).abs().compareTo(diffRange) <= 0) continue;
                    String currencySign = dataEntity.getDynamicObject("currency").getString("sign");
                    return String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u5206\u5f55\u7b2c%1$s\u884c\uff0c\u6536\u6b3e\u91d1\u989d\u672c\u4f4d\u5e01%2$s\uff0c\u5b9e\u9645\u8ba1\u7b97\u6536\u6b3e\u91d1\u989d\u672c\u4f4d\u5e01\u201c%3$s\u201d\u5b58\u5728\u8f83\u5927\u8bef\u5dee\u3002", (String)"CommonAmountCheckCondition_2", (String)"fi-er-business", (Object[])new Object[0]), idx + 1, StringUtils.joinWith(null, (Object[])new Object[]{currencySign, CommonAmountCheckCondition.stripTrailingZeros(receiveAmount)}), StringUtils.joinWith(null, (Object[])new Object[]{currencySign, CommonAmountCheckCondition.stripTrailingZeros(realReceviceAmount)}));
                }
            }
            return null;
        };
    }

    private static Function<DynamicObject, String> payOrNotAmtValidator() {
        if (IscHelper.isIntegratedWithEAS() || IscHelper.isIntegratedWithXK()) {
            return null;
        }
        return dataEntity -> {
            DataEntityPropertyCollection properties;
            IDataEntityProperty accountEntryProp;
            String entityName = dataEntity.getDataEntityType().getName();
            BillHeadFields billHeadInstance = FieldNameHelper.getBillHeadInstance(entityName);
            if (ErEntityTypeUtils.isApplyPayBill(entityName)) {
                return null;
            }
            if (billHeadInstance != null) {
                BigDecimal notPayAmount = dataEntity.getBigDecimal("notpayamount");
                BigDecimal payAmount = dataEntity.getBigDecimal(billHeadInstance.payedAmtFiled);
                BigDecimal encashAmount = dataEntity.getBigDecimal(billHeadInstance.encashAmtField);
                if (encashAmount.subtract(payAmount.add(notPayAmount)).compareTo(BigDecimal.ZERO) != 0) {
                    return ResManager.loadKDString((String)"\u5355\u5934\u672a\u4ed8\u91d1\u989d\u52a0\u5df2\u4ed8\u91d1\u989d\u4e0d\u7b49\u4e8e\u4ed8\u73b0\u91d1\u989d\u3002", (String)"CommonAmountCheckCondition_3", (String)"fi-er-business", (Object[])new Object[0]);
                }
            }
            if ((accountEntryProp = (IDataEntityProperty)(properties = dataEntity.getDataEntityType().getProperties()).get((Object)"accountentry")) != null) {
                DynamicObjectCollection accEntry = dataEntity.getDynamicObjectCollection("accountentry");
                for (int index = accEntry.getStartRowIndex(); index < accEntry.size(); ++index) {
                    BigDecimal notPayAmount;
                    BigDecimal payAmount;
                    DynamicObject row = (DynamicObject)accEntry.get(index);
                    BigDecimal receiveAmount = row.getBigDecimal("receiveamount");
                    if (receiveAmount.subtract((payAmount = row.getBigDecimal("accpayedamount")).add(notPayAmount = row.getBigDecimal("accnotpayamount"))).compareTo(BigDecimal.ZERO) == 0) continue;
                    String currencySign = dataEntity.getDynamicObject("currency").getString("sign");
                    return String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u5206\u5f55\u7b2c%1$s\u884c\uff0c\u672a\u4ed8\u91d1\u989d\u672c\u4f4d\u5e01%2$s\u4e0e\u5df2\u4ed8\u91d1\u989d\u672c\u4f4d\u5e01%3$s\u4e4b\u548c\uff0c\u4e0d\u7b49\u4e8e\u6536\u6b3e\u91d1\u989d\u672c\u4f4d\u5e01%4$s\u3002", (String)"CommonAmountCheckCondition_4", (String)"fi-er-business", (Object[])new Object[0]), index + 1, StringUtils.joinWith(null, (Object[])new Object[]{currencySign, CommonAmountCheckCondition.stripTrailingZeros(notPayAmount)}), StringUtils.joinWith(null, (Object[])new Object[]{currencySign, CommonAmountCheckCondition.stripTrailingZeros(payAmount)}), StringUtils.joinWith(null, (Object[])new Object[]{currencySign, CommonAmountCheckCondition.stripTrailingZeros(receiveAmount)}));
                }
            }
            return null;
        };
    }

    private static Function<DynamicObject, String> sumOfEntryAndHeadAmtValidator() {
        if (IscHelper.isIntegratedWithEAS() || IscHelper.isIntegratedWithXK()) {
            return null;
        }
        return dataEntity -> {
            IBillAmountService service = BillAmountServiceFacade.getService(dataEntity.getDataEntityType().getName());
            if (service != null) {
                BigDecimal headApproveAmount;
                BigDecimal sumApproveAmountOfEntry;
                DataEntityPropertyCollection properties = dataEntity.getDataEntityType().getProperties();
                if (properties.get((Object)"approveamount") != null && (sumApproveAmountOfEntry = service.calcCurrApproveAmount((DynamicObject)dataEntity)).compareTo(headApproveAmount = dataEntity.getBigDecimal("approveamount")) != 0) {
                    return String.format(ResManager.loadKDString((String)"[\u8d39\u7528\u660e\u7ec6/\u501f\u6b3e\u660e\u7ec6/\u5dee\u65c5\u660e\u7ec6]\u5206\u5f55\u6838\u5b9a\u91d1\u989d\u6c47\u603b%1$s\u4e0e\u5355\u5934\u6838\u5b9a\u91d1\u989d%2$s\u4e0d\u76f8\u7b49\u3002", (String)"CommonAmountCheckCondition_5", (String)"fi-er-business", (Object[])new Object[0]), CommonAmountCheckCondition.stripTrailingZeros(sumApproveAmountOfEntry), CommonAmountCheckCondition.stripTrailingZeros(headApproveAmount));
                }
                if (service instanceof ILoanBillAmountService) {
                    return new BizAmountCheckCondition.LoanBizAmountCheck<ILoanBillAmountService>().sumOfEntryAndHeadValidator((DynamicObject)dataEntity, (ILoanBillAmountService)service);
                }
                if (service instanceof IReimurseBillAmountSevice) {
                    return new BizAmountCheckCondition.ReimBurseBizAmountCheck<IReimurseBillAmountSevice>().sumOfEntryAndHeadValidator((DynamicObject)dataEntity, (IReimurseBillAmountSevice)service);
                }
            }
            return null;
        };
    }

    private static Function<DynamicObject, String> reCalcEntryCurApproveAmtValidator() {
        return dataEntity -> {
            ExpenseEntryFields expenseEntryFields = FieldNameHelper.getExpenseEntryFields(dataEntity.getDataEntityType().getName());
            String msg = null;
            if (expenseEntryFields != null) {
                int currencyPrecision = AmountUtils.getCurrencyPrecision(dataEntity, expenseEntryFields.currencyKey);
                if (expenseEntryFields.isTripExpenseEntry()) {
                    DynamicObjectCollection tripEntries = dataEntity.getDynamicObjectCollection("tripentry");
                    boolean isCardView = "0".equals(dataEntity.getString("billkind"));
                    String entryName = tripEntries.getDynamicObjectType().getDisplayName().getLocaleValue_zh_CN();
                    for (int index = 0; index < tripEntries.size(); ++index) {
                        msg = CommonAmountCheckCondition.reCalcEntryCurApproveAmt((DynamicObject)tripEntries.get(index), expenseEntryFields, currencyPrecision);
                        if (msg == null) continue;
                        if (isCardView) {
                            msg = String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u4e2a\u884c\u7a0b\u4e2d", (String)"CommonAmountCheckCondition_9", (String)"fi-er-business", (Object[])new Object[0]), entryName, index + 1) + msg;
                        }
                        return msg;
                    }
                } else {
                    msg = CommonAmountCheckCondition.reCalcEntryCurApproveAmt(dataEntity, expenseEntryFields, currencyPrecision);
                }
            }
            return msg;
        };
    }

    private static String reCalcEntryCurApproveAmt(DynamicObject dynamicObject, ExpenseEntryFields expenseEntryFields, int precision) {
        DynamicObjectCollection entryEnties = dynamicObject.getDynamicObjectCollection(expenseEntryFields.entryKey);
        String localeValue = entryEnties.getDynamicObjectType().getDisplayName().getLocaleValue_zh_CN();
        for (int index = 0; index < entryEnties.size(); ++index) {
            String quoteType;
            DynamicObject row = (DynamicObject)entryEnties.get(index);
            BigDecimal oriApproveAmt = row.getBigDecimal(expenseEntryFields.oriApproveAmtKey);
            BigDecimal curApproveAmt = row.getBigDecimal(expenseEntryFields.curApproveAmtKey);
            BigDecimal exchangeRate = row.getBigDecimal(expenseEntryFields.entryExchangerateKey);
            BigDecimal recalcurAppAmount = AmountUtils.getCurrencyAmount(oriApproveAmt, exchangeRate, precision, quoteType = row.getString(expenseEntryFields.quoteType));
            if (recalcurAppAmount.subtract(curApproveAmt).abs().compareTo(new BigDecimal("0.1")) <= 0) continue;
            return String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\u91cd\u7b97\u7684\u6838\u5b9a\u91d1\u989d\uff08\u672c\u4f4d\u5e01\uff09\u4e0e\u5206\u5f55\u5b58\u50a8\u6838\u5b9a\u91d1\u989d\uff08\u672c\u4f4d\u5e01\uff09\u7684\u503c\u5b58\u5728\u5dee\u5f02\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e\u3002\u6838\u5b9a\u91d1\u989d\uff1a%3$s\uff0c\u6c47\u7387\uff1a%4$s\uff0c\u6362\u7b97\u65b9\u5f0f\uff1a%5$s\uff0c\u91cd\u7b97\u540e\u7684\u6838\u5b9a\u91d1\u989d\uff08\u672c\u4f4d\u5e01\uff09\uff1a%6$s\uff0c\u6838\u5b9a\u91d1\u989d\uff08\u672c\u4f4d\u5e01\uff09\uff1a%7$s", (String)"CommonAmountCheckCondition_8", (String)"fi-er-business", (Object[])new Object[0]), index + 1, localeValue, CommonAmountCheckCondition.stripTrailingZeros(oriApproveAmt), CommonAmountCheckCondition.stripTrailingZeros(exchangeRate), quoteType, CommonAmountCheckCondition.stripTrailingZeros(recalcurAppAmount), CommonAmountCheckCondition.stripTrailingZeros(curApproveAmt));
        }
        return null;
    }
}

