/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.fatvs.skilldata;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Year;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.ext.fi.fatvs.skilldata.ISkillRunnable;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunContext;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.utils.ErConstants;

public class CloseBill
implements ISkillRunnable {
    private static final Log logger = LogFactory.getLog(CloseBill.class);
    private static final String ALGO = CloseBill.class.getName();

    public SkillRunResult pullData(SkillRunContext skillRunContext) {
        String skillNum = skillRunContext.getSkillNum();
        SkillRunResult skillResult = skillRunContext.getSkillResult();
        int shouldCloseCount = this.getShouldCloseCount();
        int closedCount = this.getClosedCount();
        String closeRateStr = this.getCloseRateStr(shouldCloseCount, closedCount);
        logger.info(String.format("CloseBill: shouldCloseCount=%s, closedCount=%s", shouldCloseCount, closedCount));
        skillResult.setTotalCount(Integer.valueOf(0));
        skillResult.setDate(skillRunContext.getStartTime());
        skillResult.setSkillNum(skillNum);
        ArrayList data = new ArrayList();
        HashMap<String, String> item = new HashMap<String, String>(4);
        item.put("number", "zdgdl");
        item.put("name", ResManager.loadKDString((String)"\u81ea\u52a8\u5173\u5355\u7387", (String)"CloseBill_0", (String)"fi-er-business", (Object[])new Object[0]));
        item.put("value", closeRateStr);
        item.put("valueType", "1");
        data.add(item);
        skillResult.setData(data);
        return skillResult;
    }

    private String getCloseRateStr(int shouldCloseCount, int closedCount) {
        BigDecimal closeRate = BigDecimal.ZERO;
        closeRate = shouldCloseCount != 0 ? new BigDecimal(closedCount).multiply(new BigDecimal(100)).divide(new BigDecimal(shouldCloseCount), 2, RoundingMode.HALF_UP) : closeRate.setScale(2);
        return closeRate + "%";
    }

    private int getClosedCount() {
        int year = Year.now().getValue();
        StringBuilder sb = new StringBuilder();
        sb.append("select count(1) count from %s").append("\n");
        sb.append(" where fbizdate >= {ts'%s-1-1'} and fbizdate < {ts'%s-1-1'}").append("\n");
        sb.append(" and fnotpayamount >= 0 and fbillstatus = 'I'");
        String fmt = sb.toString();
        String sql = "select sum(count) count from (\n%s \nunion all\n %s \nunion all\n %s\n) T";
        String sql_1 = String.format(fmt, "t_er_dailyreimbursebill", year, year + 1);
        String sql_2 = String.format(fmt, "t_er_reimbursebill", year, year + 1);
        String sql_3 = String.format(fmt, "t_er_pubreimbill", year, year + 1);
        sql = String.format(sql, sql_1, sql_2, sql_3);
        int count = 0;
        try (DataSet ds = DB.queryDataSet((String)ALGO, (DBRoute)ErConstants.FI_DB_ROUTE, (String)sql);){
            for (Row row : ds) {
                count += row.getInteger("count").intValue();
            }
        }
        return count;
    }

    private int getShouldCloseCount() {
        int year = Year.now().getValue();
        StringBuilder sb = new StringBuilder();
        sb.append("select count(1) count from %s").append("\n");
        sb.append(" where fbizdate >= {ts'%s-1-1'} and fbizdate < {ts'%s-1-1'}").append("\n");
        sb.append(" and ((fnotpayamount = 0 and (fbillstatus = 'E' or fbillstatus = 'I'))").append("\n");
        sb.append(" or (fnotpayamount > 0 and (fbillstatus = 'G' or fbillstatus = 'I')))");
        String fmt = sb.toString();
        String sql = "select sum(count) count from (\n%s \nunion all\n %s \nunion all\n %s\n) T";
        String sql_1 = String.format(fmt, "t_er_dailyreimbursebill", year, year + 1);
        String sql_2 = String.format(fmt, "t_er_reimbursebill", year, year + 1);
        String sql_3 = String.format(fmt, "t_er_pubreimbill", year, year + 1);
        sql = String.format(sql, sql_1, sql_2, sql_3);
        int count = 0;
        try (DataSet ds = DB.queryDataSet((String)ALGO, (DBRoute)ErConstants.FI_DB_ROUTE, (String)sql);){
            for (Row row : ds) {
                count += row.getInteger("count").intValue();
            }
        }
        return count;
    }
}

