/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.fatvs.skilldata;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.ext.fi.fatvs.skilldata.ISkillRunnable;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunContext;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.fatvs.skilldata.util.SkillCommonUtil;

public class IndexAccessApi
implements ISkillRunnable {
    private static final String TRIP_REIMBURSEBILL_KEY = "znyyclbx";
    private static final String TRIP_REQBILL_KEY = "znyyccsq";
    private static final String TRIP_DAILY_REIMBURSE_KEY = "znyyfybx";
    private static final String TRIP_DAILY_REIMBURSE_TABLE = "t_er_dailyreimbursebill";

    public SkillRunResult pullData(SkillRunContext skillRunContext) {
        String skillNum = skillRunContext.getSkillNum();
        SkillRunResult skillResult = skillRunContext.getSkillResult();
        Date startTime = skillRunContext.getStartTime();
        Date endTime = skillRunContext.getEndTime();
        skillResult.setDate(skillRunContext.getStartTime());
        skillResult.setSkillNum(skillNum);
        switch (skillNum) {
            case "znyyclbx": {
                skillResult.setData(this.dealTripReimburseBill(this.preExecuteSql(startTime, endTime, "er_tripreimbursebill", "t_er_reimbursebill"), skillResult));
                break;
            }
            case "znyyccsq": {
                skillResult.setData(this.dealTripReqBill(this.preExecuteSql(startTime, endTime, "er_tripreqbill", "t_er_reqBill"), skillResult));
                break;
            }
            case "znyyfybx": {
                skillResult.setData(this.dealTripDailyReimburseBill(this.preExecuteSql(startTime, endTime, "er_dailyreimbursebill", TRIP_DAILY_REIMBURSE_TABLE), skillResult));
            }
        }
        return skillResult;
    }

    private ThreeTuple<Integer, Integer, Integer> preExecuteSql(Date startTime, Date endTime, String entityName, String tableName) {
        int preRowCount = 0;
        int currentRowCount = 0;
        QFilter startTimeFilter = new QFilter("createtime", ">=", (Object)startTime);
        QFilter endTimeFilter = new QFilter("createtime", "<=", (Object)endTime);
        QFilter kFilter = new QFilter("origin", "=", (Object)"3");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{startTimeFilter, endTimeFilter, kFilter});
        String querySql = String.format("/*dialect*/select fid from %s where fcreatetime >= '%s' and fcreatetime < '%s' and forigin='3'", tableName, SkillCommonUtil.getTime(-1), SkillCommonUtil.getTime(0));
        DataSet preRows = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"er"), (String)querySql);
        if (preRows != null) {
            preRowCount = this.countDataSet(preRows);
        }
        querySql = String.format("/*dialect*/select fid from %s where fcreatetime >= '%s' and fcreatetime < '%s' and forigin='3'", tableName, SkillCommonUtil.getTime(0), SkillCommonUtil.getTime(1));
        DataSet currentRows = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"er"), (String)querySql);
        if (currentRows != null) {
            currentRowCount = this.countDataSet(currentRows);
        }
        return new ThreeTuple<Integer, Integer, Integer>(dynamicObjects.size(), preRowCount, currentRowCount);
    }

    private int countDataSet(DataSet dataSet) {
        int index = 0;
        for (Row row : dataSet) {
            ++index;
        }
        return index;
    }

    private List<Map<String, String>> dealTripReqBill(ThreeTuple<Integer, Integer, Integer> resultTuple, SkillRunResult skillResult) {
        ArrayList resList = Lists.newArrayListWithCapacity((int)4);
        HashMap<String, String> resMap = new HashMap<String, String>(4);
        int totalCount = 0;
        int preMonthTotalCount = 0;
        int currentMonthTotalCount = 0;
        String currentRatio = "";
        preMonthTotalCount = (Integer)resultTuple.second;
        resMap.put("number", "syyyccsqzs");
        resMap.put("name", ResManager.loadKDString((String)"\u4e0a\u6708\u8bed\u97f3\u51fa\u5dee\u7533\u8bf7\u603b\u6570", (String)"IndexAccessApi_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
        resMap.put("value", String.valueOf(preMonthTotalCount));
        resMap.put("valueType", "0");
        resList.add(resMap);
        resMap = new HashMap(4);
        currentMonthTotalCount = (Integer)resultTuple.third;
        resMap.put("number", "dyyyccsqzs");
        resMap.put("name", ResManager.loadKDString((String)"\u5f53\u6708\u8bed\u97f3\u51fa\u5dee\u7533\u8bf7\u603b\u6570", (String)"IndexAccessApi_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
        resMap.put("value", String.valueOf(currentMonthTotalCount));
        resMap.put("valueType", "0");
        resList.add(resMap);
        resMap = new HashMap(4);
        Integer total = this.getTotal("t_er_reqBill");
        if (total != 0) {
            currentRatio = new BigDecimal(currentMonthTotalCount).divide(new BigDecimal(total), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP) + "%";
            resMap.put("number", "dyyyccsqbl");
            resMap.put("name", ResManager.loadKDString((String)"\u5f53\u6708\u8bed\u97f3\u51fa\u5dee\u7533\u8bf7\u6bd4\u4f8b", (String)"IndexAccessApi_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
            resMap.put("value", currentRatio);
            resMap.put("valueType", "1");
            resList.add(resMap);
        }
        resMap = new HashMap(4);
        totalCount = (Integer)resultTuple.first;
        skillResult.setTotalCount(Integer.valueOf(totalCount));
        resMap.put("number", "clsjzl");
        resMap.put("name", ResManager.loadKDString((String)"\u5904\u7406\u6570\u636e\u603b\u91cf", (String)"IndexAccessApi_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
        resMap.put("value", String.valueOf(totalCount));
        resMap.put("valueType", "0");
        resList.add(resMap);
        return resList;
    }

    private List<Map<String, String>> dealTripReimburseBill(ThreeTuple<Integer, Integer, Integer> resultTuple, SkillRunResult skillResult) {
        ArrayList resList = Lists.newArrayListWithCapacity((int)4);
        HashMap<String, String> resMap = new HashMap<String, String>(4);
        int totalCount = 0;
        int currentMonthTotalCount = 0;
        String currentRatio = "";
        int preMonthTotalCount = (Integer)resultTuple.second;
        resMap.put("number", "syyyclbxzs");
        resMap.put("name", ResManager.loadKDString((String)"\u4e0a\u6708\u8bed\u97f3\u5dee\u65c5\u62a5\u9500\u603b\u6570", (String)"IndexAccessApi_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
        resMap.put("value", String.valueOf(preMonthTotalCount));
        resMap.put("valueType", "0");
        resList.add(resMap);
        resMap = new HashMap(4);
        currentMonthTotalCount = (Integer)resultTuple.third;
        resMap.put("number", "dyyyclbxzs");
        resMap.put("name", ResManager.loadKDString((String)"\u5f53\u6708\u8bed\u97f3\u5dee\u65c5\u62a5\u9500\u603b\u6570", (String)"IndexAccessApi_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
        resMap.put("value", String.valueOf(currentMonthTotalCount));
        resMap.put("valueType", "0");
        resList.add(resMap);
        resMap = new HashMap(4);
        Integer total = this.getTotal("t_er_reimbursebill");
        if (total != 0) {
            currentRatio = new BigDecimal(currentMonthTotalCount).divide(new BigDecimal(total), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP) + "%";
            resMap.put("number", "dyyyclbxbl");
            resMap.put("name", ResManager.loadKDString((String)"\u5f53\u6708\u8bed\u97f3\u5dee\u65c5\u62a5\u9500\u6bd4\u4f8b", (String)"IndexAccessApi_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
            resMap.put("value", currentRatio);
            resMap.put("valueType", "1");
            resList.add(resMap);
        }
        resMap = new HashMap(4);
        totalCount = (Integer)resultTuple.first;
        skillResult.setTotalCount(Integer.valueOf(totalCount));
        resMap.put("number", "clsjzl");
        resMap.put("name", ResManager.loadKDString((String)"\u5904\u7406\u6570\u636e\u603b\u91cf", (String)"IndexAccessApi_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
        resMap.put("value", String.valueOf(totalCount));
        resMap.put("valueType", "0");
        resList.add(resMap);
        return resList;
    }

    private List<Map<String, String>> dealTripDailyReimburseBill(ThreeTuple<Integer, Integer, Integer> resultTuple, SkillRunResult skillResult) {
        ArrayList resList = Lists.newArrayListWithCapacity((int)4);
        HashMap<String, String> resMap = new HashMap<String, String>(4);
        int totalCount = 0;
        int currentMonthTotalCount = 0;
        String currentRatio = "";
        int preMonthTotalCount = (Integer)resultTuple.second;
        resMap.put("number", "syyyfybxzs");
        resMap.put("name", ResManager.loadKDString((String)"\u4e0a\u6708\u8bed\u97f3\u8d39\u7528\u62a5\u9500\u603b\u6570", (String)"IndexAccessApi_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
        resMap.put("value", String.valueOf(preMonthTotalCount));
        resMap.put("valueType", "0");
        resList.add(resMap);
        resMap = new HashMap(4);
        currentMonthTotalCount = (Integer)resultTuple.third;
        resMap.put("number", "dyyyfybxzs");
        resMap.put("name", ResManager.loadKDString((String)"\u5f53\u6708\u8bed\u97f3\u8d39\u7528\u62a5\u9500\u603b\u6570", (String)"IndexAccessApi_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
        resMap.put("value", String.valueOf(currentMonthTotalCount));
        resMap.put("valueType", "0");
        resList.add(resMap);
        resMap = new HashMap(4);
        Integer total = this.getTotal(TRIP_DAILY_REIMBURSE_TABLE);
        if (total != 0) {
            currentRatio = new BigDecimal(currentMonthTotalCount).divide(new BigDecimal(total), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP) + "%";
            resMap.put("number", "dyyyfybxbl");
            resMap.put("name", ResManager.loadKDString((String)"\u5f53\u6708\u8bed\u97f3\u8d39\u7528\u62a5\u9500\u6bd4\u4f8b", (String)"IndexAccessApi_9", (String)"fi-er-formplugin", (Object[])new Object[0]));
            resMap.put("value", currentRatio);
            resMap.put("valueType", "1");
            resList.add(resMap);
        }
        resMap = new HashMap(4);
        totalCount = (Integer)resultTuple.first;
        skillResult.setTotalCount(Integer.valueOf(totalCount));
        resMap.put("number", "clsjzl");
        resMap.put("name", ResManager.loadKDString((String)"\u5904\u7406\u6570\u636e\u603b\u91cf", (String)"IndexAccessApi_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
        resMap.put("value", String.valueOf(totalCount));
        resMap.put("valueType", "0");
        resList.add(resMap);
        return resList;
    }

    private Integer getTotal(String tableName) {
        int currentRowCount = 0;
        String querySql = String.format("/*dialect*/select fid from %s where fcreatetime >= '%s' and fcreatetime <'%s'", tableName, SkillCommonUtil.getTime(0), SkillCommonUtil.getTime(1));
        DataSet currentRows = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"er"), (String)querySql);
        if (currentRows != null) {
            currentRowCount = this.countDataSet(currentRows);
        }
        return currentRowCount;
    }

    static class ThreeTuple<A, B, C> {
        public final A first;
        public final B second;
        public final C third;

        public ThreeTuple(A a, B b, C c) {
            this.first = a;
            this.second = b;
            this.third = c;
        }
    }
}

