/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.IFrameMessage;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.invoicecloud.InvoiceService;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceStatusEnum;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.kingdee.QueryInvoiceDetailBO;
import kd.fi.er.business.invoicecloud.model.AWSInvoiceData;
import kd.fi.er.business.invoicecloud.model.InvoiceData;
import kd.fi.er.business.invoicecloud.model.UpdateInvoiceStatusParam;
import kd.fi.er.business.invoicecloud.provider.param.req.DeleteInvoiceReqParam;
import kd.fi.er.business.invoicecloud.provider.param.req.DeleteVoucherRequestParam;
import kd.fi.er.business.invoicecloud.provider.param.req.EditInvoiceIframeReqParam;
import kd.fi.er.business.invoicecloud.provider.param.req.EditInvoiceReqParam;
import kd.fi.er.business.invoicecloud.provider.param.req.H5ImportInvoiceIframReqParam;
import kd.fi.er.business.invoicecloud.provider.param.req.H5ShowAllInvoiceIframParam;
import kd.fi.er.business.invoicecloud.provider.param.req.H5ShowInvoiceIframReqParam;
import kd.fi.er.business.invoicecloud.provider.param.req.ImportInvoiceIframeUrlReqParam;
import kd.fi.er.business.invoicecloud.provider.param.req.RecognitionCheckReqParam;
import kd.fi.er.business.invoicecloud.provider.param.req.SaveVoucherRequestParam;
import kd.fi.er.business.invoicecloud.provider.param.req.UpdateInvoiceStatusReqParam;
import kd.fi.er.business.invoicecloud.provider.param.req.ValidateInvocieReqParam;
import kd.fi.er.business.invoicecloud.provider.param.resp.DeleteInvoiceRespParam;
import kd.fi.er.business.invoicecloud.provider.param.resp.DeleteVoucherResp;
import kd.fi.er.business.invoicecloud.provider.param.resp.EditInvoiceResp;
import kd.fi.er.business.invoicecloud.provider.param.resp.IframeParam;
import kd.fi.er.business.invoicecloud.provider.param.resp.SaveVoucherResp;
import kd.fi.er.business.invoicecloud.provider.param.resp.UpdateInvoiceStatusRespParam;
import kd.fi.er.business.invoicecloud.provider.param.resp.ValidateInvocieRespParam;
import kd.fi.er.business.invoicecloud.provider.param.resp.WeChatMiniProgramShowInvoiceIframeReqParam;
import kd.fi.er.business.invoicecloud.provider.service.CommonInvoiceService;
import kd.fi.er.business.invoicecloud.provider.service.InvoiceServiceForMob;
import kd.fi.er.business.invoicecloud.provider.service.factory.InvoiceServiceFactory;
import kd.fi.er.business.invoicecloud.request.bean.ValidateInvoiceRespParam;
import kd.fi.er.business.invoicecloud.v2.InvoiceFrom;
import kd.fi.er.business.log.InvoiceLogUtils;
import kd.fi.er.business.servicehelper.InvoiceServiceHelper;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.common.exception.invoice.InvoiceCloudException;
import kd.fi.er.common.model.invoice.AttachVo;
import kd.fi.er.common.model.invoice.InvoiceVO;
import kd.fi.er.common.utils.Er;
import kd.fi.er.common.utils.ThrowableHelper;
import kd.fi.er.model.FormModel;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class OutsideInvoiceService
implements InvoiceService {
    private static Log logger = LogFactory.getLog(OutsideInvoiceService.class);
    private static volatile OutsideInvoiceService outsideInvoiceService;

    private OutsideInvoiceService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OutsideInvoiceService getInvoiceService() {
        if (outsideInvoiceService != null) return outsideInvoiceService;
        Class<OutsideInvoiceService> clazz = OutsideInvoiceService.class;
        synchronized (OutsideInvoiceService.class) {
            if (outsideInvoiceService != null) return outsideInvoiceService;
            outsideInvoiceService = new OutsideInvoiceService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return outsideInvoiceService;
        }
    }

    @Override
    public List<AttachVo> queryAttachments(AbstractFormPlugin formPlugin) {
        List<AttachVo> attachVos = APIHelper.queryInvoiceAttach(formPlugin.getView().getModel().getDataEntity());
        return attachVos;
    }

    @Override
    public void showDeleteAttachPageInPC(AbstractFormPlugin formPlugin, IDataModel model, CloseCallBack callBack, ImportInvoiceIframeUrlReqParam importRequestParam) {
        callBack = (CloseCallBack)ObjectUtils.defaultIfNull((Object)callBack, (Object)new CloseCallBack(formPlugin.getPluginName(), "er_invoicecloudpage_pc"));
        this.baseShowDeleteAttachmentInPc(callBack, importRequestParam, formPlugin.getView());
    }

    @Override
    public void baseShowDeleteAttachmentInPc(CloseCallBack callBack, ImportInvoiceIframeUrlReqParam importRequestParam, IFormView billview) {
        HashMap<String, String> customParam = new HashMap<String, String>();
        customParam.put("actionType", "deleteattach");
        customParam.put("importInvoiceIframeUrlReqParam", JSON.toJSONString((Object)importRequestParam));
        FormModel formModel = new FormModel("er_invoicecloudpage_pc", "", "14", true, customParam);
        ErStdConfig.PageSize importInvoicePageSize = ErStdConfig.getImportInvoicePageSize();
        formModel.setWidth(importInvoicePageSize.getWidth());
        formModel.setHeight(importInvoicePageSize.getHeight());
        formModel.setShowTitle(false);
        logger.info("\u3010\u53d1\u7968\u4e91\u3011\u5176\u4ed6\u5916\u90e8\u53d1\u7968\u4e91\u670d\u52a1 \u81ea\u5b9a\u4e49\u4f20\u9012\u53c2\u6570:" + customParam);
        ShowPageUtils.showPage((FormModel)formModel, (IFormView)billview, (CloseCallBack)callBack);
    }

    @Override
    public void showDeleteAttachPageInMob(AbstractFormPlugin formPlugin, IDataModel model, CloseCallBack callBack, ImportInvoiceIframeUrlReqParam importRequestParam) {
        this.baseShowDeleteAttachmentInMob(callBack, importRequestParam, formPlugin.getView());
    }

    @Override
    public void baseShowDeleteAttachmentInMob(CloseCallBack callBack, ImportInvoiceIframeUrlReqParam importRequestParam, IFormView billview) {
        IDataModel model = billview.getModel();
        String billStatus = (String)model.getValue("billstatus");
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(importRequestParam.getInvoiceCompanyId());
        if (config == null) {
            logger.info(importRequestParam.getInvoiceCompanyId() + "\u7ec4\u7ec7\u672a\u542f\u7528\u53d1\u7968\u4e91\u3002");
            return;
        }
        DynamicObject bill = billview.getModel().getDataEntity(true);
        if (StringUtils.equalsIgnoreCase((CharSequence)billStatus, (CharSequence)"A") || StringUtils.equalsIgnoreCase((CharSequence)billStatus, (CharSequence)"D")) {
            H5ImportInvoiceIframReqParam request = new H5ImportInvoiceIframReqParam();
            String bxdKey = importRequestParam.getBillId();
            request.setBillId(bxdKey);
            request.setTaxRegNum(config.getTaxRegnum());
            request.setCompanyId(config.getInvoiceOrgId());
            logger.info(String.format("\u3010\u53d1\u7968\u4e91\u3011\u5916\u90e8 \u79fb\u52a8\u7aef\u6253\u5f00\u53d1\u7968\u4e91\u754c\u9762,importRequestParam:%1$s;\u6784\u9020\u53c2\u6570request:%2$s", JSON.toJSONString((Object)importRequestParam), request));
            IframeParam iframParam = new IframeParam();
            try {
                InvoiceServiceForMob invoiceServiceForMob = InvoiceServiceFactory.getSingletonService(InvoiceServiceForMob.class);
                if (invoiceServiceForMob == null) {
                    logger.info("\u3010\u53d1\u7968\u4e91\u3011\u5916\u90e8 \u79fb\u52a8\u7aef\u6253\u5f00\u53d1\u7968\u4e91\u754c\u9762\uff0c\u672a\u627e\u5230\u6784\u9020iframeParam\u7684\u670d\u52a1\u3002");
                    return;
                }
                iframParam = invoiceServiceForMob.getShowDeleteAttachIframeParam(request, billview);
            }
            catch (Exception e1) {
                OutsideInvoiceService.writeErrorLog(ResManager.loadKDString((String)"\u53d1\u7968\u4e91", (String)"InvoiceService_4", (String)"fi-er-business", (Object[])new Object[0]), e1);
                billview.showErrorNotification(e1.getMessage());
                return;
            }
            IClientViewProxy proxy = (IClientViewProxy)billview.getService(IClientViewProxy.class);
            IFrameMessage msg = new IFrameMessage("openInvoiceCloudPage", iframParam.getUrl(), (Object)Er.objToJson(iframParam.getContent()));
            proxy.invokeControlMethod("htmlap", "postMessage", new Object[]{msg});
        } else {
            this.showAllInvoiceAndAttachmentListInMobH5(config, Collections.emptySet(), billview, model);
        }
    }

    @Override
    public void showImportInvoicePageInPC(AbstractFormPlugin formPlugin, IDataModel model, CloseCallBack callBack, ImportInvoiceIframeUrlReqParam importRequestParam) {
        if (this.showImportInvoicePageInPCTest(formPlugin, model, callBack, importRequestParam)) {
            return;
        }
        HashMap<String, String> customParam = new HashMap<String, String>();
        customParam.put("actionType", "selectInvoice");
        customParam.put("importInvoiceIframeUrlReqParam", JSON.toJSONString((Object)importRequestParam));
        FormModel formModel = new FormModel("er_invoicecloudpage_pc", "", "14", true, customParam);
        ErStdConfig.PageSize importInvoicePageSize = ErStdConfig.getImportInvoicePageSize();
        formModel.setWidth(importInvoicePageSize.getWidth());
        formModel.setHeight(importInvoicePageSize.getHeight());
        formModel.setShowTitle(false);
        callBack = (CloseCallBack)ObjectUtils.defaultIfNull((Object)callBack, (Object)new CloseCallBack((IFormPlugin)formPlugin, formModel.getFormId()));
        logger.info("\u3010\u53d1\u7968\u4e91\u3011\u5176\u4ed6\u5916\u90e8\u53d1\u7968\u4e91\u670d\u52a1 \u81ea\u5b9a\u4e49\u4f20\u9012\u53c2\u6570:" + customParam);
        ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)formPlugin, (CloseCallBack)callBack);
    }

    @Override
    public void showInvoiceListInPC(AbstractFormPlugin formPlugin, IDataModel model, Collection<String> serialNos, InvoiceCloudCfgBO config, Map<String, Object> otherParam) {
        this.baseShowInvoiceListInPc(formPlugin.getView(), model, serialNos, config, otherParam);
    }

    @Override
    public void baseShowInvoiceListInPc(IFormView view, IDataModel model, Collection<String> serialNos, InvoiceCloudCfgBO config, Map<String, Object> otherParam) {
        FormShowParameter formShowParameter = null;
        try {
            formShowParameter = InvoiceServiceHelper.buildOutShowInvoiceParameter(model.getDataEntity(), serialNos, config, otherParam);
        }
        catch (KDBizException e) {
            OutsideInvoiceService.writeErrorLog(ResManager.loadKDString((String)"\u53d1\u7968\u4e91", (String)"InvoiceService_4", (String)"fi-er-business", (Object[])new Object[0]), (Exception)((Object)e));
            view.showErrorNotification(e.getMessage());
            return;
        }
        view.showForm(formShowParameter);
    }

    @Override
    public UpdateInvoiceStatusRespParam updateInvoiceStatus(DynamicObject dataEntity, UpdateInvoiceStatusParam param) throws Exception {
        String billnoForCache = APIHelper.getBillNoCachedInCloud(dataEntity);
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(Long.valueOf(param.getOrgId()));
        List<String> serialNos = param.getInvoiceData().stream().map(inv -> inv.getSerialNo()).collect(Collectors.toList());
        boolean isTripReimburseBill = ErEntityTypeUtils.isTripReimburseBill(param.getEntityId());
        UpdateInvoiceStatusReqParam request = new UpdateInvoiceStatusReqParam();
        request.setBillId(billnoForCache);
        request.setBillNumber(param.getBillNo());
        request.setInvoiceStatus(InvoiceStatusEnum.of(Integer.parseInt(param.getStatus())));
        request.setSerialNos(serialNos);
        request.setTaxRegNum(config.getTaxRegnum());
        request.setTicketParam(config.genTicketParam());
        request.setReimbursingId(param.getBillId());
        request.setOrgId(Long.valueOf(param.getOrgId()));
        DynamicObject creator = dataEntity.getDynamicObject("creator");
        request.setCreatorId(creator.getPkValue().toString());
        request.setCreatorName(creator.getLocaleString("name").toString());
        request.setCreatorEmail(creator.getString("email"));
        request.setCreatorPhone(creator.getString("phone"));
        request.setAppId(param.getAppId());
        boolean paramValue = Boolean.TRUE;
        if (ErEntityTypeUtils.isCheckingpayBill(param.getEntityId())) {
            paramValue = TripSyncConfigUtil.getBoolean("Paper_invoice_matching", Boolean.TRUE);
        }
        List<String> invoiceType = Arrays.asList("9", "10");
        ArrayList invoiceDatas = Lists.newArrayListWithExpectedSize((int)param.getInvoiceData().size());
        for (InvoiceData invoiceBo : param.getInvoiceData()) {
            AWSInvoiceData invoiceData = new AWSInvoiceData();
            invoiceData.setSerialNo((String)ObjectUtils.defaultIfNull((Object)invoiceBo.getSerialNo(), (Object)""));
            invoiceData.setCanBeDeduction((Boolean)ObjectUtils.defaultIfNull((Object)invoiceBo.getIsOffset(), (Object)Boolean.FALSE));
            invoiceData.setEntryAmount((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceBo.getOffsetAmount(), (Object)BigDecimal.ZERO));
            invoiceData.setOutputReason((String)ObjectUtils.defaultIfNull((Object)invoiceBo.getInOutReson(), (Object)""));
            invoiceData.setOutputAmount((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceBo.getOutAount(), (Object)BigDecimal.ZERO));
            if (isTripReimburseBill && InvoiceFrom.TripBusiness.getValue().equals(invoiceBo.getInvoiceFrom())) {
                invoiceData.setInvoiceResource("1");
            }
            if (!paramValue && invoiceType.contains(invoiceBo.getInvoiceType())) {
                invoiceData.setInvoiceResource("1");
            }
            invoiceDatas.add(invoiceData);
        }
        request.setInvoiceData(invoiceDatas);
        UpdateInvoiceStatusParam.CoverData coverData = param.getCoverData();
        if (coverData != null) {
            request.setCoverBase64(coverData.getBase64());
            request.setCoverNumber(coverData.getCoveNo());
            request.setCoverFileType(coverData.getCoveType());
        }
        request.setBillOperationInfo(param.getBillOperation());
        request.setAttachmentFids(param.getAttachmentFids());
        return APIHelper.updateInvoiceStatus(request);
    }

    @Override
    @Deprecated
    public DeleteInvoiceRespParam deleteRelationBetweenInvoiceAndBill(DynamicObject dataEntity, Long invoiceOrgId, Map<String, Object> option) throws InvoiceCloudException {
        return this.deleteRelationBetweenInvoiceAndBill(new DeleteInvoiceReqParam(), dataEntity, invoiceOrgId, option);
    }

    @Override
    public DeleteInvoiceRespParam deleteRelationBetweenInvoiceAndBill(DeleteInvoiceReqParam request, DynamicObject dataEntity, Long invoiceOrgId, Map<String, Object> option) throws InvoiceCloudException {
        String billno_forCache = APIHelper.getBillNoCachedInCloud(dataEntity);
        String billno = dataEntity.getString("billno");
        logger.info(String.format("\u3010\u53d1\u7968\u4e91\u3011\u5220\u9664\u5355\u636e\u5173\u8054\u53d1\u7968\uff0cbillno_forCache:%s, billno:%s", billno_forCache, billno));
        DeleteInvoiceRespParam delRespParam = APIHelper.del(request, ErCommonUtils.getPk(invoiceOrgId), billno_forCache);
        return delRespParam;
    }

    @Override
    public ValidateInvocieRespParam validateInvoice(ValidateInvocieReqParam request, Map<String, Object> option) throws InvoiceCloudException {
        if (ErStdConfig.isDev()) {
            String validateResultDemo = "{\"errcode\":\"1000\" ,\"description\": \"\u64cd\u4f5c\u6210\u529f\",\"data\":{\"serialNo\":\"\u53d1\u7968\u6d41\u6c34\u53f7\",\"invoiceCode\":\"\u53d1\u7968\u4ee3\u7801\",\"invoiceNo\":\"\u53d1\u7968\u53f7\u7801\",\"invoiceDate\":\"\u53d1\u7968\u65e5\u671f\",\"invoiceAmount\":\"\u4e0d\u542b\u7a0e\u91d1\u989d\",\"checkCode\":\"\u6821\u9a8c\u7801\",\"totalTaxAmount\":\"\u7a0e\u989d\",\"totalAmount\":\"\u4ef7\u7a0e\u5408\u8ba1\",\"buyerName\":\"\u8d2d\u65b9\u540d\u79f0\",\"buyerTaxNo\":\"\u8d2d\u65b9\u7a0e\u53f7\",\"salerName\":\"\u9500\u65b9\u540d\u79f0\",\"salerTaxNo\":\"\u9500\u65b9\u540d\u79f0\"}}";
            ValidateInvoiceRespParam validateResult = (ValidateInvoiceRespParam)JSON.parseObject((String)validateResultDemo, ValidateInvoiceRespParam.class);
            ValidateInvocieRespParam result = new ValidateInvocieRespParam();
            result.setPass(validateResult.getErrcode().equals("0000"));
            result.setMsg(validateResult.getDescription());
            InvoiceVO invoiceVO = new InvoiceVO();
            invoiceVO.setSerialNo(validateResult.getData().getSerialNo());
            result.setInvoiceVO(invoiceVO);
            return result;
        }
        CommonInvoiceService commonInvoiceService = InvoiceServiceFactory.getSingletonService(CommonInvoiceService.class);
        if (commonInvoiceService != null) {
            return commonInvoiceService.validateInvocieBySerialNo(request);
        }
        return new ValidateInvocieRespParam();
    }

    @Override
    public SaveVoucherResp saveVoucherToInvoiceCloud(SaveVoucherRequestParam request, Map<String, Object> option) {
        try {
            CommonInvoiceService commonInvoiceService = InvoiceServiceFactory.getSingletonService(CommonInvoiceService.class);
            if (commonInvoiceService != null) {
                InvoiceLogUtils.insertLog(InvoiceLogUtils.InvoiceOpType.WEB_REQUEST, request.getVoucherInfo().getVouchId(), ResManager.loadKDString((String)"\u901a\u77e5\u53d1\u7968\u4e91\u4fdd\u5b58\u51ed\u8bc1", (String)"ImportInvoice_5", (String)"fi-er-formplugin", (Object[])new Object[0]), JSON.toJSONString((Object)request));
                return commonInvoiceService.saveVoucher(request);
            }
            return new SaveVoucherResp("500", ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u672a\u52a0\u8f7d\u5230\u53ef\u7528\u670d\u52a1\u3002", (String)"ImportInvoice_13", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            List exceptionTraceList = Arrays.asList(e.getStackTrace()).stream().collect(Collectors.toList());
            InvoiceLogUtils.insertLog(InvoiceLogUtils.InvoiceOpType.WEB_REQUEST, request.getVoucherInfo().getVouchId(), ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u4fdd\u5b58\u51ed\u8bc1\u5f02\u5e38\u3002", (String)"ImportInvoice_6", (String)"fi-er-formplugin", (Object[])new Object[0]), exceptionTraceList.toString());
            return new SaveVoucherResp("500", ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u4fdd\u5b58\u51ed\u8bc1\u5f02\u5e38\u3002", (String)"ImportInvoice_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public DeleteVoucherResp deleteVoucherInInvoiceCloud(DeleteVoucherRequestParam request, Map<String, Object> option) {
        try {
            CommonInvoiceService commonInvoiceService = InvoiceServiceFactory.getSingletonService(CommonInvoiceService.class);
            if (commonInvoiceService != null) {
                InvoiceLogUtils.insertLog(InvoiceLogUtils.InvoiceOpType.WEB_REQUEST, request.getVouchId(), ResManager.loadKDString((String)"\u901a\u77e5\u53d1\u7968\u4e91\u5220\u9664\u51ed\u8bc1", (String)"ImportInvoice_7", (String)"fi-er-formplugin", (Object[])new Object[0]), JSON.toJSONString((Object)request));
                return commonInvoiceService.deleteVoucher(request);
            }
            return new DeleteVoucherResp("500", ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u672a\u52a0\u8f7d\u5230\u53ef\u7528\u670d\u52a1\u3002", (String)"ImportInvoice_13", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            List exceptionTraceList = Arrays.asList(e.getStackTrace()).stream().collect(Collectors.toList());
            InvoiceLogUtils.insertLog(InvoiceLogUtils.InvoiceOpType.WEB_REQUEST, request.getVouchId(), ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u5220\u9664\u51ed\u8bc1\u5f02\u5e38\u3002", (String)"ImportInvoice_8", (String)"fi-er-formplugin", (Object[])new Object[0]), exceptionTraceList.toString());
            return new DeleteVoucherResp("500", ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u5220\u9664\u51ed\u8bc1\u5f02\u5e38\u3002", (String)"ImportInvoice_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void showEditInvoicePageInPC(AbstractFormPlugin formPlugin, IDataModel model, String serialNo, CloseCallBack callBack, Map<String, Object> option) {
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put("actionType", "editInvoice");
        customParam.put("onPC", true);
        Long invoiceOrgId = this.getInvoiceOrgId(formPlugin, model);
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(invoiceOrgId);
        if (config == null) {
            logger.info("\u3010\u53d1\u7968\u4e91\u3011\u8be5\u516c\u53f8\u65e0\u53d1\u7968\u4e91\u914d\u7f6e, \u65e0\u6cd5\u7f16\u8f91\u53d1\u7968..");
            return;
        }
        String taxRegNum = config.getTaxRegnum();
        logger.info(String.format("\u3010\u53d1\u7968\u4e91\u3011\u8c03\u7528\u53d1\u7968\u4e91api\u4fee\u6539\u53d1\u7968\u4fe1\u606f:%1$s,\u4f01\u4e1a\u7a0e\u53f7\u4e3a:%2$s", serialNo, taxRegNum));
        EditInvoiceIframeReqParam editRequestParam = new EditInvoiceIframeReqParam();
        editRequestParam.setSerialNo(serialNo);
        editRequestParam.setTaxRegNum(taxRegNum);
        editRequestParam.setTicketParam(config.genTicketParam());
        editRequestParam.setOrgId(invoiceOrgId);
        customParam.put("invoiceOrgId", invoiceOrgId);
        customParam.put("serialNo", serialNo);
        customParam.put("editInvoiceIframeReqParam", JSON.toJSONString((Object)editRequestParam));
        FormModel formModel = new FormModel("er_invoicecloudpage_pc", "", "14", true, customParam);
        formModel.setWidth(800);
        formModel.setHeight(530);
        formModel.setShowTitle(false);
        ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)formPlugin, (CloseCallBack)callBack);
    }

    private Long getInvoiceOrgId(AbstractFormPlugin formPlugin, IDataModel model) {
        DynamicObject costCompanyDO = null;
        IDataEntityProperty invoiceOrgProp = model.getProperty("invoiceorgname");
        costCompanyDO = invoiceOrgProp != null ? (DynamicObject)model.getValue((String)model.getValue("invoiceorgname")) : (DynamicObject)model.getValue("costcompany");
        if (costCompanyDO == null) {
            formPlugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u5148\u586b\u5199\u8d39\u7528\u627f\u62c5\u516c\u53f8\u3002", (String)"InvoiceService_1", (String)"fi-er-business", (Object[])new Object[0]));
            return null;
        }
        return ErCommonUtils.getPk(costCompanyDO);
    }

    @Override
    public void showImportInvoicePageInMob(AbstractFormPlugin formPlugin, IDataModel model, CloseCallBack callBack, ImportInvoiceIframeUrlReqParam importRequestParam) {
        IframeParam iframParam;
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(importRequestParam.getInvoiceCompanyId());
        if (config == null) {
            logger.info(importRequestParam.getInvoiceCompanyId() + "\u7ec4\u7ec7\u672a\u542f\u7528\u53d1\u7968\u4e91\u3002");
            return;
        }
        if (this.showImportInvoicePageInMobTest(formPlugin, model, callBack, importRequestParam)) {
            return;
        }
        H5ImportInvoiceIframReqParam request = new H5ImportInvoiceIframReqParam();
        String bxdKey = importRequestParam.getEntityName() + "_" + importRequestParam.getBillId();
        request.setBillId(bxdKey);
        request.setTaxRegNum(config.getTaxRegnum());
        request.setCompanyId(config.getInvoiceOrgId());
        logger.info(String.format("\u3010\u53d1\u7968\u4e91\u3011\u5916\u90e8 \u79fb\u52a8\u7aef\u6253\u5f00\u53d1\u7968\u4e91\u754c\u9762,importRequestParam:%1$s,\u53c2\u6570request%2$s", JSON.toJSONString((Object)importRequestParam), request));
        try {
            InvoiceServiceForMob invoiceServiceForMob = InvoiceServiceFactory.getSingletonService(InvoiceServiceForMob.class);
            if (invoiceServiceForMob == null) {
                logger.info("\u3010\u53d1\u7968\u4e91\u3011\u5916\u90e8 \u79fb\u52a8\u7aef\u6253\u5f00\u53d1\u7968\u4e91\u754c\u9762\uff0c\u672a\u627e\u5230\u6784\u9020iframeParam\u7684\u670d\u52a1\u3002");
                return;
            }
            iframParam = invoiceServiceForMob.getImportInvoiceIframParam(request, formPlugin.getView());
        }
        catch (Exception e1) {
            OutsideInvoiceService.writeErrorLog(ResManager.loadKDString((String)"\u53d1\u7968\u4e91", (String)"InvoiceService_4", (String)"fi-er-business", (Object[])new Object[0]), e1);
            formPlugin.getView().showErrorNotification(e1.getMessage());
            return;
        }
        IFormView view = formPlugin.getControl("htmlap").getView();
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        IFrameMessage msg = new IFrameMessage("openInvoiceCloudPage", iframParam.getUrl(), (Object)Er.objToJson(iframParam.getContent()));
        proxy.invokeControlMethod("htmlap", "postMessage", new Object[]{msg});
    }

    @Override
    public void showInvoiceListInMob(AbstractFormPlugin formPlugin, IDataModel model, Collection<String> serialNos, InvoiceCloudCfgBO config, Map<String, Object> otherParam) {
        this.baseShowInvoiceListInMob(formPlugin.getView(), model, serialNos, config, otherParam);
    }

    @Override
    public void baseShowInvoiceListInMob(IFormView billview, IDataModel model, Collection<String> serialNos, InvoiceCloudCfgBO config, Map<String, Object> otherParam) {
        if (serialNos == null) {
            serialNos = Sets.newHashSet();
        }
        if (config == null) {
            logger.info("\u3010\u53d1\u7968\u4e91\u3011\u7ec4\u7ec7\u672a\u914d\u7f6e\u53d1\u7968\u4e91");
            return;
        }
        Set<String> serialNosWithoutEmpty = serialNos.stream().filter(s -> StringUtils.isNotBlank((CharSequence)s)).collect(Collectors.toSet());
        DynamicObject bill = model.getDataEntity(true);
        if (ErStdConfig.isShowInvoiceInH5()) {
            boolean isSaveDatabase;
            String entityName = bill.getDataEntityType().getName();
            boolean showAllInvoice = false;
            if (model.getDataEntityType().getProperty("invoiceentry") != null) {
                DynamicObjectCollection invoiceentry = model.getDataEntity(true).getDynamicObjectCollection("invoiceentry");
                Set allSerial = invoiceentry.stream().map(v -> v.getString("serialno")).filter(v -> StringUtils.isNotBlank((CharSequence)v)).collect(Collectors.toSet());
                showAllInvoice = allSerial.size() == serialNosWithoutEmpty.size();
            }
            try {
                isSaveDatabase = QueryServiceHelper.exists((String)entityName, (Object)model.getDataEntity().getPkValue());
            }
            catch (Exception e) {
                isSaveDatabase = false;
            }
            boolean onlyAttach = model.getDataEntityType().getProperty("invoiceentry") == null;
            logger.info("\u3010\u53d1\u7968\u4e91\u3011\u5916\u90e8\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u67e5\u770b\u53d1\u7968 serialNos:" + serialNos + ", showAllInvoice:" + showAllInvoice + ", isSaveDatabase:" + isSaveDatabase + ", onlyAttach:" + onlyAttach);
            if (!(showAllInvoice && !ErEntityTypeUtils.isTripRecordBill(entityName) && !ErEntityTypeUtils.isExpenseRecordBill(entityName) && isSaveDatabase || onlyAttach)) {
                this.showAllInvoiceListInMobH5(config, serialNosWithoutEmpty, billview, bill);
            } else {
                this.showAllInvoiceAndAttachmentListInMobH5(config, serialNosWithoutEmpty, billview, model);
            }
        } else {
            this.showAllInvoiceListInMiniProgram(config, serialNosWithoutEmpty, billview, bill);
        }
    }

    private void showAllInvoiceAndAttachmentListInMobH5(InvoiceCloudCfgBO config, Set<String> serialNos, IFormView view, IDataModel model) {
        IframeParam iframParam;
        H5ShowAllInvoiceIframParam request = new H5ShowAllInvoiceIframParam();
        DynamicObject dataEntity = model.getDataEntity(true);
        request.setBillId(APIHelper.getBillNoCachedInCloud(dataEntity));
        String billNo = "empty";
        if (dataEntity.getDataEntityType().getProperties().get((Object)"billno") != null) {
            billNo = dataEntity.getString("billno");
        }
        request.setBillNumber(billNo);
        request.setTaxRegNum(config.getTaxRegnum());
        request.setSerialNos(Lists.newArrayList(serialNos));
        request.setOrgId(config.getInvoiceOrgId());
        try {
            InvoiceServiceForMob invoiceServiceForMob = InvoiceServiceFactory.getSingletonService(InvoiceServiceForMob.class);
            if (invoiceServiceForMob == null) {
                logger.info("\u3010\u53d1\u7968\u4e91\u3011\u5916\u90e8 \u79fb\u52a8\u7aef\u6253\u5f00\u53d1\u7968\u4e91\u53d1\u7968\u5217\u8868\u754c\u9762\uff0c\u672a\u627e\u5230\u6784\u9020iframParam\u7684\u670d\u52a1\u3002");
                return;
            }
            iframParam = invoiceServiceForMob.getH5ShowAllInvoiceIframParam(request, view);
        }
        catch (Exception e) {
            OutsideInvoiceService.writeErrorLog(ResManager.loadKDString((String)"\u53d1\u7968\u4e91", (String)"InvoiceService_4", (String)"fi-er-business", (Object[])new Object[0]), e);
            view.showErrorNotification(e.getMessage());
            return;
        }
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("er_invoicecloudpage_m");
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCustomParam("url", (Object)iframParam.getUrl());
        showParameter.setHasRight(true);
        view.showForm((FormShowParameter)showParameter);
    }

    private void showAllInvoiceListInMobH5(InvoiceCloudCfgBO config, Set<String> serialNos, IFormView view, DynamicObject dataEntity) {
        IframeParam iframParam;
        H5ShowInvoiceIframReqParam request = new H5ShowInvoiceIframReqParam();
        request.setBillId(APIHelper.getBillNoCachedInCloud(dataEntity));
        String billNo = "empty";
        if (dataEntity.getDataEntityType().getProperties().get((Object)"billno") != null) {
            billNo = dataEntity.getString("billno");
        }
        request.setBillNumber(billNo);
        request.setTaxRegNum(config.getTaxRegnum());
        request.setSerialNos(Lists.newArrayList(serialNos));
        request.setOrgId(config.getInvoiceOrgId());
        try {
            InvoiceServiceForMob invoiceServiceForMob = InvoiceServiceFactory.getSingletonService(InvoiceServiceForMob.class);
            if (invoiceServiceForMob == null) {
                logger.info("\u3010\u53d1\u7968\u4e91\u3011\u5916\u90e8 \u79fb\u52a8\u7aef\u6253\u5f00\u53d1\u7968\u4e91\u754c\u9762\uff0c\u672a\u627e\u5230\u6784\u9020iframeParam\u7684\u670d\u52a1\u3002");
                return;
            }
            iframParam = invoiceServiceForMob.getH5ShowInvoiceIframParam(request, view);
        }
        catch (Exception e) {
            view.showErrorNotification(e.getMessage());
            OutsideInvoiceService.writeErrorLog(ResManager.loadKDString((String)"\u53d1\u7968\u4e91", (String)"InvoiceService_4", (String)"fi-er-business", (Object[])new Object[0]), e);
            return;
        }
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("er_invoicecloudpage_m");
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCustomParam("url", (Object)iframParam.getUrl());
        showParameter.setHasRight(true);
        view.showForm((FormShowParameter)showParameter);
    }

    private void showAllInvoiceListInMiniProgram(InvoiceCloudCfgBO config, Set<String> serialNos, IFormView view, DynamicObject bill) {
        IframeParam iframParam;
        WeChatMiniProgramShowInvoiceIframeReqParam request = new WeChatMiniProgramShowInvoiceIframeReqParam();
        request.setSerialNos(Lists.newArrayList(serialNos));
        request.setTaxRegNum(config.getTaxRegnum());
        request.setOrgId(config.getInvoiceOrgId());
        request.setBillId(APIHelper.getBillNoCachedInCloud(bill));
        request.setBillNumber(bill.getDataEntityType().getProperties().get((Object)"billno") != null ? bill.getString("billno") : "no");
        try {
            InvoiceServiceForMob invoiceServiceForMob = InvoiceServiceFactory.getSingletonService(InvoiceServiceForMob.class);
            if (invoiceServiceForMob == null) {
                logger.info("\u3010\u53d1\u7968\u4e91\u3011\u5916\u90e8 \u79fb\u52a8\u7aef\u6253\u5f00\u53d1\u7968\u4e91\u754c\u9762\uff0c\u672a\u627e\u5230\u6784\u9020iframeParam\u7684\u670d\u52a1\u3002");
                return;
            }
            iframParam = invoiceServiceForMob.getWeChatMiniProgramShowInvoiceIframeParam(request, view);
        }
        catch (Exception e) {
            OutsideInvoiceService.writeErrorLog(ResManager.loadKDString((String)"\u53d1\u7968\u4e91", (String)"InvoiceService_4", (String)"fi-er-business", (Object[])new Object[0]), e);
            view.showErrorNotification(e.getMessage());
            return;
        }
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        IFrameMessage msg = new IFrameMessage("openInvoiceCloudPage", iframParam.getUrl(), (Object)Er.objToJson(iframParam.getContent()));
        proxy.invokeControlMethod("htmlap", "postMessage", new Object[]{msg});
    }

    @Override
    public List<InvoiceVO> queryInvoicesBySerialNos(AbstractFormPlugin formPlugin, Collection<String> serialNos, DynamicObject costCompany) {
        List<InvoiceVO> invoiceVOs = Collections.emptyList();
        String serialNoString = String.join((CharSequence)",", serialNos);
        QueryInvoiceDetailBO queryInvoiceDetailBO = QueryInvoiceDetailBO.buildQueryInvoiceDetailBO(costCompany, serialNoString);
        try {
            invoiceVOs = APIHelper.queryInvoiceDetailBySerialNo(queryInvoiceDetailBO);
        }
        catch (InvoiceCloudException e) {
            formPlugin.getView().showErrorNotification(e.getMessage());
            OutsideInvoiceService.writeErrorLog("", (Exception)((Object)e));
        }
        catch (Exception e) {
            OutsideInvoiceService.writeErrorLog("", e);
            throw new KDBizException(ThrowableHelper.toString((Exception)e));
        }
        return invoiceVOs;
    }

    @Override
    public ValidateInvocieRespParam recognitionCheckInvoice(RecognitionCheckReqParam reqParam) {
        return null;
    }

    @Override
    public EditInvoiceResp editInvoice(List<EditInvoiceReqParam> reqParams) {
        return null;
    }

    private static void writeErrorLog(String msg, Exception e) {
        logger.error(msg, (Throwable)e);
    }
}

