/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.expand.ErExpandServiceFacade;
import kd.fi.er.business.invoicecloud.InvoiceService;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.kingdee.EditInvoiceTask;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceStatusEnum;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.kingdee.XhInvoiceServiceHelper;
import kd.fi.er.business.invoicecloud.model.InvoiceData;
import kd.fi.er.business.invoicecloud.model.UpdateInvoiceStatusParam;
import kd.fi.er.business.invoicecloud.model.XHInvoiceData;
import kd.fi.er.business.invoicecloud.model.XHShowDelAttachmentParam;
import kd.fi.er.business.invoicecloud.model.XHShowInvoiceParam;
import kd.fi.er.business.invoicecloud.model.XHUpdateInvoiceStatusParam;
import kd.fi.er.business.invoicecloud.provider.param.req.DeleteInvoiceReqParam;
import kd.fi.er.business.invoicecloud.provider.param.req.DeleteVoucherRequestParam;
import kd.fi.er.business.invoicecloud.provider.param.req.EditInvoiceReqParam;
import kd.fi.er.business.invoicecloud.provider.param.req.ImportInvoiceIframeUrlReqParam;
import kd.fi.er.business.invoicecloud.provider.param.req.RecognitionCheckReqParam;
import kd.fi.er.business.invoicecloud.provider.param.req.SaveVoucherRequestParam;
import kd.fi.er.business.invoicecloud.provider.param.req.ValidateInvocieReqParam;
import kd.fi.er.business.invoicecloud.provider.param.resp.DeleteInvoiceRespParam;
import kd.fi.er.business.invoicecloud.provider.param.resp.DeleteVoucherResp;
import kd.fi.er.business.invoicecloud.provider.param.resp.EditInvoiceResp;
import kd.fi.er.business.invoicecloud.provider.param.resp.SaveVoucherResp;
import kd.fi.er.business.invoicecloud.provider.param.resp.UpdateInvoiceStatusRespParam;
import kd.fi.er.business.invoicecloud.provider.param.resp.ValidateInvocieRespParam;
import kd.fi.er.business.invoicecloud.util.BillingPoolUtils;
import kd.fi.er.business.invoicecloud.v2.InvoiceFrom;
import kd.fi.er.business.log.InvoiceLogUtils;
import kd.fi.er.business.servicehelper.InvoiceServiceHelper;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.exception.invoice.InvoiceCloudException;
import kd.fi.er.common.model.invoice.AttachVo;
import kd.fi.er.common.model.invoice.InvoiceDetailRetrunVO;
import kd.fi.er.common.model.invoice.InvoiceVO;
import kd.fi.er.common.model.invoice.xh.AttachData;
import kd.fi.er.common.model.invoice.xh.QueryInvoiceDetailParam;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class XhInvoiceService
implements InvoiceService {
    private static Log logger = LogFactory.getLog(XhInvoiceService.class);
    private static volatile XhInvoiceService xhInvoiceService;

    private XhInvoiceService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XhInvoiceService getInvoiceService() {
        if (xhInvoiceService != null) return xhInvoiceService;
        Class<XhInvoiceService> clazz = XhInvoiceService.class;
        synchronized (XhInvoiceService.class) {
            if (xhInvoiceService != null) return xhInvoiceService;
            xhInvoiceService = new XhInvoiceService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return xhInvoiceService;
        }
    }

    @Override
    public void showDeleteAttachPageInPC(AbstractFormPlugin formPlugin, IDataModel model, CloseCallBack callBack, ImportInvoiceIframeUrlReqParam importRequestParam) {
        this.baseShowDeleteAttachmentInPc(callBack, importRequestParam, formPlugin.getView());
    }

    @Override
    public void baseShowDeleteAttachmentInPc(CloseCallBack callBack, ImportInvoiceIframeUrlReqParam importRequestParam, IFormView billview) {
        DynamicObject dataEntity = billview.getModel().getDataEntity();
        String billId = dataEntity.getPkValue().toString();
        String entityId = dataEntity.getDataEntityType().getName();
        if (StringUtils.isEmpty((CharSequence)billId)) {
            billview.showErrorNotification(ResManager.loadKDString((String)"\u5355\u636eId\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ExpenseEntryHyperlinkEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("rim_fpzs_attach_delete");
        parameter.setParentFormId(billview.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("billId", (Object)billId);
        parameter.setCustomParam("entityId", (Object)entityId);
        String serialno = billview.getPageCache().get("cache_serialno_bydelete_invoice");
        if (StringUtils.isNotBlank((CharSequence)serialno)) {
            Set tempDeleteInvoice = (Set)SerializationUtils.fromJsonString((String)serialno, Set.class);
            if (dataEntity.getDataEntityType().getProperties().containsKey((Object)"invoiceattachinfo")) {
                DynamicObjectCollection attachEntries = dataEntity.getDynamicObjectCollection("invoiceattachinfo");
                Set serialNosFromEntry = attachEntries.stream().map(e -> e.getString("attachserialno")).collect(Collectors.toSet());
                tempDeleteInvoice.removeAll(serialNosFromEntry);
            }
            logger.info("\u6253\u5f00\u5220\u9664\u9644\u4ef6\u9875\u9762\u5df2\u4e34\u65f6\u5220\u9664\u7684\u9644\u4ef6\u5bf9\u5e94\u7684\u53d1\u7968\u6d41\u6c34\u53f7\uff1a" + tempDeleteInvoice);
            parameter.setCustomParam("delSerialNos", (Object)tempDeleteInvoice);
        }
        parameter.setCloseCallBack(callBack);
        billview.showForm(parameter);
    }

    @Override
    public void showDeleteAttachPageInMob(AbstractFormPlugin formPlugin, IDataModel model, CloseCallBack callBack, ImportInvoiceIframeUrlReqParam importRequestParam) {
        this.baseShowDeleteAttachmentInMob(callBack, importRequestParam, formPlugin.getView());
    }

    @Override
    public void baseShowDeleteAttachmentInMob(CloseCallBack callBack, ImportInvoiceIframeUrlReqParam importRequestParam, IFormView view) {
        IDataModel model = view.getModel();
        DynamicObject dataEntity = view.getModel().getDataEntity();
        String billId = dataEntity.getPkValue().toString();
        String entityId = dataEntity.getDataEntityType().getName();
        if (StringUtils.isEmpty((CharSequence)billId)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5355\u636eId\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ExpenseEntryHyperlinkEdit_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        String billStatus = (String)model.getValue("billstatus");
        String formId = StringUtils.equalsIgnoreCase((CharSequence)billStatus, (CharSequence)"A") || StringUtils.equalsIgnoreCase((CharSequence)billStatus, (CharSequence)"D") ? "rim_h5_attach_delete" : "rim_h5_attach_view";
        XHShowDelAttachmentParam showDelAttachmentParam = new XHShowDelAttachmentParam();
        showDelAttachmentParam.setFormView(view);
        showDelAttachmentParam.setFormId(formId);
        showDelAttachmentParam.setParentFormId(view.getFormShowParameter().getParentFormId());
        showDelAttachmentParam.setStatus(OperationStatus.VIEW);
        showDelAttachmentParam.setShowType(ShowType.Floating);
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put("billId", billId);
        customParam.put("entityId", entityId);
        showDelAttachmentParam.setCustomParam(customParam);
        showDelAttachmentParam.setCallBack(callBack);
        showDelAttachmentParam.setCaption(ResManager.loadKDString((String)"\u67e5\u770b\u53d1\u7968\u4e91\u9644\u4ef6", (String)"InvoiceService_3", (String)"fi-er-business", (Object[])new Object[0]));
        XhInvoiceServiceHelper.showDeleteAttachmentInMob(showDelAttachmentParam);
    }

    @Override
    public void showImportInvoicePageInPC(AbstractFormPlugin formPlugin, IDataModel model, CloseCallBack callBack, ImportInvoiceIframeUrlReqParam importRequestParam) {
        this.showImportInvoice(formPlugin, model, callBack, importRequestParam, "rim_fpzs_main", ShowType.Modal);
    }

    private void showImportInvoice(AbstractFormPlugin formPlugin, IDataModel model, CloseCallBack callBack, ImportInvoiceIframeUrlReqParam importRequestParam, String formId, ShowType showType) {
        if (formId.equals("rim_mobile_index") ? this.showImportInvoicePageInMobTest(formPlugin, model, callBack, importRequestParam) : this.showImportInvoicePageInPCTest(formPlugin, model, callBack, importRequestParam)) {
            return;
        }
        logger.info("\u3010\u53d1\u7968\u4e91\u3011\u661f\u701a\u53d1\u7968\u4e91\u5bfc\u5165\u53d1\u7968\uff0cimportRequestParam: {}", (Object)JSON.toJSONString((Object)importRequestParam));
        HashMap customParam = Maps.newHashMapWithExpectedSize((int)16);
        String entityId = importRequestParam.getEntityName();
        if (StringUtils.isBlank((CharSequence)entityId)) {
            entityId = formPlugin.getView().getEntityId();
        }
        String billType = "";
        Object invokeExtService = ErExpandServiceFacade.get().invokeExtService("ext.service.er.getBillTypeCode", "extendHandle", new Object[]{model}, new Class[]{IDataModel.class});
        if (invokeExtService != null && !"-1".equals(invokeExtService)) {
            billType = (String)invokeExtService;
        }
        if ("".equals(billType) || "-1".equals(billType)) {
            billType = entityId;
        }
        customParam.put("billType", billType);
        customParam.put("billNo", model.getValue("billno"));
        customParam.put("billId", model.getDataEntity().getPkValue().toString());
        customParam.put("entityId", entityId);
        customParam.put("viewPage", entityId);
        customParam.put("orgId", importRequestParam.getInvoiceCompanyId());
        customParam.put("resource", "4");
        Long invoiceCompanyId = importRequestParam.getInvoiceCompanyId();
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(invoiceCompanyId);
        if (config == null) {
            formPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8d39\u7528\u627f\u62c5\u516c\u53f8\u672a\u542f\u7528\u53d1\u7968\u4e91\uff0c\u8bf7\u5148\u542f\u7528\u3002", (String)"InvoiceService_0", (String)"fi-er-business", (Object[])new Object[0]));
            return;
        }
        String taxRegnum = config.getTaxRegnum();
        String companyName = config.getFirmname();
        List taxNoList = Arrays.stream(taxRegnum.split("=")).collect(Collectors.toList());
        List companyNameList = Arrays.stream(companyName.split("=")).collect(Collectors.toList());
        int companyInfoCount = taxNoList.size() < companyNameList.size() ? taxNoList.size() : companyNameList.size();
        ArrayList companyInfos = Lists.newArrayListWithExpectedSize((int)companyInfoCount);
        for (int i = 0; i < companyInfoCount; ++i) {
            HashMap companyInfo = Maps.newHashMapWithExpectedSize((int)2);
            companyInfo.put("taxNo", taxNoList.get(i));
            companyInfo.put("name", companyNameList.get(i));
            companyInfos.add(companyInfo);
        }
        customParam.put("companyInfo", companyInfos);
        FormShowParameter param = new FormShowParameter();
        logger.info("\u3010\u53d1\u7968\u4e91\u3011\u661f\u701a\u53d1\u7968\u4e91\u5bfc\u5165\u53d1\u7968\uff0ccustomParam: {}", (Object)JSON.toJSONString((Object)customParam));
        param.setCustomParams((Map)customParam);
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        param.setCloseCallBack(callBack);
        formPlugin.getView().showForm(param);
    }

    @Override
    public void showInvoiceListInPC(AbstractFormPlugin formPlugin, IDataModel model, Collection<String> serialNos, InvoiceCloudCfgBO config, Map<String, Object> otherParam) {
        this.baseShowInvoiceListInPc(formPlugin.getView(), model, serialNos, config, otherParam);
    }

    @Override
    public void baseShowInvoiceListInPc(IFormView view, IDataModel model, Collection<String> serialNos, InvoiceCloudCfgBO config, Map<String, Object> otherParam) {
        if (config == null) {
            logger.info("\u3010\u53d1\u7968\u4e91\u3011\u7ec4\u7ec7\u672a\u914d\u7f6e\u53d1\u7968\u4e91");
            return;
        }
        Map<String, Object> customParams = InvoiceServiceHelper.buildXhShowInvoiceParameter(model, model.getDataEntity(), serialNos, config, otherParam);
        XHShowInvoiceParam showInvoiceParam = new XHShowInvoiceParam();
        showInvoiceParam.setFormId("rim_view_invoice");
        showInvoiceParam.setFormView(view);
        showInvoiceParam.setShowType(ShowType.NewWindow);
        showInvoiceParam.setCustomParams(customParams);
        XhInvoiceServiceHelper.showInvoiceList(showInvoiceParam);
    }

    @Override
    public void baseShowInvoiceListInMob(IFormView view, IDataModel model, Collection<String> serialNos, InvoiceCloudCfgBO config, Map<String, Object> otherParam) {
        if (config == null) {
            logger.info("\u3010\u53d1\u7968\u4e91\u3011\u7ec4\u7ec7\u672a\u914d\u7f6e\u53d1\u7968\u4e91");
            return;
        }
        Map<String, Object> customParams = InvoiceServiceHelper.buildXhShowInvoiceParameter(model, model.getDataEntity(), serialNos, config, otherParam);
        XHShowInvoiceParam showInvoiceParam = new XHShowInvoiceParam();
        showInvoiceParam.setFormId("rim_invoice_list_mobile");
        showInvoiceParam.setFormView(view);
        showInvoiceParam.setShowType(ShowType.Floating);
        showInvoiceParam.setCustomParams(customParams);
        XhInvoiceServiceHelper.showInvoiceList(showInvoiceParam);
    }

    @Override
    public UpdateInvoiceStatusRespParam updateInvoiceStatus(DynamicObject dataEntity, UpdateInvoiceStatusParam param) throws Exception {
        String status = param.getStatus();
        if (StringUtils.equals((CharSequence)status, (CharSequence)String.valueOf(InvoiceStatusEnum.save.getValue()))) {
            UpdateInvoiceStatusRespParam result = new UpdateInvoiceStatusRespParam();
            result.setErrcode("0000");
            return result;
        }
        boolean isTripReimburseBill = ErEntityTypeUtils.isTripReimburseBill(param.getEntityId());
        XHUpdateInvoiceStatusParam xhUpdateInvoiceStatusParam = new XHUpdateInvoiceStatusParam();
        xhUpdateInvoiceStatusParam.setAppId(param.getAppId());
        xhUpdateInvoiceStatusParam.setBillId(param.getBillId());
        xhUpdateInvoiceStatusParam.setBillNo(param.getBillNo());
        xhUpdateInvoiceStatusParam.setBillType(param.getBillType());
        xhUpdateInvoiceStatusParam.setBillUser(param.getBillUser());
        xhUpdateInvoiceStatusParam.setCompanyInfo(param.getCompanyInfo());
        xhUpdateInvoiceStatusParam.setCoverData(param.getCoverData());
        xhUpdateInvoiceStatusParam.setEntityId(APIHelper.getEntityNameSSc(param.getEntityId()));
        ArrayList xhInvoiceDatas = Lists.newArrayListWithExpectedSize((int)param.getInvoiceData().size());
        boolean paramValue = Boolean.TRUE;
        if (ErEntityTypeUtils.isCheckingpayBill(param.getEntityId())) {
            paramValue = TripSyncConfigUtil.getBoolean("Paper_invoice_matching", Boolean.TRUE);
        }
        List<String> invoiceType = Arrays.asList("9", "10");
        for (InvoiceData invoiceData : param.getInvoiceData()) {
            XHInvoiceData xhInvoiceData = new XHInvoiceData();
            xhInvoiceData.setSerialNo((String)ObjectUtils.defaultIfNull((Object)invoiceData.getSerialNo(), (Object)""));
            xhInvoiceData.setDeductionFlag((Boolean)ObjectUtils.defaultIfNull((Object)invoiceData.getIsOffset(), (Object)Boolean.FALSE) != false ? "1" : "0");
            xhInvoiceData.setOutputAmount((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceData.getOutAount(), (Object)BigDecimal.ZERO));
            xhInvoiceData.setDeductionTaxAmount((BigDecimal)ObjectUtils.defaultIfNull((Object)invoiceData.getOffsetAmount(), (Object)BigDecimal.ZERO));
            xhInvoiceData.setRemark((String)ObjectUtils.defaultIfNull((Object)invoiceData.getInOutReson(), (Object)""));
            xhInvoiceData.setInvoiceOrgId(invoiceData.getInvoiceOrgId());
            xhInvoiceData.setNotDeductibleType(invoiceData.getNoDeductionReason());
            if (isTripReimburseBill && InvoiceFrom.TripBusiness.getValue().equals(invoiceData.getInvoiceFrom())) {
                xhInvoiceData.setInvoiceResource("1");
            }
            if (!paramValue && invoiceType.contains(invoiceData.getInvoiceType())) {
                xhInvoiceData.setInvoiceResource("1");
            }
            xhInvoiceDatas.add(xhInvoiceData);
        }
        xhUpdateInvoiceStatusParam.setInvoiceData(xhInvoiceDatas);
        xhUpdateInvoiceStatusParam.setOrgId(param.getOrgId());
        xhUpdateInvoiceStatusParam.setResource(param.getResource());
        xhUpdateInvoiceStatusParam.setStatus(param.getStatus());
        xhUpdateInvoiceStatusParam.setVerifyFlag(param.getVerifyFlag());
        xhUpdateInvoiceStatusParam.setViewPage(param.getViewPage());
        String attachmentFids = param.getAttachmentFids();
        if (StringUtils.isNotEmpty((CharSequence)attachmentFids)) {
            List attachmentNos = Arrays.stream(attachmentFids.split(",")).filter(e -> StringUtils.isNotBlank((CharSequence)e)).collect(Collectors.toList());
            ArrayList attachDataList = Lists.newArrayListWithExpectedSize((int)attachmentNos.size());
            for (String attachNo : attachmentNos) {
                AttachData attachData = new AttachData();
                attachData.setAttachNo(attachNo);
                attachDataList.add(attachData);
            }
            xhUpdateInvoiceStatusParam.setAttachData(attachDataList);
        }
        xhUpdateInvoiceStatusParam.setUpdateAttachRelation("1");
        xhUpdateInvoiceStatusParam.setIsAllowRepeat(BillingPoolUtils.isMultReim(dataEntity));
        return XhInvoiceServiceHelper.updateInvoiceStatus(xhUpdateInvoiceStatusParam);
    }

    @Override
    public DeleteInvoiceRespParam deleteRelationBetweenInvoiceAndBill(DynamicObject dataEntity, Long invoiceOrgId, Map<String, Object> option) throws InvoiceCloudException {
        return XhInvoiceServiceHelper.deleteInvoice(dataEntity.getDataEntityType().getName(), (Long)dataEntity.getPkValue(), null);
    }

    @Override
    @Deprecated
    public DeleteInvoiceRespParam deleteRelationBetweenInvoiceAndBill(DeleteInvoiceReqParam request, DynamicObject dataEntity, Long invoiceOrgId, Map<String, Object> option) throws InvoiceCloudException {
        return this.deleteRelationBetweenInvoiceAndBill(dataEntity, invoiceOrgId, option);
    }

    @Override
    public ValidateInvocieRespParam validateInvoice(ValidateInvocieReqParam request, Map<String, Object> option) throws InvoiceCloudException {
        return XhInvoiceServiceHelper.validateInvoice(request, option);
    }

    @Override
    public SaveVoucherResp saveVoucherToInvoiceCloud(SaveVoucherRequestParam request, Map<String, Object> option) {
        try {
            InvoiceLogUtils.insertLog(InvoiceLogUtils.InvoiceOpType.WEB_REQUEST, request.getVoucherInfo().getVouchId(), ResManager.loadKDString((String)"\u901a\u77e5\u53d1\u7968\u4e91\u4fdd\u5b58\u51ed\u8bc1", (String)"ImportInvoice_5", (String)"fi-er-formplugin", (Object[])new Object[0]), JSON.toJSONString((Object)request));
            return XhInvoiceServiceHelper.saveVoucherToInvoiceCloud(request, option);
        }
        catch (Exception e) {
            List exceptionTraceList = Arrays.asList(e.getStackTrace()).stream().collect(Collectors.toList());
            InvoiceLogUtils.insertLog(InvoiceLogUtils.InvoiceOpType.WEB_REQUEST, request.getVoucherInfo().getVouchId(), ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u4fdd\u5b58\u51ed\u8bc1\u5f02\u5e38\u3002", (String)"ImportInvoice_6", (String)"fi-er-formplugin", (Object[])new Object[0]), exceptionTraceList.toString());
            return new SaveVoucherResp("500", ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u4fdd\u5b58\u51ed\u8bc1\u5f02\u5e38\u3002", (String)"ImportInvoice_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public DeleteVoucherResp deleteVoucherInInvoiceCloud(DeleteVoucherRequestParam request, Map<String, Object> option) {
        try {
            InvoiceLogUtils.insertLog(InvoiceLogUtils.InvoiceOpType.WEB_REQUEST, request.getVouchId(), ResManager.loadKDString((String)"\u901a\u77e5\u53d1\u7968\u4e91\u5220\u9664\u51ed\u8bc1", (String)"ImportInvoice_7", (String)"fi-er-formplugin", (Object[])new Object[0]), JSON.toJSONString((Object)request));
            return XhInvoiceServiceHelper.deleteVoucherInInvoiceCloud(request, option);
        }
        catch (Exception e) {
            List exceptionTraceList = Arrays.asList(e.getStackTrace()).stream().collect(Collectors.toList());
            InvoiceLogUtils.insertLog(InvoiceLogUtils.InvoiceOpType.WEB_REQUEST, request.getVouchId(), ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u5220\u9664\u51ed\u8bc1\u5f02\u5e38\u3002", (String)"ImportInvoice_8", (String)"fi-er-formplugin", (Object[])new Object[0]), exceptionTraceList.toString());
            return new DeleteVoucherResp("500", ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u5220\u9664\u51ed\u8bc1\u5f02\u5e38\u3002", (String)"ImportInvoice_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void showEditInvoicePageInPC(AbstractFormPlugin formPlugin, IDataModel model, String serialNo, CloseCallBack callBack, Map<String, Object> option) {
        FormShowParameter param = new FormShowParameter();
        HashMap<String, String> customParams = new HashMap<String, String>(8);
        formPlugin.getView().getPageCache().put("oldSerialNo", serialNo);
        customParams.put("serialNo", serialNo);
        customParams.put("resource", "4");
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("rim_inv_collect_edit");
        logger.info("\u3010\u53d1\u7968\u4e91\u3011\u6253\u5f00\u7f16\u8f91\u53d1\u7968\u7684\u754c\u9762\uff0c\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString(customParams));
        param.setCloseCallBack(callBack);
        formPlugin.getView().showForm(param);
    }

    @Override
    public void showImportInvoicePageInMob(AbstractFormPlugin formPlugin, IDataModel model, CloseCallBack callBack, ImportInvoiceIframeUrlReqParam importRequestParam) {
        this.showImportInvoice(formPlugin, model, callBack, importRequestParam, "rim_mobile_index", ShowType.Floating);
    }

    @Override
    public void showInvoiceListInMob(AbstractFormPlugin formPlugin, IDataModel model, Collection<String> serialNos, InvoiceCloudCfgBO config, Map<String, Object> otherParam) {
        this.baseShowInvoiceListInMob(formPlugin.getView(), model, serialNos, config, otherParam);
    }

    @Override
    public List<InvoiceVO> queryInvoicesBySerialNos(AbstractFormPlugin formPlugin, Collection<String> serialNos, DynamicObject costCompany) {
        List<InvoiceVO> invoiceVOs = Collections.emptyList();
        QueryInvoiceDetailParam param = InvoiceUtils.buildQueryInvoiceDetailParam(formPlugin, costCompany, serialNos);
        try {
            if (param != null) {
                invoiceVOs = XhInvoiceServiceHelper.queryInvoiceDetail(param, null);
            }
        }
        catch (Exception e) {
            XhInvoiceService.writeErrorLog("", e);
            formPlugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u8fd4\u56de\u6570\u636e\u7ed3\u6784\u6709\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractImportInvoicePlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        return invoiceVOs;
    }

    @Override
    public List<AttachVo> queryAttachments(AbstractFormPlugin formPlugin) {
        QueryInvoiceDetailParam param = new QueryInvoiceDetailParam();
        DynamicObject dataEntity = formPlugin.getView().getModel().getDataEntity();
        String entityName = dataEntity.getDataEntityType().getName();
        param.setEntityId(entityName);
        param.setBillId(String.valueOf(dataEntity.getPkValue()));
        List<Object> attachVos = new ArrayList<AttachVo>(1);
        try {
            InvoiceDetailRetrunVO returnVo = XhInvoiceServiceHelper.queryInvoiceAndFile(param, null);
            if (returnVo.getAttachment() != null) {
                attachVos = returnVo.getAttachment().stream().map(e -> e.toAttachVo_1()).collect(Collectors.toList());
            }
        }
        catch (Exception e2) {
            XhInvoiceService.writeErrorLog("", e2);
            formPlugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u8fd4\u56de\u6570\u636e\u7ed3\u6784\u6709\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractImportInvoicePlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        return attachVos;
    }

    @Override
    public ValidateInvocieRespParam recognitionCheckInvoice(RecognitionCheckReqParam reqParam) {
        return XhInvoiceServiceHelper.recognitionCheckInvoice(reqParam);
    }

    @Override
    public EditInvoiceResp editInvoice(List<EditInvoiceReqParam> reqParams) {
        for (EditInvoiceReqParam reqParam : reqParams) {
            EditInvoiceTask editInvoiceTask = new EditInvoiceTask(reqParam);
            ThreadService.execute((Runnable)editInvoiceTask, (TaskType)TaskType.ER_INVOICE_TASK, (RequestContext)RequestContext.get());
        }
        return new EditInvoiceResp();
    }

    private static void writeErrorLog(String msg, Exception e) {
        logger.error(msg, (Throwable)e);
    }
}

