/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.asynclog;

import com.alibaba.fastjson.JSON;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.invoicecloud.asynclog.InvoiceCloudOperEnum;
import kd.fi.er.business.invoicecloud.kingdee.action.AsyncAction;
import kd.fi.er.business.invoicecloud.provider.param.req.BillOperationInfo;
import kd.fi.er.business.invoicecloud.provider.param.std.UpdateInvoiceStatusStdResqParam;
import kd.fi.er.common.utils.ThrowableHelper;
import org.apache.commons.lang3.StringUtils;

public class AsyncLogUtil {
    private static final String ALGO = AsyncLogUtil.class.getName();
    private static final String asyncLogMetadataNumber = "er_invoiceasynclog";

    public static void writeAsyncLog(BillOperationInfo billOperationInfo, Date reqTime, InvoiceCloudOperEnum invoiceCloudOperEnum, String stdReqParamStr, String respStr, boolean reqStatus) {
        if (billOperationInfo == null) {
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)asyncLogMetadataNumber);
        DynamicObject logObj = (DynamicObject)dataEntityType.createInstance();
        logObj.set("reqtime", (Object)reqTime);
        logObj.set("reqstatus", (Object)(reqStatus ? "1" : "0"));
        logObj.set("xhtraceid", (Object)RequestContext.get().getTraceId());
        logObj.set("bizobj", (Object)billOperationInfo.getBillMetadataNumber());
        logObj.set("billno", (Object)billOperationInfo.getBillNumber());
        logObj.set("billid", (Object)billOperationInfo.getBillId());
        logObj.set("billoper", billOperationInfo.getOperationId());
        logObj.set("invoiceCloudOper", (Object)invoiceCloudOperEnum.getValue());
        logObj.set("isworkflow", (Object)billOperationInfo.isWorkflow());
        String stdReqParamStr_short = stdReqParamStr;
        if (stdReqParamStr_short.length() > 47) {
            stdReqParamStr_short = stdReqParamStr_short.substring(0, 47) + "...";
        }
        logObj.set("param", (Object)stdReqParamStr_short);
        logObj.set("param_tag", (Object)stdReqParamStr);
        if (respStr.length() > 255) {
            respStr = respStr.substring(0, 252) + "...";
        }
        logObj.set("response", (Object)respStr);
        logObj.set("org", billOperationInfo.getOrgId());
        logObj.set("icp", billOperationInfo.getIcpId());
        try (TXHandle h = TX.requiresNew();){
            try {
                DeleteServiceHelper.delete((String)asyncLogMetadataNumber, (QFilter[])new QFilter("billid", "=", (Object)billOperationInfo.getBillId()).toArray());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObj});
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private static void clearOldLog() {
        LocalDate localDate = LocalDate.now();
        int dayOfMonth = localDate.getDayOfMonth();
        if (dayOfMonth != 1) {
            return;
        }
        localDate = localDate.minusMonths(1L);
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDate.atStartOfDay().atZone(zone).toInstant();
        Date date = Date.from(instant);
        QFilter[] filters = new QFilter[]{new QFilter("reqtime", "<", (Object)date), new QFilter("reqstatus", "=", (Object)"1")};
        DeleteServiceHelper.delete((String)asyncLogMetadataNumber, (QFilter[])filters);
    }

    public static void updateAsyncLog() {
        String asyncLogMetadataNumber = asyncLogMetadataNumber;
        HashSet<Long> logIds = new HashSet<Long>();
        QFilter[] qFilters = new QFilter[]{new QFilter("reqstatus", "=", (Object)"0"), new QFilter("billoper.sync", "=", (Object)false).or("isworkflow", "=", (Object)true)};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)ALGO, (String)asyncLogMetadataNumber, (String)"id", (QFilter[])qFilters, null);){
            for (Row row : ds) {
                logIds.add(row.getLong("id"));
            }
        }
        AsyncLogUtil.updateAsyncLog(logIds);
    }

    public static int[] updateAsyncLog(Set<Long> logIds) {
        String sql;
        AsyncLogUtil.clearOldLog();
        String asyncLogMetadataNumber = asyncLogMetadataNumber;
        String selectFields = "id,org,invoicecloudoper,param_tag";
        QFilter[] filters = new QFilter[]{new QFilter("reqstatus", "=", (Object)"0"), new QFilter("billoper.sync", "=", (Object)false).or("isworkflow", "=", (Object)true), new QFilter("id", "in", logIds)};
        ArrayList<Object[]> allLogLst = new ArrayList<Object[]>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)ALGO, (String)asyncLogMetadataNumber, (String)selectFields, (QFilter[])filters, null);){
            for (Object row : ds) {
                Object[] logObj = new Object[]{row.get("id"), row.get("org"), row.get("invoicecloudoper"), row.get("param_tag")};
                allLogLst.add(logObj);
            }
        }
        if (allLogLst.isEmpty()) {
            return null;
        }
        String traceId = RequestContext.get().getTraceId();
        ArrayList<Object[]> successes = new ArrayList<Object[]>();
        ArrayList<Object[]> fails = new ArrayList<Object[]>();
        for (Object[] logObj : allLogLst) {
            String respStr;
            Date reqTime = new Date();
            Object logId = logObj[0];
            try {
                AsyncAction asyncAction = new AsyncAction(traceId, logObj, fails);
                respStr = asyncAction.execute();
                UpdateInvoiceStatusStdResqParam stdResp = (UpdateInvoiceStatusStdResqParam)JSON.parseObject((String)respStr, UpdateInvoiceStatusStdResqParam.class);
                String errCode = stdResp.getErrcode();
                boolean success = StringUtils.equals((CharSequence)errCode, (CharSequence)"0000");
                if (respStr.length() > 255) {
                    respStr = respStr.substring(0, 252) + "...";
                }
                if (success) {
                    successes.add(new Object[]{reqTime, traceId, respStr, logId});
                    continue;
                }
                fails.add(new Object[]{reqTime, traceId, respStr, logId});
            }
            catch (Exception e) {
                respStr = ThrowableHelper.toString((Exception)e);
                if (respStr.length() > 255) {
                    respStr = respStr.substring(0, 252) + "...";
                }
                fails.add(new Object[]{reqTime, traceId, respStr, logId});
            }
        }
        if (!successes.isEmpty()) {
            sql = "update t_er_invoiceasynclog set freqstatus='1',freqtime=?,fxhtraceid=?,fresponse=? where fid=?";
            DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)sql, successes);
        }
        if (!fails.isEmpty()) {
            sql = "update t_er_invoiceasynclog set freqtime=?,fxhtraceid=?,fresponse=? where fid=?";
            DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)sql, fails);
        }
        return new int[]{successes.size(), fails.size()};
    }
}

