/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.cache.model;

import com.alibaba.fastjson.JSON;
import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.cache.AppCache;
import kd.bos.form.IPageCache;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceTitleTax;
import org.apache.commons.lang3.StringUtils;

public class ErCacheUtils {
    public static final String KEY_APLIT = "::";

    public static void put(String region, String key, Object value) {
        AppCache.get((String)"er").put(region + KEY_APLIT + key, value, 3600);
    }

    public static void put(String region, String key, Object value, int releaseTime) {
        AppCache.get((String)"er").put(region + KEY_APLIT + key, value, releaseTime);
    }

    public static <T> T get(String region, String key, Class<T> tClass) {
        return (T)AppCache.get((String)"er").get(region + KEY_APLIT + key, tClass);
    }

    public static void remove(String region, String key) {
        AppCache.get((String)"er").remove(region + KEY_APLIT + key);
    }

    public static InvoiceCloudCfgBO transferInvoiceCfgDyoToInvoiceCloudCfgBO(DynamicObject config) {
        if (config == null) {
            return null;
        }
        InvoiceCloudCfgBO invoiceCloudCfgBO = new InvoiceCloudCfgBO();
        ErCacheUtils.initInvoiceCloudCfgBO(invoiceCloudCfgBO, config);
        String firmName = config.getString("firmname");
        firmName = firmName.replaceAll("\\(", "\uff08").replaceAll("\\)", "\uff09");
        invoiceCloudCfgBO.setFirmname(firmName);
        invoiceCloudCfgBO.setTaxRegnum(config.getString("taxregnum"));
        InvoiceTitleTax titleTax = new InvoiceTitleTax(firmName, config.getString("taxregnum"));
        invoiceCloudCfgBO.setTitleTaxList(Collections.singletonList(titleTax));
        return invoiceCloudCfgBO;
    }

    public static void initInvoiceCloudCfgBO(InvoiceCloudCfgBO invoiceCloudCfgBO, DynamicObject config) {
        invoiceCloudCfgBO.setClientId(config.getString("client_id"));
        invoiceCloudCfgBO.setClientSecret(config.getString("client_secret"));
        invoiceCloudCfgBO.setEncryptKey(config.getString("encrypt_key"));
        invoiceCloudCfgBO.setReimedCi(config.getString("reimed_ci"));
        invoiceCloudCfgBO.setNameNotMatchCi(config.getString("namenotmatch_ci"));
        invoiceCloudCfgBO.setTaxNumNotMatchCi(config.getString("taxnumnotmatch_ci"));
        invoiceCloudCfgBO.setCheckNotPassCi(config.getString("checknotpass_ci"));
        invoiceCloudCfgBO.setBuyerNameLessEqual5Ci(config.getString("buyernamele5_ci"));
        if (config.getDynamicObjectType().getProperty("deductibleoftaxpayer") != null) {
            invoiceCloudCfgBO.setDeductibleoftaxpayer(config.getString("deductibleoftaxpayer"));
        }
        if (config.getDynamicObjectType().getProperty("nonoffsetcomputoutaount") != null) {
            invoiceCloudCfgBO.setNonOffsetComputOutAount(config.getString("nonoffsetcomputoutaount"));
            invoiceCloudCfgBO.setNonOffsetImportTaxAmout(config.getString("nonoffsetimporttaxamout"));
            invoiceCloudCfgBO.setOffsetOnlyFromInvoice(config.getString("offsetonlyfrominvoice"));
        }
    }

    public static <T> void putValueToPageCache(IPageCache pageCache, String key, T value) {
        if (key == null || value == null) {
            return;
        }
        pageCache.put(key, JSON.toJSONString(value));
    }

    public static <T> T getValueFromPageCache(IPageCache pageCache, String key, Class<T> valClass) {
        if (key == null || valClass == null) {
            return null;
        }
        String value = pageCache.get(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return (T)JSON.parseObject((String)value, valClass);
        }
        return null;
    }

    public static void removeInPage(IPageCache pageCache, String key) {
        if (key == null) {
            return;
        }
        pageCache.remove(key);
    }
}

