/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.dap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.ext.fi.ai.Voucher;
import kd.bos.ext.fi.ai.VoucherOperation;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.invoicecloud.dap.SendVoucherMsgUtil;
import kd.fi.er.business.utils.AbstractErDAPWriteBackUtils;
import kd.fi.er.business.utils.ErStdConfig;

public class ApplyPayBillWriteBackInvoicePool
extends AbstractErDAPWriteBackUtils {
    @Override
    public void writeBack(VoucherOperation operation, String billEntityNumber, Map<Long, Voucher> billToVch) {
        try (TXHandle h = TX.requiresNew();){
            super.writeBack(operation, billEntityNumber, billToVch);
        }
        if (!ErStdConfig.getBoolean("invoicecloud.saveDownstreamVoucher")) {
            return;
        }
        Long publicReimTableId = EntityMetadataCache.loadTableDefine((String)"er_publicreimbursebill", (String)"er_publicreimbursebill").getTableId();
        List linkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)"er_applypaybill", (Long[])billToVch.keySet().toArray(new Long[0]), null);
        HashMap<String, Map<Long, List<Voucher>>> entity_erBillToVch = new HashMap<String, Map<Long, List<Voucher>>>(linkUpNodes.size());
        for (BFRowLinkUpNode bFRowLinkUpNode : linkUpNodes) {
            Map sNodes = bFRowLinkUpNode.getSNodes();
            if (sNodes == null || sNodes.isEmpty()) continue;
            BFRowId next = (BFRowId)sNodes.keySet().iterator().next();
            Long srcBillId = next.getBillId();
            Long srcMainTableId = next.getMainTableId();
            if (Long.compare(publicReimTableId, srcMainTableId) != 0) continue;
            List<Voucher> voucherLst = this.getVoucherLst(entity_erBillToVch, "er_publicreimbursebill", srcBillId);
            Long applyPayBillId = bFRowLinkUpNode.getRowId().getBillId();
            voucherLst.add(billToVch.get(applyPayBillId));
        }
        for (Map.Entry entry : entity_erBillToVch.entrySet()) {
            String _billEntityNumber = (String)entry.getKey();
            Map _billToVch = (Map)entry.getValue();
            SendVoucherMsgUtil.sendVoucherMsg(operation.getValue(), _billEntityNumber, _billToVch);
        }
    }

    private List<Voucher> getVoucherLst(Map<String, Map<Long, List<Voucher>>> entity_erBillToVch, String entityName, Long billId) {
        List<Voucher> voucherLst;
        Map<Long, List<Voucher>> erBillToVch = entity_erBillToVch.get(entityName);
        if (erBillToVch == null) {
            erBillToVch = new HashMap<Long, List<Voucher>>();
            entity_erBillToVch.put(entityName, erBillToVch);
        }
        if ((voucherLst = erBillToVch.get(billId)) == null) {
            voucherLst = new ArrayList<Voucher>();
            erBillToVch.put(billId, voucherLst);
        }
        return voucherLst;
    }

    @Override
    protected void handleDeleteField(Map<String, Object> fieldValueMapping, DynamicObject voucher, long billID) {
    }

    @Override
    protected void handleCreateField(Map<String, Object> fieldValueMapping, DynamicObject voucher, long billID) {
    }
}

