/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.invoicepackage.util;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.kingdee.QueryInvoiceDetailBO;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.model.invoice.InvoiceVO;
import kd.fi.er.common.model.invoice.OperationConfigBo;
import kd.fi.er.common.model.invoice.QuickConfigBo;
import org.apache.commons.lang3.StringUtils;

public class QuickReimUtil {
    private static final Log log = LogFactory.getLog(QuickReimUtil.class);

    public static final List<InvoiceVO> queryInvoice(String serialNosStr, InvoiceCloudCfgBO config, IFormView view) {
        QueryInvoiceDetailBO queryInvoiceDetailBO = ErStdConfig.isDev() ? QuickReimUtil.buildQueryInvoiceDetailBO("test", config, view) : QuickReimUtil.buildQueryInvoiceDetailBO(serialNosStr, config, view);
        try {
            List<InvoiceVO> invoiceVOs = APIHelper.queryInvoiceDetailBySerialNo(queryInvoiceDetailBO);
            invoiceVOs.forEach(vo -> log.info("\u3010Invoice folder\u3011query original invoice data\uff1a" + vo));
            return invoiceVOs;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            view.showErrorNotification(e.getMessage());
            return Collections.EMPTY_LIST;
        }
    }

    private static final QueryInvoiceDetailBO buildQueryInvoiceDetailBO(String serialNosStr, InvoiceCloudCfgBO config, IFormView view) {
        QueryInvoiceDetailBO queryInvoiceDetailBO = new QueryInvoiceDetailBO();
        queryInvoiceDetailBO.setSerialNo(serialNosStr);
        queryInvoiceDetailBO.setTaxNo(config.getTaxRegnum());
        queryInvoiceDetailBO.setCompanyName(config.getFirmname());
        queryInvoiceDetailBO.setCostCompany(config.getInvoiceOrgId().toString());
        queryInvoiceDetailBO.setBxdKey("no");
        queryInvoiceDetailBO.setView(view);
        return queryInvoiceDetailBO;
    }

    public static final List<QuickConfigBo> getQuickConfigs(Long companyId, boolean needMeg, IFormView view, QFilter otherFilter) {
        DynamicObjectCollection billSettingCollection;
        QFilter settingFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_bill_setting", (Long)companyId);
        settingFilter.and("fastreimburse", "=", (Object)true);
        settingFilter.and("group.controlfield", "!=", (Object)"reimbursetype");
        settingFilter.and("bizitem", "!=", (Object)0);
        settingFilter.and("enable", "=", (Object)"1");
        if (otherFilter != null) {
            settingFilter.and(otherFilter);
        }
        if ((billSettingCollection = QueryServiceHelper.query((String)"er_bill_setting", (String)"id,number,name,reimbursetype,bizitem,formtitle,group,group.number,group.controlfield,fastreimburse,picturefield,createorg,createtime", (QFilter[])new QFilter[]{settingFilter})).isEmpty()) {
            if (needMeg) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e1a\u52a1\u4e8b\u9879\u672a\u542f\u7528\u5411\u5bfc\u5f0f\u53d1\u8d77\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u3002", (String)"QuickReimburseListMob_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            return Collections.EMPTY_LIST;
        }
        ArrayList settingResult = new ArrayList();
        Map<Object, List<DynamicObject>> groupCollection = billSettingCollection.stream().collect(Collectors.groupingBy(setting -> setting.getLong("group")));
        groupCollection.forEach((key, value) -> {
            Map<Long, List<DynamicObject>> bizItemGroup = value.stream().collect(Collectors.groupingBy(groupSetting -> groupSetting.getLong("bizitem")));
            bizItemGroup.forEach((bizItemKey, bizItemGroupValues) -> {
                Optional<DynamicObject> currentCompanyValue = bizItemGroupValues.stream().filter(bizItemValue -> bizItemValue.getLong("createorg") == companyId.longValue()).findFirst();
                if (currentCompanyValue.isPresent()) {
                    settingResult.add(currentCompanyValue.get());
                } else {
                    Optional<DynamicObject> createTimeValue = bizItemGroupValues.stream().max(Comparator.comparing(a -> a.getDate("createtime")));
                    if (createTimeValue.isPresent()) {
                        settingResult.add(createTimeValue.get());
                    }
                }
            });
        });
        List settingPkList = settingResult.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(settingPkList)) {
            if (needMeg) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e1a\u52a1\u4e8b\u9879\u672a\u542f\u7528\u5411\u5bfc\u5f0f\u53d1\u8d77\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u3002", (String)"QuickReimburseListMob_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            return Collections.EMPTY_LIST;
        }
        QFilter idsFilter = new QFilter("id", "in", settingPkList);
        DataSet billSetting = QueryServiceHelper.queryDataSet((String)"QuickReimUtil", (String)"er_bill_setting", (String)"id,formtitle,group,group.name as groupname,group.number as groupnumber,bizitem,reimbursetype,fastreimburse,picturefield,createorg,createtime", (QFilter[])new QFilter[]{idsFilter}, null);
        QFilter qFilter = new QFilter("clienttype", "=", (Object)"0");
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("isdefault", "=", (Object)true);
        DataSet pluginInfo = QueryServiceHelper.queryDataSet((String)"QuickReimUtil", (String)"er_invoicepginfo", (String)"id as pgid,number,name,clienttype,bizitem as pgbizitem,billgroup,isdefault,pluginpath,clicksign,enable", (QFilter[])new QFilter[]{qFilter}, null);
        DataSet resultDataSet = billSetting.leftJoin(pluginInfo).on("bizitem", "pgbizitem").on("group", "billgroup").select(new String[]{"id", "pgid", "formtitle", "group", "groupname", "billgroup", "groupnumber", "bizitem", "pgbizitem", "reimbursetype", "fastreimburse", "clienttype", "picturefield", "createorg", "createtime", "isdefault", "pluginpath", "clicksign"}).finish();
        List<QuickConfigBo> result = QuickReimUtil.buildConfigModel(resultDataSet);
        billSetting.close();
        pluginInfo.close();
        resultDataSet.close();
        if (CollectionUtils.isEmpty(result)) {
            if (needMeg) {
                view.showTipNotification(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u4e00\u952e\u62a5\u9500\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u4e00\u952e\u62a5\u9500\u64cd\u4f5c\u914d\u7f6e\u3002", (String)"QuickReimburseListMob_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            return Collections.EMPTY_LIST;
        }
        return result;
    }

    public static final List<QuickConfigBo> getQuickConfigs(Long companyId, boolean needMeg, IFormView view) {
        return QuickReimUtil.getQuickConfigs(companyId, needMeg, view, null);
    }

    private static final List<QuickConfigBo> buildConfigModel(DataSet billSettingPg) {
        ArrayList<QuickConfigBo> list = new ArrayList<QuickConfigBo>();
        if (billSettingPg == null) {
            return list;
        }
        for (Row configDo : billSettingPg) {
            log.info("\u3010\u4e00\u952e\u62a5\u9500\u3011\u52a0\u8f7d\u914d\u7f6e\u9879\uff1a" + configDo);
            Long pgId = configDo.getLong("pgid");
            Long billGroup = configDo.getLong("billgroup");
            Long pgBizItem = configDo.getLong("pgbizitem");
            String pluginPath = configDo.getString("pluginpath");
            String clickSign = configDo.getString("clicksign");
            QuickConfigBo bo = new QuickConfigBo();
            bo.setId(configDo.getLong("id"));
            bo.setBizItem(configDo.getLong("bizitem"));
            bo.setName(StringUtils.isNotEmpty((CharSequence)configDo.getString("formtitle")) ? configDo.getString("formtitle") : configDo.getString("groupname"));
            bo.setReimburseType(configDo.getString("reimbursetype"));
            bo.setFastReimburse(configDo.getBoolean("fastreimburse").booleanValue());
            bo.setGroup(configDo.getLong("group"));
            bo.setSrcFormId(configDo.getString("groupnumber"));
            bo.setMenuImg(configDo.getString("picturefield"));
            bo.setCreateOrg(configDo.getLong("createorg"));
            bo.setCreateTime(configDo.getDate("createtime"));
            if (pgId != null && pgId != 0L && billGroup != null && billGroup != 0L && pgBizItem != null && pgBizItem != 0L && !StringUtils.isEmpty((CharSequence)pluginPath) || !StringUtils.isEmpty((CharSequence)clickSign)) {
                OperationConfigBo operation = bo.getOperation();
                bo.setInvoicePlugin(configDo.getLong("pgid"));
                operation.setId(pgId);
                operation.setBillGroup(billGroup);
                operation.setBizItem(pgBizItem);
                operation.setPluginPath(pluginPath);
                operation.setDefault(configDo.getBoolean("isdefault"));
                operation.setClickSign(clickSign);
                operation.setClientType("0");
            }
            list.add(bo);
        }
        return list;
    }

    public static final List<QuickConfigBo> getSortConfigs(List<QuickConfigBo> input) {
        List bizItemIds = input.stream().map(config -> config.getBizItem()).collect(Collectors.toList());
        Long currentUserId = Long.valueOf(RequestContext.get().getUserId());
        QFilter filter = new QFilter("applier", "=", (Object)currentUserId);
        filter.and("bizitem", "in", bizItemIds);
        LocalDate now = LocalDate.now();
        Date startDate = Date.from(now.plusMonths(-6L).with(TemporalAdjusters.firstDayOfMonth()).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        filter.and("bizdate", ">=", (Object)startDate);
        log.info(String.format("\u3010\u4e00\u952e\u62a5\u9500\u3011\u6392\u5e8f\u6761\u4ef6\uff1a%s\uff0c%s\uff0c%s\u3002", currentUserId, bizItemIds, startDate));
        DynamicObjectCollection bizItemCollection = QueryServiceHelper.query((String)"er_reimbursebill_ds", (String)"bizitem", (QFilter[])new QFilter[]{filter});
        if (CollectionUtils.isEmpty((Collection)bizItemCollection)) {
            return input;
        }
        Map<Long, List<DynamicObject>> bizItem_group = bizItemCollection.stream().filter(bizItem -> bizItem.getLong("bizitem") != 0L).collect(Collectors.groupingBy(bizItem -> bizItem.getLong("bizitem")));
        ArrayList<Map.Entry<Long, List<DynamicObject>>> list = new ArrayList<Map.Entry<Long, List<DynamicObject>>>(bizItem_group.entrySet());
        Collections.sort(list, (o1, o2) -> {
            if (((List)o1.getValue()).size() > ((List)o2.getValue()).size()) {
                return -1;
            }
            if (((List)o1.getValue()).size() < ((List)o2.getValue()).size()) {
                return 1;
            }
            return 0;
        });
        List sortBizItemIds = list.stream().map(obj -> (Long)obj.getKey()).collect(Collectors.toList());
        ArrayList<QuickConfigBo> output = new ArrayList<QuickConfigBo>(sortBizItemIds.size());
        ArrayList noMatch = new ArrayList(sortBizItemIds.size());
        for (Long sortBizItemId : sortBizItemIds) {
            List bizItemCollect = input.stream().filter(obj -> obj.getBizItem().equals(sortBizItemId)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(bizItemCollect)) {
                output.addAll(bizItemCollect);
                continue;
            }
            noMatch.addAll(bizItemCollect);
        }
        output.addAll(noMatch);
        return output;
    }
}

