/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.kingdee;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceTypeEnum;
import kd.fi.er.business.invoicecloud.kingdee.MapWrapper;
import kd.fi.er.business.invoicecloud.model.Invoice;
import kd.fi.er.business.invoicecloud.model.InvoiceItem;
import org.apache.commons.lang3.StringUtils;

public class InvoiceCreator {
    private static Log logger = LogFactory.getLog(InvoiceCreator.class);

    public static List<Invoice> convertToInvoiceLst(List<Map> rawInvoiceLst) {
        List rawWrapperLst = rawInvoiceLst.stream().map(v -> new MapWrapper((Map)v)).collect(Collectors.toList());
        List<Invoice> invoiceLst = rawWrapperLst.stream().map(InvoiceCreator::rawToInvoice).collect(Collectors.toList());
        return invoiceLst;
    }

    private static Invoice rawToInvoice(MapWrapper rawInvoice) {
        Invoice.Builder builder = new Invoice.Builder();
        builder.withInvoiceDate(rawInvoice.getString("invoiceDate")).withInvoiceCode(rawInvoice.getString("invoiceCode")).withInvoiceNo(rawInvoice.getString("invoiceNo")).withInvoiceType(rawInvoice.getString("invoiceType")).withSerialNo(rawInvoice.getString("serialNo")).withSalerName(rawInvoice.getString("salerName")).withBuyerName(rawInvoice.getString("buyerName")).withValidateMessage(rawInvoice.getString("validateMessage")).withRemark(rawInvoice.getString("remark")).withPassengerName(rawInvoice.getString("passengerName"));
        String airPortConstructionAmountStr = (String)rawInvoice.get("airportConstructionFee");
        if (StringUtils.isBlank((CharSequence)airPortConstructionAmountStr)) {
            airPortConstructionAmountStr = "0";
        }
        builder.withAirportConstructionFee(airPortConstructionAmountStr);
        if (rawInvoice.getBigDecimal("amount") == null) {
            builder.withAmount(rawInvoice.getBigDecimal("totalAmount"));
        } else {
            builder.withAmount(rawInvoice.getBigDecimal("amount"));
        }
        if (rawInvoice.getBigDecimal("taxAmount") == null) {
            builder.withTaxAmount(BigDecimal.ZERO);
        } else {
            builder.withTaxAmount(rawInvoice.getBigDecimal("taxAmount"));
        }
        builder.withTotalAmount(rawInvoice.getBigDecimal("totalAmount")).build();
        String trip = rawInvoice.getString("trip");
        if (trip != null) {
            builder.withTrip(trip.replaceAll(" - ", ","));
        }
        builder.withFromInvoiceCloud(true);
        Invoice invoice = builder.build();
        List rawInvoiceItemLst = rawInvoice.getList("items");
        if (rawInvoiceItemLst != null) {
            rawInvoiceItemLst.stream().map(InvoiceCreator::rawToInvoiceItem).forEach(invoice::addItem);
        }
        return invoice;
    }

    private static InvoiceItem.Builder rawToInvoiceItem(Map rawInvoiceItem) {
        return new InvoiceItem.Builder().withDetailAmount(new BigDecimal(rawInvoiceItem.get("detailAmount").toString())).withTaxAmount(new BigDecimal(rawInvoiceItem.get("taxAmount").toString())).withTaxRate(new BigDecimal(rawInvoiceItem.get("taxRate").toString())).withGoodsCode(rawInvoiceItem.get("goodsCode").toString()).withGoodsName(rawInvoiceItem.get("goodsName").toString());
    }

    public static void handleNoItem(List<Invoice> invoiceLst) {
        for (Invoice invoice : invoiceLst) {
            if (invoice.getItems().size() != 0) continue;
            BigDecimal taxAmount = invoice.getTaxAmount();
            BigDecimal totalAmount = invoice.getTotalAmount();
            BigDecimal taxRate = invoice.getTaxRate();
            BigDecimal noTaxAmount = invoice.getAmount();
            BigDecimal airportConstructionAmount = BigDecimal.ZERO;
            if (InvoiceTypeEnum.key_10.getValue().equals(invoice.getInvoiceType())) {
                noTaxAmount = totalAmount.subtract(taxAmount);
                airportConstructionAmount = invoice.getAirportConstructionFee();
            }
            invoice.getInvoiceType();
            invoice.addItem(new InvoiceItem.Builder().withDetailAmount(noTaxAmount).withTaxAmount(taxAmount).withTaxRate(taxRate).withAriportConstructionFee(airportConstructionAmount));
        }
    }

    public static BigDecimal sum(List<Invoice> invoices, Function<Invoice, BigDecimal> propFn) {
        return invoices.stream().map(propFn).collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add));
    }
}

