/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.kingdee;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.invoicecloud.cache.model.CheckLevel;
import kd.fi.er.business.invoicecloud.cache.model.ErCacheUtils;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceConfigPattern;
import kd.fi.er.business.invoicecloud.v2.util.AllInvoiceUrl;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import org.apache.commons.lang3.StringUtils;

public class KingdeeInvoiceCloudConfig {
    public static final String METADATA_NUMBER = "er_bd_kdinvoicecloudcfg";

    private KingdeeInvoiceCloudConfig() {
    }

    public static String getDomain() {
        boolean not_prod = ErStdConfig.getBoolean("invoicecloud.not_prod");
        return not_prod ? ErStdConfig.get("invoicecloud.domain_test") : ErStdConfig.get("invoicecloud.domain_prod");
    }

    @Deprecated
    public static String getClientId(String taxRegNum) {
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(taxRegNum);
        if (config == null) {
            return null;
        }
        return config.getClientId();
    }

    @Deprecated
    public static String getClientSecret(String taxRegNum) {
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(taxRegNum);
        if (config == null) {
            return null;
        }
        return config.getClientSecret();
    }

    @Deprecated
    public static String getEncryptKey(String taxRegNum) {
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(taxRegNum);
        if (config == null) {
            return null;
        }
        return config.getEncryptKey();
    }

    @Deprecated
    public static String getTicketParam(String taxRegNum) {
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(taxRegNum);
        if (config == null) {
            return null;
        }
        return config.genTicketParam();
    }

    @Deprecated
    public static boolean reimed_ci(String taxRegNum) {
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(taxRegNum);
        if (config == null) {
            return false;
        }
        return !config.getReimedCi().equalsIgnoreCase(CheckLevel.StrictControl.getValue());
    }

    public static Boolean reimed_ci(Long companyId) {
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(companyId);
        if (config == null) {
            return null;
        }
        return !config.getReimedCi().equalsIgnoreCase(CheckLevel.StrictControl.getValue());
    }

    public static String getCompanyNameBy(Long companyId) {
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(companyId);
        if (config == null) {
            return null;
        }
        return config.getFirmname();
    }

    @Deprecated
    public static InvoiceCloudCfgBO getConfig(String taxRegNum) {
        QFilter[] filters = new QFilter[]{new QFilter("taxregnum", "=", (Object)taxRegNum), new QFilter("enable", "=", (Object)true)};
        DynamicObject config = BusinessDataServiceHelper.loadSingleFromCache((String)METADATA_NUMBER, (QFilter[])filters);
        if (config == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f01\u4e1a\u7a0e\u53f7\u201c%s\u201d\u7684\u53d1\u7968\u4e91\u914d\u7f6e\u4e0d\u5b58\u5728\u6216\u672a\u542f\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"KingdeeInvoiceCloudConfig_0", (String)"fi-er-business", (Object[])new Object[0]), taxRegNum));
        }
        InvoiceCloudCfgBO invoiceCloudCfgBO = ErCacheUtils.transferInvoiceCfgDyoToInvoiceCloudCfgBO(config);
        return invoiceCloudCfgBO;
    }

    public static InvoiceCloudCfgBO getConfig(Long companyId) {
        if (companyId == null) {
            return null;
        }
        return KingdeeInvoiceCloudConfig.getInvoiceConfigPattern().getConfig(companyId);
    }

    public static boolean existConfig() {
        return KingdeeInvoiceCloudConfig.getInvoiceConfigPattern().existConfig();
    }

    public static boolean checkHttpsCertificate() {
        String value = ErStdConfig.get("invoicecloud.check_https_certificate");
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    public static String getInvoiceURL_PC() {
        boolean not_prod = ErStdConfig.getBoolean("invoicecloud.not_prod");
        return not_prod ? ErStdConfig.get("invoicecloud.pc_vurl_test") : ErStdConfig.get("invoicecloud.pc_vurl_prod");
    }

    public static String getInvoiceURL_mobile() {
        return KingdeeInvoiceCloudConfig.getInvoiceSelectURL_mobile();
    }

    public static String getInvoiceListURL_PC() {
        boolean not_prod = ErStdConfig.getBoolean("invoicecloud.not_prod");
        return not_prod ? ErStdConfig.get("invoicecloud.pc_vlisturl_test") : ErStdConfig.get("invoicecloud.pc_vlisturl_prod");
    }

    public static String getInvoiceListURL_mobile() {
        return KingdeeInvoiceCloudConfig.getInvoiceSelectURL_mobile();
    }

    public static String getInvoiceSelectURL_PC() {
        boolean not_prod = ErStdConfig.getBoolean("invoicecloud.not_prod");
        return not_prod ? ErStdConfig.get("invoicecloud.pc_surl_test") : ErStdConfig.get("invoicecloud.pc_surl_prod");
    }

    public static String getNewInvoiceSelectURL_PC() {
        boolean not_prod = ErStdConfig.getBoolean("invoicecloud.not_prod");
        return not_prod ? ErStdConfig.get("invoicecloud.new_pc_surl_test") : ErStdConfig.get("invoicecloud.new_pc_surl_prod");
    }

    public static boolean enableNewInvoiceSelectURL_PC() {
        return ErStdConfig.getBoolean("invoicecloud.enable_new_pc_surl");
    }

    public static String getInvoiceSelectURL_mobile() {
        boolean not_prod = ErStdConfig.getBoolean("invoicecloud.not_prod");
        return not_prod ? ErStdConfig.get("invoicecloud.mobile_surl_test") : ErStdConfig.get("invoicecloud.mobile_surl_prod");
    }

    public static String getInvoiceAttachmentAPIURL() {
        boolean notProd = ErStdConfig.getBoolean("invoicecloud.not_prod");
        return notProd ? ErStdConfig.get("invoicecloud.attachmentapi_test") : ErStdConfig.get("invoicecloud.attachmentapi_prod");
    }

    public static boolean syncInvoiceAttachmentToBill() {
        return ErStdConfig.getBoolean("invoicecloud.syncattachmenttobill");
    }

    @Deprecated
    public static boolean isEnabled(String taxRegNum) {
        QFilter[] filters = new QFilter[]{new QFilter("taxregnum", "=", (Object)taxRegNum), new QFilter("enable", "=", (Object)true)};
        return QueryServiceHelper.exists((String)METADATA_NUMBER, (QFilter[])filters);
    }

    public static boolean isEnabled(long orgid) {
        return KingdeeInvoiceCloudConfig.getConfig(orgid) != null;
    }

    public static String getTaxRegNum(long orgId) {
        InvoiceCloudCfgBO config = null;
        try {
            config = KingdeeInvoiceCloudConfig.getConfig(orgId);
        }
        catch (KDBizException e) {
            config = null;
        }
        if (config != null) {
            return config.getTaxRegnum();
        }
        return null;
    }

    @Deprecated
    public static boolean sumExpNull(long orgid) {
        QFilter[] filters = new QFilter[]{new QFilter("org.id", "=", (Object)orgid), new QFilter("enable", "=", (Object)true)};
        DynamicObject obj = QueryServiceHelper.queryOne((String)METADATA_NUMBER, (String)"sumexpnull", (QFilter[])filters);
        if (obj == null) {
            return false;
        }
        return obj.getBoolean("sumexpnull");
    }

    public static String getEditInvoiceUrlPc() {
        return AllInvoiceUrl.getEditInvoiceUrlPc();
    }

    public static InvoiceConfigPattern getInvoiceConfigPattern() {
        String result = ErStdConfig.get("invoicecloud.configpattern");
        if (StringUtils.isNotEmpty((CharSequence)result) && StringUtils.equals((CharSequence)result.trim(), (CharSequence)"2")) {
            return InvoiceConfigPattern.groupPattern;
        }
        return InvoiceConfigPattern.orgPattern;
    }

    public static boolean isEnableXhInvoiceCloud() {
        String enable = ErStdConfig.get("invoicecloud.invoicecloudxh");
        if (enable == null || StringUtils.isBlank((CharSequence)enable)) {
            return false;
        }
        return Boolean.parseBoolean(enable.trim());
    }

    public static boolean isEnableXhInvoiceCloudInMob() {
        boolean isEnable = true;
        return isEnable;
    }

    public static boolean getDeductibleOfTaxPayer(Long companyId) {
        if (companyId == null) {
            return true;
        }
        InvoiceCloudCfgBO cfgBO = KingdeeInvoiceCloudConfig.getInvoiceConfigPattern().getConfig(companyId);
        if (cfgBO == null) {
            return true;
        }
        return !StringUtils.equals((CharSequence)cfgBO.getDeductibleoftaxpayer(), (CharSequence)"0");
    }

    public static boolean isNonoffsetComputOutAount(Long companyId) {
        if (companyId == null) {
            return false;
        }
        InvoiceCloudCfgBO cfgBO = KingdeeInvoiceCloudConfig.getInvoiceConfigPattern().getConfig(companyId);
        if (cfgBO == null) {
            return false;
        }
        return StringUtils.equals((CharSequence)cfgBO.getNonOffsetComputOutAount(), (CharSequence)"1");
    }

    public static boolean isNonOffsetImportTaxAmout(Long companyId) {
        if (companyId == null) {
            return false;
        }
        InvoiceCloudCfgBO cfgBO = KingdeeInvoiceCloudConfig.getInvoiceConfigPattern().getConfig(companyId);
        if (cfgBO == null) {
            return false;
        }
        return StringUtils.equals((CharSequence)cfgBO.getNonOffsetImportTaxAmout(), (CharSequence)"1");
    }

    public static boolean isOffsetOnlyFromInvoice(Long companyId) {
        if (companyId == null) {
            return false;
        }
        InvoiceCloudCfgBO cfgBO = KingdeeInvoiceCloudConfig.getInvoiceConfigPattern().getConfig(companyId);
        if (cfgBO == null) {
            return false;
        }
        return StringUtils.equals((CharSequence)cfgBO.getOffsetOnlyFromInvoice(), (CharSequence)"1");
    }

    public static Long getCostCompanyId(DynamicObject d) {
        String entityId = d.getDynamicObjectType().getName();
        String costCompanyFieldName = "costcompany";
        if (ErEntityTypeUtils.isCheckingpayBill(entityId)) {
            costCompanyFieldName = "company";
        }
        if (d.getDynamicObjectType().getProperty(costCompanyFieldName) == null) {
            return null;
        }
        Long costCompany = ErCommonUtils.getPk(d.get(costCompanyFieldName));
        return costCompany;
    }
}

