/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.privatization.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.privatization.bean.ErrorInfoBean;
import kd.fi.er.business.invoicecloud.privatization.bean.ReqParamBean;
import kd.fi.er.business.invoicecloud.privatization.utils.PrivatizationUtils;

public class PrivatizationRunable
implements Runnable {
    private static Log logger = LogFactory.getLog(PrivatizationRunable.class);
    private List<ReqParamBean> listReq;
    private boolean isSubmit;
    private String opType;

    public PrivatizationRunable(String opType) {
        this(PrivatizationUtils.querryBeans4Err(), opType, false);
    }

    public PrivatizationRunable(DynamicObject dataEntity, String opType, boolean isSubmit) {
        this(PrivatizationUtils.buildReqParamBean(dataEntity), opType, isSubmit);
    }

    public PrivatizationRunable(ReqParamBean req, String opType, boolean isSubmit) {
        this(Lists.newArrayList((Object[])new ReqParamBean[]{req}), opType, isSubmit);
    }

    public PrivatizationRunable(List<ReqParamBean> listReq, String opType, boolean isSubmit) {
        this.listReq = listReq;
        this.isSubmit = isSubmit;
        this.opType = opType;
    }

    private long[] initWaiyArr() {
        if (this.isSubmit) {
            return new long[]{0L, 60000L, 180000L, 300000L};
        }
        return new long[]{0L};
    }

    @Override
    public void run() {
        try {
            HashMap errorMap = Maps.newHashMapWithExpectedSize((int)this.listReq.size());
            long[] waitArr = this.initWaiyArr();
            logger.info(this.opType + "\u901a\u77e5\u5f71\u50cf\u62c9\u53d6\u53d1\u7968 \uff0c\u6267\u884c\u6b21\u6570\uff1a " + waitArr.length);
            for (int i = 0; i < waitArr.length; ++i) {
                if (waitArr[i] != 0L) {
                    try {
                        Thread.sleep(waitArr[i]);
                    }
                    catch (InterruptedException e) {
                        logger.error((Throwable)e);
                    }
                }
                if (this.isSubmit) {
                    ErrorInfoBean errorInfo = PrivatizationUtils.imageNotify(this.listReq.get(0), this.opType);
                    logger.info(this.opType + "\u901a\u77e5\u5f71\u50cf\u62c9\u53d6\u53d1\u7968 \uff0c\u901a\u77e5\u4fe1\u606f\uff1a " + errorInfo);
                    errorMap.put(errorInfo.getReqParamBean().getId(), errorInfo);
                    if (errorInfo.isSuccess()) break;
                    PrivatizationUtils.updateErrorInfo(errorMap.values(), this.opType);
                    continue;
                }
                for (ReqParamBean reqParamBean : this.listReq) {
                    ErrorInfoBean errorInfo = PrivatizationUtils.imageNotify(reqParamBean, this.opType);
                    logger.info(this.opType + "\u901a\u77e5\u5f71\u50cf\u62c9\u53d6\u53d1\u7968 \uff0c\u901a\u77e5\u4fe1\u606f\uff1a " + errorInfo);
                    errorMap.put(errorInfo.getReqParamBean().getId(), errorInfo);
                }
            }
            PrivatizationUtils.updateErrorInfo(errorMap.values(), this.opType);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }
}

