/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.provider.service.std;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.asynclog.AsyncLogUtil;
import kd.fi.er.business.invoicecloud.asynclog.InvoiceCloudOperEnum;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.concurrency.KdForkJoinWorkerThreadFactory;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.kingdee.QueryInvoiceDetailBO;
import kd.fi.er.business.invoicecloud.kingdee.QueryInvoiceTask;
import kd.fi.er.business.invoicecloud.kingdee.action.DelAction;
import kd.fi.er.business.invoicecloud.kingdee.action.DelVouchAction;
import kd.fi.er.business.invoicecloud.kingdee.action.QueryBySerialNoAction;
import kd.fi.er.business.invoicecloud.kingdee.action.SaveVouchAction;
import kd.fi.er.business.invoicecloud.kingdee.action.TokenAction;
import kd.fi.er.business.invoicecloud.kingdee.action.UpdateInvoiceStatusAction;
import kd.fi.er.business.invoicecloud.kingdee.action.ValidateAction;
import kd.fi.er.business.invoicecloud.model.BatchQueryInvoiceRespBO;
import kd.fi.er.business.invoicecloud.provider.param.req.BillOperationInfo;
import kd.fi.er.business.invoicecloud.provider.param.req.DeleteInvoiceReqParam;
import kd.fi.er.business.invoicecloud.provider.param.req.DeleteVoucherRequestParam;
import kd.fi.er.business.invoicecloud.provider.param.req.SaveVoucherRequestParam;
import kd.fi.er.business.invoicecloud.provider.param.req.UpdateInvoiceStatusReqParam;
import kd.fi.er.business.invoicecloud.provider.param.req.ValidateInvocieReqParam;
import kd.fi.er.business.invoicecloud.provider.param.resp.DeleteInvoiceRespParam;
import kd.fi.er.business.invoicecloud.provider.param.resp.DeleteVoucherResp;
import kd.fi.er.business.invoicecloud.provider.param.resp.SaveVoucherResp;
import kd.fi.er.business.invoicecloud.provider.param.resp.UpdateInvoiceStatusRespParam;
import kd.fi.er.business.invoicecloud.provider.param.resp.ValidateInvocieRespParam;
import kd.fi.er.business.invoicecloud.provider.param.std.DeleteInvoiceStdReqParam;
import kd.fi.er.business.invoicecloud.provider.param.std.DeleteInvoiceStdRespParam;
import kd.fi.er.business.invoicecloud.provider.param.std.UpdateInvoiceStatusStdReqParam;
import kd.fi.er.business.invoicecloud.provider.param.std.UpdateInvoiceStatusStdResqParam;
import kd.fi.er.business.invoicecloud.provider.service.CommonInvoiceService;
import kd.fi.er.business.invoicecloud.request.bean.ValidateInvoiceReqParam;
import kd.fi.er.business.invoicecloud.request.bean.ValidateInvoiceRespParam;
import kd.fi.er.business.invoicecloud.v2.util.AllInvoiceUrl;
import kd.fi.er.business.invoicecloud.v2.util.InvoiceJsonParseUtils;
import kd.fi.er.business.servicehelper.HttpServiceHelper;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.exception.invoice.InvoiceCloudException;
import kd.fi.er.common.model.invoice.InvoiceDetailRetrunVO;
import kd.fi.er.common.model.invoice.InvoiceVO;
import kd.fi.er.common.utils.Er;
import kd.fi.er.common.utils.ThrowableHelper;
import kd.sdk.fi.er.extpoint.invoicecloud.AfterSelectInvoice;
import org.apache.commons.lang3.StringUtils;

public class CommonInvoiceServiceImpl
implements CommonInvoiceService {
    private static Log logger = LogFactory.getLog(CommonInvoiceServiceImpl.class);
    public static final ForkJoinPool.ForkJoinWorkerThreadFactory kdForkJoinWorkerThreadFactory = new KdForkJoinWorkerThreadFactory();

    private String getToken(TokenAction tokenAction) {
        Object errcode;
        if (ErStdConfig.getBoolean("intranet")) {
            return "whatever";
        }
        String raw_response = tokenAction.execute();
        Map response = (Map)Er.jsonToObj((String)raw_response, Map.class);
        if (response != null && (errcode = response.get("errcode")) != null && errcode.toString().equals("0000")) {
            logger.info("\u3010\u8c03\u7528\u53d1\u7968\u4e91\u3011\u83b7\u53d6token\u6210\u529f");
            return response.get("access_token").toString();
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u661f\u701a\u8d39\u7528\u4e0e\u53d1\u7968\u4e91\u4ea4\u4e92\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CommonInvoiceServiceImpl_7", (String)"fi-er-business", (Object[])new Object[0]));
    }

    @Deprecated
    public List<InvoiceVO> queryInvoiceVos(QueryInvoiceDetailBO queryBO) throws InvoiceCloudException {
        return this.queryInvoiceVos(queryBO, null);
    }

    public List<InvoiceVO> queryInvoiceVos(QueryInvoiceDetailBO queryBO, PluginProxy<AfterSelectInvoice> afterSelectInvoicePluginProxy) throws InvoiceCloudException {
        String serialNos = queryBO.getSerialNo();
        if (serialNos == null || serialNos.isEmpty()) {
            logger.info("\u3010\u53d1\u7968\u4e91\u3011\u67e5\u8be2\u53d1\u7968\u8be6\u7ec6, \u4f20\u9012\u8fdb\u6765\u7684\u5e8f\u5217\u53f7\u4e3a\u7a7a");
            return Collections.emptyList();
        }
        Long orgId = null;
        if (StringUtils.isNotBlank((CharSequence)queryBO.getCostCompany())) {
            orgId = Long.valueOf(queryBO.getCostCompany());
        }
        QueryBySerialNoAction queryAction = new QueryBySerialNoAction(serialNos);
        queryAction.setTaxNo(queryBO.getTaxNo());
        queryAction.setCompanyName(queryBO.getCompanyName());
        queryAction.setBxdKey(queryBO.getBxdKey());
        queryAction.setInvoiceOrgId(orgId);
        String apiReturnJson = queryAction.execute();
        InvoiceDetailRetrunVO invoiceDetailReturnVO = InvoiceJsonParseUtils.parseInvoiceDetailReturnVO(apiReturnJson);
        String errCode = invoiceDetailReturnVO.getErrcode();
        if (StringUtils.equals((CharSequence)errCode, (CharSequence)"0000")) {
            logger.info("\u3010\u53d1\u7968\u4e91\u3011\u8c03\u7528\u53d1\u7968\u4e91\u67e5\u8be2\u8be6\u7ec6\u4fe1\u606f\u6210\u529f");
            List data = invoiceDetailReturnVO.getData();
            if (afterSelectInvoicePluginProxy != null) {
                logger.info("\u4e8c\u5f00\u7f13\u5b58\u53d1\u7968\u4e91\u8fd4\u56de\u7684\u53d1\u7968json");
                String finalApiReturnJson = apiReturnJson;
                afterSelectInvoicePluginProxy.callReplace(p -> {
                    p.cacheJsonFromInvoiceCloud(finalApiReturnJson);
                    return null;
                });
                logger.info("end \u4e8c\u5f00\u7f13\u5b58\u53d1\u7968\u4e91\u8fd4\u56de\u7684\u53d1\u7968json");
            }
            return data;
        }
        throw new InvoiceCloudException(ResManager.loadKDString((String)"\u661f\u701a\u8d39\u7528\u4e0e\u53d1\u7968\u4e91\u4ea4\u4e92\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CommonInvoiceServiceImpl_7", (String)"fi-er-business", (Object[])new Object[0]));
    }

    @Override
    public List<InvoiceVO> batchQueryInvoiceVosBySerialNos(QueryInvoiceDetailBO queryBO) throws InvoiceCloudException {
        return this.batchQueryInvoiceVosBySerialNos(queryBO, null);
    }

    @Override
    public List<InvoiceVO> batchQueryInvoiceVosBySerialNos(QueryInvoiceDetailBO queryBO, PluginProxy<AfterSelectInvoice> afterSelectInvoicePluginProxy) throws InvoiceCloudException {
        String serialNoStr = queryBO.getSerialNo();
        logger.info("\u3010\u53d1\u7968\u4e91\u3011queryInvoiceDetailBySerialNo: " + serialNoStr);
        if (StringUtils.isBlank((CharSequence)serialNoStr)) {
            return Lists.newArrayList();
        }
        String[] serialNoArr = serialNoStr.trim().split(",");
        RequestContext copyRequestContext = RequestContext.copy((RequestContext)RequestContext.get());
        copyRequestContext.setTraceId(RequestContext.get().getTraceId());
        QueryInvoiceTask queryInvoiceTask = new QueryInvoiceTask(queryBO, serialNoArr, 0, serialNoArr.length, copyRequestContext, afterSelectInvoicePluginProxy);
        ForkJoinPool forkJoinPool = new ForkJoinPool(Runtime.getRuntime().availableProcessors() * 4, kdForkJoinWorkerThreadFactory, null, false);
        List<BatchQueryInvoiceRespBO> batchQueryInvoiceRespBOs = forkJoinPool.invoke(queryInvoiceTask);
        Optional<BatchQueryInvoiceRespBO> anyRespBOWithException = batchQueryInvoiceRespBOs.stream().filter(q -> q.getException() != null).findAny();
        if (anyRespBOWithException.isPresent()) {
            throw new InvoiceCloudException(anyRespBOWithException.get().getException().getMessage());
        }
        List<InvoiceVO> invoiceVOs = batchQueryInvoiceRespBOs.stream().flatMap(q -> q.getInvoiceVOs().stream()).collect(Collectors.toList());
        logger.info("\u3010\u53d1\u7968\u4e91\u3011\u5408\u5e76\u540e\u67e5\u8be2\u5230\u7684\u53d1\u7968\u4fe1\u606f\u4e3a: " + JSONArray.toJSONString(invoiceVOs));
        return invoiceVOs;
    }

    @Override
    public UpdateInvoiceStatusRespParam updateInvoiceStatus(UpdateInvoiceStatusReqParam request) throws Exception {
        UpdateInvoiceStatusStdReqParam stdReqParam = new UpdateInvoiceStatusStdReqParam();
        stdReqParam.setBillNumber(request.getBillNumber());
        stdReqParam.setBxd_key(request.getBillId());
        stdReqParam.setInvoiceStatus(String.valueOf(request.getInvoiceStatus().getValue()));
        stdReqParam.setTicketParam(request.getTicketParam());
        stdReqParam.setInvoiceData(request.getInvoiceData());
        stdReqParam.setCoverNumber(request.getCoverNumber());
        stdReqParam.setCoverFileType(request.getCoverFileType());
        stdReqParam.setCoverBase64(request.getCoverBase64());
        stdReqParam.setCreatorId(request.getCreatorId());
        stdReqParam.setCreatorName(request.getCreatorName());
        stdReqParam.setCreatorEmail(request.getCreatorEmail());
        stdReqParam.setCreatorPhone(request.getCreatorPhone());
        stdReqParam.setReimbursingId(request.getReimbursingId());
        stdReqParam.setResource("4");
        stdReqParam.setAttachmentFids(request.getAttachmentFids());
        Date reqTime = new Date();
        InvoiceCloudOperEnum invoiceCloudOperEnum = InvoiceCloudOperEnum.update;
        String stdReqParamStr = JSON.toJSONString((Object)stdReqParam);
        BillOperationInfo billOperationInfo = request.getBillOperationInfo();
        UpdateInvoiceStatusRespParam result = new UpdateInvoiceStatusRespParam();
        boolean isAsync = billOperationInfo != null && billOperationInfo.isAsync();
        boolean isTokenFail = false;
        try {
            UpdateInvoiceStatusStdResqParam stdResp;
            String respStr;
            String invoiceSwitch = ErStdConfig.get("invoice.switch");
            if (StringUtils.equals((CharSequence)"old", (CharSequence)invoiceSwitch)) {
                String token = APIHelper.getCacheToken(request.getOrgId(), false);
                if (StringUtils.isEmpty((CharSequence)token)) {
                    isTokenFail = true;
                    throw new KDBizException(ResManager.loadKDString((String)"\u661f\u701a\u8d39\u7528\u4e0e\u53d1\u7968\u4e91\u4ea4\u4e92\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CommonInvoiceServiceImpl_7", (String)"fi-er-business", (Object[])new Object[0]));
                }
                String url = AllInvoiceUrl.updateInvoiceStatus(token);
                respStr = HttpServiceHelper.doPost_noVerify(ResManager.loadKDString((String)"\u4fee\u6539\u53d1\u7968\u72b6\u6001", (String)"CommonInvoiceServiceImpl_2", (String)"fi-er-business", (Object[])new Object[0]), url, null, stdReqParamStr);
                stdResp = (UpdateInvoiceStatusStdResqParam)JSON.parseObject((String)respStr, UpdateInvoiceStatusStdResqParam.class);
                if (stdResp.getErrcode().equals("1300") && stdResp.getResponseCode() == 403) {
                    token = APIHelper.getCacheToken(request.getOrgId(), true);
                    if (StringUtils.isEmpty((CharSequence)token)) {
                        isTokenFail = true;
                        throw new KDBizException(ResManager.loadKDString((String)"\u661f\u701a\u8d39\u7528\u4e0e\u53d1\u7968\u4e91\u4ea4\u4e92\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CommonInvoiceServiceImpl_7", (String)"fi-er-business", (Object[])new Object[0]));
                    }
                    url = AllInvoiceUrl.updateInvoiceStatus(token);
                    respStr = HttpServiceHelper.doPost_noVerify(ResManager.loadKDString((String)"\u4fee\u6539\u53d1\u7968\u72b6\u6001", (String)"CommonInvoiceServiceImpl_2", (String)"fi-er-business", (Object[])new Object[0]), url, null, stdReqParamStr);
                    stdResp = (UpdateInvoiceStatusStdResqParam)JSON.parseObject((String)respStr, UpdateInvoiceStatusStdResqParam.class);
                }
            } else {
                UpdateInvoiceStatusAction updateAction = new UpdateInvoiceStatusAction(request.getOrgId(), stdReqParamStr);
                respStr = updateAction.execute();
                stdResp = (UpdateInvoiceStatusStdResqParam)JSON.parseObject((String)respStr, UpdateInvoiceStatusStdResqParam.class);
            }
            String errcode = stdResp.getErrcode();
            result.setErrcode(errcode);
            boolean success = result.isSuccess();
            if (isAsync && !success) {
                result.setErrcode("0000");
            }
            AsyncLogUtil.writeAsyncLog(billOperationInfo, reqTime, invoiceCloudOperEnum, stdReqParamStr, respStr, success);
            return result;
        }
        catch (Exception e) {
            String errMsg = isTokenFail ? String.format(ResManager.loadKDString((String)"\u83b7\u53d6token\u5931\u8d25\uff1a%1$s\u3002", (String)"CommonInvoiceServiceImpl_12", (String)"fi-er-business", (Object[])new Object[0]), "") : ThrowableHelper.toString((Exception)e);
            AsyncLogUtil.writeAsyncLog(billOperationInfo, reqTime, invoiceCloudOperEnum, stdReqParamStr, errMsg, false);
            if (isAsync) {
                result.setErrcode("0000");
                return result;
            }
            throw e;
        }
    }

    @Override
    public DeleteInvoiceRespParam deleteInvoicesByBillId(DeleteInvoiceReqParam request) throws InvoiceCloudException {
        DeleteInvoiceStdReqParam stdReqParam = new DeleteInvoiceStdReqParam();
        stdReqParam.setBillNumber(request.getBillId());
        Date reqTime = new Date();
        InvoiceCloudOperEnum invoiceCloudOperEnum = InvoiceCloudOperEnum.delete;
        String stdReqParamStr = JSON.toJSONString((Object)stdReqParam);
        BillOperationInfo billOperationInfo = request.getBillOperationInfo();
        DeleteInvoiceRespParam result = new DeleteInvoiceRespParam();
        boolean isAsync = billOperationInfo != null && billOperationInfo.isAsync();
        boolean isTokenFail = false;
        try {
            DeleteInvoiceStdRespParam stdResp;
            String respStr;
            String invoiceSwitch = ErStdConfig.get("invoice.switch");
            if (StringUtils.equals((CharSequence)"old", (CharSequence)invoiceSwitch)) {
                String token = APIHelper.getCacheToken(request.getOrgId(), false);
                if (StringUtils.isEmpty((CharSequence)token)) {
                    isTokenFail = true;
                    throw new KDBizException(ResManager.loadKDString((String)"\u661f\u701a\u8d39\u7528\u4e0e\u53d1\u7968\u4e91\u4ea4\u4e92\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CommonInvoiceServiceImpl_7", (String)"fi-er-business", (Object[])new Object[0]));
                }
                String url = AllInvoiceUrl.delAction(token);
                respStr = HttpServiceHelper.doPost_noVerify(ResManager.loadKDString((String)"\u5220\u9664\u5355\u636e\u7ed1\u5b9a\u7684\u53d1\u7968\u3002", (String)"CommonInvoiceServiceImpl_3", (String)"fi-er-business", (Object[])new Object[0]), url, null, stdReqParamStr);
                stdResp = (DeleteInvoiceStdRespParam)JSON.parseObject((String)respStr, DeleteInvoiceStdRespParam.class);
                String errCode = stdResp.getErrcode();
                int responseCode = stdResp.getResponseCode();
                if (StringUtils.equals((CharSequence)errCode, (CharSequence)"1300") && responseCode == 403) {
                    logger.info("\u3010\u53d1\u7968\u4e91\u3011token " + token + " \u5931\u6548\u6216\u8fc7\u671f\uff0c\u5c1d\u8bd5\u91cd\u65b0\u83b7\u53d6token");
                    token = APIHelper.getCacheToken(request.getOrgId(), true);
                    if (StringUtils.isEmpty((CharSequence)token)) {
                        isTokenFail = true;
                        throw new KDBizException(ResManager.loadKDString((String)"\u661f\u701a\u8d39\u7528\u4e0e\u53d1\u7968\u4e91\u4ea4\u4e92\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CommonInvoiceServiceImpl_7", (String)"fi-er-business", (Object[])new Object[0]));
                    }
                    url = AllInvoiceUrl.delAction(token);
                    respStr = HttpServiceHelper.doPost_noVerify(ResManager.loadKDString((String)"\u5220\u9664\u5355\u636e\u7ed1\u5b9a\u7684\u53d1\u7968\u3002", (String)"CommonInvoiceServiceImpl_3", (String)"fi-er-business", (Object[])new Object[0]), url, null, stdReqParamStr);
                    stdResp = (DeleteInvoiceStdRespParam)JSON.parseObject((String)respStr, DeleteInvoiceStdRespParam.class);
                }
            } else {
                DelAction delAction = new DelAction(request.getOrgId(), stdReqParamStr);
                respStr = delAction.execute();
                stdResp = (DeleteInvoiceStdRespParam)JSON.parseObject((String)respStr, DeleteInvoiceStdRespParam.class);
            }
            String errCode = stdResp.getErrcode();
            result.setErrcode(errCode);
            boolean success = result.isSuccess();
            AsyncLogUtil.writeAsyncLog(billOperationInfo, reqTime, invoiceCloudOperEnum, stdReqParamStr, respStr, success);
            if (isAsync && !success) {
                result.setErrcode("0000");
            }
            return result;
        }
        catch (Exception e) {
            String errMsg = null;
            errMsg = isTokenFail ? String.format(ResManager.loadKDString((String)"\u83b7\u53d6token\u5931\u8d25\uff1a%1$s\u3002", (String)"CommonInvoiceServiceImpl_12", (String)"fi-er-business", (Object[])new Object[0]), "") : ThrowableHelper.toString((Exception)e);
            AsyncLogUtil.writeAsyncLog(billOperationInfo, reqTime, invoiceCloudOperEnum, stdReqParamStr, errMsg, false);
            if (isAsync) {
                result.setErrcode("0000");
                return result;
            }
            throw e;
        }
    }

    @Override
    public ValidateInvocieRespParam validateInvocieBySerialNo(ValidateInvocieReqParam request) throws InvoiceCloudException {
        ValidateInvoiceRespParam validateResult;
        ValidateInvocieRespParam result = new ValidateInvocieRespParam();
        if (ErStdConfig.isDev()) {
            result.setPass(true);
            InvoiceVO invoiceVO = new InvoiceVO();
            invoiceVO.setSerialNo("abc");
            result.setInvoiceVO(invoiceVO);
            return result;
        }
        ValidateInvoiceReqParam validateInvoiceReqParam = new ValidateInvoiceReqParam();
        InvoiceCloudCfgBO config = request.getInvoiceCompanyId() != null ? KingdeeInvoiceCloudConfig.getConfig(request.getInvoiceCompanyId()) : KingdeeInvoiceCloudConfig.getConfig(request.getTaxRegNum());
        validateInvoiceReqParam.setClientId(config.getClientId());
        validateInvoiceReqParam.setCheckBuyerName(config.getFirmname());
        validateInvoiceReqParam.setCheckBuyerTaxNo(config.getTaxRegnum());
        validateInvoiceReqParam.setExpenseId(request.getBillId());
        validateInvoiceReqParam.setSerialNo(request.getSerialNo());
        validateInvoiceReqParam.setTicketParam(config.genTicketParam());
        String invoiceSwitch = ErStdConfig.get("invoice.switch");
        if (StringUtils.equals((CharSequence)"old", (CharSequence)invoiceSwitch)) {
            String token = APIHelper.getCacheToken(config.getInvoiceOrgId(), false);
            String url = AllInvoiceUrl.validate(token);
            String respStr = HttpServiceHelper.doPost_noVerify(ResManager.loadKDString((String)"\u67e5\u9a8c\u53d1\u7968", (String)"CommonInvoiceServiceImpl_4", (String)"fi-er-business", (Object[])new Object[0]), url, null, JSON.toJSONString((Object)validateInvoiceReqParam));
            validateResult = (ValidateInvoiceRespParam)JSON.parseObject((String)respStr, ValidateInvoiceRespParam.class);
            String errCode = validateResult.getErrcode();
            int responseCode = validateResult.getResponseCode();
            if (StringUtils.equals((CharSequence)errCode, (CharSequence)"1300") && responseCode == 403) {
                logger.info("\u3010\u53d1\u7968\u4e91\u3011token" + token + "\u5931\u6548\u6216\u8fc7\u671f\uff0c\u5c1d\u8bd5\u91cd\u65b0\u83b7\u53d6token\u3002");
                token = APIHelper.getCacheToken(config.getInvoiceOrgId(), true);
                url = AllInvoiceUrl.validate(token);
                respStr = HttpServiceHelper.doPost_noVerify(ResManager.loadKDString((String)"\u67e5\u9a8c\u53d1\u7968", (String)"CommonInvoiceServiceImpl_4", (String)"fi-er-business", (Object[])new Object[0]), url, null, JSON.toJSONString((Object)validateInvoiceReqParam));
                validateResult = (ValidateInvoiceRespParam)JSON.parseObject((String)respStr, ValidateInvoiceRespParam.class);
            }
        } else {
            ValidateAction validateAction = new ValidateAction(request.getInvoiceCompanyId(), JSON.toJSONString((Object)validateInvoiceReqParam));
            String respStr = validateAction.execute();
            validateResult = (ValidateInvoiceRespParam)JSON.parseObject((String)respStr, ValidateInvoiceRespParam.class);
        }
        String errCode = validateResult.getErrcode();
        result.setPass(StringUtils.equals((CharSequence)errCode, (CharSequence)"0000"));
        result.setMsg(validateResult.getDescription());
        if (result.isPass()) {
            InvoiceVO invoiceVO = new InvoiceVO();
            invoiceVO.setSerialNo(validateResult.getData().getSerialNo());
            result.setInvoiceVO(invoiceVO);
        }
        return result;
    }

    @Override
    public SaveVoucherResp saveVoucher(SaveVoucherRequestParam request) {
        String response;
        List<String> expenseIdArray = request.getExpenseIdArray();
        if (expenseIdArray != null && !expenseIdArray.isEmpty()) {
            for (int i = 0; i < expenseIdArray.size(); ++i) {
                expenseIdArray.set(i, request.getEntityName() + "_" + expenseIdArray.get(i));
            }
        }
        String requestStr = JSON.toJSONString((Object)request);
        logger.info("\u901a\u77e5\u53d1\u7968\u4e91\u4fdd\u5b58\u51ed\u8bc1, \u8bf7\u6c42\u53c2\u6570\uff1a {}", (Object)requestStr);
        Long invoiceOrgId = request.getInvoiceOrgId();
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(invoiceOrgId);
        if (config == null) {
            logger.debug("{}\u8be5\u8d39\u7528\u627f\u62c5\u516c\u53f8\u672a\u542f\u7528\u53d1\u7968\u4e91", (Object)invoiceOrgId);
            return null;
        }
        logger.info("\u3010\u53d1\u7968\u4e91\u3011aws: \u4fdd\u5b58\u51ed\u8bc1\u524d\u5148\u5220\u9664\u51ed\u8bc1\u3002");
        DeleteVoucherRequestParam delRequest = new DeleteVoucherRequestParam();
        delRequest.setVouchId(request.getVoucherInfo().getVouchId());
        delRequest.setExpenseIdArray(new ArrayList<String>(request.getExpenseIdArray()));
        delRequest.setInvoiceOrgId(request.getInvoiceOrgId());
        delRequest.setEntityName(request.getEntityName());
        DeleteVoucherResp deleteResp = this.deleteVoucher(delRequest);
        if (!"0000".equals(deleteResp.getErrcode())) {
            return new SaveVoucherResp(deleteResp.getErrcode(), deleteResp.getDescription());
        }
        String invoiceSwitch = ErStdConfig.get("invoice.switch");
        if (StringUtils.equals((CharSequence)"old", (CharSequence)invoiceSwitch)) {
            String token = APIHelper.getCacheToken(invoiceOrgId, false);
            String url = AllInvoiceUrl.getSaveVoucherUrl(token);
            response = HttpServiceHelper.doPost_noVerify(ResManager.loadKDString((String)"\u51ed\u8bc1\u4fdd\u5b58\u65f6\u901a\u77e5\u53d1\u7968\u4e91", (String)"CommonInvoiceServiceImpl_5", (String)"fi-er-business", (Object[])new Object[0]), url, null, requestStr);
            JSONObject responseJsonObject = JSON.parseObject((String)response);
            Integer responseCode = responseJsonObject.getInteger("responseCode");
            String errCode = responseJsonObject.getString("errcode");
            if (errCode.equals("1300") && responseCode == 403) {
                logger.info("\u3010\u53d1\u7968\u4e91\u3011\u91cd\u65b0\u83b7\u53d6token\u4fdd\u5b58\u51ed\u8bc1\u3002");
                token = APIHelper.getCacheToken(invoiceOrgId, true);
                url = AllInvoiceUrl.getSaveVoucherUrl(token);
                response = HttpServiceHelper.doPost_noVerify(ResManager.loadKDString((String)"\u51ed\u8bc1\u4fdd\u5b58\u65f6\u901a\u77e5\u53d1\u7968\u4e91", (String)"CommonInvoiceServiceImpl_5", (String)"fi-er-business", (Object[])new Object[0]), url, null, requestStr);
            }
            logger.info("\u3010\u53d1\u7968\u4e91\u3011\u4fdd\u5b58\u51ed\u8bc1response\uff1a" + response);
        } else {
            SaveVouchAction saveVouchAction = new SaveVouchAction(invoiceOrgId, requestStr);
            response = saveVouchAction.execute();
        }
        SaveVoucherResp saveVoucherResp = (SaveVoucherResp)JSON.parseObject((String)response, SaveVoucherResp.class);
        return saveVoucherResp;
    }

    @Override
    public DeleteVoucherResp deleteVoucher(DeleteVoucherRequestParam request) {
        String response;
        List<String> expenseIdArray = request.getExpenseIdArray();
        if (expenseIdArray != null && !expenseIdArray.isEmpty()) {
            for (int i = 0; i < expenseIdArray.size(); ++i) {
                expenseIdArray.set(i, request.getEntityName() + "_" + expenseIdArray.get(i));
            }
        }
        String requestStr = JSON.toJSONString((Object)request);
        logger.info("\u3010\u53d1\u7968\u4e91\u3011\u901a\u77e5\u53d1\u7968\u4e91\u5220\u9664\u51ed\u8bc1, \u8bf7\u6c42\u53c2\u6570\uff1a {}", (Object)requestStr);
        Long invoiceOrgId = request.getInvoiceOrgId();
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig(invoiceOrgId);
        if (config == null) {
            logger.debug("{}-\u8be5\u8d39\u7528\u627f\u62c5\u516c\u53f8\u672a\u542f\u7528\u53d1\u7968\u4e91", (Object)invoiceOrgId);
            return null;
        }
        String invoiceSwitch = ErStdConfig.get("invoice.switch");
        if (StringUtils.equals((CharSequence)"old", (CharSequence)invoiceSwitch)) {
            String token = APIHelper.getCacheToken(invoiceOrgId, false);
            String url = AllInvoiceUrl.getDeleteVoucherUrl(token);
            response = HttpServiceHelper.doPost_noVerify(ResManager.loadKDString((String)"\u51ed\u8bc1\u5220\u9664\u65f6\u901a\u77e5\u53d1\u7968\u4e91", (String)"CommonInvoiceServiceImpl_6", (String)"fi-er-business", (Object[])new Object[0]), url, null, requestStr);
            JSONObject responseJsonObject = JSON.parseObject((String)response);
            Integer responseCode = responseJsonObject.getInteger("responseCode");
            String errCode = responseJsonObject.getString("errcode");
            if (errCode.equals("1300") && responseCode == 403) {
                logger.info("\u3010\u53d1\u7968\u4e91\u3011\u91cd\u65b0\u83b7\u53d6token\u901a\u77e5\u53d1\u7968\u4e91\u5220\u9664\u51ed\u8bc1\u3002");
                token = APIHelper.getCacheToken(invoiceOrgId, true);
                url = AllInvoiceUrl.getDeleteVoucherUrl(token);
                response = HttpServiceHelper.doPost_noVerify(ResManager.loadKDString((String)"\u51ed\u8bc1\u5220\u9664\u65f6\u901a\u77e5\u53d1\u7968\u4e91", (String)"CommonInvoiceServiceImpl_6", (String)"fi-er-business", (Object[])new Object[0]), url, null, requestStr);
            }
            logger.info("\u3010\u53d1\u7968\u4e91\u3011\u5220\u9664\u51ed\u8bc1response\uff1a" + response);
        } else {
            DelVouchAction delVouchAction = new DelVouchAction(invoiceOrgId, requestStr);
            response = delVouchAction.execute();
        }
        DeleteVoucherResp deleteVoucherResp = (DeleteVoucherResp)JSON.parseObject((String)response, DeleteVoucherResp.class);
        return deleteVoucherResp;
    }
}

