/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.util;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.HeadInvoiceStatus;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.invoicecloud.util.InvoiceTypeUtils;
import kd.fi.er.business.invoicecloud.v2.InvoiceFrom;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.SettlementTypeEnum;

public class HeadInvoiceStatusUtil {
    private static final Log logger = LogFactory.getLog(HeadInvoiceStatusUtil.class);

    public static void needScanSetting(DynamicObject dataEntity) {
        String status = HeadInvoiceStatus.OTHER.getValue();
        if (dataEntity.getDynamicObjectType().getProperties().get((Object)"is_all_einvoice") != null) {
            DynamicObjectCollection invoiceEntries = dataEntity.getDynamicObjectCollection("invoiceentry");
            if (!invoiceEntries.isEmpty()) {
                List list = invoiceEntries.stream().filter(entry -> InvoiceFrom.InvoiceCloud.equalsFrom(entry.getString("invoicefrom"))).collect(Collectors.toList());
                if (!list.isEmpty()) {
                    Set<String> types = InvoiceTypeUtils.loadEInvoiceTypes();
                    if (types.isEmpty()) {
                        logger.info("\u53d1\u7968\u7c7b\u578b\u4e2d\u65e0\u7535\u7968\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002");
                    } else {
                        boolean allMatch = list.stream().allMatch(entry -> types.contains(entry.getString("invoicetype")));
                        status = allMatch ? HeadInvoiceStatus.IS_ALL_EINVOICE.getValue() : HeadInvoiceStatus.IS_NOT_ALL_EINVOICE.getValue();
                    }
                }
            } else {
                Boolean noInvoice = ErStdConfig.getBoolean("HeadInvoiceStatus.NoInvoice");
                if (noInvoice.booleanValue()) {
                    status = HeadInvoiceStatus.NO_INVOICE.getValue();
                }
            }
        }
        String billNo = dataEntity.getString("billno");
        logger.info("\u5355\u636e\uff1a" + billNo + "\uff0c\u53d1\u7968\u72b6\u6001\uff1a" + status + "\uff0c\u5355\u5934\u65e0\u7968\uff1a" + dataEntity.getBoolean("noinvoice"));
        boolean isNoInvoice = true;
        boolean isOther = HeadInvoiceStatus.OTHER.getValue().equals(status);
        if (isOther && dataEntity.getDynamicObjectType().getProperties().get((Object)"noinvoice") != null) {
            DynamicObjectCollection itemEntry;
            if (dataEntity.getDynamicObjectType().getProperties().get((Object)"tripentry") != null) {
                DynamicObjectCollection tripEntries = dataEntity.getDynamicObjectCollection("tripentry");
                if (!tripEntries.isEmpty()) {
                    block0: for (DynamicObject tripEntry : tripEntries) {
                        DynamicObjectCollection itemEntries = tripEntry.getDynamicObjectCollection("entryentity");
                        for (DynamicObject item : itemEntries) {
                            DynamicObject expenseItem;
                            String itemFrom = item.getString("itemfrom");
                            String settlementType = item.getString("settlementtype");
                            if (SettlementTypeEnum.MONTH_SETTLEMENT.getCode().equals(settlementType) || ItemFrom.OCR.equalsFrom(itemFrom) || ItemFrom.TripBusiness.equalsFrom(itemFrom) || (expenseItem = item.getDynamicObject("expenseitem")) == null || expenseItem.getBoolean("noinvoice")) continue;
                            isNoInvoice = false;
                            logger.info(String.format("\u5355\u636e\uff1a%s \uff0c\u5b58\u5728\u65e0\u7968\u4e3a\u5426\u7684\u5dee\u65c5\u9879\u76ee\uff1a%s", billNo, expenseItem));
                            continue block0;
                        }
                    }
                }
            } else if (dataEntity.getDynamicObjectType().getProperties().get((Object)"expenseentryentity") != null && !(itemEntry = dataEntity.getDynamicObjectCollection("expenseentryentity")).isEmpty()) {
                for (DynamicObject item : itemEntry) {
                    DynamicObject expenseItem;
                    String itemFrom = item.getString("itemfrom");
                    if (ItemFrom.OCR.equalsFrom(itemFrom) || ItemFrom.TripBusiness.equalsFrom(itemFrom) || (expenseItem = item.getDynamicObject("expenseitem")) == null || expenseItem.getBoolean("noinvoice")) continue;
                    isNoInvoice = false;
                    logger.info(String.format("\u5355\u636e\uff1a%s \uff0c\u5b58\u5728\u65e0\u7968\u4e3a\u5426\u7684\u8d39\u7528\u9879\u76ee\uff1a%s", billNo, expenseItem));
                    break;
                }
            }
            if (isNoInvoice) {
                logger.info(String.format("\u5355\u636e\uff1a%s \u662f\u65e0\u7968\u5355\u636e", billNo));
                status = HeadInvoiceStatus.NO_INVOICE.getValue();
            }
        }
        dataEntity.set("is_all_einvoice", (Object)status);
        DynamicObject company = dataEntity.getDynamicObject("company");
        boolean isMapInvoiceCloudImage = false;
        if (company != null) {
            Long companyId = (Long)company.getPkValue();
            isMapInvoiceCloudImage = SystemParamterUtil.isMapInvoiceCloudImage(companyId);
        }
        Boolean fieldExist = dataEntity.getDynamicObjectType().getProperty("needuploadinvoice") != null;
        Boolean needUploadInvoice = false;
        if (fieldExist.booleanValue() && null == (needUploadInvoice = Boolean.valueOf(dataEntity.getBoolean("needuploadinvoice")))) {
            needUploadInvoice = false;
        }
        if (ErCommonUtils.isNeedImageScan(isMapInvoiceCloudImage, company, dataEntity.getBoolean("noinvoice"), status, needUploadInvoice)) {
            dataEntity.set("needimagescan", (Object)Character.valueOf('1'));
        } else {
            dataEntity.set("needimagescan", (Object)Character.valueOf('2'));
        }
    }
}

