/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.invoicecloud.MetaDataInvoiceTypeEntryEnum;
import kd.fi.er.business.invoicecloud.util.InvoiceTypeUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.common.EntityTypeEnum;

public class InvoiceTypeComboBoxUtil {
    private static String ER_INVOICE_TYPE = "er_invoicetype";

    private InvoiceTypeComboBoxUtil() {
    }

    public static void constructFormInvoiceTypeComboBox(IDataModel model, IFormView view) {
        String entityId = InvoiceTypeComboBoxUtil.getEntityId(view.getEntityId());
        List<MetaDataInvoiceTypeEntryEnum> invoiceTypeNode = MetaDataInvoiceTypeEntryEnum.getInvoiceTypeNode(entityId);
        if (invoiceTypeNode.isEmpty()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5143\u6570\u636e\u672a\u8bbe\u7f6e\u53d1\u7968\u7c7b\u578b\uff0c\u8bf7\u8bbe\u7f6e\u53d1\u7968\u7c7b\u578b\u4e3a\u57fa\u7840\u8d44\u6599\u3010\u53d1\u7968\u7c7b\u578b(\u53d1\u7968\u4e91)\u3011\uff0c\u5e76\u5173\u95edInvoiceTypeComboBoxPlugin\u63d2\u4ef6\u3002", (String)"InvoiceTypeComboBoxUtil_1", (String)"fi-er-business", (Object[])new Object[0]));
        }
        List loadInvoiceTypesComboItems = InvoiceTypeComboBoxUtil.loadInvoiceTypesComboItems(1);
        for (MetaDataInvoiceTypeEntryEnum metaData : invoiceTypeNode) {
            ComboEdit comboEdit = (ComboEdit)view.getControl(metaData.getFieldName());
            if (comboEdit == null) continue;
            comboEdit.setComboItems(loadInvoiceTypesComboItems);
        }
    }

    public static void constructListFilterInvoiceTypeComboBox(IDataModel model, IFormView view, List<FilterColumn> filterColumns) {
        String entityId = view instanceof ListView ? InvoiceTypeComboBoxUtil.getEntityId(((ListView)view).getBillFormId()) : InvoiceTypeComboBoxUtil.getEntityId(view.getEntityId());
        List<MetaDataInvoiceTypeEntryEnum> invoiceTypeNode = MetaDataInvoiceTypeEntryEnum.getInvoiceTypeNode(entityId);
        if (invoiceTypeNode.isEmpty()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5143\u6570\u636e\u672a\u8bbe\u7f6e\u53d1\u7968\u7c7b\u578b\uff0c\u8bf7\u8bbe\u7f6e\u53d1\u7968\u7c7b\u578b\u4e3a\u57fa\u7840\u8d44\u6599\u3010\u53d1\u7968\u7c7b\u578b(\u53d1\u7968\u4e91)\u3011\uff0c\u5e76\u5173\u95edInvoiceTypeComboBoxPlugin\u63d2\u4ef6\u3002", (String)"InvoiceTypeComboBoxUtil_1", (String)"fi-er-business", (Object[])new Object[0]));
        }
        for (MetaDataInvoiceTypeEntryEnum metaData : invoiceTypeNode) {
            Optional<FilterColumn> first = filterColumns.stream().filter(column -> column.getFieldName().equals(metaData.getFieldName())).findFirst();
            if (!first.isPresent()) continue;
            if (first.get().getClass().isAssignableFrom(CommonFilterColumn.class)) {
                ((CommonFilterColumn)first.get()).setComboItems(InvoiceTypeComboBoxUtil.loadInvoiceTypesComboItems(1));
                continue;
            }
            if (!first.get().getClass().isAssignableFrom(SchemeFilterColumn.class)) continue;
            ((SchemeFilterColumn)first.get()).setComboItems(InvoiceTypeComboBoxUtil.loadInvoiceTypesComboItems(1));
        }
    }

    public static List loadInvoiceTypesComboItems(int returnType) {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        QFilter nullFilter = new QFilter("number", "!=", (Object)"0");
        DynamicObjectCollection values = InvoiceTypeUtils.loadInvoiceTypes(new QFilter[]{qFilter, nullFilter});
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(values.size());
        for (DynamicObject type : values) {
            LocaleString cn;
            ComboItem item;
            if (returnType == 1) {
                item = new ComboItem();
                item.setValue(type.getString("number"));
                cn = new LocaleString();
                cn.setLocaleValue(String.valueOf(type.get("name")));
                item.setCaption(cn);
                item.setItemVisible(true);
                comboItems.add(item);
                continue;
            }
            if (returnType != 2) continue;
            item = new ValueMapItem();
            item.setValue(type.getString("number"));
            cn = new LocaleString();
            cn.setLocaleValue(String.valueOf(type.get("name")));
            item.setName(cn);
            item.setItemVisible(true);
            comboItems.add(item);
        }
        return comboItems;
    }

    public static Map<String, ComboItem> loadInvoiceTypesComboItemsMap() {
        return InvoiceTypeComboBoxUtil.loadInvoiceTypesComboItems(1).stream().collect(Collectors.toMap(item -> item.getValue(), item -> item));
    }

    private static String getEntityId(String entityId) {
        EntityTypeEnum entityType = ErEntityTypeUtils.getEntityType(entityId);
        if (entityType != null) {
            return entityType.getEntityIds()[0];
        }
        return entityId;
    }
}

