/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService.CreateEntryService;
import kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService.CreateExpenseItemEntryServiceImpl;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.model.invoice.bo.ExpenseEntryBO;
import org.apache.commons.lang3.ObjectUtils;

public class CreateExpenseItemEntryForMobServiceImpl
extends CreateEntryService {
    private static final Log log = LogFactory.getLog(CreateExpenseItemEntryServiceImpl.class);
    public static final String EXPENSE_ITEM_ENTRY = "expenseentryentity";
    private IDataModel pDataModel;

    public CreateExpenseItemEntryForMobServiceImpl(InvoiceContext invoiceContext, IDataModel dataModel, IDataModel pDataModel) {
        super(invoiceContext);
        this.dataModel = dataModel;
        this.pDataModel = pDataModel;
    }

    public CreateExpenseItemEntryForMobServiceImpl(InvoiceContext invoiceContext, IDataModel dataModel, IDataModel pDataModel, DynamicObject curSelectedItem) {
        this(invoiceContext, dataModel, pDataModel);
        this.curSelectedItem = curSelectedItem;
        this.isOrgOffset = invoiceContext.getInvoiceConfig().isOrgOffset();
    }

    @Deprecated
    public CreateExpenseItemEntryForMobServiceImpl(InvoiceContext invoiceContext, IDataModel dataModel, IDataModel pDataModel, DynamicObject curSelectedItem, boolean isOrgOffset) {
        this(invoiceContext, dataModel, pDataModel);
        this.curSelectedItem = curSelectedItem;
        this.isOrgOffset = isOrgOffset;
    }

    @Override
    public void process() {
        List<ExpenseEntryBO> expenseEntryBOs = this.invoiceContext.getExpenseEntryBOs();
        if (expenseEntryBOs.size() <= 0) {
            log.info("\u672a\u5bfc\u5165\u4efb\u4f55\u6709\u6548\u53d1\u7968");
            return;
        }
        List expenseEntryExcludeZeroBOs = expenseEntryBOs.stream().filter(entry -> entry.getTotalAmount().abs().compareTo(BigDecimal.valueOf(1.0E-6)) > 0).collect(Collectors.toList());
        DynamicObjectCollection expenseEntry = this.dataModel.getDataEntity(true).getDynamicObjectCollection(EXPENSE_ITEM_ENTRY);
        HashMap<Long, Integer> rowIndexByEntryId = new HashMap<Long, Integer>(expenseEntry.size());
        for (int i = 0; i < expenseEntry.size(); ++i) {
            rowIndexByEntryId.put(((DynamicObject)expenseEntry.get(i)).getLong("id"), i);
        }
        expenseEntryExcludeZeroBOs.sort((entry1, entry2) -> ((Date)ObjectUtils.defaultIfNull((Object)entry1.getHappenDate(), (Object)ErCommonUtils.getDateFromLocalDate(LocalDate.now()))).compareTo(entry2.getHappenDate()));
        for (ExpenseEntryBO expenseEntryBO : expenseEntryExcludeZeroBOs) {
            int rowIndex = rowIndexByEntryId.containsKey(expenseEntryBO.getEntryId()) ? ((Integer)rowIndexByEntryId.get(expenseEntryBO.getEntryId())).intValue() : this.dataModel.createNewEntryRow(EXPENSE_ITEM_ENTRY);
            this.genExpenseItemEntry(this.invoiceContext, expenseEntryBO, rowIndex, -1);
        }
    }

    @Override
    protected void createExpenseItemEntry(ExpenseEntryBO expenseEntryBO, int rowIndex, int parentIndex) {
        DynamicObject entrycostcompanyDO;
        log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011CreateExpenseItemEntryForMobServiceImpl \u8d39\u7528\u660e\u7ec6\u4fe1\u606f: " + expenseEntryBO + "\uff0c rowIndex\uff1a" + rowIndex + ", parentIndex\uff1a" + parentIndex);
        DynamicObject expenseEntryDO = (DynamicObject)this.dataModel.getEntryEntity(EXPENSE_ITEM_ENTRY).get(rowIndex);
        expenseEntryDO.set("id", (Object)expenseEntryBO.getEntryId());
        this.dataModel.setValue("itemfrom", (Object)ItemFrom.InvoiceCloud.getValue(), rowIndex);
        this.dataModel.setValue("invoicetypeitem", (Object)expenseEntryBO.getInvoiceType(), rowIndex);
        this.dataModel.setValue("happendate", (Object)expenseEntryBO.getHappenDate(), rowIndex);
        this.dataModel.setValue("expenseitem", (Object)expenseEntryBO.getExpenseItemId(), rowIndex);
        if (this.curSelectedItem != null) {
            this.copyItem(rowIndex, expenseEntryBO);
        }
        this.dataModel.setValue("entrycurrency", (Object)expenseEntryBO.getEntryCurrencyId(), rowIndex);
        Map<String, Object> exchangeMap = AmountChangeUtil.getCurrentEntryExchangeRate(expenseEntryBO.getEntryCurrencyId(), this.dataModel);
        String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeMap.get("quoteType")), (Object)"0");
        BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeMap.get("exchangeRate")), (Object)BigDecimal.ONE);
        if (this.dataModel.getProperty("expquotetype") != null) {
            this.dataModel.setValue("expquotetype", (Object)quoteType, rowIndex);
        }
        this.dataModel.setValue("exchangerate", (Object)exchangeRate, rowIndex);
        this.dataModel.setValue("expenseamount", (Object)expenseEntryBO.getTotalAmount(), rowIndex);
        this.dataModel.setValue("expeapproveamount", (Object)expenseEntryBO.getTotalAmount(), rowIndex);
        this.dataModel.setValue("airportconstructionfee", (Object)expenseEntryBO.getAirportConstructionFee(), rowIndex);
        DynamicObject entrycostdeptDO = (DynamicObject)this.dataModel.getValue("entrycostdept", rowIndex);
        if (entrycostdeptDO == null) {
            this.dataModel.setValue("entrycostdept", (Object)ErCommonUtils.getPk(this.pDataModel.getValue("costdept")), rowIndex);
        }
        if ((entrycostcompanyDO = (DynamicObject)this.dataModel.getValue("entrycostcompany", rowIndex)) == null) {
            this.dataModel.setValue("entrycostcompany", (Object)ErCommonUtils.getPk(this.pDataModel.getValue("costcompany")), rowIndex);
        }
        if (!this.isOrgOffset) {
            this.dataModel.setValue("taxrate", (Object)BigDecimal.ZERO, rowIndex);
            this.dataModel.setValue("taxamount", (Object)BigDecimal.ZERO, rowIndex);
            this.dataModel.setValue("orientryamount", (Object)expenseEntryBO.getTotalAmount(), rowIndex);
        } else {
            this.dataModel.setValue("taxrate", (Object)expenseEntryBO.getTaxRate().multiply(BigDecimal.valueOf(100L)), rowIndex);
            this.dataModel.setValue("taxamount", (Object)expenseEntryBO.getTaxAmount(), rowIndex);
            this.dataModel.setValue("orientryamount", (Object)expenseEntryBO.getNotIncludeTaxAmount(), rowIndex);
        }
        this.dataModel.setValue("is_special_invoice", (Object)expenseEntryBO.getIsSpecialInvoice(), rowIndex);
        this.dataModel.setValue("taxclasscode", (Object)expenseEntryBO.getTaxClassCodeId(), rowIndex);
        this.dataModel.setValue("invoicelink", (Object)InvoiceUtils.getLimitedInvoiceCode(expenseEntryBO.getInvoiceCodeUnion()), rowIndex);
        this.dataModel.setValue("invoiceno_entry", (Object)InvoiceUtils.getLimitedInvoiceNo(expenseEntryBO.getInvoiceNoUnion()), rowIndex);
        IDataEntityProperty goodsNameProp = this.dataModel.getProperty("expensegoodsname");
        if (goodsNameProp != null) {
            this.dataModel.setValue("expensegoodsname", (Object)expenseEntryBO.getGoodName(), rowIndex);
        }
        boolean isOffset = expenseEntryBO.getIsOffset() != false && this.isOrgOffset;
        this.dataModel.beginInit();
        this.dataModel.setValue("offset", (Object)(!isOffset ? 1 : 0), rowIndex);
        this.dataModel.endInit();
        this.dataModel.setValue("offset", (Object)isOffset, rowIndex);
        this.dataModel.setValue("deductibletax", (Object)expenseEntryBO.getOffsetAmount(), rowIndex);
        this.dataModel.setValue("remark", (Object)expenseEntryBO.getRemark(), rowIndex);
    }

    private void copyItem(int rowIndex, ExpenseEntryBO expenseEntryBO) {
        this.dataModel.setValue("entrycostcompany", (Object)ErCommonUtils.getPk(this.curSelectedItem.get("entrycostcompany")), rowIndex);
        this.dataModel.setValue("entrycostdept", (Object)ErCommonUtils.getPk(this.curSelectedItem.get("entrycostdept")), rowIndex);
        this.dataModel.setValue("std_project", (Object)ErCommonUtils.getPk(this.curSelectedItem.get("std_project")), rowIndex);
    }
}

