/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService.CreateEntryService;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.model.invoice.bo.ExpenseEntryBO;
import kd.fi.er.formplugin.web.tripstandard.util.PlaneSeatUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class CreateTripItemEntryServiceImplForMob
extends CreateEntryService {
    private static final Log log = LogFactory.getLog(CreateTripItemEntryServiceImplForMob.class);

    public CreateTripItemEntryServiceImplForMob(InvoiceContext invoiceContext, IDataModel dataModel) {
        super(invoiceContext);
        this.dataModel = dataModel;
        this.isOrgOffset = invoiceContext.getInvoiceConfig().isOrgOffset();
    }

    @Deprecated
    public CreateTripItemEntryServiceImplForMob(InvoiceContext invoiceContext, IDataModel dataModel, boolean isOrgOffset) {
        this(invoiceContext, dataModel);
        this.isOrgOffset = isOrgOffset;
    }

    @Override
    public void process() {
        List<ExpenseEntryBO> expenseEntryBOs = this.invoiceContext.getExpenseEntryBOs();
        if (expenseEntryBOs.size() <= 0) {
            log.info("\u672a\u5bfc\u5165\u4efb\u4f55\u6709\u6548\u53d1\u7968");
            return;
        }
        List expenseEntryExcludeZeroBOs = expenseEntryBOs.stream().filter(entry -> entry.getTotalAmount().abs().compareTo(BigDecimal.valueOf(1.0E-6)) > 0).collect(Collectors.toList());
        for (int i = 0; i < expenseEntryExcludeZeroBOs.size(); ++i) {
            this.genExpenseItemEntry(this.invoiceContext, (ExpenseEntryBO)expenseEntryExcludeZeroBOs.get(i), -1, -1);
        }
    }

    @Override
    protected void createExpenseItemEntry(ExpenseEntryBO expenseEntryBO, int rowIndex, int parentIndex) {
        DynamicObject selectExpenseitem;
        log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011CreateTripItemEntryServiceImplForMob \u5dee\u65c5\u660e\u7ec6\u4fe1\u606f: " + expenseEntryBO + "\uff0c rowIndex\uff1a" + rowIndex + ", parentIndex\uff1a" + parentIndex);
        this.dataModel.setValue("itemfrom", (Object)ItemFrom.InvoiceCloud.getValue());
        this.dataModel.setValue("invoicetypeitem", (Object)expenseEntryBO.getInvoiceType());
        this.dataModel.setValue("entrycurrency", (Object)expenseEntryBO.getEntryCurrencyId());
        Map<String, Object> exchangeMap = AmountChangeUtil.getCurrentEntryExchangeRate(expenseEntryBO.getEntryCurrencyId(), this.dataModel);
        String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeMap.get("quoteType")), (Object)"0");
        BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeMap.get("exchangeRate")), (Object)BigDecimal.ONE);
        if (this.dataModel.getProperty("detailquotetype") != null) {
            this.dataModel.setValue("detailquotetype", (Object)quoteType);
        }
        this.dataModel.setValue("exchangerate", (Object)exchangeRate);
        DynamicObject oldExpenseItemDO = (DynamicObject)this.dataModel.getValue("expenseitem");
        if (oldExpenseItemDO == null) {
            this.dataModel.setValue("expenseitem", (Object)expenseEntryBO.getExpenseItemId());
        } else {
            expenseEntryBO.setExpenseItemId((Long)oldExpenseItemDO.getPkValue());
        }
        if (expenseEntryBO.getExpenseItemId() != null && !expenseEntryBO.getExpenseItemId().equals(0L) && (selectExpenseitem = CommonServiceHelper.getObjById("er_tripexpenseitem", expenseEntryBO.getExpenseItemId())) != null) {
            this.dataModel.setValue("pic", (Object)selectExpenseitem.getString("expenseitemicon"));
        }
        this.dataModel.setValue("orientryamount", (Object)expenseEntryBO.getTotalAmount());
        AmountUtils.refreshCurrAmount(this.dataModel, expenseEntryBO.getTotalAmount(), "entryamount", "exchangerate", "entrycurrency", "detailquotetype");
        this.dataModel.setValue("airportconstructionfee", (Object)expenseEntryBO.getAirportConstructionFee());
        if (!this.isOrgOffset) {
            this.dataModel.setValue("taxrate", (Object)BigDecimal.ZERO);
            this.dataModel.setValue("taxamount", (Object)BigDecimal.ZERO);
            this.dataModel.setValue("notaxamount", (Object)expenseEntryBO.getTotalAmount());
            this.dataModel.setValue("deductibletax", (Object)BigDecimal.ZERO);
            this.dataModel.setValue("iteminoutamount", (Object)BigDecimal.ZERO);
        } else {
            this.dataModel.setValue("taxrate", (Object)expenseEntryBO.getTaxRate().multiply(BigDecimal.valueOf(100L)));
            this.dataModel.setValue("taxamount", (Object)expenseEntryBO.getTaxAmount());
            this.dataModel.setValue("notaxamount", (Object)expenseEntryBO.getNotIncludeTaxAmount());
            this.dataModel.setValue("deductibletax", (Object)expenseEntryBO.getOffsetAmount());
            this.dataModel.setValue("iteminoutamount", (Object)expenseEntryBO.getItemInOutAmount());
        }
        this.dataModel.setValue("isvactax", (Object)expenseEntryBO.getIsSpecialInvoice());
        this.dataModel.setValue("taxclasscode", (Object)expenseEntryBO.getTaxClassCodeId());
        this.dataModel.setValue("invoicelink", (Object)InvoiceUtils.getLimitedInvoiceCode(expenseEntryBO.getInvoiceCodeUnion()));
        this.dataModel.setValue("invoiceno_entry", (Object)InvoiceUtils.getLimitedInvoiceNo(expenseEntryBO.getInvoiceNoUnion()));
        this.dataModel.setValue("comment", (Object)expenseEntryBO.getRemark());
        if (this.dataModel.getProperty("mulseatgrade") != null) {
            this.genSeatGrade(expenseEntryBO);
        }
    }

    private void genSeatGrade(ExpenseEntryBO expenseEntryBO) {
        RefObject attrRef;
        DynamicObject expenseItemDO = (DynamicObject)this.dataModel.getValue("expenseitem");
        Set seatGrade = this.getSeatGradle(expenseEntryBO, expenseItemDO, (RefObject<String>)(attrRef = new RefObject()));
        if (!seatGrade.isEmpty() && StringUtils.isNotEmpty((CharSequence)((CharSequence)attrRef.getValue()))) {
            DynamicObject[] seatGradeArr = PlaneSeatUtil.findSeatByAttribute((String)attrRef.getValue(), seatGrade);
            if (seatGradeArr != null && seatGradeArr.length > 0) {
                Object[] seats = Arrays.stream(seatGradeArr).map(seat -> seat.get("id")).toArray();
                this.dataModel.setValue("mulseatgrade", (Object)seats);
            } else {
                this.dataModel.setValue("mulseatgrade", null);
            }
        }
    }
}

