/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl.createInvoiceService;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.provider.param.AfterDataModelProxy;
import kd.fi.er.business.invoicecloud.provider.param.DataModelProxy;
import kd.fi.er.business.invoicecloud.provider.param.InvoiceContextProxy;
import kd.fi.er.business.invoicecloud.provider.service.IAfterCreateInvoiceInfoService;
import kd.fi.er.business.invoicecloud.provider.service.IBeforeCreateInvoiceInfoService;
import kd.fi.er.business.invoicecloud.provider.service.factory.InvoiceServiceFactory;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.InvoiceFrom;
import kd.fi.er.business.invoicecloud.v2.service.impl.createInvoiceService.CreateInvoiceServiceI;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.model.invoice.bo.InvoiceEntryBO;
import kd.fi.er.common.model.invoice.bo.InvoiceItemEntryBO;
import org.apache.commons.lang3.StringUtils;

public class CreateInvoiceEntryServiceImpl
extends CreateInvoiceServiceI {
    private static final Log log = LogFactory.getLog(CreateInvoiceEntryServiceImpl.class);
    private IDataModel dataModel;
    private final String INVOICE_ENTRY = "invoiceentry";
    private final String INVOICE_ITEM = "invoiceitementry";
    private boolean isImportNonDeductionTaxAmount;

    public CreateInvoiceEntryServiceImpl(InvoiceContext invoiceContext, IDataModel dataModel) {
        super(invoiceContext);
        this.dataModel = dataModel;
        this.isImportNonDeductionTaxAmount = invoiceContext.getInvoiceConfig().isOrgOffset() && invoiceContext.getInvoiceConfig().isImportNonDeductionTaxAmout();
    }

    @Deprecated
    public CreateInvoiceEntryServiceImpl(InvoiceContext invoiceContext, IDataModel dataModel, boolean isOrgOffset) {
        this(invoiceContext, dataModel);
    }

    @Override
    public void process() {
        List<InvoiceEntryBO> invoiceEntryBOs = this.invoiceContext.getInvoiceEntryBOs();
        if (invoiceEntryBOs.size() <= 0) {
            log.info("\u672a\u5bfc\u5165\u4efb\u4f55\u53d1\u7968");
            return;
        }
        this.initRelation();
        DynamicObjectCollection invoiceCollection = this.dataModel.getEntryEntity("invoiceentry");
        List<Object> sortList = this.sortInvoiceEntity(invoiceCollection, invoiceEntryBOs);
        this.createEntryRowForBos(invoiceCollection, invoiceEntryBOs, sortList);
        this.resetInvoiceEntitySeq(this.dataModel.getEntryEntity("invoiceentry"));
        List<InvoiceItemEntryBO> invoiceItemEntryBOs = this.invoiceContext.getInvoiceItemEntryBOs();
        int size = invoiceItemEntryBOs.size();
        int[] rowIndexes = this.dataModel.batchCreateNewEntryRow("invoiceitementry", size);
        for (int i = 0; i < size; ++i) {
            this.createInvoiceItem(invoiceItemEntryBOs.get(i), rowIndexes[i]);
        }
    }

    @Override
    protected void createInvoiceHeadEntry(InvoiceEntryBO invoiceEntryBO, int rowIndex) {
        List invoiceItemEntryBOs;
        DynamicObject dataEntity = this.dataModel.getDataEntity(true);
        DynamicObject invoiceEntryDO = (DynamicObject)dataEntity.getDynamicObjectCollection("invoiceentry").get(rowIndex);
        invoiceEntryDO.set("id", (Object)invoiceEntryBO.getEntryId());
        this.dataModel.setValue("invoicefrom", (Object)StringUtils.defaultIfBlank((CharSequence)invoiceEntryBO.getInvoiceFrom(), (CharSequence)InvoiceFrom.InvoiceCloud.getValue()), rowIndex);
        this.dataModel.setValue("invoicetype", (Object)invoiceEntryBO.getInvoiceType(), rowIndex);
        this.dataModel.setValue("invoicecode", (Object)invoiceEntryBO.getInvoiceCode(), rowIndex);
        this.dataModel.setValue("invoiceno", (Object)invoiceEntryBO.getInvoiceNo(), rowIndex);
        this.dataModel.setValue("invoicedate", (Object)invoiceEntryBO.getInvoiceDate(), rowIndex);
        this.dataModel.setValue("totalamount", (Object)invoiceEntryBO.getTotalAmount(), rowIndex);
        this.dataModel.setValue("passengername", (Object)invoiceEntryBO.getPassengerName(), rowIndex);
        if (this.isImportNonDeductionTaxAmount || invoiceEntryBO.getIsOffset().booleanValue()) {
            this.dataModel.setValue("alltaxrate", (Object)invoiceEntryBO.getAllTaxRate(), rowIndex);
            this.dataModel.setValue("taxrate_invoice", (Object)invoiceEntryBO.getTaxRate().multiply(BigDecimal.valueOf(100L)), rowIndex);
            this.dataModel.setValue("taxamount_invoice", (Object)invoiceEntryBO.getTaxAmount(), rowIndex);
            this.dataModel.setValue("offset_invoice", (Object)invoiceEntryBO.getIsOffset(), rowIndex);
            this.dataModel.setValue("offsetamount", (Object)invoiceEntryBO.getOffsetAmount(), rowIndex);
            this.dataModel.setValue("inoutamount", (Object)invoiceEntryBO.getInOutAmount(), rowIndex);
        }
        this.dataModel.setValue("validatemessage", (Object)InvoiceUtils.getLimitedValidateMessage(invoiceEntryBO.getValidateMessage()), rowIndex);
        this.dataModel.setValue("buyerorgname", (Object)invoiceEntryBO.getBuyerOrgName(), rowIndex);
        this.dataModel.setValue("makeoutcompname", (Object)invoiceEntryBO.getMakeOutCompanyName(), rowIndex);
        this.dataModel.setValue("count", (Object)1, rowIndex);
        String remarkInvoice = StringUtils.abbreviate((String)invoiceEntryBO.getRemark_Invoice(), (int)1024);
        this.dataModel.setValue("remark_invoice", (Object)remarkInvoice, rowIndex);
        this.dataModel.setValue("frominvoicecloud", (Object)invoiceEntryBO.getIsFromInvoiceCloud(), rowIndex);
        this.dataModel.setValue("serialno", (Object)invoiceEntryBO.getSerialNo(), rowIndex);
        this.dataModel.setValue("invoiceairportconstfee", (Object)invoiceEntryBO.getAirportConstructionFee(), rowIndex);
        if (invoiceEntryBO.getTotalAmount().compareTo(BigDecimal.ZERO) == 0) {
            this.dataModel.setValue("ismapexpense", (Object)"0", rowIndex);
        } else {
            this.dataModel.setValue("ismapexpense", (Object)(invoiceEntryBO.isMapExpenseItem() ? "1" : "0"), rowIndex);
        }
        if (this.dataModel.getProperty("invoicefromcity") != null) {
            this.dataModel.setValue("invoicefromcity", (Object)invoiceEntryBO.getFrom(), rowIndex);
        }
        if (this.dataModel.getProperty("invoicetocity") != null) {
            this.dataModel.setValue("invoicetocity", (Object)invoiceEntryBO.getTo(), rowIndex);
        }
        if (this.dataModel.getProperty("ie_validatest") != null) {
            this.dataModel.setValue("ie_validatest", (Object)invoiceEntryBO.getCheckStatus(), rowIndex);
        }
        if (this.dataModel.getProperty("istartcity") != null) {
            this.dataModel.setValue("istartcity", (Object)invoiceEntryBO.getStartCity(), rowIndex);
        }
        if (this.dataModel.getProperty("idestcity") != null) {
            this.dataModel.setValue("idestcity", (Object)invoiceEntryBO.getDestCity(), rowIndex);
        }
        if (this.dataModel.getProperty("istartprovince") != null) {
            this.dataModel.setValue("istartprovince", (Object)invoiceEntryBO.getStartProvince(), rowIndex);
        }
        if (this.dataModel.getProperty("idestprovince") != null) {
            this.dataModel.setValue("idestprovince", (Object)invoiceEntryBO.getDestProvince(), rowIndex);
        }
        if (this.dataModel.getProperty("seatgrade") != null) {
            this.dataModel.setValue("seatgrade", (Object)invoiceEntryBO.getSeatGrade(), rowIndex);
        }
        if (this.dataModel.getProperty("transportnote") != null) {
            this.dataModel.setValue("transportnote", (Object)invoiceEntryBO.getTransportNote(), rowIndex);
        }
        if (this.dataModel.getProperty("invoicenotaxamount") != null) {
            this.dataModel.setValue("invoicenotaxamount", (Object)invoiceEntryBO.getInvoiceNoTaxAmount(), rowIndex);
        }
        if (this.dataModel.getProperty("invoiceischange") != null) {
            this.dataModel.setValue("invoiceischange", (Object)invoiceEntryBO.getInvoiceIsChange(), rowIndex);
        }
        if (this.dataModel.getProperty("buyertaxno") != null) {
            this.dataModel.setValue("buyertaxno", (Object)invoiceEntryBO.getBuyerTaxNo(), rowIndex);
        }
        if (this.dataModel.getProperty("salertaxno_h") != null) {
            this.dataModel.setValue("salertaxno_h", (Object)invoiceEntryBO.getSalerTaxNo(), rowIndex);
        }
        if (!(invoiceItemEntryBOs = invoiceEntryBO.getInvoiceItemEntryBOs()).isEmpty()) {
            InvoiceItemEntryBO invoiceItemEntryBO = (InvoiceItemEntryBO)invoiceItemEntryBOs.get(0);
            String[] fields = new String[]{"specModel", "unit", "num", "unitPrice"};
            Object[] values = new Object[]{invoiceItemEntryBO.getSpecModel(), invoiceItemEntryBO.getUnit(), invoiceItemEntryBO.getNum(), invoiceItemEntryBO.getUnitPrice()};
            for (int i = 0; i < fields.length; ++i) {
                String field = fields[i] + "_h";
                if (this.dataModel.getProperty(field) == null) continue;
                this.dataModel.setValue(field, values[i], rowIndex);
            }
        }
        if (this.dataModel.getProperty("ticketchanges") != null) {
            this.dataModel.setValue("ticketchanges", (Object)invoiceEntryBO.getTicketChanges(), rowIndex);
        }
        if (this.dataModel.getProperty("sequencenum") != null) {
            this.dataModel.setValue("sequencenum", (Object)invoiceEntryBO.getSequenceNum(), rowIndex);
            if (this.dataModel.getProperty("sequencenuminfo") != null && StringUtils.equals((CharSequence)invoiceEntryBO.getSequenceNum(), (CharSequence)"1")) {
                this.dataModel.setValue("sequencenuminfo", (Object)InvoiceUtils.getLimitedValidateMessage(invoiceEntryBO.getSequenceNumInfo()), rowIndex);
            }
        }
        if (this.dataModel.getProperty("flighttrainnums") != null) {
            this.dataModel.setValue("flighttrainnums", (Object)invoiceEntryBO.getFlightTrainNums(), rowIndex);
        }
        if (this.dataModel.getProperty("issupplement") != null) {
            this.dataModel.setValue("issupplement", (Object)(invoiceEntryBO.isSupplement() ? "1" : "0"), rowIndex);
        }
        if (this.dataModel.getProperty("billcreatetime") != null) {
            this.dataModel.setValue("billcreatetime", (Object)invoiceEntryBO.getBillCreateTime(), rowIndex);
        }
        if (this.dataModel.getProperty("passverifybuyername") != null) {
            this.dataModel.setValue("passverifybuyername", (Object)invoiceEntryBO.getPassVerifyBuyerName(), rowIndex);
        }
        if (this.dataModel.getProperty("passverifybuyertaxno") != null) {
            this.dataModel.setValue("passverifybuyertaxno", (Object)invoiceEntryBO.getPassVerifyBuyerTaxNo(), rowIndex);
        }
        if (this.dataModel.getProperty("personalinvoice") != null) {
            this.dataModel.setValue("personalinvoice", (Object)invoiceEntryBO.getPersonalInvoice(), rowIndex);
        }
        if (this.dataModel.getProperty("invoicecurrency") != null) {
            this.dataModel.setValue("invoicecurrency", (Object)invoiceEntryBO.getInvoiceCurrencyId(), rowIndex);
        }
        if (this.dataModel.getProperty("invoicegoodsname") != null) {
            this.dataModel.setValue("invoicegoodsname", (Object)InvoiceUtils.getLimitedValidateMessage(invoiceEntryBO.getInvoiceGoodsName()), rowIndex);
        }
        if (this.dataModel.getProperty("invoicealltaxcode") != null) {
            this.dataModel.setValue("invoicealltaxcode", (Object)InvoiceUtils.getLimitedValidateMessage(invoiceEntryBO.getInvoiceAllTaxCode()), rowIndex);
        }
        if (this.dataModel.getProperty("customeridnumber") != null) {
            this.dataModel.setValue("customeridnumber", (Object)invoiceEntryBO.getCustomerIDNumber(), rowIndex);
        }
        if (this.dataModel.getProperty("airconstfee") != null) {
            this.dataModel.setValue("airconstfee", (Object)invoiceEntryBO.getAirConstFee(), rowIndex);
        }
        if (this.dataModel.getProperty("othertotaltaxamount") != null) {
            this.dataModel.setValue("othertotaltaxamount", (Object)invoiceEntryBO.getOtherTotalTaxAmount(), rowIndex);
        }
        if (this.dataModel.getProperty("insurancepremium") != null) {
            this.dataModel.setValue("insurancepremium", (Object)invoiceEntryBO.getInsurancePremium(), rowIndex);
        }
        if (this.dataModel.getProperty("isred") != null) {
            this.dataModel.setValue("isred", (Object)invoiceEntryBO.getRed(), rowIndex);
        }
        if (this.dataModel.getProperty("region") != null) {
            this.dataModel.setValue("region", (Object)invoiceEntryBO.getRegion(), rowIndex);
        }
        if (this.dataModel.getProperty("isxbrl") != null) {
            this.dataModel.setValue("isxbrl", (Object)invoiceEntryBO.isXbrl(), rowIndex);
        }
        if (this.dataModel.getProperty("uploadSeq") != null) {
            this.dataModel.setValue("uploadSeq", (Object)invoiceEntryBO.getUploadSeq(), rowIndex);
        }
        if (this.dataModel.getProperty("invoicestartdate") != null) {
            this.dataModel.setValue("invoicestartdate", (Object)invoiceEntryBO.getStartDate(), rowIndex);
        }
        if (this.dataModel.getProperty("invoiceenddate") != null) {
            this.dataModel.setValue("invoiceenddate", (Object)invoiceEntryBO.getEndDate(), rowIndex);
        }
        if (this.dataModel.getProperty("invoicecity") != null) {
            this.dataModel.setValue("invoicecity", (Object)invoiceEntryBO.getCity(), rowIndex);
        }
        if (this.dataModel.getProperty("invoiceairtime") != null) {
            this.dataModel.setValue("invoiceairtime", (Object)invoiceEntryBO.getAirTime(), rowIndex);
        }
        if (this.dataModel.getProperty("invoicefuelsurcharge") != null) {
            this.dataModel.setValue("invoicefuelsurcharge", (Object)invoiceEntryBO.getFuelSurcharge(), rowIndex);
        }
        if (this.dataModel.getProperty("invoicebuyeraddressphone") != null) {
            this.dataModel.setValue("invoicebuyeraddressphone", (Object)invoiceEntryBO.getBuyerAddressPhone(), rowIndex);
        }
        if (this.dataModel.getProperty("endorsement") != null) {
            this.dataModel.setValue("endorsement", (Object)invoiceEntryBO.getEndorsement(), rowIndex);
        }
        if (this.dataModel.getProperty("blockchain") != null && "1".equals(invoiceEntryBO.getBlockChain())) {
            this.dataModel.setValue("blockchain", (Object)invoiceEntryBO.getBlockChain(), rowIndex);
        }
        if (this.dataModel.getProperty("islinkagedetail") != null) {
            this.dataModel.setValue("islinkagedetail", (Object)invoiceEntryBO.isLinkageDetail(), rowIndex);
        }
        this.setValueIfExist("billingpoolid", invoiceEntryBO.getBillingPoolId(), rowIndex);
        this.setValueIfExist("expirypaydate", invoiceEntryBO.getDueDate(), rowIndex);
        this.setValueIfExist("country", invoiceEntryBO.getCountryId(), rowIndex);
        this.setValueIfExist("countrystr", invoiceEntryBO.getCountry(), rowIndex);
        this.setValueIfExist("taxDetails", invoiceEntryBO.getTaxDetails(), rowIndex);
        this.setValueIfExist("ismutilreimburse", invoiceEntryBO.getMutiReimburse(), rowIndex);
        this.setValueIfExist("oribalanceamount", invoiceEntryBO.getOriBalanceAmount(), rowIndex);
        this.setValueIfExist("poolreimburseamount", invoiceEntryBO.getPoolReimburseAmount(), rowIndex);
        if (invoiceEntryBO.getBillingPoolId() != null && invoiceEntryBO.getBillingPoolId() != 0L) {
            this.setValueIfExist("ispool", true, rowIndex);
            if (invoiceEntryBO.isCanCloseMultiReimburse()) {
                IPageCache pageCache = this.invoiceContext.getView().getPageCache();
                pageCache.put(invoiceEntryBO.getSerialNo(), "1");
            }
        }
        this.setInvoiceEntryCustomFields(invoiceEntryBO, rowIndex);
    }

    private void setValueIfExist(String name, Object value, int rowIndex) {
        if (this.dataModel.getProperty(name) != null) {
            this.dataModel.setValue(name, value, rowIndex);
        }
    }

    @Override
    protected void createInvoiceItemEntry(InvoiceItemEntryBO invoiceItemEntryBO, int rowIndex) {
        DynamicObject dataEntity = this.dataModel.getDataEntity(true);
        DynamicObject invoiceItemEntryDO = (DynamicObject)dataEntity.getDynamicObjectCollection("invoiceitementry").get(rowIndex);
        invoiceItemEntryDO.set("id", (Object)invoiceItemEntryBO.getEntryId());
        Long itemEntryId = invoiceItemEntryBO.getExpenseEntryBO() == null ? Long.valueOf(0L) : invoiceItemEntryBO.getExpenseEntryBO().getEntryId();
        Long entryId = invoiceItemEntryBO.getInvoiceEntryBO().getEntryId();
        this.dataModel.setValue("itementryid", (Object)itemEntryId, rowIndex);
        this.dataModel.setValue("invoiceheadentryid", (Object)entryId, rowIndex);
        this.dataModel.setValue("unitprice", (Object)invoiceItemEntryBO.getUnitPrice(), rowIndex);
        this.dataModel.setValue("invoiceitemtaxrate", (Object)invoiceItemEntryBO.getInvoiceItemTaxRate(), rowIndex);
        this.dataModel.setValue("unit", (Object)invoiceItemEntryBO.getUnit(), rowIndex);
        this.dataModel.setValue("excludeamount", (Object)invoiceItemEntryBO.getExcludeAmount(), rowIndex);
        this.dataModel.setValue("specmodel", (Object)invoiceItemEntryBO.getSpecModel(), rowIndex);
        this.dataModel.setValue("invoiceitemtaxamout", (Object)invoiceItemEntryBO.getInvoiceItemTaxAmout(), rowIndex);
        InvoiceEntryBO invoiceEntryBO = invoiceItemEntryBO.getInvoiceEntryBO();
        String invoiceType = invoiceEntryBO.getInvoiceType();
        this.dataModel.setValue("goodscode", (Object)StringUtils.defaultIfBlank((CharSequence)invoiceItemEntryBO.getGoodsCode(), (CharSequence)invoiceType), rowIndex);
        this.dataModel.setValue("num", (Object)invoiceItemEntryBO.getNum(), rowIndex);
        this.dataModel.setValue("goodsname", (Object)invoiceItemEntryBO.getGoodsName(), rowIndex);
        this.dataModel.setValue("invoiceitemoffset", (Object)invoiceItemEntryBO.getInvoiceItemOffset(), rowIndex);
        this.dataModel.setValue("salerTaxNo", (Object)invoiceEntryBO.getSalerTaxNo(), rowIndex);
        this.dataModel.setValue("invoicecloudoffset", (Object)invoiceItemEntryBO.getInvoiceCloudOffset(), rowIndex);
        if (invoiceItemEntryDO.containsProperty("invoiceitemserialno")) {
            this.dataModel.setValue("invoiceitemserialno", (Object)invoiceEntryBO.getSerialNo(), rowIndex);
        }
        this.setInvoiceItemCustomFields(invoiceItemEntryBO, rowIndex);
    }

    public List<Object> sortInvoiceEntity(DynamicObjectCollection invoiceColl, List<InvoiceEntryBO> invoiceEntryBOs) {
        ArrayList sortList = Lists.newArrayListWithExpectedSize((int)(invoiceColl.size() + invoiceEntryBOs.size()));
        sortList.addAll(invoiceColl);
        sortList.addAll(invoiceEntryBOs);
        sortList.sort((u, v) -> {
            Date vInvoiceDate;
            Date vCreateTime;
            Long vSeq;
            Long uSeq = (Long)this.getFieldData(u, "uploadSeq");
            int cmpResult = this.compare(uSeq, vSeq = (Long)this.getFieldData(v, "uploadSeq"));
            if (cmpResult != 0) {
                return cmpResult;
            }
            Date uCreateTime = (Date)this.getFieldData(u, "billcreatetime");
            cmpResult = this.compare(uCreateTime, vCreateTime = (Date)this.getFieldData(v, "billcreatetime"));
            if (cmpResult != 0) {
                return cmpResult;
            }
            Date uInvoiceDate = (Date)this.getFieldData(u, "invoicedate");
            cmpResult = this.compare(uInvoiceDate, vInvoiceDate = (Date)this.getFieldData(v, "invoicedate"));
            if (cmpResult != 0) {
                return cmpResult;
            }
            String uInvoiceNo = this.getInvoiceNo(u);
            String vInvoiceNo = this.getInvoiceNo(v);
            return this.compare((Comparable)((Object)uInvoiceNo), (Comparable)((Object)vInvoiceNo));
        });
        return sortList;
    }

    private int compare(Comparable a, Comparable b) {
        if (a != null && b != null) {
            return a.compareTo(b);
        }
        if (a == null && b != null) {
            return 1;
        }
        if (a != null && b == null) {
            return -1;
        }
        return 0;
    }

    private void createEntryRowForBos(DynamicObjectCollection invoiceColl, List<InvoiceEntryBO> invoiceEntryBOs, List<Object> sortList) {
        if (invoiceColl.isEmpty()) {
            this.dataModel.beginInit();
            int[] invoiceHeadRowIndexs = this.dataModel.batchCreateNewEntryRow("invoiceentry", invoiceEntryBOs.size());
            this.dataModel.endInit();
            int i = 0;
            for (int index = 0; index < sortList.size(); ++index) {
                Object entry = sortList.get(index);
                if (!(entry instanceof InvoiceEntryBO)) continue;
                this.createInvoiceHead((InvoiceEntryBO)entry, invoiceHeadRowIndexs[i++]);
            }
        } else {
            for (int index = 0; index < sortList.size(); ++index) {
                Object entry = sortList.get(index);
                if (!(entry instanceof InvoiceEntryBO)) continue;
                this.dataModel.beginInit();
                int insertIndex = this.dataModel.insertEntryRow("invoiceentry", index);
                this.dataModel.endInit();
                this.createInvoiceHead((InvoiceEntryBO)entry, insertIndex);
            }
        }
        if (this.invoiceContext.getView() != null) {
            this.invoiceContext.getView().updateView("invoiceentry");
        }
    }

    private void resetInvoiceEntitySeq(DynamicObjectCollection invoiceColl) {
        for (int index = 0; index < invoiceColl.size(); ++index) {
            ((DynamicObject)invoiceColl.get(index)).set("seq", (Object)(index + 1));
        }
    }

    private Object getFieldData(Object dateSource, String fieldName) {
        Object data = null;
        if (dateSource instanceof DynamicObject) {
            data = ((DynamicObject)dateSource).get(fieldName);
        }
        if (dateSource instanceof InvoiceEntryBO) {
            switch (fieldName) {
                case "billcreatetime": {
                    data = ((InvoiceEntryBO)dateSource).getBillCreateTime();
                    break;
                }
                case "invoicedate": {
                    data = ((InvoiceEntryBO)dateSource).getInvoiceDate();
                    break;
                }
                case "uploadSeq": {
                    data = ((InvoiceEntryBO)dateSource).getUploadSeq();
                }
            }
        }
        return data;
    }

    private String getInvoiceNo(Object dateSource) {
        if (dateSource instanceof DynamicObject) {
            return ((DynamicObject)dateSource).getString("invoiceno");
        }
        if (dateSource instanceof InvoiceEntryBO) {
            return ((InvoiceEntryBO)dateSource).getInvoiceNo();
        }
        return null;
    }

    private final void createInvoiceHead(InvoiceEntryBO invoiceEntryBO, int rowIndex) {
        this.executeBeforeCreateInvoiceHead(invoiceEntryBO, rowIndex);
        this.createInvoiceHeadEntry(invoiceEntryBO, rowIndex);
        this.executeAfterCreateInvoiceHead(invoiceEntryBO, rowIndex);
    }

    private final void createInvoiceItem(InvoiceItemEntryBO invoiceItemEntryBO, int rowIndex) {
        this.executeBeforeCreateInvoiceItem(invoiceItemEntryBO, rowIndex);
        this.createInvoiceItemEntry(invoiceItemEntryBO, rowIndex);
        this.executeAfterCreateInvoiceItem(invoiceItemEntryBO, rowIndex);
    }

    private final void executeBeforeCreateInvoiceHead(InvoiceEntryBO invoiceEntryBO, int rowIndex) {
        try {
            IBeforeCreateInvoiceInfoService beforeService = InvoiceServiceFactory.getSingletonService(IBeforeCreateInvoiceInfoService.class);
            if (beforeService == null) {
                return;
            }
            log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u53d1\u7968\u4fe1\u606f\u751f\u6210\u524d\u7f6e\u670d\u52a1\u524dinvoiceEntryBO:" + invoiceEntryBO);
            beforeService.beforeCreateInvoiceEntry(new InvoiceContextProxy(this.invoiceContext), new DataModelProxy(this.dataModel), invoiceEntryBO, rowIndex);
            log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u53d1\u7968\u4fe1\u606f\u751f\u6210\u524d\u7f6e\u670d\u52a1\u540einvoiceEntryBO:" + invoiceEntryBO);
        }
        catch (Exception e) {
            log.error("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u7b2c\u4e09\u65b9\u53d1\u7968\u4fe1\u606f\u751f\u6210\u524d\u7f6e\u670d\u52a1\u5f02\u5e38:", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private final void executeAfterCreateInvoiceHead(InvoiceEntryBO invoiceEntryBO, int rowIndex) {
        try {
            IAfterCreateInvoiceInfoService afterService = InvoiceServiceFactory.getSingletonService(IAfterCreateInvoiceInfoService.class);
            if (afterService == null) {
                return;
            }
            log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u53d1\u7968\u4fe1\u606f\u751f\u6210\u540e\u7f6e\u670d\u52a1\u524dinvoiceEntryBO:" + invoiceEntryBO);
            afterService.afterCreateInvoiceEntry(new InvoiceContextProxy(this.invoiceContext), new AfterDataModelProxy(this.dataModel), invoiceEntryBO, rowIndex);
            log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u53d1\u7968\u4fe1\u606f\u751f\u6210\u540e\u7f6e\u670d\u52a1\u540einvoiceEntryBO:" + invoiceEntryBO);
        }
        catch (Exception e) {
            log.error("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u7b2c\u4e09\u65b9\u53d1\u7968\u4fe1\u606f\u751f\u6210\u524d\u7f6e\u670d\u52a1\u5f02\u5e38:", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private final void executeBeforeCreateInvoiceItem(InvoiceItemEntryBO invoiceItemEntryBO, int rowIndex) {
        try {
            IBeforeCreateInvoiceInfoService beforeService = InvoiceServiceFactory.getSingletonService(IBeforeCreateInvoiceInfoService.class);
            if (beforeService == null) {
                return;
            }
            log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u53d1\u7968\u660e\u7ec6\u751f\u6210\u524d\u7f6e\u670d\u52a1\u524dinvoiceItemEntryBO:" + invoiceItemEntryBO);
            beforeService.beforeCreateInvoiceItemEntry(new InvoiceContextProxy(this.invoiceContext), new DataModelProxy(this.dataModel), invoiceItemEntryBO, rowIndex);
            log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u53d1\u7968\u660e\u7ec6\u751f\u6210\u524d\u7f6e\u670d\u52a1\u540einvoiceItemEntryBO:" + invoiceItemEntryBO);
        }
        catch (Exception e) {
            log.error("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u7b2c\u4e09\u65b9\u53d1\u7968\u660e\u7ec6\u751f\u6210\u524d\u7f6e\u670d\u52a1\u5f02\u5e38:", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private final void executeAfterCreateInvoiceItem(InvoiceItemEntryBO invoiceItemEntryBO, int rowIndex) {
        try {
            IAfterCreateInvoiceInfoService afterService = InvoiceServiceFactory.getSingletonService(IAfterCreateInvoiceInfoService.class);
            if (afterService == null) {
                return;
            }
            log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u53d1\u7968\u660e\u7ec6\u751f\u6210\u540e\u7f6e\u670d\u52a1\u524dinvoiceItemEntryBO:" + invoiceItemEntryBO);
            afterService.afterCreateInvoiceItemEntry(new InvoiceContextProxy(this.invoiceContext), new AfterDataModelProxy(this.dataModel), invoiceItemEntryBO, rowIndex);
            log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u53d1\u7968\u660e\u7ec6\u751f\u6210\u540e\u7f6e\u670d\u52a1\u540einvoiceItemEntryBO:" + invoiceItemEntryBO);
        }
        catch (Exception e) {
            log.error("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u8c03\u7528\u7b2c\u4e09\u65b9\u53d1\u7968\u660e\u7ec6\u751f\u6210\u540e\u7f6e\u670d\u52a1\u5f02\u5e38:", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("0", e.getMessage()), new Object[0]);
        }
    }

    private void setInvoiceEntryCustomFields(InvoiceEntryBO invoiceEntryBO, int rowIndex) {
        Map customFields = invoiceEntryBO.getCustomFields();
        if (customFields.isEmpty()) {
            return;
        }
        Field[] fields = InvoiceEntryBO.class.getDeclaredFields();
        List fieldNameList = Arrays.stream(fields).map(field -> field.getName().toLowerCase()).collect(Collectors.toList());
        DynamicObjectCollection entryEntity = this.dataModel.getEntryEntity("invoiceentry");
        DataEntityPropertyCollection properties = entryEntity.getDynamicObjectType().getProperties();
        for (Map.Entry next : customFields.entrySet()) {
            String fieldName = (String)next.getKey();
            Object value = next.getValue();
            if (fieldNameList.contains(fieldName.toLowerCase()) || properties.get((Object)fieldName) == null) continue;
            this.dataModel.setValue(fieldName, value, rowIndex);
        }
    }

    private void setInvoiceItemCustomFields(InvoiceItemEntryBO invoiceItemEntryBO, int rowIndex) {
        Map customFields = invoiceItemEntryBO.getCustomFields();
        if (customFields.isEmpty()) {
            return;
        }
        Field[] fields = InvoiceItemEntryBO.class.getDeclaredFields();
        List fieldNameList = Arrays.stream(fields).map(field -> field.getName().toLowerCase()).collect(Collectors.toList());
        DynamicObjectCollection entryEntity = this.dataModel.getEntryEntity("invoiceitementry");
        DataEntityPropertyCollection properties = entryEntity.getDynamicObjectType().getProperties();
        for (Map.Entry next : customFields.entrySet()) {
            String fieldName = (String)next.getKey();
            Object value = next.getValue();
            if (fieldNameList.contains(fieldName.toLowerCase()) || properties.get((Object)fieldName) == null) continue;
            this.dataModel.setValue(fieldName, value, rowIndex);
        }
    }
}

