/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl.mergeInvoiceService;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.entity.datamodel.IDataModel;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.AbstractInvoiceService;
import kd.fi.er.common.model.invoice.bo.InvoiceEntryBO;
import kd.fi.er.common.model.invoice.bo.InvoiceItemEntryBO;

public abstract class MergeInvoiceService
extends AbstractInvoiceService {
    private IDataModel model;
    private boolean useExpenseDate;

    public MergeInvoiceService(InvoiceContext invoiceContext) {
        super(invoiceContext);
    }

    public IDataModel getModel() {
        return this.model;
    }

    public void setModel(IDataModel model) {
        this.model = model;
    }

    public boolean getUseExpenseDate() {
        return this.useExpenseDate;
    }

    public void setUseExpenseDate(boolean useExpenseDate) {
        this.useExpenseDate = useExpenseDate;
    }

    protected Date getEarliestDate(List<InvoiceItemEntryBO> groupedInvoiceItemEntryBOs) {
        Date invoiceDate = null;
        if (!groupedInvoiceItemEntryBOs.isEmpty()) {
            invoiceDate = groupedInvoiceItemEntryBOs.get(0).getInvoiceEntryBO().getInvoiceDate();
            for (InvoiceItemEntryBO invoiceItemEntryBO : groupedInvoiceItemEntryBOs) {
                Date invoiceDateTemp = invoiceItemEntryBO.getInvoiceEntryBO().getInvoiceDate();
                if (invoiceDate == null) {
                    invoiceDate = invoiceDateTemp;
                    continue;
                }
                if (invoiceDateTemp == null || invoiceDateTemp.compareTo(invoiceDate) >= 0) continue;
                invoiceDate = invoiceDateTemp;
            }
        }
        if (invoiceDate == null) {
            invoiceDate = new Date();
        }
        return invoiceDate;
    }

    protected void updateLinkDetail() {
        List<InvoiceEntryBO> invoiceEntryBOs = this.invoiceContext.getInvoiceEntryBOs();
        invoiceEntryBOs.forEach(invoiceEntry -> {
            List invoiceItemEntry = invoiceEntry.getInvoiceItemEntryBOs();
            List expenseItemIdList = invoiceItemEntry.stream().map(invoiceItem -> invoiceItem.getExpenseItemId()).collect(Collectors.toList());
            if (!expenseItemIdList.isEmpty() && expenseItemIdList.size() == 1 && expenseItemIdList.get(0) != null) {
                invoiceEntry.setLinkageDetail(true);
            }
        });
    }

    @Deprecated
    public boolean isImportNonDeductionTaxAmount() {
        return false;
    }

    @Deprecated
    public void setImportNonDeductionTaxAmount(boolean isImportNonDeductionTaxAmount) {
    }
}

