/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.service.impl.mergeInvoiceService;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.ScriptException;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceTypeEnum;
import kd.fi.er.business.invoicecloud.util.InvoiceTypeUtils;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.mergerule.EqualFiledCalc;
import kd.fi.er.business.invoicecloud.v2.service.impl.mergeInvoiceService.EqualKeyAndJs;
import kd.fi.er.business.invoicecloud.v2.service.impl.mergeInvoiceService.MergeInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.mergeInvoiceService.MergeSalesListInvoiceServiceImpl;
import kd.fi.er.business.js.ErContextFactory;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.constant.StdConfigConstant;
import kd.fi.er.common.model.invoice.bo.ExpenseEntryBO;
import kd.fi.er.common.model.invoice.bo.InvoiceEntryBO;
import kd.fi.er.common.model.invoice.bo.InvoiceItemEntryBO;
import kd.fi.er.common.model.invoice.merge.ItemEnum;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class MergeInvoiceServiceImpl
extends MergeInvoiceService {
    private String entityName;
    private static final Log log = LogFactory.getLog(MergeInvoiceServiceImpl.class);
    private MergeSalesListInvoiceServiceImpl mergeSalesListInvoiceServiceImpl;
    private DynamicObject curSelectedItem = null;
    private static final List<String> equalFieldNames = Lists.newArrayList((Object[])new String[]{"goodcodeequal", "goodnameequal", "taxrateequal", "taxnumequal", "buyernameequal", "salernameequal", "passengerequal", "itemequal", "invoicedateequal", "invoicedatedetailequal", "offsetequal", "fromequal", "toequal", "amountequal", "seatgradequal", "currrencyequal"});
    private static final ErContextFactory contextFactory = new ErContextFactory();
    private SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");

    public MergeInvoiceServiceImpl(InvoiceContext invoiceContext, String entityNameForExpenseItem) {
        super(invoiceContext);
        this.entityName = entityNameForExpenseItem;
        List<DynamicObject> selectItem = invoiceContext.getSelectItem();
        if (selectItem != null && !selectItem.isEmpty()) {
            this.curSelectedItem = selectItem.get(0);
        }
    }

    public MergeInvoiceServiceImpl(InvoiceContext invoiceContext, String entityNameForExpenseItem, IDataModel model) {
        super(invoiceContext);
        this.entityName = entityNameForExpenseItem;
        this.setModel(model);
        this.setUseExpenseDate(invoiceContext.getInvoiceConfig().isUseExpenseDate());
        List<DynamicObject> selectItem = invoiceContext.getSelectItem();
        if (selectItem != null && !selectItem.isEmpty()) {
            this.curSelectedItem = selectItem.get(0);
        }
    }

    @Deprecated
    public MergeInvoiceServiceImpl(InvoiceContext invoiceContext, String entityNameForExpenseItem, IDataModel model, boolean useExpenseDate) {
        super(invoiceContext);
        this.entityName = entityNameForExpenseItem;
        this.setModel(model);
        this.setUseExpenseDate(useExpenseDate);
    }

    public MergeSalesListInvoiceServiceImpl getMergeSalesInvoiceListService() {
        if (this.mergeSalesListInvoiceServiceImpl == null) {
            this.mergeSalesListInvoiceServiceImpl = new MergeSalesListInvoiceServiceImpl(this.invoiceContext, this.entityName, this.getModel());
        }
        return this.mergeSalesListInvoiceServiceImpl;
    }

    @Override
    public void process() {
        List expenseEntryExcludeZeroBOs;
        List<InvoiceEntryBO> salesDetails;
        List<Object> invoiceEntryBOs = this.invoiceContext.getInvoiceEntryBOs();
        int threshold = ErStdConfig.getIntValue("invoicecloud.saleslistinvoicemerge.threshold", 8);
        if (threshold >= 8 && (salesDetails = invoiceEntryBOs.stream().filter(e -> e.getInvoiceItemEntryBOs() != null && e.getInvoiceItemEntryBOs().size() >= threshold).collect(Collectors.toList())).size() > 0) {
            this.invoiceContext.setSalesListInvoiceEntryBos(salesDetails);
            this.getMergeSalesInvoiceListService().process();
            invoiceEntryBOs = invoiceEntryBOs.stream().filter(e -> e.getInvoiceItemEntryBOs() == null || e.getInvoiceItemEntryBOs().size() < threshold).collect(Collectors.toList());
        }
        if (invoiceEntryBOs.size() <= 0) {
            return;
        }
        Map<String, List<InvoiceEntryBO>> invoiceTypeMap = invoiceEntryBOs.stream().collect(Collectors.groupingBy(InvoiceEntryBO::getInvoiceType));
        LinkedList expenseEntryBOs = Lists.newLinkedList();
        HashSet<String> invoicetypes = new HashSet<String>(invoiceTypeMap.keySet());
        invoicetypes.add(InvoiceTypeEnum.key_11.getValue());
        QFilter qFilter = new QFilter("invoicetype", "in", invoicetypes);
        Map invoiceMergeRule = BusinessDataServiceHelper.loadFromCache((String)"er_invoicemergerule", (QFilter[])new QFilter[]{qFilter});
        Map<String, List<DynamicObject>> invoiceMergeRuleMap = invoiceMergeRule.values().stream().collect(Collectors.groupingBy(m -> m.getString("invoicetype")));
        for (Map.Entry<String, List<InvoiceEntryBO>> entry2 : invoiceTypeMap.entrySet()) {
            DynamicObject mergeRuleDO;
            String mergeType;
            String invoiceType = entry2.getKey();
            List<InvoiceEntryBO> invoiceEntryBOByType = entry2.getValue();
            List<DynamicObject> loadFromCache = invoiceMergeRuleMap.get(invoiceType);
            if (loadFromCache.isEmpty()) {
                loadFromCache = invoiceMergeRuleMap.get(InvoiceTypeEnum.key_11.getValue());
            }
            if (StringUtils.equals((CharSequence)(mergeType = (mergeRuleDO = loadFromCache.get(0)).getString("mergetype")), (CharSequence)"1")) {
                invoiceEntryBOByType.stream().flatMap(invoiceEntry -> invoiceEntry.getInvoiceItemEntryBOs().stream()).forEach(invoiceItem -> expenseEntryBOs.add(this.genExpenseEntryBO(Collections.singletonList(invoiceItem))));
                continue;
            }
            ArrayList equalFields = Lists.newArrayList();
            if (StringUtils.equals((CharSequence)mergeType, (CharSequence)"2")) {
                equalFields.add("invoiceequal");
            }
            equalFields.addAll(equalFieldNames.stream().filter(name -> {
                if (mergeRuleDO.containsProperty(name)) {
                    return mergeRuleDO.getBoolean(name);
                }
                return false;
            }).collect(Collectors.toList()));
            HashMap<String, List> equalKeyToInvoiceItem = new HashMap<String, List>();
            invoiceEntryBOByType.stream().flatMap(invoiceEntry -> invoiceEntry.getInvoiceItemEntryBOs().stream()).forEach(invoiceItem -> {
                String key = this.getGroupKey((InvoiceItemEntryBO)invoiceItem, equalFields);
                if (!equalKeyToInvoiceItem.containsKey(key)) {
                    equalKeyToInvoiceItem.put(key, Lists.newLinkedList());
                }
                ((List)equalKeyToInvoiceItem.get(key)).add(invoiceItem);
            });
            String js = mergeRuleDO.getString("js");
            if (StringUtils.isBlank((CharSequence)js)) {
                equalKeyToInvoiceItem.forEach((k, v) -> expenseEntryBOs.add(this.genExpenseEntryBO((List<InvoiceItemEntryBO>)v)));
                continue;
            }
            HashMap<EqualKeyAndJs, List> equalKeyAndJsToInvoiceItems = new HashMap<EqualKeyAndJs, List>();
            equalKeyToInvoiceItem.forEach((key, items) -> {
                for (InvoiceItemEntryBO item : items) {
                    try {
                        Boolean jsResult = this.executeJs(js, item);
                        if (jsResult.booleanValue()) {
                            EqualKeyAndJs equalAndJs = new EqualKeyAndJs();
                            equalAndJs.key = key;
                            equalAndJs.js = js;
                            if (!equalKeyAndJsToInvoiceItems.containsKey(equalAndJs)) {
                                equalKeyAndJsToInvoiceItems.put(equalAndJs, Lists.newArrayList());
                            }
                            ((List)equalKeyAndJsToInvoiceItems.get(equalAndJs)).add(item);
                            continue;
                        }
                        expenseEntryBOs.add(this.genExpenseEntryBO(Collections.singletonList(item)));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(ResManager.loadKDString((String)"\u53d1\u7968\u5408\u5e76\u81ea\u5b9a\u4e49\u6761\u4ef6\u89e3\u6790\u5f02\u5e38\u3002", (String)"MergeInvoiceServiceImpl_0", (String)"fi-er-business", (Object[])new Object[0]), e);
                    }
                }
            });
            equalKeyAndJsToInvoiceItems.forEach((k, items) -> expenseEntryBOs.add(this.genExpenseEntryBO((List<InvoiceItemEntryBO>)items)));
        }
        this.invoiceContext.getExpenseEntryBOs().addAll(expenseEntryBOs);
        if (this.curSelectedItem != null && !expenseEntryBOs.isEmpty() && !(expenseEntryExcludeZeroBOs = expenseEntryBOs.stream().filter(entry -> entry.getTotalAmount().abs().compareTo(BigDecimal.valueOf(1.0E-6)) > 0).collect(Collectors.toList())).isEmpty()) {
            Long curSelectPk = ErCommonUtils.getPk(this.curSelectedItem);
            if (curSelectPk == null || curSelectPk == 0L) {
                curSelectPk = ORM.create().genLongId(this.entityName);
                this.curSelectedItem.set("id", (Object)curSelectPk);
            }
            ((ExpenseEntryBO)expenseEntryExcludeZeroBOs.get(0)).setEntryId(curSelectPk);
        }
        long[] expenseEntryIds = this.createEntryIds(this.entityName, expenseEntryBOs.size());
        for (int i = 0; i < expenseEntryIds.length; ++i) {
            ExpenseEntryBO expenseEntryBO = (ExpenseEntryBO)expenseEntryBOs.get(i);
            if (expenseEntryBO == null || expenseEntryBO.getEntryId() != null && expenseEntryBO.getEntryId() != 0L) continue;
            expenseEntryBO.setEntryId(Long.valueOf(expenseEntryIds[i]));
        }
        this.updateLinkDetail();
        log.info("\u521b\u5efa\u8d39\u7528\u660e\u7ec6\u5206\u5f55\u5171 " + expenseEntryBOs.size() + " \u884c\u3002\u5206\u5f55ID\u4e3a\uff1a" + expenseEntryBOs.stream().map(v -> v.getEntryId().toString()).collect(Collectors.joining(",")));
    }

    private Boolean executeJs(String js, InvoiceItemEntryBO item) throws ScriptException {
        Context context = contextFactory.makeContext();
        contextFactory.enterContext(context);
        ScriptableObject prototype = context.initStandardObjects();
        prototype.setParentScope(null);
        Scriptable scope = context.newObject((Scriptable)prototype);
        scope.setPrototype((Scriptable)prototype);
        scope.put("goodsname", scope, (Object)item.getGoodsName());
        scope.put("goodscode", scope, (Object)item.getGoodsCode());
        scope.put("taxrate", scope, (Object)item.getInvoiceItemTaxRate().multiply(BigDecimal.valueOf(100L)).setScale(0, RoundingMode.HALF_EVEN).doubleValue());
        scope.put("detailamount", scope, (Object)item.getTotalAmount().doubleValue());
        scope.put("taxamount", scope, (Object)item.getInvoiceItemTaxAmout().doubleValue());
        scope.put("buyertaxno", scope, (Object)item.getInvoiceEntryBO().getBuyerTaxNo());
        scope.put("buyername", scope, (Object)item.getInvoiceEntryBO().getBuyerOrgName());
        scope.put("salername", scope, (Object)item.getInvoiceEntryBO().getMakeOutCompanyName());
        scope.put("remark", scope, (Object)item.getInvoiceEntryBO().getRemark_Invoice());
        Long expenseItemId = item.getExpenseItemId();
        String expenseNumber = "";
        ItemEnum expenseItemEnum = item.getItemEnum();
        if (expenseItemId != null && !expenseItemId.equals(0L)) {
            DynamicObject expenseItemDO = BusinessDataServiceHelper.loadSingleFromCache((Object)expenseItemId, (String)expenseItemEnum.getEntityName());
            expenseNumber = expenseItemDO.getString(expenseItemEnum.getNumberName());
        }
        scope.put("tripitemnumber", scope, (Object)expenseNumber);
        scope.put("expenseitemnumber", scope, (Object)expenseNumber);
        Date invoiceDate = item.getInvoiceEntryBO().getInvoiceDate();
        String invoiceDateStr = "";
        if (invoiceDate != null) {
            invoiceDateStr = this.df.format(invoiceDate);
        }
        scope.put("invoicedate", scope, (Object)invoiceDateStr);
        scope.put("passengername", scope, (Object)item.getInvoiceEntryBO().getPassengerName());
        Object result = context.evaluateString(scope, js, null, -1, null);
        Boolean jsResult = (Boolean)result;
        return jsResult;
    }

    private String getGroupKey(InvoiceItemEntryBO invoiceItem, List<String> euqalFields) {
        StringBuilder sb = new StringBuilder();
        for (String fieldName : euqalFields) {
            String value = EqualFiledCalc.of(fieldName).getFiledValue(invoiceItem);
            value = (String)StringUtils.defaultIfBlank((CharSequence)value, (CharSequence)"");
            String appendStr = fieldName + ":" + value + "$$";
            sb.append(appendStr);
        }
        return sb.toString();
    }

    protected ExpenseEntryBO expenseEntryBO(List<InvoiceItemEntryBO> groupedInvoiceItemEntryBOs) {
        return this.genExpenseEntryBO(groupedInvoiceItemEntryBOs);
    }

    private ExpenseEntryBO genExpenseEntryBO(List<InvoiceItemEntryBO> groupedInvoiceItemEntryBOs) {
        List invoiceDateLst;
        long entryId = ORM.create().genLongId(this.entityName);
        ExpenseEntryBO expenseEntryBO = new ExpenseEntryBO();
        InvoiceItemEntryBO firstInvoiceItemEntryBO = groupedInvoiceItemEntryBOs.get(0);
        expenseEntryBO.setEntryId(Long.valueOf(entryId));
        expenseEntryBO.setExpenseItemId(firstInvoiceItemEntryBO.getExpenseItemId());
        if (Objects.equals(this.invoiceContext.getInvoiceConfig().getExpenseDateValue(), StdConfigConstant.EXPENSE_DATE_VALUE_HEAD) && this.getUseExpenseDate()) {
            expenseEntryBO.setHappenDate((Date)this.getModel().getValue("bizdate"));
        } else {
            expenseEntryBO.setHappenDate(this.getEarliestDate(groupedInvoiceItemEntryBOs));
        }
        BigDecimal airportConstructionFeeAmount = groupedInvoiceItemEntryBOs.stream().map(itemBo -> (BigDecimal)ObjectUtils.defaultIfNull((Object)itemBo.getInvoiceEntryBO().getAirportConstructionFee(), (Object)BigDecimal.ZERO)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        expenseEntryBO.setAirportConstructionFee(airportConstructionFeeAmount);
        Set<String> set = InvoiceTypeUtils.loadSpecialInvoiceTypes();
        boolean isSpecialInvoice = groupedInvoiceItemEntryBOs.stream().allMatch(invoiceItem -> set.contains(invoiceItem.getInvoiceEntryBO().getInvoiceType()));
        expenseEntryBO.setIsSpecialInvoice(Boolean.valueOf(isSpecialInvoice));
        expenseEntryBO.setInvoiceItemEntryVOs(groupedInvoiceItemEntryBOs);
        expenseEntryBO.setTaxClassCodeId(firstInvoiceItemEntryBO.getGoodsCodeId());
        Optional<InvoiceItemEntryBO> invoiceItemBOWithGoodNameOP = groupedInvoiceItemEntryBOs.stream().filter(invoiceItemBO -> StringUtils.isNotBlank((CharSequence)invoiceItemBO.getGoodsName())).findFirst();
        if (invoiceItemBOWithGoodNameOP.isPresent()) {
            expenseEntryBO.setGoodName(invoiceItemBOWithGoodNameOP.get().getGoodsName());
        } else {
            expenseEntryBO.setGoodName("");
        }
        Set invoiceNoList = groupedInvoiceItemEntryBOs.stream().map(itemBo -> itemBo.getInvoiceEntryBO().getInvoiceNo()).collect(Collectors.toSet());
        Set invoiceCodeList = groupedInvoiceItemEntryBOs.stream().map(itemBo -> itemBo.getInvoiceEntryBO().getInvoiceCode()).collect(Collectors.toSet());
        expenseEntryBO.setInvoiceNoUnion(StringUtils.join(invoiceNoList, (String)","));
        expenseEntryBO.setInvoiceCodeUnion(StringUtils.join(invoiceCodeList, (String)","));
        Set taxRates = groupedInvoiceItemEntryBOs.stream().map(InvoiceItemEntryBO::getInvoiceItemTaxRate).collect(Collectors.toSet());
        if (taxRates.size() == 1) {
            expenseEntryBO.setTaxRate((BigDecimal)taxRates.iterator().next());
        } else {
            expenseEntryBO.setTaxRate(BigDecimal.ZERO);
            expenseEntryBO.setRemark(taxRates.stream().map(r -> r.multiply(BigDecimal.valueOf(100L)).setScale(0, RoundingMode.HALF_EVEN).toString()).collect(Collectors.joining(", ")));
        }
        BigDecimal taxAmount = groupedInvoiceItemEntryBOs.stream().map(invoiceItem -> invoiceItem.getInvoiceItemTaxAmout()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        if (!this.invoiceContext.getInvoiceConfig().isImportNonDeductionTaxAmout()) {
            Stream<InvoiceItemEntryBO> entryBOStream = this.invoiceContext.getInvoiceConfig().isInvoicesCredits() ? groupedInvoiceItemEntryBOs.stream().filter(v -> v.getInvoiceItemOffset()) : groupedInvoiceItemEntryBOs.stream().filter(v -> v.getInvoiceCloudOffset());
            BigDecimal reComputTaxAmount = entryBOStream.map(invoiceItem -> invoiceItem.getInvoiceItemTaxAmout()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            if (taxAmount.compareTo(reComputTaxAmount) != 0 || reComputTaxAmount.compareTo(BigDecimal.ZERO) == 0) {
                expenseEntryBO.setTaxRate(BigDecimal.ZERO);
            }
            taxAmount = reComputTaxAmount;
        }
        expenseEntryBO.setTaxAmount(taxAmount);
        this.setOffset(groupedInvoiceItemEntryBOs, expenseEntryBO);
        BigDecimal totalAmount = groupedInvoiceItemEntryBOs.stream().map(InvoiceItemEntryBO::getTotalAmount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        expenseEntryBO.setTotalAmount(totalAmount);
        expenseEntryBO.setNotIncludeTaxAmount(totalAmount.subtract(expenseEntryBO.getTaxAmount()));
        expenseEntryBO.setInvoiceType(firstInvoiceItemEntryBO.getInvoiceEntryBO().getInvoiceType());
        List invoiceEntryBOs = groupedInvoiceItemEntryBOs.stream().map(item -> item.getInvoiceEntryBO()).collect(Collectors.toList());
        List passengers = invoiceEntryBOs.stream().filter(invoice -> StringUtils.isNotBlank((CharSequence)invoice.getPassengerName())).map(invoice -> invoice.getPassengerName()).collect(Collectors.toList());
        Set<String> vehicleInvoiceTypes = InvoiceTypeUtils.loadVehicleInvoiceTypes();
        List vehicleInvoiceEntryBOs = invoiceEntryBOs.stream().filter(invoice -> vehicleInvoiceTypes.contains(invoice.getInvoiceType()) && StringUtils.isNotBlank((CharSequence)invoice.getStartCity()) && StringUtils.isNotBlank((CharSequence)invoice.getDestCity()) && invoice.getInvoiceDate() != null).collect(Collectors.toList());
        vehicleInvoiceEntryBOs.sort(Comparator.comparing(InvoiceEntryBO::getInvoiceDateForSort));
        if (!vehicleInvoiceEntryBOs.isEmpty()) {
            InvoiceEntryBO firstInvoice = (InvoiceEntryBO)vehicleInvoiceEntryBOs.get(0);
            InvoiceEntryBO lastInvoice = (InvoiceEntryBO)vehicleInvoiceEntryBOs.get(vehicleInvoiceEntryBOs.size() - 1);
            String startCity = firstInvoice.getStartCity();
            String destCity = lastInvoice.getDestCity();
            startCity = startCity.endsWith(ResManager.loadKDString((String)"\u5e02", (String)"MergeInvoiceServiceImpl_1", (String)"fi-er-business", (Object[])new Object[0])) ? startCity.substring(0, startCity.length() - 1) : startCity;
            destCity = destCity.endsWith(ResManager.loadKDString((String)"\u5e02", (String)"MergeInvoiceServiceImpl_1", (String)"fi-er-business", (Object[])new Object[0])) ? destCity.substring(0, destCity.length() - 1) : destCity;
            startCity = startCity.replace(ResManager.loadKDString((String)"\u7279\u522b\u884c\u653f\u533a", (String)"MergeInvoiceServiceImpl_2", (String)"fi-er-business", (Object[])new Object[0]), "");
            destCity = destCity.replace(ResManager.loadKDString((String)"\u7279\u522b\u884c\u653f\u533a", (String)"MergeInvoiceServiceImpl_2", (String)"fi-er-business", (Object[])new Object[0]), "");
            expenseEntryBO.setStartCity(startCity);
            expenseEntryBO.setEndCity(destCity);
            expenseEntryBO.setPassengers(passengers);
        }
        if ((invoiceDateLst = invoiceEntryBOs.stream().filter(v -> v.getInvoiceDate() != null).map(v -> v.getInvoiceDate()).collect(Collectors.toList())).isEmpty()) {
            Date d = new Date();
            expenseEntryBO.setStartDate(d);
            expenseEntryBO.setEndDate(d);
        } else {
            invoiceDateLst.sort((a, b) -> a.compareTo((Date)b));
            expenseEntryBO.setStartDate((Date)invoiceDateLst.get(0));
            expenseEntryBO.setEndDate((Date)invoiceDateLst.get(invoiceDateLst.size() - 1));
        }
        this.seatGrade(expenseEntryBO, groupedInvoiceItemEntryBOs);
        groupedInvoiceItemEntryBOs.forEach(item -> item.setExpenseEntryBO(expenseEntryBO));
        expenseEntryBO.setEntryCurrencyId(groupedInvoiceItemEntryBOs.get(0).getInvoiceEntryBO().getInvoiceCurrencyId());
        return expenseEntryBO;
    }

    private void seatGrade(ExpenseEntryBO expenseEntryBO, List<InvoiceItemEntryBO> groupedInvoiceItemEntryBOs) {
        List invoiceEntryBOs = groupedInvoiceItemEntryBOs.stream().map(v -> v.getInvoiceEntryBO()).collect(Collectors.toList());
        HashMap seatGrades = Maps.newHashMapWithExpectedSize((int)2);
        Set airSeatGrade = invoiceEntryBOs.stream().filter(invoice -> StringUtils.equals((CharSequence)invoice.getInvoiceType(), (CharSequence)InvoiceTypeEnum.key_10.getValue())).map(invoice -> invoice.getSeatGrade()).collect(Collectors.toSet());
        seatGrades.put("2", airSeatGrade);
        Set trainSeatGrade = invoiceEntryBOs.stream().filter(invoice -> StringUtils.equals((CharSequence)invoice.getInvoiceType(), (CharSequence)InvoiceTypeEnum.key_9.getValue())).map(invoice -> invoice.getSeatGrade()).collect(Collectors.toSet());
        seatGrades.put("4", trainSeatGrade);
        Set shipSeatGrade = invoiceEntryBOs.stream().filter(invoice -> StringUtils.equals((CharSequence)invoice.getInvoiceType(), (CharSequence)InvoiceTypeEnum.key_20.getValue())).map(invoice -> invoice.getSeatGrade()).collect(Collectors.toSet());
        seatGrades.put("7", shipSeatGrade);
        expenseEntryBO.setSeatGrades((Map)seatGrades);
    }

    public void setCurSelectedItem(DynamicObject curSelectedItem) {
        this.curSelectedItem = curSelectedItem;
    }

    private long[] createEntryIds(String entryName, int length) {
        long[] ids = ORM.create().genLongIds(entryName, length);
        return ids;
    }

    private void setOffset(List<InvoiceItemEntryBO> groupedInvoiceItemEntryBOs, ExpenseEntryBO expenseEntryBO) {
        Boolean isItemOffset = false;
        boolean invoicesCredits = this.invoiceContext.getInvoiceConfig().isInvoicesCredits();
        Boolean isInvoiceOffset = invoicesCredits ? Boolean.valueOf(groupedInvoiceItemEntryBOs.stream().anyMatch(invoiceItem -> invoiceItem.getInvoiceItemOffset())) : Boolean.valueOf(groupedInvoiceItemEntryBOs.stream().anyMatch(invoiceItem -> invoiceItem.getInvoiceCloudOffset()));
        if (expenseEntryBO.getExpenseItemId() != null && expenseEntryBO.getExpenseItemId() != 0L) {
            ItemEnum item = groupedInvoiceItemEntryBOs.get(0).getItemEnum();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)expenseEntryBO.getExpenseItemId(), (String)item.getEntityName());
            isItemOffset = dynamicObject.getBoolean(item.getOffsetName());
        }
        expenseEntryBO.setInvoiceIsOffset(isInvoiceOffset);
        boolean orgOffset = this.invoiceContext.getInvoiceConfig().isOrgOffset();
        expenseEntryBO.setIsOffset(Boolean.valueOf(isInvoiceOffset != false && isItemOffset != false && orgOffset));
        if (expenseEntryBO.getIsOffset().booleanValue()) {
            Optional<BigDecimal> reduce = groupedInvoiceItemEntryBOs.stream().filter(invoiceItem -> invoicesCredits ? invoiceItem.getInvoiceItemOffset() : invoiceItem.getInvoiceCloudOffset()).map(invoiceItem -> invoiceItem.getInvoiceItemTaxAmout()).reduce(BigDecimal::add);
            if (reduce.isPresent()) {
                expenseEntryBO.setOffsetAmount(reduce.get());
            }
        } else {
            expenseEntryBO.setOffsetAmount(BigDecimal.ZERO);
        }
        expenseEntryBO.setItemInOutAmount(expenseEntryBO.getTaxAmount().subtract(expenseEntryBO.getOffsetAmount()));
    }
}

