/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.v2.InvoiceDateFormatDeserializer;
import kd.fi.er.common.exception.invoice.InvoiceCloudException;
import kd.fi.er.common.model.invoice.InvoiceDetailRetrunVO;
import kd.fi.er.common.model.invoice.InvoiceVO;

public class InvoiceJsonParseUtils {
    private static final Log log = LogFactory.getLog(InvoiceJsonParseUtils.class);

    public static List<InvoiceVO> parseInvoiceVO(String apiReturnJson) throws InvoiceCloudException {
        InvoiceDetailRetrunVO invoiceDetailRetrunVO = InvoiceJsonParseUtils.parseInvoiceDetailReturnVO(apiReturnJson);
        if (invoiceDetailRetrunVO == null) {
            return Collections.emptyList();
        }
        List invoice = invoiceDetailRetrunVO.getData();
        if (invoice == null || invoice.isEmpty()) {
            return Collections.emptyList();
        }
        return invoice;
    }

    public static InvoiceDetailRetrunVO parseInvoiceDetailReturnVO(String apiReturnJson) throws InvoiceCloudException {
        InvoiceDetailRetrunVO invoiceDetailRetrunVO = null;
        try {
            ParserConfig config = new ParserConfig();
            config.putDeserializer(Date.class, (ObjectDeserializer)InvoiceDateFormatDeserializer.getInstance());
            invoiceDetailRetrunVO = (InvoiceDetailRetrunVO)JSON.parseObject((String)apiReturnJson, InvoiceDetailRetrunVO.class, (ParserConfig)config, (int)JSON.DEFAULT_PARSER_FEATURE, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            throw new InvoiceCloudException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u8fd4\u56de\u7684\u53d1\u7968\u8be6\u60c5\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InvoiceJsonParseUtils_0", (String)"fi-er-business", (Object[])new Object[0]) + ",apiReturnJson:" + apiReturnJson, (Throwable)e);
        }
        return invoiceDetailRetrunVO;
    }
}

