/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.invoicecloud.v2.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.ORM;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.model.invoice.bill.BillOfInvoice;

public class SimpleRelateExpenseOrTripItemAndInvoiceUtil {
    public static void deleteMapinfo(IDataModel model, Set<Long> invoiceIds) {
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection invoiceAndExpenseEntrys = dataEntity.getDynamicObjectCollection("invoiceandexpense");
        ArrayList needDelIndexs = Lists.newArrayList();
        for (int i = 0; i < invoiceAndExpenseEntrys.size(); ++i) {
            if (!invoiceIds.contains(((DynamicObject)invoiceAndExpenseEntrys.get(i)).getLong("invoiceentryid")) || model.getProperty("invoiceexpisunbind") != null && ((Boolean)model.getValue("invoiceexpisunbind", i)).booleanValue()) continue;
            needDelIndexs.add(i);
        }
        model.deleteEntryRows("invoiceandexpense", needDelIndexs.stream().mapToInt(Integer::intValue).toArray());
    }

    public static void createMapinfo(IDataModel model, Set<Long> itemIds, Set<Long> invoiceIds) {
        for (Long expenseEntryId : itemIds) {
            for (Long invoiceEntryId : invoiceIds) {
                int newRowIndex = model.createNewEntryRow("invoiceandexpense");
                model.setValue("expenseentryid", (Object)expenseEntryId, newRowIndex);
                model.setValue("invoiceentryid", (Object)invoiceEntryId, newRowIndex);
            }
        }
    }

    public static void refreshExpenseField(IDataModel model, BillOfInvoice bill, Set<Long> itemIds, Set<Long> invoiceIds) {
        ItemFrom itemFrom;
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection invoiceEntrys = model.getEntryEntity("invoiceentry");
        String unionInvoiceCode = invoiceEntrys.stream().filter(entry -> invoiceIds.contains(entry.getPkValue())).map(entry -> entry.getString("invoicecode")).collect(Collectors.joining(","));
        String unionInvoiceNo = invoiceEntrys.stream().filter(entry -> invoiceIds.contains(entry.getPkValue())).map(entry -> entry.getString("invoiceno")).collect(Collectors.joining(","));
        ItemFrom itemFrom2 = itemFrom = invoiceIds.isEmpty() ? ItemFrom.Manual : ItemFrom.InvoiceCloud;
        if (bill == BillOfInvoice.DailyReimburseBill) {
            DynamicObjectCollection expenseEntryDOs = (DynamicObjectCollection)bill.getExpenseEntryEntities(dataEntity);
            for (int rowIndex = 0; rowIndex < expenseEntryDOs.size(); ++rowIndex) {
                DynamicObject expenseEntryDO = (DynamicObject)expenseEntryDOs.get(rowIndex);
                if (!itemIds.contains(ErCommonUtils.getPk(expenseEntryDO))) continue;
                String oldInvoiceNoEntry = (String)model.getValue("invoiceno_entry", rowIndex);
                String oldInvoiceLink = (String)model.getValue("invoicelink", rowIndex);
                String newInvoiceNoEntry = StringUtils.isEmpty((CharSequence)oldInvoiceNoEntry) ? unionInvoiceNo : (StringUtils.isEmpty((CharSequence)unionInvoiceNo) ? oldInvoiceNoEntry : oldInvoiceNoEntry + "," + unionInvoiceNo);
                String newInvoiceLink = StringUtils.isEmpty((CharSequence)oldInvoiceLink) ? unionInvoiceCode : (StringUtils.isEmpty((CharSequence)unionInvoiceNo) ? oldInvoiceLink : oldInvoiceLink + "," + unionInvoiceCode);
                model.setValue("invoiceno_entry", (Object)InvoiceUtils.getLimitedInvoiceNo(newInvoiceNoEntry), rowIndex);
                model.setValue("invoicelink", (Object)InvoiceUtils.getLimitedInvoiceCode(newInvoiceLink), rowIndex);
                model.setValue("itemfrom", (Object)itemFrom.getValue(), rowIndex);
            }
        } else {
            Map tripMap = (Map)bill.getExpenseEntryEntities(dataEntity);
            for (Map.Entry tripDyCollection : tripMap.entrySet()) {
                Integer tripIndex = (Integer)tripDyCollection.getKey();
                DynamicObjectCollection expenseEntry = (DynamicObjectCollection)tripDyCollection.getValue();
                for (int expenseIndex = 0; expenseIndex < expenseEntry.size(); ++expenseIndex) {
                    DynamicObject expenseEntryDO = (DynamicObject)expenseEntry.get(expenseIndex);
                    if (!itemIds.contains(ErCommonUtils.getPk(expenseEntryDO))) continue;
                    String oldInvoiceNoEntry = (String)model.getValue("invoiceno_entry", expenseIndex, tripIndex.intValue());
                    String oldInvoiceLink = (String)model.getValue("invoicelink", expenseIndex, tripIndex.intValue());
                    String newInvoiceNoEntry = StringUtils.isEmpty((CharSequence)oldInvoiceNoEntry) ? unionInvoiceNo : (StringUtils.isEmpty((CharSequence)unionInvoiceNo) ? oldInvoiceNoEntry : oldInvoiceNoEntry + "," + unionInvoiceNo);
                    String newInvoiceLink = StringUtils.isEmpty((CharSequence)oldInvoiceLink) ? unionInvoiceCode : (StringUtils.isEmpty((CharSequence)unionInvoiceNo) ? oldInvoiceLink : oldInvoiceLink + "," + unionInvoiceCode);
                    model.setValue("invoiceno_entry", (Object)InvoiceUtils.getLimitedInvoiceNo(newInvoiceNoEntry), expenseIndex, tripIndex.intValue());
                    model.setValue("invoicelink", (Object)InvoiceUtils.getLimitedInvoiceCode(newInvoiceLink), expenseIndex, tripIndex.intValue());
                    model.setValue("itemfrom", (Object)itemFrom.getValue(), expenseIndex, tripIndex.intValue());
                }
            }
        }
    }

    public static Set<Long> getSeleteEntryId(IFormView view, BillOfInvoice bill) {
        IDataModel model = view.getModel();
        Set<Long> expenseEntryIds = SimpleRelateExpenseOrTripItemAndInvoiceUtil.setAndGetSelectedRowEntryId(view, bill);
        if (expenseEntryIds.isEmpty()) {
            String entityDisplayName = ((EntityType)model.getDataEntityType().getAllEntities().get(bill.getExpenseEntryEntityName())).getDisplayName().toString();
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d", (String)"SimpleRelateExpenseOrTripItemAndInvoiceUtil_0", (String)"fi-er-business", (Object[])new Object[0]) + entityDisplayName + ResManager.loadKDString((String)"\u540e\u518d\u5bfc\u5165\u53d1\u7968\u3002", (String)"SimpleRelateExpenseOrTripItemAndInvoiceUtil_1", (String)"fi-er-business", (Object[])new Object[0]));
            return Sets.newHashSetWithExpectedSize((int)0);
        }
        if (bill == BillOfInvoice.TripReimburseBill && !SimpleRelateExpenseOrTripItemAndInvoiceUtil.includeTripOrder(view, bill, expenseEntryIds)) {
            return Sets.newHashSetWithExpectedSize((int)0);
        }
        return expenseEntryIds;
    }

    public static List<DynamicObject> getSelectItems(IFormView view, BillOfInvoice bill) {
        IDataModel model = view.getModel();
        Set<Long> expenseEntryIds = SimpleRelateExpenseOrTripItemAndInvoiceUtil.setAndGetSelectedRowEntryId(view, bill);
        if (expenseEntryIds.isEmpty()) {
            String entityDisplayName = ((EntityType)model.getDataEntityType().getAllEntities().get(bill.getExpenseEntryEntityName())).getDisplayName().toString();
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d", (String)"SimpleRelateExpenseOrTripItemAndInvoiceUtil_0", (String)"fi-er-business", (Object[])new Object[0]) + entityDisplayName + ResManager.loadKDString((String)"\u540e\u518d\u5bfc\u5165\u53d1\u7968\u3002", (String)"SimpleRelateExpenseOrTripItemAndInvoiceUtil_1", (String)"fi-er-business", (Object[])new Object[0]));
            return null;
        }
        if (bill == BillOfInvoice.TripReimburseBill && !SimpleRelateExpenseOrTripItemAndInvoiceUtil.includeTripOrder(view, bill, expenseEntryIds)) {
            return null;
        }
        return null;
    }

    public static Set<Long> setAndGetSelectedRowEntryId(IFormView view, BillOfInvoice bill) {
        DynamicObjectCollection expenseEntryEntity;
        IDataModel model = view.getModel();
        EntryGrid grid = (EntryGrid)view.getControl(bill.getExpenseEntryEntityName());
        int[] rowIndexs = grid.getSelectRows();
        if (bill == BillOfInvoice.DailyReimburseBill) {
            expenseEntryEntity = (DynamicObjectCollection)bill.getExpenseEntryEntities(model.getDataEntity(true));
        } else {
            Map map = (Map)bill.getExpenseEntryEntities(model.getDataEntity(true));
            expenseEntryEntity = (DynamicObjectCollection)map.get(0);
        }
        Arrays.stream(rowIndexs).mapToObj(rowIndex -> (DynamicObject)expenseEntryEntity.get(rowIndex)).forEach(entry -> {
            Long entryId = (Long)entry.getPkValue();
            if (Objects.equals(entryId, 0L)) {
                entryId = ORM.create().genLongId(view.getEntityId());
                entry.set("id", (Object)entryId);
            }
        });
        Set<Long> expenseEntryIds = Arrays.stream(rowIndexs).mapToObj(rowIndex -> (DynamicObject)expenseEntryEntity.get(rowIndex)).filter(expenseEntry -> !Objects.equals(expenseEntry.getPkValue(), 0L)).map(entry -> (Long)entry.getPkValue()).collect(Collectors.toSet());
        return expenseEntryIds;
    }

    private static boolean includeTripOrder(IFormView view, BillOfInvoice bill, Set<Long> itemIds) {
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection expenseEntryEntity = null;
        if (bill == BillOfInvoice.DailyReimburseBill) {
            expenseEntryEntity = (DynamicObjectCollection)bill.getExpenseEntryEntities(dataEntity);
        } else {
            Map map = (Map)bill.getExpenseEntryEntities(dataEntity);
            expenseEntryEntity = (DynamicObjectCollection)map.get(0);
        }
        for (DynamicObject dynamicObject : expenseEntryEntity) {
            String ordernum;
            if (!itemIds.contains(dynamicObject.getPkValue()) || !StringUtils.isNotBlank((CharSequence)(ordernum = dynamicObject.getString("ordernum")))) continue;
            view.showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u660e\u7ec6\u4e2d\u5305\u542b\u5546\u65c5\u660e\u7ec6\uff0c\u65e0\u6cd5\u5173\u8054\u53d1\u7968\u3002\u8bf7\u5148\u53d6\u6d88\u9009\u62e9\u5546\u65c5\u53d1\u7968\uff0c\u518d\u5173\u8054\u8d39\u7528\u3002", (String)"SimpleRelateExpenseOrTripItemAndInvoiceUtil_2", (String)"fi-er-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

