/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.log.task;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.externalsystem.SyncReqBillToYzjNew;
import kd.fi.er.business.servicehelper.HttpServiceHelper;
import kd.fi.er.common.utils.ThrowableHelper;
import org.apache.commons.lang3.StringUtils;

public class TripReqBillToYZJTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(TripReqBillToYZJTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DynamicObject[] formInfos = this.getformInfos();
        ArrayList<Map<Long, JSONObject>> jsonObjs = this.getJsonObj(formInfos);
        if (jsonObjs == null || jsonObjs.size() == 0) {
            logger.info("\u51fa\u5dee\u7533\u8bf7\u5355\u540c\u6b65\u81f3\u4e91\u4e4b\u5bb6\uff1ajsonObjs\u4e3a\u7a7a");
            return;
        }
        String domain = SyncReqBillToYzjNew.getDomain();
        String eid = SyncReqBillToYzjNew.getEid();
        if (domain == null || eid == null || "".equals(domain) || "".equals(eid)) {
            logger.info("\u51fa\u5dee\u7533\u8bf7\u5355\u540c\u6b65\u81f3\u4e91\u4e4b\u5bb6\uff1a\u7cfb\u7edf\u53c2\u6570--\u7b2c\u4e09\u65b9\u53c2\u6570--\u4e91\u4e4b\u5bb6\u53c2\u6570\u7684\u5730\u5740\u548ceid\u4e3a\u7a7a");
            return;
        }
        String url = domain + "/gateway/smartatt-core/v2/thirdflow/travel/syncUpdate?accessToken=";
        HashMap<String, Object> yzjMap = SyncReqBillToYzjNew.getTokenNew();
        String accessToken = (String)yzjMap.get("accessToken");
        if (accessToken == null) {
            logger.info("SyncReqBillToYzjSingle accessToken is null");
            return;
        }
        url = url + accessToken;
        logger.info("TripReqBillToYZJTask,url:" + url);
        HashSet<String> notNeedSycDatano = new HashSet<String>();
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        for (Map<Long, JSONObject> jsonObjMap : jsonObjs) {
            JSONObject returnObject = null;
            for (Map.Entry<Long, JSONObject> longJSONObjectEntry : jsonObjMap.entrySet()) {
                DynamicObject dynamicObject;
                Long id = longJSONObjectEntry.getKey();
                JSONObject jsonObj = longJSONObjectEntry.getValue();
                String datano = jsonObj.getJSONObject("formInfo").getString("formInstId");
                if (notNeedSycDatano.contains(datano)) continue;
                Optional<DynamicObject> first = Arrays.stream(formInfos).filter(formInfo -> id.equals(Long.valueOf(formInfo.getString("id")))).findFirst();
                if (!first.isPresent()) {
                    return;
                }
                try {
                    logger.info("\u51fa\u5dee\u7533\u8bf7\u5355\u540c\u6b65\u81f3\u4e91\u4e4b\u5bb6httpPost\u5f00\u59cb\uff0c\u5165\u53c2\uff1a" + jsonObj.toJSONString());
                    returnObject = HttpServiceHelper.httpPost(url, jsonObj, 10000);
                }
                catch (Exception e) {
                    DynamicObject dynamicObject2 = first.get();
                    dynamicObject2.set("failmessage", (Object)ResManager.loadKDString((String)"\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38", (String)"TripReqBillToYZJTask_0", (String)"fi-er-business", (Object[])new Object[0]));
                    dynamicObjects.add(dynamicObject2);
                    String throwableMsg = ThrowableHelper.toString((Exception)e);
                    if (throwableMsg.length() > 2000) {
                        throwableMsg = throwableMsg.substring(2000);
                    }
                    logger.info("\u51fa\u5dee\u7533\u8bf7\u5355\u540c\u6b65\u81f3\u4e91\u4e4b\u5bb6\uff0c\u63a5\u53e3\u8bf7\u6c42\u5f02\u5e38\uff1a{}", (Object)throwableMsg);
                }
                if (returnObject == null) continue;
                logger.info("\u51fa\u5dee\u7533\u8bf7\u5355\u540c\u6b65\u81f3\u4e91\u4e4b\u5bb6httpPost\u7ed3\u675f\uff0creturnObject\uff1a" + returnObject.toJSONString());
                String data = returnObject.getString("data");
                Integer errorCode = returnObject.getInteger("errorCode");
                String errorMsg = returnObject.getString("errorMsg");
                String success = returnObject.getString("success");
                if (StringUtils.isNotBlank((CharSequence)errorMsg) || !"true".equals(success)) {
                    logger.info("\u51fa\u5dee\u7533\u8bf7\u5355\u540c\u6b65\u81f3\u4e91\u4e4b\u5bb6,\u63a5\u53e3\u8fd4\u56de\u7684\u6570\u636e\u5f02\u5e38\uff1adata\uff1a{}\uff0cerrorCode\uff1a{}\uff0cerrorMsg\uff1a{}\uff0csucess\uff1a{}", new Object[]{data, errorCode, errorMsg, success});
                    dynamicObject = first.get();
                    dynamicObject.set("synstate", (Object)"fail");
                    dynamicObject.set("failmessage", (Object)errorMsg);
                    dynamicObject.set("modifytime", (Object)new Date());
                    dynamicObjects.add(dynamicObject);
                    notNeedSycDatano.add(dynamicObject.getString("datano"));
                    continue;
                }
                dynamicObject = first.get();
                dynamicObject.set("synstate", (Object)"yes");
                dynamicObject.set("modifytime", (Object)new Date());
                dynamicObject.set("failmessage", (Object)"");
                dynamicObjects.add(dynamicObject);
            }
        }
        SaveServiceHelper.update((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
    }

    private DynamicObject[] getformInfos() {
        ArrayList<String> needSynState = new ArrayList<String>();
        needSynState.add("no");
        needSynState.add("fail");
        DynamicObject[] formInfos = BusinessDataServiceHelper.load((String)"er_syntripreq", (String)"id,datano,travelerid,optype,synstate,failmessage,createtime,modifytime,entryid", (QFilter[])new QFilter[]{new QFilter("synstate", "in", needSynState)}, (String)"createtime asc");
        return formInfos;
    }

    private ArrayList<Map<Long, JSONObject>> getJsonObj(DynamicObject[] formInfos) {
        if (formInfos.length == 0) {
            return null;
        }
        Map datanoToforminfos = Arrays.stream(formInfos).collect(Collectors.groupingBy(formInfo -> (String)formInfo.get("datano"), LinkedHashMap::new, Collectors.toList()));
        ArrayList<Map<Long, JSONObject>> jsonObjects = new ArrayList<Map<Long, JSONObject>>();
        for (Map.Entry stringListEntry : datanoToforminfos.entrySet()) {
            List forminfos = (List)stringListEntry.getValue();
            Collections.sort(forminfos, (o1, o2) -> {
                Date createtime2;
                Date createtime1 = o1.getDate("createtime");
                if (createtime1.compareTo(createtime2 = o2.getDate("createtime")) == 0) {
                    String optype1 = (String)o1.get("optype");
                    String optype2 = (String)o2.get("optype");
                    if (StringUtils.equalsIgnoreCase((CharSequence)optype1, (CharSequence)"DELETE") && !StringUtils.equalsIgnoreCase((CharSequence)optype2, (CharSequence)"DELETE")) {
                        return -1;
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)optype1, (CharSequence)"DELETE") && StringUtils.equalsIgnoreCase((CharSequence)optype2, (CharSequence)"DELETE")) {
                        return 1;
                    }
                    return 0;
                }
                return createtime1.compareTo(createtime2);
            });
            for (DynamicObject formInfo2 : forminfos) {
                Date[][] mergeDates;
                String action = (String)formInfo2.get("optype");
                String creatorOid = (String)formInfo2.get("travelerid");
                String formInstId = (String)formInfo2.get("datano");
                JSONObject formInfoObject = new JSONObject();
                formInfoObject.put("action", (Object)action);
                formInfoObject.put("creatorOid", (Object)creatorOid);
                formInfoObject.put("effectOid", (Object)creatorOid);
                formInfoObject.put("formInstId", (Object)formInstId);
                formInfoObject.put("serialNo", (Object)formInstId);
                formInfoObject.put("formSource", (Object)"xinghan");
                JSONObject dataObject = new JSONObject();
                ArrayList<JSONObject> list = new ArrayList<JSONObject>();
                String entryid = (String)formInfo2.get("entryid");
                long[] ids = Arrays.stream(entryid.split(",")).mapToLong(Long::parseLong).toArray();
                DynamicObject[] dataEntrys = BusinessDataServiceHelper.load((String)"er_syntripentry", (String)"id,cityname,enddate,startdate", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
                Date[][] dates = new Date[dataEntrys.length][2];
                for (int i = 0; i < dataEntrys.length; ++i) {
                    dates[i][0] = (Date)dataEntrys[i].get("startdate");
                    dates[i][1] = (Date)dataEntrys[i].get("enddate");
                }
                for (Date[] mergeDate : mergeDates = this.mergeTripentry(dates)) {
                    JSONObject entryObject = new JSONObject();
                    String address = (String)dataEntrys[0].get("cityname");
                    entryObject.put("address", (Object)address);
                    entryObject.put("endTime", (Object)mergeDate[1]);
                    entryObject.put("startTime", (Object)mergeDate[0]);
                    list.add(entryObject);
                }
                dataObject.put("formType", (Object)"TRAVEL");
                dataObject.put("list", list);
                JSONObject result = new JSONObject();
                result.put("formInfo", (Object)formInfoObject);
                result.put("data", (Object)dataObject);
                HashMap<Long, JSONObject> map = new HashMap<Long, JSONObject>();
                map.put(Long.valueOf(formInfo2.get("id").toString()), result);
                jsonObjects.add(map);
            }
        }
        return jsonObjects;
    }

    public Date[][] mergeTripentry(Date[][] intervals) {
        Arrays.sort(intervals, new Comparator<Date[]>(){

            @Override
            public int compare(Date[] interval1, Date[] interval2) {
                return interval1[0].compareTo(interval2[0]);
            }
        });
        ArrayList<Date[]> merged = new ArrayList<Date[]>();
        for (int i = 0; i < intervals.length; ++i) {
            Date L = intervals[i][0];
            Date R = intervals[i][1];
            if (merged.size() == 0 || ((Date[])merged.get(merged.size() - 1))[1].compareTo(L) < 0) {
                merged.add(new Date[]{L, R});
                continue;
            }
            ((Date[])merged.get((int)(merged.size() - 1)))[1] = ((Date[])merged.get(merged.size() - 1))[1].after(R) ? ((Date[])merged.get(merged.size() - 1))[1] : R;
        }
        return (Date[][])merged.toArray((T[])new Date[merged.size()][]);
    }
}

